/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.MgetReqInProgress;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.XPL2MacAddrDataSource;
import cerent.cms.ui.xpl2.XPL2MacAddrTableModel;
import cerent.util.BusEvent;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.SDebug;
import cerent.util.SvlanRange;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.VlanListPropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class XPL2MacAddrLearningListPane
extends AbstractPane
implements ITabName,
ActionListener,
Observer {
    protected static final String REFRESH_STRING = "Refresh";
    protected static final String CLEAR_STRING = "Clear";
    private JPanel controlPane;
    private JButton refreshButton;
    private JButton clearButton;
    private JLabel retrievalTime;
    private VlanListPropertyEditor svlanList = new VlanListPropertyEditor("SVLANs", 10, true);
    private XPL2MacAddrDataSource dataSource;

    public XPL2MacAddrLearningListPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.dataSource == null) {
                this.init();
            }
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XPL2MacAddrLearningListPane.this.svlanList.requestFocus();
            }
        });
    }

    private void init() {
        if (db.on()) {
            db.println("init: start");
        }
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 5));
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        this.dataSource = new XPL2MacAddrDataSource();
        this.table = new UTable((TableModel)((Object)new XPL2MacAddrTableModel(this.dataSource, this.getUiModel())));
        ((XPL2MacAddrTableModel)((Object)this.table.getModel())).initTable(this.table);
        ((XPL2MacAddrTableModel)((Object)this.table.getModel())).setModel(this.getUiModel());
        EventBus.instance().addObserver((Observer)this, (Object)XPL2MacAddrDataSource.class.toString());
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)uScrollPane, "Center");
        JPanel jPanel2 = XPL2MacAddrLearningListPane.createVerticalPanel(null);
        jPanel2.add(this.makeControlPanel());
        this.add(jPanel, "Center");
        this.add(jPanel2, "South");
        if (db.on()) {
            db.println("init: finish");
        }
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
        ((XPL2MacAddrTableModel)((Object)this.table.getModel())).stopAnyCall();
    }

    private JPanel makeControlPanel() {
        this.controlPane = new JPanel(new FlowLayout(0));
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(this.getHelpID());
        this.enableComponent(this.svlanList);
        this.refreshButton = new JButton(REFRESH_STRING);
        this.refreshButton.setEnabled(AbstractPane.isUserAuthorized(this.getUiModel(), SecurityLevel.RETRIEVE));
        if (this.refreshButton.isEnabled()) {
            this.refreshButton.addActionListener(this);
        }
        this.clearButton = new JButton(CLEAR_STRING);
        this.clearButton.setEnabled(AbstractPane.isUserAuthorized(this.getUiModel(), SecurityLevel.PROVISIONING));
        if (this.clearButton.isEnabled()) {
            this.clearButton.addActionListener(this);
        }
        this.retrievalTime = new JLabel("Refreshed (never)");
        this.controlPane.add(this.svlanList);
        this.controlPane.add(this.refreshButton);
        this.controlPane.add(this.clearButton);
        this.controlPane.add(Box.createHorizontalStrut(50));
        this.controlPane.add(this.retrievalTime);
        cSHelpButtonPane.addLeft(this.controlPane);
        return cSHelpButtonPane;
    }

    public void applyChangesToModel() throws Exception {
    }

    @Override
    public void dispose() {
        block3: {
            try {
                EventBus.instance().deleteObserver((Observer)this, (Object)XPL2MacAddrDataSource.class.toString());
            }
            catch (Exception exception) {
                db.fine("Caught exception while deleteObserver");
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (this.table != null && this.table.getModel() != null) {
            ((XPL2MacAddrTableModel)((Object)this.table.getModel())).dispose();
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2MacAddrLearningListPane;
    }

    @Override
    public final void refresh() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshButton) {
            this.svlanList.actionPerformed(null);
            if (this.svlanList.getVlanList() != null) {
                SvlanRange[] svlanRangeArray = this.svlanList.getVlanList().getRanges();
                if (svlanRangeArray.length == 0) {
                    ErrorMsg.displayError((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), (EID)CEMC.EID_SVLAN_OUT_OF_RANGE);
                    return;
                }
                this.refreshButton.setEnabled(false);
                this.loadMacAddressList(svlanRangeArray);
            }
            SwingUtilities.updateComponentTreeUI(this.controlPane);
        } else if (object == this.clearButton) {
            this.clearAllLearnedAddresses();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMacAddressList(SvlanRange[] svlanRangeArray) {
        try {
            this.setCursor(3);
            ((XPL2MacAddrTableModel)((Object)this.table.getModel())).loadMacAddressList(svlanRangeArray);
        }
        catch (EMCProvisionError eMCProvisionError) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_RTRV_MAC_ADDR);
        }
        catch (NotSupportedOnEquipment notSupportedOnEquipment) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_UNSUPPORTED_EQTYPE);
        }
        finally {
            this.setCursor(0);
        }
    }

    private boolean clearAllLearnedAddresses() {
        if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)"Do you really want to clear all learned MAC addresses (Hardware Operation)?", (String)"Clear All")) {
            return false;
        }
        try {
            ((XPL2MacAddrTableModel)((Object)this.table.getModel())).clearLearnedAddress();
        }
        catch (NoSuchEquipment noSuchEquipment) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MAC_CLEAR_LEARNED_ADDR);
            return false;
        }
        catch (NotSupportedOnEquipment notSupportedOnEquipment) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_UNSUPPORTED_OPERATION_PARAM_1);
            return false;
        }
        catch (MgetReqInProgress mgetReqInProgress) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_GET_REQUEST_IN_PROGRESS);
            return false;
        }
        return true;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof EventBus && ((BusEvent)object).getEvent() == XPL2MacAddrTableModel.LOAD_FINISHED) {
            this.retrievalTime.setText("Retrieved at " + DateFormat.getDateTimeInstance(1, 1).format(new Date()));
            this.controlPane.invalidate();
            this.refreshButton.setEnabled(true);
        } else if (observable instanceof EventBus && ((BusEvent)object).getEvent() == XPL2MacAddrTableModel.LOAD_ERROR) {
            this.retrievalTime.setText("Refreshed (never)");
            this.controlPane.invalidate();
            this.refreshButton.setEnabled(true);
        } else {
            super.update(observable, object);
        }
    }
}

