/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.Epos.eBridgePortState;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class XPL2ProtectionTableModel
extends AbstractTableModel
implements Observer {
    public static final int PORT_INDEX = 0;
    public static final int STATUS_INDEX = 1;
    public static final int ACTUAL_STATUS_INDEX = 2;
    public static final int CLEAR_CRC_ALARM_INDEX = 3;
    static final String[] columnNames = new String[]{"Port", "Status", "Actual Status", "Clear/Suppress CRC Alarm"};
    private ModuleModel eqpmtModel = null;
    private XPL2LineModel[] lineModels = null;
    private eBridgePortState[] bridgePortState = null;
    private eBridgePortState[] actualBridgePortState = null;
    private Boolean[] clearCrcAlarm = null;
    public static final String bridgeEnumTag = "ETHER." + eBridgePortState.class.getName();
    private boolean[][] isDirty = null;
    private int numLines = 0;
    private String[] portNames;
    protected EntityCellRenderer myPortRenderer;
    private static final SDebug db = new SDebug("XPL2MapEtherPortTableModel");

    public XPL2ProtectionTableModel(ModuleModel moduleModel, XPL2LineModel[] xPL2LineModelArray) {
        this.eqpmtModel = moduleModel;
        this.myPortRenderer = new EntityCellRenderer(false);
        this.refreshMyLines(xPL2LineModelArray);
    }

    public void refreshMyLines(XPL2LineModel[] xPL2LineModelArray) {
        this.lineModels = xPL2LineModelArray;
        this.numLines = this.lineModels.length;
        this.bridgePortState = new eBridgePortState[this.numLines];
        this.clearCrcAlarm = new Boolean[this.numLines];
        if (this.actualBridgePortState == null || this.actualBridgePortState.length != this.numLines) {
            this.actualBridgePortState = new eBridgePortState[this.numLines];
        }
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirty();
        try {
            this.refreshFromModel();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        this.registerWithLineModels();
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.lineModels != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.lineModels[0], SecurityLevel.PROVISIONING)) {
            return n2 == 1 || n2 == 3;
        }
        return false;
    }

    public boolean flowControlChanged() {
        return false;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    private String getLineNumber(int n) {
        try {
            IPortModel iPortModel = this.lineModels[n].getPortModel();
            return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
        }
        catch (Exception exception) {
            if (XPL2ProtectionTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 3: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        block8: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumber(n);
                    }
                    case 1: {
                        return this.getBridgePortState(n);
                    }
                    case 2: {
                        return this.getActualBridgePortState(n);
                    }
                    case 3: {
                        return this.clearCrcAlarm[n];
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block8;
                db.println("Error in getValueAt in XPL2ProtectionTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        try {
            switch (n2) {
                case 1: {
                    this.bridgePortState[n] = eBridgePortState.from_int(((Attribute)object).getIntValue());
                    break;
                }
                case 3: {
                    this.clearCrcAlarm[n] = (Boolean)object;
                }
            }
            this.isDirty[n][n2] = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fireTableCellUpdated(n, n2);
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        block2: {
            try {
                this.resetLineCache(n);
                this.fireTableRowsUpdated(n, n);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected Attribute getActualBridgePortState(int n) {
        return this.getAttributeFor(bridgeEnumTag, this.actualBridgePortState[n].value());
    }

    protected Attribute getBridgePortState(int n) {
        return this.getAttributeFor(bridgeEnumTag, this.bridgePortState[n].value());
    }

    protected Attribute[] getBridgePortStateValues() {
        Attribute[] attributeArray = new Attribute[]{this.getAttributeFor(bridgeEnumTag, 5), this.getAttributeFor(bridgeEnumTag, 2)};
        return attributeArray;
    }

    protected Attribute getAttributeFor(String string, int n) {
        INodeModel iNodeModel = this.eqpmtModel.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeForVal(string, n);
    }

    public void applyToModel(int n) throws Exception {
        if (this.isDirty[n][1]) {
            this.lineModels[n].setBridgePortState(this.bridgePortState[n]);
        }
        if (this.isDirty[n][3]) {
            this.lineModels[n].setClearCrcAlarm(this.clearCrcAlarm[n]);
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshActualBridgePortState() {
        try {
            for (int i = 0; i < this.numLines; ++i) {
                this.actualBridgePortState[i] = this.getActualBridgePortStateFromModel(i);
                this.fireTableCellUpdated(i, 2);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    protected void resetLineCache(int n) throws Exception {
        try {
            this.bridgePortState[n] = this.getBridgePortStateFromModel(n);
            this.clearCrcAlarm[n] = this.getClearCrcAlarmFromModel(n);
            if (this.actualBridgePortState[n] == null) {
                this.actualBridgePortState[n] = this.getActualBridgePortStateFromModel(n);
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.isDirty[n][i] = false;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private eBridgePortState getBridgePortStateFromModel(int n) throws NoSuchInterface, WrongInterfaceType, AbstractCmsNoSuchEntityException {
        return this.lineModels[n].getBridgePortState();
    }

    private Boolean getClearCrcAlarmFromModel(int n) throws NoSuchInterface, WrongInterfaceType, AbstractCmsNoSuchEntityException {
        return this.lineModels[n].getClearCrcAlarm();
    }

    private eBridgePortState getActualBridgePortStateFromModel(int n) throws NoSuchInterface, WrongInterfaceType, AbstractCmsNoSuchEntityException {
        return this.lineModels[n].getActualBridgePortState();
    }

    private void registerWithLineModels() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver(this);
        }
    }

    private void unRegisterWithLineModels() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver(this);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            int n;
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if ((n = Arrays.asList(this.lineModels).indexOf(observable)) != -1) {
                this.refreshLineFromModel(n);
            }
        }
    }

    public void dispose() {
        this.unRegisterWithLineModels();
    }
}

