/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.dscp2Cos;
import cerent.cms.idl.EtherL2Media.dscp2CosInfo;
import cerent.cms.idl.EtherL2Media.eQinQMode;
import cerent.cms.idl.EtherL2Media.sMcastInfo;
import cerent.cms.idl.EtherL2Media.sQinQInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.IXPL2QinQSvlanTableModel;
import cerent.cms.model.IXPLLayer2LineModel;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PortModel;
import cerent.cms.model.QinQSettings;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2ChannelGroupModel;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.OPERMODE;
import cerent.cms.ui.xpl2.XPL2DscpCosPopup;
import cerent.cms.ui.xpl2.XPL2QinQRangeDialog;
import cerent.cms.ui.xpl2.XPL2QinQSvlanTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XPL2QinQProvPane
extends NodeProvPane
implements TableModelListener,
ActionListener {
    private IXPLLayer2LineModel cktEndPoint;
    protected short selSVLANId;
    protected boolean fromNet = false;
    private INodeModel nm;
    protected PortModel[] portModels = null;
    protected XPL2ModuleModel eqpmtModel = null;
    protected XPL2LineModel[] linesModels = null;
    protected XPL2Layer2LineModel[] layer2Models = null;
    protected XPL2Layer2LineModel[] uniL2Models = null;
    private JLabel portLabel;
    private UComboBox portCB;
    private UComboBox bpduCB;
    private UComboBox modeCB;
    private JButton dscpCosButton;
    private UComboBox svlanCB;
    private UComboBox svlanCBEditor;
    private UComboBox intSvlanCBEditor;
    private UComboBox cosCBEditor;
    private UComboBox operationCBEditor;
    private ComboBoxRenderer comboRenderer = new ComboBoxRenderer();
    private TableColumn cosColumn;
    private TableColumn igmpColumn;
    private JButton addRowButton;
    private JButton removeRowButton;
    private JButton rangeButton;
    private JButton closeButton;
    private JButton resetButton;
    private CSHelpButton helpButton;
    public static final String CLOSE = "Apply";
    public static final int MAX_QINQ_XLTE_ENTRIES = 384;
    protected XPL2QinQSvlanTableModel dataSvlanModel = null;
    private JPanel sVlanPane = null;
    private JPanel cVlanPane = null;
    private GridBagPanel gbp = null;
    private boolean dialogDisplayed;
    private boolean applyChanges = false;
    private ObservableManager _obsMgr;
    private QinQSettings qinqInfoFromNet = null;
    short[][] dscp2CosTable = new short[64][2];
    private static final SDebug db = new SDebug("XPL2QinQProvPane");

    public XPL2QinQProvPane(String string, TabbedView tabbedView, XPL2ModuleModel xPL2ModuleModel, IXPLLayer2LineModel iXPLLayer2LineModel, short s, QinQSettings qinQSettings) {
        super(string, (IModel)xPL2ModuleModel.getNodeModel(), tabbedView);
        this.nm = xPL2ModuleModel.getNodeModel();
        this.eqpmtModel = xPL2ModuleModel;
        this.portModels = xPL2ModuleModel.getXPL2EtherPorts();
        this.linesModels = xPL2ModuleModel.getXPL2EtherLines();
        this.layer2Models = xPL2ModuleModel.getXPL2Layer2EtherLines();
        this.uniL2Models = xPL2ModuleModel.getXPL2UNILinesAndChGrps();
        this.cktEndPoint = iXPLLayer2LineModel;
        this.selSVLANId = s;
        if (qinQSettings != null) {
            this.fromNet = true;
            this.qinqInfoFromNet = qinQSettings;
        }
        if (xPL2ModuleModel == null || this.portModels == null) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + xPL2ModuleModel + " portModels=" + this.portModels);
            }
            return;
        }
        this.init();
    }

    @Override
    protected void registerWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.portModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.portModels[n]));
        }
        for (n = 0; n < this.linesModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.linesModels[n]));
        }
        for (n = 0; n < this.layer2Models.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.layer2Models[n]));
        }
    }

    protected void unRegisterWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.portModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.portModels[n]));
        }
        for (n = 0; n < this.linesModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.linesModels[n]));
        }
        for (n = 0; n < this.layer2Models.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.layer2Models[n]));
        }
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.gbp = new GridBagPanel();
        this.gbp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.gbp.fillBoth();
        this.gbp.add((Component)this.createPortPane(), 0, 1);
        this.gbp.fillBoth();
        this.gbp.add((Component)this.createSVlanPane(), 1, 1);
        this.add((Component)new UScrollPane((Component)this.gbp));
        this.createCVlanPane();
        if (this.fromNet) {
            this.buttonPanel.setVisible(false);
            this.add(this.getButtonPanel(), "East");
            this.portCB.setSelectedItem((Object)this.cktEndPoint);
            try {
                if (this.qinqInfoFromNet.getQinQMode() == -1) {
                    this.initQinQInfoFromNet();
                } else if (db.on()) {
                    db.println("Already inizialised QinQ mode and BPDU");
                }
                this.refreshFromModel();
            }
            catch (Exception exception) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            finally {
                this.portCB.setEnabled(false);
            }
        }
    }

    private JPanel getButtonPanel() {
        Dimension dimension = new Dimension(75, 25);
        this.closeButton = new JButton(CLOSE);
        this.closeButton.setMinimumSize(dimension);
        this.closeButton.setMaximumSize(dimension);
        this.closeButton.addActionListener(this);
        this.resetButton = new JButton("Reset");
        this.resetButton.setMinimumSize(dimension);
        this.resetButton.setMaximumSize(dimension);
        this.resetButton.addActionListener(this);
        JPanel jPanel = XPL2QinQProvPane.createVerticalPanel(null);
        jPanel.add(this.closeButton);
        jPanel.add(Box.createVerticalStrut(this.closeButton.getPreferredSize().height / 3));
        jPanel.add(this.resetButton);
        if (this.getHelpID() != null) {
            this.helpButton = new CSHelpButton(this);
            this.helpButton.setMinimumSize(dimension);
            this.helpButton.setMaximumSize(dimension);
            jPanel.add(Box.createVerticalStrut(this.closeButton.getPreferredSize().height / 3));
            jPanel.add(this.helpButton);
        }
        return jPanel;
    }

    private void initQinQInfoFromNet() throws WrongInterfaceType, InvalidOperation, NoSuchInterface {
        if (this.fromNet && this.uniL2Models.length != 0) {
            XPL2Layer2LineModel xPL2Layer2LineModel = (XPL2Layer2LineModel)this.portCB.getSelectedItem();
            sQinQInfo sQinQInfo2 = null;
            sQinQInfo2 = xPL2Layer2LineModel.getQinQInfo();
            if (xPL2Layer2LineModel.getEtherBasicL2Info().sIngressCOS == 10) {
                this.loadDscp2CosTableFromModel(xPL2Layer2LineModel);
            }
            if (db.on()) {
                db.println("Initializing QinQ mode and BPDU " + sQinQInfo2.qinqMode.value() + " " + xPL2Layer2LineModel.getBpdu());
            }
            this.qinqInfoFromNet.setQinQMode(sQinQInfo2.qinqMode.value());
            this.qinqInfoFromNet.setQinQBPDU(xPL2Layer2LineModel.getBpdu().booleanValue());
        }
    }

    private JPanel createPortPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setPreferredSize(new Dimension(350, 160));
        jPanel.setBorder(BorderFactory.createTitledBorder("Select Port"));
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        double[] dArray = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 1.0E-4};
        double[] dArray2 = new double[]{1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0E-4};
        gridBagLayout.columnWidths = nArray;
        gridBagLayout.rowHeights = nArray2;
        gridBagLayout.columnWeights = dArray;
        gridBagLayout.rowWeights = dArray2;
        this.portLabel = new JLabel("Port: ");
        jPanel.add((Component)this.portLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.portCB = new UComboBox((Object[])this.uniL2Models);
        this.portCB.setRenderer((ListCellRenderer)this.comboRenderer);
        jPanel.add((Component)this.portCB, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel = new JLabel("Mode: ");
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.modeCB = new UComboBox(new DefaultComboBoxModel<String>(new String[]{"Transparent", "Selective"}));
        this.modeCB.setRenderer((ListCellRenderer)this.comboRenderer);
        this.modeCB.addActionListener((ActionListener)this);
        this.enableComponent((JComponent)this.modeCB, (IModel)this.nm);
        jPanel.add((Component)this.modeCB, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel("BPDU: ");
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.bpduCB = new UComboBox(new DefaultComboBoxModel<String>(new String[]{"Drop", "Tunnel"}));
        this.bpduCB.setRenderer((ListCellRenderer)this.comboRenderer);
        this.bpduCB.addActionListener((ActionListener)this);
        this.enableComponent((JComponent)this.bpduCB, (IModel)this.nm);
        jPanel.add((Component)this.bpduCB, new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dscpCosButton = new JButton("DSCP-CoS mapping Table");
        this.dscpCosButton.addActionListener(this);
        jPanel.add((Component)this.dscpCosButton, new GridBagConstraints(1, 6, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createSVlanPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.sVlanPane = new JPanel(gridBagLayout);
        this.sVlanPane.setPreferredSize(new Dimension(350, 160));
        this.sVlanPane.setBorder(BorderFactory.createTitledBorder("Transparent Mode"));
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        double[] dArray = new double[]{1.0, 0.0, 1.0, 0.0, 1.0, 1.0E-4};
        double[] dArray2 = new double[]{1.0, 0.0, 1.0, 1.0E-4};
        gridBagLayout.columnWidths = nArray;
        gridBagLayout.rowHeights = nArray2;
        gridBagLayout.columnWeights = dArray;
        gridBagLayout.rowWeights = dArray2;
        JLabel jLabel = new JLabel("SVLAN: ");
        this.sVlanPane.add((Component)jLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.svlanCB = new UComboBox();
        this.svlanCB.addActionListener((ActionListener)this);
        this.svlanCB.setRenderer((ListCellRenderer)this.comboRenderer);
        this.enableComponent((JComponent)this.svlanCB, (IModel)this.nm);
        this.sVlanPane.add((Component)this.svlanCB, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        return this.sVlanPane;
    }

    private JPanel createCVlanPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        double[] dArray = new double[]{11.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        double[] dArray2 = new double[]{1.0, 0.0, 0.0, 1.0E-4};
        gridBagLayout.columnWidths = nArray;
        gridBagLayout.rowHeights = nArray2;
        gridBagLayout.columnWeights = dArray;
        gridBagLayout.rowWeights = dArray2;
        this.cVlanPane = new JPanel(gridBagLayout);
        this.cVlanPane.setPreferredSize(new Dimension(380, 160));
        this.cVlanPane.setBorder(BorderFactory.createTitledBorder("Selective Mode"));
        if (this.fromNet) {
            if (this.qinqInfoFromNet.getQinQTable() != null) {
                if (db.on()) {
                    db.println("Already inizialised QinQ table model ");
                }
                this.dataSvlanModel = (XPL2QinQSvlanTableModel)this.qinqInfoFromNet.getQinQTable();
            } else {
                if (db.on()) {
                    db.println("Initializing QinQ table model ");
                }
                this.dataSvlanModel = new XPL2QinQSvlanTableModel((Container)((Object)this), true);
                this.qinqInfoFromNet.setQinQTable((IXPL2QinQSvlanTableModel)this.dataSvlanModel);
            }
        } else {
            this.dataSvlanModel = new XPL2QinQSvlanTableModel((Container)((Object)this), false);
        }
        this.dataSvlanModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataSvlanModel);
        this.cosColumn = this.table.getColumnModel().getColumn(5);
        this.igmpColumn = this.table.getColumnModel().getColumn(1);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedTableSvlan();
        this.cVlanPane.add((Component)uScrollPane, new GridBagConstraints(0, 0, 5, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.rangeButton = new JButton("Add Range");
        this.rangeButton.addActionListener(this);
        this.enableComponent(this.rangeButton, (IModel)this.nm);
        this.addRowButton = new JButton("Add Row");
        this.addRowButton.addActionListener(this);
        this.enableComponent(this.addRowButton, (IModel)this.nm);
        this.removeRowButton = new JButton("Remove Row(s)");
        this.removeRowButton.addActionListener(this);
        this.enableComponent(this.removeRowButton, (IModel)this.nm);
        this.cVlanPane.add((Component)this.addRowButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cVlanPane.add((Component)this.removeRowButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cVlanPane.add((Component)this.rangeButton, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 13, new Insets(0, 0, 0, 5), 0, 0));
        return this.cVlanPane;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != this.dscpCosButton) {
            this.setDirty();
        }
        IVlanInfo[] iVlanInfoArray = this.eqpmtModel.getVlanDb();
        if ((object == this.addRowButton || object == this.rangeButton) && iVlanInfoArray.length == 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_VLAN_VLAN_DB_EMPTY);
            return;
        }
        if (object == this.addRowButton) {
            if (this.svlanCB.getModel().getSize() != iVlanInfoArray.length) {
                this.svlanCB.setModel(new DefaultComboBoxModel<IVlanInfo>(iVlanInfoArray));
                this.svlanCBEditor.setModel(new DefaultComboBoxModel<IVlanInfo>(iVlanInfoArray));
                this.intSvlanCBEditor.setModel(new DefaultComboBoxModel<IVlanInfo>(iVlanInfoArray));
            }
            short s = this.fromNet ? this.selSVLANId : (iVlanInfoArray.length > 0 ? iVlanInfoArray[0].getVlanId() : (short)0);
            this.dataSvlanModel.addRow(s);
        } else if (object == this.removeRowButton) {
            this.dataSvlanModel.removeRows(this.table.getSelectedRows());
        } else if (object == this.modeCB) {
            if (this.modeCB.getSelectedItem().equals("Transparent")) {
                this.prepareTabForTransparentMode(this.selSVLANId);
            } else {
                this.prepareTabForSelectiveMode();
            }
            this.setDirty();
        } else if (object == this.closeButton) {
            EventBus.instance().notifyEvent((Object)this, (Object)CLOSE);
        } else if (object == this.helpButton) {
            this.helpButton.launchHelp(this.getHelpID());
        } else if (object == this.resetButton) {
            this.reset();
        } else if (object == this.bpduCB) {
            if (this.fromNet) {
                this.qinqInfoFromNet.setQinQBPDU(this.bpduCB.getSelectedIndex() == 0);
            }
        } else if (object == this.rangeButton) {
            XPL2QinQRangeDialog.getInstance(this, this.eqpmtModel).setVisible(true);
        } else if (object == this.dscpCosButton) {
            JFrame jFrame = (JFrame)JOptionPane.getFrameForComponent((Component)((Object)this));
            XPL2DscpCosPopup xPL2DscpCosPopup = new XPL2DscpCosPopup((Frame)jFrame, this);
            xPL2DscpCosPopup.start();
            xPL2DscpCosPopup.pack();
            xPL2DscpCosPopup.setVisible(true);
        }
    }

    private void prepareTabForTransparentMode(int n) {
        boolean bl;
        IVlanInfo iVlanInfo;
        int n2;
        block9: {
            this.svlanCB.removeActionListener((ActionListener)this);
            this.modeCB.removeActionListener((ActionListener)this);
            this.enableComponent((JComponent)this.svlanCB, (IModel)this.nm);
            this.gbp.remove(this.cVlanPane);
            this.gbp.add((Component)this.sVlanPane, 1, 1);
            n2 = this.svlanCB.getModel().getSize();
            iVlanInfo = null;
            XPL2Layer2LineModel xPL2Layer2LineModel = (XPL2Layer2LineModel)this.portCB.getSelectedItem();
            bl = false;
            try {
                if (xPL2Layer2LineModel.getEtherBasicL2Info().sIngressCOS == 10) {
                    this.dscpCosButton.setEnabled(true);
                } else {
                    this.dscpCosButton.setEnabled(false);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (InvalidOperation invalidOperation) {
                if (!db.on()) break block9;
                SDebug.printStackTrace((Throwable)invalidOperation);
            }
        }
        for (int i = 0; i < n2; ++i) {
            iVlanInfo = (IVlanInfo)this.svlanCB.getItemAt(i);
            if (iVlanInfo.getVlanId() != n) continue;
            bl = true;
            this.svlanCB.setSelectedItem((Object)iVlanInfo);
            break;
        }
        if (!bl && this.svlanCB.getItemCount() > 0) {
            this.svlanCB.setSelectedIndex(0);
        }
        this.modeCB.setSelectedIndex(0);
        this.svlanCB.addActionListener((ActionListener)this);
        this.modeCB.addActionListener((ActionListener)this);
        this.resetDirty();
        this.validate();
        this.updateUI();
        if (this.fromNet) {
            this.qinqInfoFromNet.setQinQMode(1);
            this.svlanCB.setEnabled(false);
        }
    }

    private void prepareTabForSelectiveMode() {
        block24: {
            XPL2Layer2LineModel xPL2Layer2LineModel;
            block23: {
                this.modeCB.removeActionListener((ActionListener)this);
                this.svlanCB.setEnabled(false);
                this.gbp.remove(this.sVlanPane);
                this.gbp.add((Component)this.cVlanPane, 1, 1);
                xPL2Layer2LineModel = (XPL2Layer2LineModel)this.portCB.getSelectedItem();
                this.dataSvlanModel.updateModel(xPL2Layer2LineModel);
                if (this.fromNet) {
                    this.qinqInfoFromNet.setQinQMode(0);
                    if (this.dataSvlanModel.getRowCount() > 0 && !this.dataSvlanModel.hasSvlanEntryOnlyFromNet()) {
                        this.modeCB.setEnabled(false);
                    }
                    try {
                        if (xPL2Layer2LineModel.getEtherBasicL2Info().sIngressCOS == 10) {
                            if (this.qinqInfoFromNet.getDscpMapTable() != null) {
                                if (db.on()) {
                                    db.println("Already inizialised DSCP map table model ");
                                }
                                this.dscp2CosTable = this.qinqInfoFromNet.getDscpMapTable();
                            } else {
                                if (db.on()) {
                                    db.println("Initializing DSCP map table model ");
                                }
                                this.qinqInfoFromNet.setDscpMapTable(this.dscp2CosTable);
                            }
                        }
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)noSuchInterface);
                        }
                    }
                    catch (InvalidOperation invalidOperation) {
                        if (!db.on()) break block23;
                        SDebug.printStackTrace((Throwable)invalidOperation);
                    }
                }
            }
            try {
                int n;
                sMcastInfo sMcastInfo2 = this.eqpmtModel.getMvrInfo();
                if (sMcastInfo2.igmpEnabledOnCvlan && !(xPL2Layer2LineModel instanceof XPL2ChannelGroupModel)) {
                    n = this.table.convertColumnIndexToView(1);
                    if (n == -1) {
                        this.table.getColumnModel().addColumn(this.igmpColumn);
                    }
                } else {
                    this.table.getColumnModel().removeColumn(this.igmpColumn);
                }
                if (xPL2Layer2LineModel.getEtherBasicL2Info().sIngressCOS == 9) {
                    n = this.table.convertColumnIndexToView(5);
                    if (n == -1) {
                        this.table.getColumnModel().addColumn(this.cosColumn);
                    }
                } else {
                    this.table.getColumnModel().removeColumn(this.cosColumn);
                }
                if (xPL2Layer2LineModel.getEtherBasicL2Info().sIngressCOS == 10) {
                    this.dscpCosButton.setEnabled(true);
                } else {
                    this.dscpCosButton.setEnabled(false);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (InvalidOperation invalidOperation) {
                if (!db.on()) break block24;
                SDebug.printStackTrace((Throwable)invalidOperation);
            }
        }
        this.modeCB.setSelectedIndex(1);
        this.resetDirty();
        this.modeCB.addActionListener((ActionListener)this);
        this.validate();
        this.updateUI();
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        if (db.on()) {
            db.println("calling enteringPage");
        }
        this.getObsMgr().setPassing(true);
        this.registerWithModel();
        this.checkQinQXlteEntries();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    private void setUpArrayAndComboBoxes() {
        IVlanInfo[] iVlanInfoArray;
        this.uniL2Models = this.eqpmtModel.getXPL2UNILinesAndChGrps();
        this.layer2Models = this.eqpmtModel.getXPL2Layer2EtherLines();
        if (!this.fromNet) {
            iVlanInfoArray = this;
            VetoableComboBoxModel vetoableComboBoxModel = (XPL2QinQProvPane)this.new VetoableComboBoxModel(this.uniL2Models);
            vetoableComboBoxModel.addVetoableSelectionListener(new VetoableComboBoxSelectionListener((XPL2QinQProvPane)iVlanInfoArray){
                final /* synthetic */ XPL2QinQProvPane val$provPane;
                {
                    this.val$provPane = xPL2QinQProvPane2;
                }

                @Override
                public boolean selectionChanged(VetoableChangeEvent vetoableChangeEvent) {
                    if (XPL2QinQProvPane.this.isProvPaneDirty()) {
                        switch (CerentDialog.cancelableQuestionDialog((Component)((Object)this.val$provPane), (String)"Is it OK to apply these changes?", (String)"Changes Not Applied")) {
                            case 0: {
                                XPL2QinQProvPane.this.applyChanges = true;
                                return true;
                            }
                            case 1: {
                                return true;
                            }
                        }
                        return false;
                    }
                    return true;
                }
            });
            this.portCB.setModel((ComboBoxModel)vetoableComboBoxModel);
        }
        iVlanInfoArray = this.eqpmtModel.getVlanDb();
        this.svlanCB.setModel(new DefaultComboBoxModel<IVlanInfo>(iVlanInfoArray));
        this.svlanCBEditor.setModel(new DefaultComboBoxModel<IVlanInfo>(iVlanInfoArray));
        this.intSvlanCBEditor.setModel(new DefaultComboBoxModel<IVlanInfo>(iVlanInfoArray));
        if (this.portModels.length == 0) {
            this.portCB.setEnabled(false);
            this.modeCB.setEnabled(false);
            this.svlanCB.setEnabled(false);
            this.bpduCB.setEnabled(false);
            this.addRowButton.setEnabled(false);
            this.removeRowButton.setEnabled(false);
        } else {
            this.portCB.setEnabled(true);
            this.enableComponent((JComponent)this.modeCB, (IModel)this.nm);
            this.enableComponent((JComponent)this.svlanCB, (IModel)this.nm);
            this.enableComponent((JComponent)this.bpduCB, (IModel)this.nm);
            this.enableComponent(this.addRowButton, (IModel)this.nm);
            this.enableComponent(this.removeRowButton, (IModel)this.nm);
        }
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
        super.leavingPage();
        this.getObsMgr().setPassing(false);
        this.unRegisterWithModel();
    }

    protected void customizedTableSvlan() {
        TableColumn tableColumn = null;
        tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new ColorTableRenderer());
        tableColumn = this.table.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(new ColorTableRenderer());
        if (this.fromNet) {
            tableColumn.setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (n2 == 2) {
                        component.setBackground(Color.LIGHT_GRAY);
                    }
                    return component;
                }
            });
        }
        this.svlanCBEditor = new UComboBox();
        this.svlanCBEditor.setRenderer((ListCellRenderer)this.comboRenderer);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JComboBox<?>)this.svlanCBEditor);
        defaultCellEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(defaultCellEditor);
        tableColumn = this.table.getColumnModel().getColumn(3);
        this.operationCBEditor = new UComboBox();
        this.operationCBEditor.setRenderer((ListCellRenderer)this.comboRenderer);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OPERMODE.ADD.getName());
        arrayList.add(OPERMODE.TRANSLATE.getName());
        arrayList.add(OPERMODE.DOUBLE_ADD.getName());
        arrayList.add(OPERMODE.TRANSLATE_ADD.getName());
        this.operationCBEditor.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        defaultCellEditor = new DefaultCellEditor((JComboBox<?>)this.operationCBEditor);
        defaultCellEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(defaultCellEditor);
        tableColumn = this.table.getColumnModel().getColumn(4);
        tableColumn.setCellRenderer(new ColorTableRenderer());
        this.intSvlanCBEditor = new UComboBox();
        this.intSvlanCBEditor.setRenderer((ListCellRenderer)this.comboRenderer);
        defaultCellEditor = new DefaultCellEditor((JComboBox<?>)this.intSvlanCBEditor);
        defaultCellEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(defaultCellEditor);
        tableColumn = this.table.getColumnModel().getColumn(5);
        this.cosCBEditor = new UComboBox();
        this.cosCBEditor.setRenderer((ListCellRenderer)this.comboRenderer);
        ArrayList<Short> arrayList2 = new ArrayList<Short>();
        for (int i = 0; i < 8; ++i) {
            arrayList2.add(new Short((short)i));
        }
        this.cosCBEditor.setModel(new DefaultComboBoxModel<Object>(arrayList2.toArray()));
        defaultCellEditor = new DefaultCellEditor((JComboBox<?>)this.cosCBEditor);
        defaultCellEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(defaultCellEditor);
        tableColumn = this.table.getColumnModel().getColumn(1);
        final TableCellRenderer tableCellRenderer = this.table.getDefaultRenderer(Boolean.class);
        tableColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                TableModel tableModel;
                Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                int n3 = jTable.convertColumnIndexToModel(n2);
                if (n3 == 1 && !(tableModel = jTable.getModel()).isCellEditable(n, n3)) {
                    component.setBackground((Color)UIManager.get("Label.disabledForeground"));
                }
                return component;
            }
        });
    }

    @Override
    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.dataSvlanModel != null) {
            this.dataSvlanModel.removeTableModelListener(this);
            this.dataSvlanModel.dispose();
        }
        super.destroy();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataSvlanModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void applyChangesToModel() throws Exception {
        XPL2Layer2LineModel xPL2Layer2LineModel = (XPL2Layer2LineModel)this.portCB.getSelectedItem();
        sQinQInfo sQinQInfo2 = xPL2Layer2LineModel.getQinQInfo();
        if (this.checkDiplayWarningMsgAndIfToContinue(xPL2Layer2LineModel, this.modeCB.getSelectedIndex() == 0)) {
            dscp2Cos[] dscp2CosArray;
            if (this.bpduCB.getSelectedIndex() == 0) {
                xPL2Layer2LineModel.setBpdu(Boolean.TRUE);
            } else {
                xPL2Layer2LineModel.setBpdu(Boolean.FALSE);
            }
            if (xPL2Layer2LineModel.getEtherBasicL2Info().sIngressCOS == 10) {
                dscp2CosArray = new dscp2Cos[64];
                for (int i = 0; i < 64; ++i) {
                    dscp2CosArray[i] = new dscp2Cos(this.dscp2CosTable[i][0], this.dscp2CosTable[i][1]);
                }
                dscp2CosInfo dscp2CosInfo2 = new dscp2CosInfo(dscp2CosArray);
                xPL2Layer2LineModel.setDscp2CosInfo(dscp2CosInfo2);
            }
            if (this.modeCB.getSelectedIndex() == 0) {
                sQinQInfo2.qinqMode = eQinQMode.TRASPARENT_MODE;
                dscp2CosArray = this.eqpmtModel.getVlanDb();
                if (dscp2CosArray.length == 0) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_VLAN_VLAN_DB_EMPTY);
                    this.refresh();
                    return;
                }
                sQinQInfo2.trasparentSvlanId = ((IVlanInfo)this.svlanCB.getSelectedItem()).getVlanId();
                sQinQInfo2.igmpCvlan = (short)-3;
                xPL2Layer2LineModel.setQinQInfo(sQinQInfo2);
            } else {
                sQinQInfo2.qinqMode = eQinQMode.SELECTIVE_MODE;
                xPL2Layer2LineModel.setQinQInfo(sQinQInfo2);
                xPL2Layer2LineModel.setVlanCrossInfoList(this.dataSvlanModel.getVlanCrossInfoList());
                if (this.eqpmtModel.getMvrInfo().igmpEnabledOnCvlan) {
                    sQinQInfo2.igmpCvlan = this.dataSvlanModel.getIgmpCvlan();
                    xPL2Layer2LineModel.setQinQInfo(sQinQInfo2);
                } else {
                    sQinQInfo2.igmpCvlan = (short)-3;
                    xPL2Layer2LineModel.setQinQInfo(sQinQInfo2);
                }
            }
            this.resetDirty();
        }
    }

    public boolean checkDiplayWarningMsgAndIfToContinue(XPL2Layer2LineModel xPL2Layer2LineModel, boolean bl) {
        block7: {
            try {
                if (xPL2Layer2LineModel.getAdminState() != 1) {
                    sQinQInfo sQinQInfo2 = xPL2Layer2LineModel.getQinQInfo();
                    short s = 0;
                    if (bl) {
                        s = ((IVlanInfo)this.svlanCB.getSelectedItem()).getVlanId();
                    }
                    if (!bl && this.dataSvlanModel.isVlanCrossInfoListUpdated() || bl && sQinQInfo2.trasparentSvlanId != s && sQinQInfo2.qinqMode == eQinQMode.TRASPARENT_MODE) {
                        return ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)EMC.WID_SVLAN_SETTING, "Warning Message", "QinQ");
                    }
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    db.println("NoSuchInterface caught in checkDiplayWarningMsgAndIfToContinue() " + (Object)((Object)noSuchInterface));
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!db.on()) break block7;
                db.println("WrongInterfaceType caught in checkDiplayWarningMsgAndIfToContinue() " + (Object)((Object)wrongInterfaceType));
            }
        }
        return true;
    }

    private void reset() {
        block2: {
            try {
                this.initQinQInfoFromNet();
                this.dataSvlanModel.clearSvlanCrossInfoList();
                this.refreshFromModel();
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("Exception caught in reset() " + exception);
            }
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.portModels = this.eqpmtModel.getPortModels();
        this.linesModels = this.eqpmtModel.getXPL2EtherLines();
        this.layer2Models = this.eqpmtModel.getXPL2Layer2EtherLines();
        this.uniL2Models = this.eqpmtModel.getXPL2UNILinesAndChGrps();
        int n = this.portCB.getSelectedIndex();
        if (!this.isProvPaneDirty()) {
            this.setUpArrayAndComboBoxes();
        }
        if (n != -1 && this.portCB.getModel().getSize() > n) {
            this.portCB.setSelectedIndex(n);
        }
        if (this.fromNet) {
            this.portCB.setEnabled(false);
            this.refreshFromModelSelectItemNet();
        } else {
            this.refreshFromModelSelectItem();
        }
    }

    public void refreshFromModelSelectItem() throws Exception {
        if (this.uniL2Models.length != 0) {
            XPL2Layer2LineModel xPL2Layer2LineModel = (XPL2Layer2LineModel)this.portCB.getSelectedItem();
            sQinQInfo sQinQInfo2 = null;
            sQinQInfo2 = xPL2Layer2LineModel.getQinQInfo();
            if (xPL2Layer2LineModel.getEtherBasicL2Info().sIngressCOS == 10) {
                this.loadDscp2CosTableFromModel(xPL2Layer2LineModel);
            }
            if (xPL2Layer2LineModel.getBpdu().booleanValue()) {
                this.bpduCB.setSelectedIndex(0);
            } else {
                this.bpduCB.setSelectedIndex(1);
            }
            if (sQinQInfo2.qinqMode == eQinQMode.SELECTIVE_MODE) {
                this.prepareTabForSelectiveMode();
            } else {
                this.prepareTabForTransparentMode(sQinQInfo2.trasparentSvlanId);
            }
        }
    }

    private void loadDscp2CosTableFromModel(XPL2Layer2LineModel xPL2Layer2LineModel) throws NoSuchInterface, WrongInterfaceType {
        if (db.on()) {
            db.println("Loading Dscp2Cos mapping table...");
        }
        dscp2CosInfo dscp2CosInfo2 = xPL2Layer2LineModel.getDscp2CosInfo();
        for (int i = 0; i < 64; ++i) {
            this.dscp2CosTable[i][0] = dscp2CosInfo2.dscp2CosTable[i].dscp;
            this.dscp2CosTable[i][1] = dscp2CosInfo2.dscp2CosTable[i].cos;
        }
    }

    public void refreshFromModelSelectItemNet() throws Exception {
        if (this.uniL2Models.length != 0) {
            if (this.qinqInfoFromNet.getQinQBPDU()) {
                this.bpduCB.setSelectedIndex(0);
            } else {
                this.bpduCB.setSelectedIndex(1);
            }
            if (this.qinqInfoFromNet.getQinQMode() == 0) {
                this.prepareTabForSelectiveMode();
            } else {
                this.prepareTabForTransparentMode(this.selSVLANId);
            }
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2QinQProvPane;
    }

    public short[][] getDscp2CosTable() {
        return this.dscp2CosTable;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof DwdmLineUpdate) {
            this.requestRefresh(observable, this.getEtherPortUpdateThread(observable));
        }
        if ((observable instanceof PortModel || observable instanceof XPL2LineModel || observable instanceof XPL2Layer2LineModel || observable instanceof XPL2ModuleModel) && object instanceof Integer) {
            if (object.equals(ModelUpdateType.DELETED)) {
                this.resetDirty();
            }
            this.requestRefresh(observable, this.getEtherPortUpdateThread(observable));
        }
    }

    private Runnable getEtherPortUpdateThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    XPL2QinQProvPane.this.refreshEtherPortFromUpdates(observable);
                }
                catch (Exception exception) {
                    db.fine("Caught " + exception + " in Refreshing XPL2QinQProvPane");
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshEtherPortFromUpdates(Observable observable) {
        XPL2QinQProvPane xPL2QinQProvPane = this;
        synchronized (xPL2QinQProvPane) {
            if (this.dialogDisplayed) {
                return;
            }
            this.stopTableCellEditing();
            if (this.isProvPaneDirty()) {
                this.dialogDisplayed = true;
                switch (CerentDialog.questionDialog((Component)((Object)this), (String)"New update(s) have arrived.  Is it OK to apply these changes before updating?", (String)"New Updates")) {
                    case 0: {
                        this.apply();
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.unRegisterWithModel();
                        this.refresh();
                        this.registerWithModel();
                    }
                }
                this.dialogDisplayed = false;
            } else {
                this.unRegisterWithModel();
                this.refresh();
                this.registerWithModel();
            }
        }
    }

    public ComboBoxRenderer getComboRenderer() {
        return this.comboRenderer;
    }

    public void checkQinQXlteEntries() {
        int n = this.portCB.getItemCount();
        String string = new String();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            XPL2Layer2LineModel xPL2Layer2LineModel = (XPL2Layer2LineModel)this.portCB.getItemAt(i);
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            this.dataSvlanModel.updateModel(xPL2Layer2LineModel);
            if (db.on()) {
                db.println("getNumXTLEntries = " + this.dataSvlanModel.getNumXTLEntries());
            }
            if (this.dataSvlanModel.getNumXTLEntries() <= 384) continue;
            try {
                string = string.concat(entityCellRenderer.getPortString((IEntityModel)xPL2Layer2LineModel.getPort(), false));
                string = string.concat("\n");
                n2 = 1;
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (n2 > 0) {
            IgnorableDialog.infoDialog((Component)((Object)this), (String)("The latest release supports a maximum of 384 QinQ \"TRANSLATE\" entries\nwith two  VLAN tags for  egress traffic. If the QinQ TRANSLATE entries\nexceed 384, the traffic is egressed with a single VLAN tag. After upgrading\nto this  release, it is recommended that the excess entries are removed to\nensure that the QinQ \"TRANSLATE\" entries are restricted to a maximum of 384.\nFollowing ports have QinQ \"TRANSLATE\" entries exceeded :\n" + string), (String)"Warning", (String)"qInqXlateExceedAck", (String)"Acknowledge that QinQ translate entries exceeded");
        }
    }

    class ColorTableRenderer
    extends DefaultTableCellRenderer {
        public ColorTableRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = jTable.convertColumnIndexToModel(n2);
            if (n3 == 4) {
                TableModel tableModel = jTable.getModel();
                if (tableModel.getValueAt(n, 3).equals(OPERMODE.ADD.getName()) || tableModel.getValueAt(n, 3).equals(OPERMODE.TRANSLATE.getName())) {
                    component.setBackground((Color)UIManager.get("Label.disabledForeground"));
                } else if (!bl) {
                    component.setBackground((Color)UIManager.get("List.textBackground"));
                }
            } else if (n3 == 0) {
                TableModel tableModel = jTable.getModel();
                if (tableModel.getValueAt(n, 3).equals(OPERMODE.DOUBLE_ADD.getName())) {
                    component.setBackground((Color)UIManager.get("Label.disabledForeground"));
                } else if (!bl) {
                    component.setBackground((Color)UIManager.get("List.textBackground"));
                }
            }
            return component;
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                this.setText("");
                return this;
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object instanceof XPL2Layer2LineModel) {
                XPL2Layer2LineModel xPL2Layer2LineModel = (XPL2Layer2LineModel)object;
                EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                try {
                    this.setText(entityCellRenderer.getPortString((IEntityModel)xPL2Layer2LineModel.getPort(), false));
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
            } else if (object instanceof XPL2LineModel) {
                XPL2LineModel xPL2LineModel = (XPL2LineModel)object;
                EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                try {
                    this.setText(entityCellRenderer.getPortString((IEntityModel)xPL2LineModel.getPort(), false));
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
            } else if (object instanceof PortModel) {
                IPortModel iPortModel = (IPortModel)object;
                EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                this.setText(entityCellRenderer.getPortString((IEntityModel)iPortModel, false));
            } else if (object instanceof IVlanInfo) {
                this.setText(((IVlanInfo)object).getVlanId() + "");
            } else if (object instanceof Short) {
                this.setText(((Short)object).toString());
            } else if (object instanceof String) {
                this.setText((String)object);
            }
            return this;
        }
    }

    class VetoableChangeEvent
    extends ChangeEvent {
        private Object newValue;

        public VetoableChangeEvent(Object object, Object object2) {
            super(object);
            this.newValue = object2;
        }

        public Object getNewValue() {
            return this.newValue;
        }
    }

    class VetoableComboBoxModel
    extends DefaultComboBoxModel {
        private ArrayList<VetoableComboBoxSelectionListener> selectionListeners;

        public VetoableComboBoxModel() {
            this.selectionListeners = new ArrayList();
        }

        public VetoableComboBoxModel(Object[] objectArray) {
            super(objectArray);
            this.selectionListeners = new ArrayList();
        }

        public void addVetoableSelectionListener(VetoableComboBoxSelectionListener vetoableComboBoxSelectionListener) {
            this.selectionListeners.add(vetoableComboBoxSelectionListener);
        }

        public void removeVetoableSelectionListener(VetoableComboBoxSelectionListener vetoableComboBoxSelectionListener) {
            this.selectionListeners.remove(vetoableComboBoxSelectionListener);
        }

        protected boolean fireVetoableSelectionChange(Object object) {
            boolean bl = true;
            VetoableChangeEvent vetoableChangeEvent = new VetoableChangeEvent(this, object);
            for (VetoableComboBoxSelectionListener vetoableComboBoxSelectionListener : this.selectionListeners) {
                bl &= vetoableComboBoxSelectionListener.selectionChanged(vetoableChangeEvent);
            }
            return bl;
        }

        @Override
        public void setSelectedItem(Object object) {
            Object object2 = this.getSelectedItem();
            if (this.fireVetoableSelectionChange(object)) {
                if (XPL2QinQProvPane.this.applyChanges) {
                    XPL2QinQProvPane.this.apply();
                    XPL2QinQProvPane.this.applyChanges = false;
                }
                super.setSelectedItem(object);
                try {
                    XPL2QinQProvPane.this.refreshFromModelSelectItem();
                }
                catch (Exception exception) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            } else {
                super.setSelectedItem(object2);
            }
        }
    }

    static interface VetoableComboBoxSelectionListener
    extends EventListener {
        public boolean selectionChanged(VetoableChangeEvent var1);
    }
}

