/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sCVlanRange;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.xpl2.XPL2QinQProvPane;
import cerent.cms.ui.xpl2.XPL2QinQSvlanTableModel;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.UComboBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class XPL2QinQRangeDialog
extends JDialog
implements ActionListener {
    private static final SDebug db = new SDebug("XPL2QinQRangeDialog");
    private static final String TITLE = "Add CVLAN<>SVLAN Range";
    public static final String OK = "OK";
    public static final String CANCEL = "Cancel";
    public static final int MARGIN = 10;
    private JLabel addLabel = null;
    private UComboBox svlanCombo = null;
    private JTextField rangeTxtField = null;
    private JButton okButton;
    private JButton cancelButton;
    private static XPL2QinQRangeDialog instance;
    private XPL2QinQProvPane provPane = null;
    private XPL2ModuleModel eqpmtModel = null;
    protected boolean isCVlanRangeCorrect;
    protected static final Color EDITING_COLOR;
    protected static final Color ERROR_COLOR;

    private XPL2QinQRangeDialog(XPL2QinQProvPane xPL2QinQProvPane, XPL2ModuleModel xPL2ModuleModel) {
        super(JOptionPane.getFrameForComponent((Component)((Object)xPL2QinQProvPane)), TITLE, true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XPL2QinQRangeDialog.this.dispose();
            }
        });
        this.eqpmtModel = xPL2ModuleModel;
        this.provPane = xPL2QinQProvPane;
        this.init();
    }

    public static XPL2QinQRangeDialog getInstance(XPL2QinQProvPane xPL2QinQProvPane, XPL2ModuleModel xPL2ModuleModel) {
        if (instance == null) {
            instance = new XPL2QinQRangeDialog(xPL2QinQProvPane, xPL2ModuleModel);
        }
        if (xPL2QinQProvPane != XPL2QinQRangeDialog.instance.provPane) {
            XPL2QinQRangeDialog.instance.eqpmtModel = xPL2ModuleModel;
            XPL2QinQRangeDialog.instance.provPane = xPL2QinQProvPane;
        }
        instance.refresh();
        return instance;
    }

    private void refresh() {
        if (this.provPane.fromNet) {
            IVlanInfo[] iVlanInfoArray = this.eqpmtModel.getVlanDb();
            for (int i = 0; i < iVlanInfoArray.length; ++i) {
                if (iVlanInfoArray[i].getVlanId() != this.provPane.selSVLANId) continue;
                this.svlanCombo.setModel(new DefaultComboBoxModel<IVlanInfo>(new IVlanInfo[]{iVlanInfoArray[i]}));
                break;
            }
        } else {
            this.svlanCombo.setModel(new DefaultComboBoxModel<IVlanInfo>(this.eqpmtModel.getVlanDb()));
        }
    }

    private void init() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.createPortPane(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.setSize(250, 150);
        this.setLocationRelativeTo((Component)((Object)this.provPane));
        this.setResizable(false);
    }

    private JPanel createPortPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        double[] dArray = new double[]{0.0, 0.5, 0.5, 1.0, 0.0, 1.0E-4};
        double[] dArray2 = new double[]{1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0E-4};
        gridBagLayout.columnWidths = nArray;
        gridBagLayout.rowHeights = nArray2;
        gridBagLayout.columnWeights = dArray;
        gridBagLayout.rowWeights = dArray2;
        JLabel jLabel = new JLabel("Operation: ");
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel("SVLAN: ");
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel3 = new JLabel("Range: ");
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addLabel = new JLabel("ADD");
        jPanel.add((Component)this.addLabel, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.svlanCombo = new UComboBox(new DefaultComboBoxModel<IVlanInfo>(this.eqpmtModel.getVlanDb()));
        this.svlanCombo.setRenderer((ListCellRenderer)this.provPane.getComboRenderer());
        jPanel.add((Component)this.svlanCombo, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.rangeTxtField = new JTextField();
        this.rangeTxtField.setAlignmentX(0.5f);
        this.rangeTxtField.setText("0-0");
        jPanel.add((Component)this.rangeTxtField, new GridBagConstraints(1, 5, 3, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (((XPL2QinQSvlanTableModel)this.provPane.getTable().getModel()).checkCVlanRange(this.rangeTxtField.getText(), new sCVlanRange())) {
                this.fillTableWithRowRanges();
                this.rangeTxtField.setText("0-0");
                this.dispose();
            } else {
                this.rangeTxtField.select(0, this.rangeTxtField.getText().length());
            }
        } else if (object == this.cancelButton) {
            this.rangeTxtField.setText("0-0");
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    private void fillTableWithRowRanges() {
        String string = this.rangeTxtField.getText();
        String[] stringArray = string.split("-");
        try {
            short s = Short.valueOf(stringArray[0]);
            short s2 = Short.valueOf(stringArray[1]);
            ((XPL2QinQSvlanTableModel)this.provPane.getTable().getModel()).addRows(((IVlanInfo)this.svlanCombo.getSelectedItem()).getVlanId(), s, s2);
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 10, 10));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        this.okButton.setPreferredSize(this.cancelButton.getPreferredSize());
        this.cancelButton.setPreferredSize(this.okButton.getPreferredSize());
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    static {
        EDITING_COLOR = Color.WHITE;
        ERROR_COLOR = Color.RED;
    }
}

