/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sRepAdminVlan;
import cerent.cms.model.ConfigError;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class XPL2REPAdminVLANPane
extends NodeProvPane
implements ActionListener,
DocumentListener {
    private XPL2ModuleModel module;
    protected JComboBox svlanCB;
    protected JTextField cVlanTF;
    protected boolean hasProvPrivilege = false;
    private sRepAdminVlan repAdminVlan;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "XPL2REPAdminVLANPane");

    protected JPanel createVLANPanel() {
        JPanel jPanel = XPL2REPAdminVLANPane.createHorizontalPanel(null);
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.anchorWest();
        gridBagPanel.inset(4, 1);
        int n = 0;
        gridBagPanel.add(new JLabel("SVLAN:"), 0, n++, 1, 1);
        gridBagPanel.add(new JLabel("CVLAN:"), 0, n++, 1, 1);
        gridBagPanel.fillBoth(100, 0);
        this.svlanCB = new JComboBox<Short>(new DefaultComboBoxModel<Short>(this.getSvlanListFromModule()));
        this.svlanCB.addActionListener(this);
        this.svlanCB.setEditable(true);
        this.cVlanTF = new JTextField(10);
        this.cVlanTF.getDocument().addDocumentListener(this);
        n = 0;
        gridBagPanel.add((Component)this.svlanCB, 1, n++);
        gridBagPanel.add((Component)this.cVlanTF, 1, n++);
        jPanel.add(gridBagPanel);
        jPanel.add(Box.createHorizontalStrut(50));
        this.svlanCB.setEnabled(this.hasProvPrivilege);
        this.cVlanTF.setEnabled(this.hasProvPrivilege);
        return jPanel;
    }

    public XPL2REPAdminVLANPane(String string, TabbedView tabbedView, XPL2ModuleModel xPL2ModuleModel) {
        super(string, tabbedView);
        this.module = xPL2ModuleModel;
        this.repAdminVlan = new sRepAdminVlan();
        this.init();
    }

    private Short[] getSvlanListFromModule() {
        IVlanInfo[] iVlanInfoArray = this.module.getVlanDb();
        Short[] shortArray = new Short[iVlanInfoArray.length];
        for (int i = 0; i < iVlanInfoArray.length; ++i) {
            shortArray[i] = iVlanInfoArray[i].getVlanId();
        }
        return shortArray;
    }

    private void init() {
        this.hasProvPrivilege = this.isUserAuthorized(SecurityLevel.PROVISIONING);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBorder(BorderFactory.createTitledBorder("Admin VLANS"));
        jPanel.add(this.createVLANPanel());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        this.add((Component)new UScrollPane((Component)jPanel2));
        this.registerWithModel();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Short s;
        if (actionEvent.getSource() == this.svlanCB && this.repAdminVlan.svlan != (s = (Short)this.svlanCB.getSelectedItem())) {
            this.repAdminVlan.svlan = s;
            this.setDirty();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        Short s;
        if (db.on()) {
            db.println("Document event insertUpdate ");
        }
        if (this.repAdminVlan.cvlan != (s = Short.valueOf(this.cVlanTF.getText()))) {
            this.repAdminVlan.cvlan = s;
            this.setDirty();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (db.on()) {
            db.println("Document event changedUpdate ");
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (db.on()) {
            db.println("Document event removeUpdate ");
        }
        this.setDirty();
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel: start");
        }
        this.repAdminVlan = this.module.getRepAdminVlan();
        Short s = this.repAdminVlan.svlan;
        this.svlanCB.setSelectedItem(s);
        String string = String.valueOf(this.repAdminVlan.cvlan);
        this.cVlanTF.setText(string);
        this.resetDirty();
        if (db.on()) {
            db.println("refreshFromModel: finish");
        }
    }

    @Override
    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("applyChangesToModel: start");
        }
        this.validateValues();
        try {
            this.module.setRepAdminVlan(this.repAdminVlan);
        }
        catch (Exception exception) {
            this.refreshFromModel();
            throw new ConfigError(exception.getMessage());
        }
        if (db.on()) {
            db.println("applyChangesToModel: finish");
        }
    }

    private void validateValues() throws Exception {
        if (this.repAdminVlan.cvlan < 0 || this.repAdminVlan.cvlan > 4094) {
            throw new Exception("REP Admin CVLAN value must be between 1..4094. 0 is used to indicate an unreserved Vlan value.");
        }
        if (this.repAdminVlan.svlan < 0 || this.repAdminVlan.svlan > 4093) {
            throw new Exception("REP Admin SVLAN value must be between 1..4093. 0 is used to indicate an unreserved Vlan value.");
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2REPAdminVLANPane;
    }
}

