/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.Common.sEtherMacAddr;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.xpl2.XPL2MacFilterTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.MacAddrCellEditor;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XPL2SecurityMacAdrressFilterDialog
extends JDialog
implements ActionListener {
    private static final String TITLE = "Edit Mac Address";
    public static final String ADD = "Add";
    public static final String REMOVE = "Remove";
    public static final String OK = "OK";
    public static final String CANCEL = "Cancel";
    public static final int MARGIN = 25;
    private static final SDebug db = new SDebug("XPL2SecurityMacAdrressFilterDialog");
    private static final int MAX_ROW_COUNT = 25;
    protected XPL2ModuleModel eqpmtModel = null;
    private JButton addButton;
    private JButton remuveButton;
    private JButton okButton;
    private JButton cancelButton;
    UTable table;
    protected XPL2MacFilterTableModel dataModel = null;

    public XPL2SecurityMacAdrressFilterDialog(Frame frame, XPL2ModuleModel xPL2ModuleModel, sEtherMacAddr[] sEtherMacAddrArray) {
        super(frame, TITLE, true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XPL2SecurityMacAdrressFilterDialog.this.dispose();
            }
        });
        this.dataModel = this.dataModel;
        this.dataModel = new XPL2MacFilterTableModel(sEtherMacAddrArray);
        this.table = new UTable((TableModel)this.dataModel);
        TableColumn tableColumn = this.table.getColumn((Object)this.dataModel.getColumnName(0));
        tableColumn.setCellEditor(new MacAddrCellEditor());
        tableColumn.setPreferredWidth(150);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.createAttributesPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.addButton.setEnabled(AbstractPane.isUserAuthorized(xPL2ModuleModel, SecurityLevel.PROVISIONING));
        this.remuveButton.setEnabled(AbstractPane.isUserAuthorized(xPL2ModuleModel, SecurityLevel.PROVISIONING));
        this.okButton.setEnabled(AbstractPane.isUserAuthorized(xPL2ModuleModel, SecurityLevel.PROVISIONING));
        container.add((Component)uScrollPane);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
        }
        if (object == this.addButton) {
            if (this.dataModel.getRowCount() < 8) {
                this.dataModel.addRow();
            } else {
                CerentDialog.errorDialog((Component)this, (String)ErrorMsg.getString((EID)EMC.EID_MAX_MAC_ADDR_NUMBER_REACHED));
            }
        } else {
            if (object == this.remuveButton) {
                this.dataModel.removeRows(this.table.getSelectedRows());
                return;
            }
            if (object == this.okButton) {
                this.dataModel.applyToModel();
                this.dispose();
            } else if (object == this.cancelButton) {
                this.dispose();
            } else {
                throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
            }
        }
    }

    public sEtherMacAddr[] getMacTable() {
        return this.dataModel.getMacTable();
    }

    private JPanel createAttributesPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 25, 25));
        this.addButton = this.makeActionButton(ADD);
        jPanel.add(this.addButton);
        this.remuveButton = this.makeActionButton(REMOVE);
        jPanel.add(this.remuveButton);
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

