/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.helper;

import cerent.cms.model.CTCUserException;
import cerent.cms.xml.SchemaTagFactory;
import cerent.cms.xml.helper.BaseObjectHelper;
import cerent.cms.xml.helper.CDATAHelper;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.UTF8Utils;
import cerent.util.xml.DOMUtil;
import java.util.Iterator;
import org.w3c.dom.Node;

public class StringHelper
extends BaseObjectHelper {
    protected static final String LT_SYMBOL = "&lt;";
    protected static final String GT_SYMBOL = "&gt;";
    protected static final String AMP_SYMBOL = "&amp;";
    protected static final String APOS_SYMBOL = "&apos;";
    protected static final String QUOT_SYMBOL = "&quot;";
    static boolean doHexDump = Preferences.instance().getBoolean("ctc", "xml.hexdebugdump", true);
    static String charset = Preferences.instance().getProperty("ctc", "xml.charset", null);
    static boolean utf8Encode = charset != null && charset.compareToIgnoreCase("utf-8") == 0;
    static SDebug sdb = new SDebug("StringHelper");

    public static Node objectToXml(Object object, String string, Node node) throws CTCUserException {
        String string2;
        String string3 = string2 = object == null ? "" : StringHelper.normalize(object.toString());
        if (sdb.on()) {
            if (doHexDump) {
                db.println("o2x: '" + UTF8Utils.toHexDump((String)string2) + "'");
            } else {
                db.println("o2x: '" + string2 + "'");
            }
        }
        return BaseObjectHelper.objectToXml(string2, string, node);
    }

    public static Object nodeToObject(Node node, String string) throws CTCUserException {
        Iterator iterator;
        if (db.on()) {
            db.print("[StringHelper] nodeToObject(" + node.getNodeName() + ", " + string + ") ");
            db.print("[StringHelper] node is " + DOMUtil.nodeToString((Node)node));
        }
        if ((iterator = DOMUtil.getChildCDATANodes((Node)node)).hasNext()) {
            return CDATAHelper.nodeToObject(iterator, string);
        }
        String string2 = "";
        if (node.getFirstChild() != null && node.getFirstChild().getNodeValue() != null) {
            string2 = node.getFirstChild().getNodeValue();
            if (db.on()) {
                db.println("[StringHelper] getFirstChild().getNodeValue() : " + string2);
            }
        } else if (db.on()) {
            db.println("[WARNING] arg node value is NULL. Will substitute an empty string instead");
        }
        if (sdb.on()) {
            if (doHexDump) {
                db.println("x2o: '" + UTF8Utils.toHexDump((String)string2) + "'");
            } else {
                db.println("x2o: '" + string2 + "'");
            }
        }
        return string2;
    }

    public static Object toSchema(String string, String string2) throws CTCUserException {
        return SchemaTagFactory.createClosedElementTag(string, "string");
    }

    public static String normalize(String string) throws CTCUserException {
        if (utf8Encode) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string != null ? string.length() : 0;
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    stringBuilder.append(c);
                    continue block3;
                }
                default: {
                    if (!(Character.isSpaceChar(c) || c >= ' ' && c <= '~')) {
                        if (db.on()) {
                            db.println("Normalizing " + c + " to a space");
                        }
                        stringBuilder.append(" ");
                        continue block3;
                    }
                    if (db.on()) {
                        db.println("Adding " + c + " to the string");
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String denormalize(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        boolean bl = false;
        while (n2 < n) {
            if (string.charAt(n2) == '&') {
                if (string.regionMatches(n2, LT_SYMBOL, 0, 4)) {
                    stringBuilder.append('<');
                    n2 += 4;
                    continue;
                }
                if (string.regionMatches(n2, GT_SYMBOL, 0, 4)) {
                    stringBuilder.append('>');
                    n2 += 4;
                    continue;
                }
                if (string.regionMatches(n2, AMP_SYMBOL, 0, 5)) {
                    stringBuilder.append('&');
                    n2 += 5;
                    continue;
                }
                if (string.regionMatches(n2, APOS_SYMBOL, 0, 6)) {
                    stringBuilder.append('\'');
                    n2 += 6;
                    continue;
                }
                if (string.regionMatches(n2, QUOT_SYMBOL, 0, 6)) {
                    stringBuilder.append('\"');
                    n2 += 6;
                    continue;
                }
                stringBuilder.append('&');
                ++n2;
                continue;
            }
            stringBuilder.append(string.charAt(n2));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        String string;
        StringHelper stringHelper = new StringHelper();
        StringBuilder stringBuilder = new StringBuilder(128);
        System.out.println("Testing Normalize...");
        for (int i = 0; i < 128; ++i) {
            string = null;
            try {
                string = StringHelper.normalize(new Character((char)i).toString());
            }
            catch (CTCUserException cTCUserException) {
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            stringBuilder.append(string);
        }
        String string2 = "          \n  \r                   !&quot;#$%&amp;&apos;()*+,-./0123456789:;&lt;=&gt;?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ ";
        System.out.println("Testing denormalize...");
        string = StringHelper.denormalize(stringBuilder.toString());
        String string3 = "          \n  \r                   !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ ";
        if (string.equals(string3)) {
            System.out.println("PASSED");
        } else {
            System.out.println("FAILED - Output does not match expected output");
        }
    }
}

