/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.CoordinateElement;
import cerent.util.SDebug;
import cerent.util.gui.AbstractPropertyEditor;
import cerent.util.gui.SpinPropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CoordinatePropertyEditor
extends AbstractPropertyEditor
implements PropertyChangeListener {
    public static int LATITUDE = 0;
    public static int LONGITUDE = 1;
    private static int LATITUDE_DEGREE_SIZE = 2;
    private static int LONGITUDE_DEGREE_SIZE = 3;
    private static int MINUTE_SIZE = 2;
    private static int SECOND_SIZE = 5;
    private SpinPropertyEditor degEdit;
    private SpinPropertyEditor minEdit;
    private int type;
    private JComboBox dirCombo = new JComboBox();
    private boolean fromSetValue = false;
    private int degreeSize;
    private static final SDebug db = new SDebug("CoordinatePropertyEditor");

    public CoordinatePropertyEditor(String string, int n) {
        JLabel jLabel = new JLabel(string + " ");
        this.type = n;
        this.degreeSize = n == LATITUDE ? LATITUDE_DEGREE_SIZE : LONGITUDE_DEGREE_SIZE;
        this.setLayout(new BorderLayout());
        if (string != null && string.length() > 0) {
            this.add((Component)jLabel, "West");
        }
        if (n == LATITUDE) {
            this.dirCombo.addItem("N");
            this.dirCombo.addItem("S");
            this.degEdit = new SpinPropertyEditor(" ", "deg.", 1, 0, 90);
        } else {
            this.dirCombo.addItem("E");
            this.dirCombo.addItem("W");
            this.degEdit = new SpinPropertyEditor(" ", "deg.", 1, 0, 180);
        }
        this.minEdit = new SpinPropertyEditor(" ", "min.", 1, 0, 59);
        this.degEdit.setEditorSize(4);
        this.minEdit.setEditorSize(3);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.dirCombo, "North");
        jPanel.add((Component)new JLabel(" "), "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "West");
        jPanel2.add((Component)this.degEdit, "Center");
        jPanel2.add((Component)this.minEdit, "East");
        this.add((Component)jPanel2, "Center");
        this.dirCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!CoordinatePropertyEditor.this.fromSetValue) {
                    CoordinatePropertyEditor.this.setDirty(true);
                }
            }
        });
    }

    public JPanel makePanel(Component component, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel(string);
        jPanel.add(jLabel);
        jPanel.add(component);
        return jPanel;
    }

    @Override
    public boolean onValidate() {
        return this.degEdit.onValidate() || this.minEdit.onValidate();
    }

    @Override
    public Object getValue() {
        return String.valueOf(this.toDoubleValue());
    }

    public Object getValueEx() {
        String string = (String)this.dirCombo.getSelectedItem();
        string = this.type == LATITUDE ? string + this.padZero((String)this.degEdit.getValue(), LATITUDE_DEGREE_SIZE) : string + this.padZero((String)this.degEdit.getValue(), LONGITUDE_DEGREE_SIZE);
        string = string + this.padZero((String)this.minEdit.getValue(), MINUTE_SIZE);
        string = string + this.padZero("", SECOND_SIZE);
        return string;
    }

    private String padZero(String string, int n) {
        String string2 = "";
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            string2 = string2 + "0";
        }
        string2 = string2 + string;
        return string2;
    }

    @Override
    public void setValue(Object object) {
        String string = (String)object;
        if (string == null || string.length() == 0) {
            this.degEdit.setValue("0");
            this.minEdit.setValue("0");
            return;
        }
        try {
            if (this.isDoubleValue(string)) {
                string = this.toStringValue(Double.valueOf((String)object));
            }
        }
        catch (Exception exception) {
            return;
        }
        int n = string.length();
        if (this.type == LATITUDE && n < 1 + LATITUDE_DEGREE_SIZE + MINUTE_SIZE) {
            return;
        }
        if (this.type == LONGITUDE && n < 1 + LONGITUDE_DEGREE_SIZE + MINUTE_SIZE) {
            return;
        }
        this.fromSetValue = true;
        this.dirCombo.setSelectedItem(String.valueOf(string.charAt(0)));
        this.degEdit.setValue(string.substring(1, 1 + this.degreeSize));
        this.minEdit.setValue(string.substring(1 + this.degreeSize, 1 + this.degreeSize + MINUTE_SIZE));
        this.fromSetValue = false;
    }

    private boolean isDoubleValue(String string) {
        try {
            double d = Double.valueOf(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.degEdit.isDirty() || this.minEdit.isDirty();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.dirCombo.setEnabled(bl);
        this.degEdit.setEnabled(bl);
        this.minEdit.setEnabled(bl);
    }

    public double toDoubleValue() {
        double d = 0.0;
        int n = 1;
        String string = (String)this.dirCombo.getSelectedItem();
        if (string.equals("S") || string.equals("W")) {
            n = -1;
        }
        String string2 = (String)this.degEdit.getValue();
        String string3 = (String)this.minEdit.getValue();
        try {
            d += new Double(string2).doubleValue();
            d += new Double(string3) / 60.0;
        }
        catch (Exception exception) {
            db.println("Exception in toDoubleValue(); degStr=" + string2 + ", minStr=" + string3 + " " + exception);
        }
        return d * (double)n;
    }

    public String toStringValue(double d) {
        return CoordinateElement.toStringValue(d, this.type);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.degEdit.addPropertyChangeListener(this);
        this.minEdit.addPropertyChangeListener(this);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.degEdit.removePropertyChangeListener(this);
        this.minEdit.removePropertyChangeListener(this);
        super.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object instanceof AbstractPropertyEditor) {
            this.firePropertyChange();
        }
    }
}

