/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.SDebug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DualListModel
extends AbstractListModel
implements ListDataListener,
ActionListener {
    private JList src;
    private JList dst;
    private AbstractButton todst;
    private AbstractButton tosrc;
    private int dstMaxItems;
    private List srcItems;
    private List dstItems;
    private List srcRefItems;
    private List dstRefItems;
    private LocalListModel srcModel = null;
    private LocalListModel dstModel = null;
    private static final String TOSRC = "SRC";
    private static final String TODST = "DST";
    private boolean enabled = false;
    private MouseListener srcListener = null;
    private MouseListener dstListener = null;
    private static final SDebug db = new SDebug("DualListModel");

    public DualListModel(JList jList, JList jList2, List list, List list2, AbstractButton abstractButton, AbstractButton abstractButton2, int n) {
        this.src = jList;
        this.dst = jList2;
        this.todst = abstractButton;
        this.tosrc = abstractButton2;
        this.dstMaxItems = n;
        this.setContent(list, list2);
        this.setEnabled(true);
    }

    public void setContent(List list, List list2) {
        this.srcItems = list == null ? new ArrayList() : new ArrayList(list);
        this.dstItems = list2 == null ? new ArrayList() : new ArrayList(list2);
        this.removeListDataListeners();
        this.srcModel = new LocalListModel(this.srcItems);
        this.dstModel = new LocalListModel(this.dstItems);
        this.addListDataListeners();
        this.src.setModel(this.srcModel);
        this.dst.setModel(this.dstModel);
        this.syncButtons();
        this.fireContentsChanged(this.dstModel, 0, this.dstItems.size());
    }

    public void setContentOrderReference(List list, List list2) {
        this.srcRefItems = list;
        this.dstRefItems = list2;
    }

    public List getSrcContent() {
        return this.srcItems;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        if (bl) {
            this.todst.addActionListener(this);
            this.tosrc.addActionListener(this);
            this.todst.setActionCommand(TODST);
            this.tosrc.setActionCommand(TOSRC);
            if (this.srcListener == null) {
                this.srcListener = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getClickCount() == 2 && (DualListModel.this.dstMaxItems <= 0 || DualListModel.this.dst.getModel().getSize() < DualListModel.this.dstMaxItems)) {
                            DualListModel.this.moveItem(DualListModel.this.src, DualListModel.this.dst, DualListModel.this.dstRefItems, DualListModel.this.dstItems);
                        }
                    }
                };
            }
            if (this.dstListener == null) {
                this.dstListener = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getClickCount() == 2) {
                            int n = DualListModel.this.dst.locationToIndex(mouseEvent.getPoint());
                            DualListModel.this.moveItem(DualListModel.this.dst, DualListModel.this.src, DualListModel.this.srcRefItems, DualListModel.this.srcItems);
                        }
                    }
                };
            }
            this.src.addMouseListener(this.srcListener);
            this.dst.addMouseListener(this.dstListener);
        } else {
            this.todst.removeActionListener(this);
            this.tosrc.removeActionListener(this);
            if (this.srcListener != null) {
                this.src.removeMouseListener(this.srcListener);
            }
            if (this.dstListener != null) {
                this.dst.removeMouseListener(this.dstListener);
            }
        }
        this.enabled = bl;
        this.syncButtons();
    }

    public List getDstContent() {
        return this.dstItems;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(TOSRC)) {
            this.moveItem(this.dst, this.src, this.srcRefItems, this.srcItems);
        } else if (string.equals(TODST)) {
            this.moveItem(this.src, this.dst, this.dstRefItems, this.dstItems);
        }
    }

    public void moveItem(JList jList, Object object) {
        List list;
        List list2;
        JList jList2;
        List list3;
        if (jList == this.src) {
            list3 = this.srcItems;
            jList2 = this.dst;
            list2 = this.dstRefItems;
            list = this.dstItems;
        } else if (jList == this.dst) {
            list3 = this.dstItems;
            jList2 = this.src;
            list2 = this.srcRefItems;
            list = this.srcItems;
        } else {
            return;
        }
        int n = list3.indexOf(object);
        if (n > -1) {
            jList.setSelectedIndex(n);
            this.moveItem(jList, jList2, list2, list);
        }
    }

    protected void moveItem(JList jList, JList jList2, List list, List list2) {
        int n;
        Object[] objectArray = null;
        int n2 = -1;
        int[] nArray = jList.getSelectedIndices();
        int n3 = nArray.length;
        if (n3 > 0) {
            int n4;
            objectArray = new Object[n3];
            for (n = 0; n < n3; ++n) {
                n4 = nArray[n];
                objectArray[n] = jList.getModel().getElementAt(n4);
            }
            for (n = 0; n < n3; ++n) {
                int n5;
                Object object = objectArray[n];
                n2 = nArray[n];
                if (!((LocalListModel)jList.getModel()).removeObject(objectArray[n])) {
                    db.println("Error -- object is not in the from list anymore!");
                }
                n4 = -1;
                if (list != null && (n5 = this.getIndexOf(object, list)) >= 0) {
                    Object e;
                    int n6;
                    for (n4 = 0; n4 < list2.size() && (n6 = this.getIndexOf(e = list2.get(n4), list)) >= 0 && n6 <= n5; ++n4) {
                    }
                }
                if (n4 == -1) {
                    n4 = jList2.getModel().getSize();
                }
                ((LocalListModel)jList2.getModel()).insertObjectAt(n4, object);
                jList2.setSelectedIndex(n4);
                if (jList2 == this.dst) {
                    this.fireIntervalAdded(this.dstModel, n4, n4);
                    continue;
                }
                this.fireIntervalRemoved(this.dstModel, n2, n2);
            }
        }
        if (n2 > (n = jList.getModel().getSize()) - 1) {
            n2 = n - 1;
        }
        jList.setSelectedIndex(n2);
        this.syncButtons();
    }

    private int getIndexOf(Object object, List list) {
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e != object && !object.equals(e)) continue;
            return i;
        }
        return -1;
    }

    protected void syncButtons() {
        if (this.src.getModel().getSize() > 0 && this.src.getSelectedIndex() == -1) {
            this.src.setSelectedIndex(0);
        }
        if (this.dst.getModel().getSize() > 0 && this.dst.getSelectedIndex() == -1) {
            this.dst.setSelectedIndex(0);
        }
        if (this.enabled) {
            this.tosrc.setEnabled(this.dst.getModel().getSize() > 0);
            this.todst.setEnabled(this.src.getModel().getSize() > 0 && (this.dstMaxItems <= 0 || this.dst.getModel().getSize() < this.dstMaxItems));
        } else {
            this.tosrc.setEnabled(false);
            this.todst.setEnabled(false);
        }
    }

    @Override
    public int getSize() {
        return this.dstItems.size();
    }

    @Override
    public Object getElementAt(int n) {
        return this.dstItems.get(n);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.fireIntervalAdded(listDataEvent.getSource(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.fireIntervalRemoved(listDataEvent.getSource(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.fireContentsChanged(listDataEvent.getSource(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
    }

    private void addListDataListeners() {
        if (this.srcModel != null) {
            this.srcModel.addListDataListener(this);
        }
        if (this.dstModel != null) {
            this.dstModel.addListDataListener(this);
        }
    }

    private void removeListDataListeners() {
        if (this.srcModel != null) {
            this.srcModel.removeListDataListener(this);
        }
        if (this.dstModel != null) {
            this.dstModel.removeListDataListener(this);
        }
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        super.removeListDataListener(listDataListener);
        this.removeListDataListeners();
    }

    private class LocalListModel
    extends AbstractListModel {
        private List list;

        LocalListModel(List list) {
            this.list = list;
        }

        @Override
        public Object getElementAt(int n) {
            return this.list.get(n);
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        void insertObjectAt(int n, Object object) {
            this.list.add(n, object);
            this.fireIntervalAdded(this, n, n);
        }

        Object removeObjectAt(int n) {
            Object e = this.list.get(n);
            this.list.remove(n);
            this.fireIntervalRemoved(this, n, n);
            return e;
        }

        boolean removeObject(Object object) {
            int n = this.list.indexOf(object);
            boolean bl = this.list.remove(object);
            this.fireIntervalRemoved(this, n, n);
            return bl;
        }
    }
}

