/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.poller;

import cerent.cms.model.INodeModel;
import cerent.util.SDebug;
import cerent.util.threadpool.IActionClient;
import cerent.util.threadpool.IThreadWorker;
import cerent.util.threadpool.ThreadPool;
import com.cisco.crs.model.CLICommandFailure;
import com.cisco.crs.model.CLICommander;
import com.cisco.crs.model.PlatformNodeModel;
import com.cisco.crs.poller.IPollerClient;
import com.cisco.crs.poller.NoSessionException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ModelPoller
implements IActionClient {
    private static final int POLLING_TIME = 60;
    private static SDebug dbg;
    private static Map<INodeModel, ModelPoller> pollers;
    private PlatformNodeModel node;
    private List<IPollerClient> clients = new LinkedList<IPollerClient>();
    private SDebug db;
    private boolean isStarted;
    private static int pollingTime;

    public final void setPollingTimeSecs(int n) {
        pollingTime = n;
        this.stop();
        this.start();
    }

    private ModelPoller(PlatformNodeModel platformNodeModel) {
        this.node = platformNodeModel;
        if (dbg == null) {
            dbg = new SDebug("ModelPoller");
            dbg.addCommand(this, "dumpPollers", "Dump all the registered pollers");
            dbg.addCommand(this, "setPollingTimeSecs", "Changes the polling time for al pollers (in secs)");
        }
        this.db = platformNodeModel.getChildDebug(ModelPoller.class);
        if (this.isDbgOn()) {
            this.db.println("ModelPoller created for " + platformNodeModel.getName());
        }
    }

    public final void dumpPollers() {
        dbg.println("Dump pollers ---> BEGIN");
        for (INodeModel iNodeModel : pollers.keySet()) {
            dbg.println("Node: " + iNodeModel.getName());
            ModelPoller modelPoller = pollers.get(iNodeModel);
            for (IPollerClient iPollerClient : modelPoller.clients) {
                dbg.println("\tPoller: " + iPollerClient.prettyString());
            }
        }
        dbg.println("Dump pollers <--- END");
    }

    public static synchronized ModelPoller getInstance(PlatformNodeModel platformNodeModel) {
        ModelPoller modelPoller = pollers.get(platformNodeModel);
        if (modelPoller == null) {
            modelPoller = new ModelPoller(platformNodeModel);
            pollers.put(platformNodeModel, modelPoller);
        }
        return modelPoller;
    }

    public void start() {
        if (!this.isStarted) {
            if (this.isDbgOn()) {
                this.db.println("Start schedule each " + pollingTime + "secs");
            }
            ThreadPool.instance().enqueuePeriodicNonAwtClient((IActionClient)this, pollingTime);
            this.isStarted = true;
        }
    }

    public void stop() {
        if (this.isStarted) {
            if (this.isDbgOn()) {
                this.db.println("Stop schedule");
            }
            ThreadPool.instance().killPeriodicNonAwtClient((IActionClient)this);
            this.isStarted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPollerClient(final IPollerClient iPollerClient) {
        List<IPollerClient> list = this.clients;
        synchronized (list) {
            this.clients.add(iPollerClient);
        }
        ThreadPool.instance().enqueueClient(new IActionClient(){

            public void doAction() throws Exception {
                ModelPoller.this.doAction(iPollerClient);
            }

            public void failedAction(IThreadWorker iThreadWorker) {
            }

            public void dispose() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePollerClient(IPollerClient iPollerClient) {
        List<IPollerClient> list = this.clients;
        synchronized (list) {
            this.clients.remove(iPollerClient);
        }
    }

    private boolean isDbgOn() {
        return dbg.on() || this.db.on();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction() throws Exception {
        LinkedList<IPollerClient> linkedList;
        long l = System.currentTimeMillis();
        if (this.isDbgOn()) {
            this.db.println("Starting poller for " + this.node.getName());
        }
        List<IPollerClient> list = this.clients;
        synchronized (list) {
            linkedList = new LinkedList<IPollerClient>(this.clients);
        }
        this.doAction(linkedList);
        if (this.isDbgOn()) {
            this.db.println(linkedList.size() + " pollers completed in " + (System.currentTimeMillis() - l) + " ms");
        }
    }

    private void doAction(List<IPollerClient> list) throws IOException, NoSessionException {
        for (IPollerClient iPollerClient : list) {
            if (this.clients.indexOf(iPollerClient) == -1) {
                if (!this.isDbgOn()) break;
                this.db.println("Skipping removed client " + iPollerClient);
                break;
            }
            this.doAction(iPollerClient);
        }
    }

    private void doAction(IPollerClient iPollerClient) throws IOException, NoSessionException {
        String string = iPollerClient.getCommand();
        CLICommander cLICommander = this.node.getCLICommander();
        try {
            String string2 = cLICommander.sendCommand(string);
            if (this.clients.indexOf(iPollerClient) == -1) {
                if (this.isDbgOn()) {
                    this.db.println("Disposed, result discarded");
                }
                return;
            }
            iPollerClient.handleResult(string2);
        }
        catch (CLICommandFailure cLICommandFailure) {
            if (this.isDbgOn()) {
                this.db.println("Got error:" + cLICommandFailure.getMessage());
            }
            iPollerClient.handleError(cLICommandFailure);
        }
    }

    public void failedAction(IThreadWorker iThreadWorker) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.isDbgOn()) {
            this.db.println("Disposing poller for " + this.node.getName());
        }
        this.stop();
        Object object = this.clients;
        synchronized (object) {
            this.clients.clear();
        }
        object = pollers;
        synchronized (object) {
            pollers.remove(this.node);
        }
    }

    static {
        pollers = new HashMap<INodeModel, ModelPoller>();
        pollingTime = 60;
    }
}

