/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc310cl.ui.shelf;

import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.MfgData;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ICardPainter;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class CardPainter
implements ICardPainter {
    static final int TAB_MARGIN = 5;
    static final int CARD_WIDTH = 80;
    static final int CARD_2_5THS_HT = 240;
    static final int CARD_3_5THS_HT = 360;
    private static final int CONTROLLER_SLOT = 2;
    private static final int EXTENDER_SLOT = 1;
    private static final Dimension SMALL_CARD_DIM = new Dimension(240, 80);
    private static final Dimension LARGE_CARD_DIM = new Dimension(360, 80);
    public static final int NAME_X_OFFSET = 5;
    public static final int NAME_Y_OFFSET = 10;
    protected static final int LAN_WIDTH = 25;
    static final int PORT_WIDTH = 26;
    static final int SMALL_PORT_WIDTH = 13;
    static final int PORT_HEIGHT = 13;
    static final int PORT_CONN1_X = 8;
    static final int PORT_CONN2_X = 18;
    static final int SMALL_PORT_CONN1_X = 4;
    static final int SMALL_PORT_CONN2_X = 8;
    static final int PORT_CONN1_Y = 6;
    static final int PORT_CONN2_Y = 6;
    static final int PORT_LOOPBACK_DIST = 4;
    static final int BBE_WIDTH = 60;
    static final int WBE_WIDTH = 120;
    static final int OPTICON_X_SPACING = 29;
    static final int SMALL_OPTICON_X_SPACING = 15;
    static final int OPTICON_Y_SPACING = 0;
    static final int OPTICON_X_OFFSET = 34;
    static final int MULTIPORT_OPTICON_X_OFFSET = 130;
    static final int OPTICON_Y_OFFSET = 45;
    protected final Rectangle mainRectangle;
    protected CardGraphic cg;
    private static final int EXT_HEIGHT = 8;
    private static final int EXT_WIDTH = 80;
    private static final int LHS_EXT_X_OFFSET = 5;
    private static final int RHS_EXT_X_OFFSET = 274;
    private static final int EXT_Y_OFFSET = 72;
    private static final int EXT_L2_SIZE = 70;
    private static final int EXT_L3_SIZE = 10;
    private static final int ARC_WIDTH = 10;
    private static final int HALF_ARC_WIDTH = 5;
    private static final int ARC_HEIGHT = 8;
    public static final Line2D.Double extractorLine1 = new Line2D.Double(5.0, 72.0, 5.0, 80.0);
    public static final Line2D.Double extractorLine2 = new Line2D.Double(5.0, 72.0, 74.0, 72.0);
    public static final Arc2D.Double extractorArc1 = new Arc2D.Double(70.0, 72.0, 10.0, 8.0, 90.0, 180.0, 0);
    public static final Line2D.Double extractorLine3 = new Line2D.Double(75.0, 72.0, 84.0, 72.0);
    public static final Arc2D.Double extractorArc2 = new Arc2D.Double(80.0, 72.0, 10.0, 8.0, -90.0, 180.0, 0);

    public CardPainter(CardGraphic cardGraphic) {
        this.cg = cardGraphic;
        Dimension dimension = CardPainter.getSlotDim(this.cg.getSlot());
        this.mainRectangle = new Rectangle(0, 0, dimension.width, dimension.height);
    }

    @Override
    public void updateWidth() {
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3;
        int n4 = this.cg.getSlot();
        int n5 = this.cg.getState();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(graphics2D.getFont().deriveFont(1));
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        Font font = graphics2D.getFont();
        graphics2D.setColor(this.cg.getCurrentColor());
        graphics2D.fill(this.mainRectangle);
        graphics2D.setColor(Color.black);
        graphics2D.draw(this.mainRectangle);
        int n6 = 10;
        if (n4 != 2) {
            IEntityModel iEntityModel;
            String string = null;
            try {
                iEntityModel = this.cg.getModel();
                if (iEntityModel instanceof MfgEntityModel) {
                    string = new MfgData(((MfgEntityModel)iEntityModel).getMfgData()).getName();
                }
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                // empty catch block
            }
            Color color = iEntityModel = string == null ? null : this.getExtractorColor(n5, string.equals("FILLER"));
            if (iEntityModel != null) {
                graphics2D.setColor((Color)iEntityModel);
                n3 = 10;
                n6 = 10 + n3;
                graphics2D.fill(new Rectangle(0, 0, 240, n3));
                graphics2D.drawString(this.cg.getEqLabel(), 5, 10 + n3);
                graphics2D.setColor((Color)iEntityModel);
                graphics2D.fill(new Rectangle(0, 70, 240, 80));
                graphics2D.setColor(Color.black);
            }
            graphics2D.draw(extractorLine1);
            graphics2D.draw(extractorLine2);
            graphics2D.draw(extractorArc1);
            graphics2D.draw(extractorLine3);
            graphics2D.draw(extractorArc2);
        }
        graphics2D.drawString(this.cg.getEqLabel(), 5, n6);
        int n7 = 7;
        int n8 = 9;
        n3 = this.getCardHeight() - 5 - n8;
        int n9 = 30;
        Rectangle2D.Double double_ = new Rectangle2D.Double(n3, n9 - n7, n8, n7);
        boolean bl = true;
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.black);
        n3 -= 20;
        switch (n5) {
            case 5: {
                graphics2D.drawString("Act", n3, n9);
                graphics2D.setColor(Color.green);
                break;
            }
            case 4: {
                graphics2D.drawString("Sby", n3, n9);
                graphics2D.setColor(Color.yellow);
                break;
            }
            case 2: {
                graphics2D.drawString("Ldg", n3, n9);
                graphics2D.setColor(Color.white);
                break;
            }
            case 3: {
                graphics2D.drawString("Fail", n3, n9);
                graphics2D.setColor(Color.red);
                break;
            }
            case 0: {
                graphics2D.drawString("NP", n3, n9);
                graphics2D.setColor(this.cg.getCurrentColor());
                break;
            }
            case 1: {
                graphics2D.drawString("Mis", n3, n9);
                graphics2D.setColor(this.cg.getCurrentColor());
                break;
            }
            case 6: {
                graphics2D.drawString("Del", n3, n9);
                graphics2D.setColor(this.cg.getCurrentColor());
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            graphics2D.fill(double_);
            graphics2D.setColor(Color.black);
            graphics2D.draw(double_);
        }
        graphics2D.setColor(color);
    }

    protected static Dimension getSlotDim(int n) {
        Dimension dimension = SMALL_CARD_DIM;
        if (n == 2) {
            dimension = LARGE_CARD_DIM;
        } else if (n == 1) {
            dimension = SMALL_CARD_DIM;
        } else {
            SDebug.printStackTrace((Throwable)new Exception("Slot " + n + " out of expected range in getSlotDim()"));
        }
        return dimension;
    }

    public static void paintRJ45(Graphics2D graphics2D, String string, int n) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(n, 40.0, 25.0, 25.0);
        graphics2D.draw(double_);
        Font font = graphics2D.getFont();
        Font font2 = font.deriveFont(7.0f);
        graphics2D.setFont(font2);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
        int n2 = fontMetrics.stringWidth(string);
        graphics2D.drawString(string, n + (25 - n2) / 2 + 1, 75);
        graphics2D.setFont(font);
    }

    @Override
    public int getOpticonXOffset() {
        return 34;
    }

    @Override
    public int getOpticonYOffset() {
        return 45;
    }

    @Override
    public int getMultiPortOpticonXOffset() {
        return 130;
    }

    @Override
    public int getOpticonXSpacing() {
        return 29;
    }

    @Override
    public int getOpticonYSpacing() {
        return 0;
    }

    @Override
    public int getMiniMultiPortOticonXOffset() {
        return 0;
    }

    @Override
    public int getCardWidth() {
        return 80;
    }

    @Override
    public int getCardHeight() {
        return CardPainter.getSlotDim((int)this.cg.getSlot()).width;
    }

    @Override
    public Rectangle getMainRectangle() {
        return this.mainRectangle;
    }

    @Override
    public int getPortWidth() {
        return 26;
    }

    @Override
    public int getPortHeight() {
        return 13;
    }

    @Override
    public int getMiniPortWidth() {
        return 0;
    }

    @Override
    public int getMiniPortHeight() {
        return 0;
    }

    @Override
    public int getMiniOpticonYSpacing() {
        return 0;
    }

    @Override
    public int getMiniOpticonYOffset() {
        return 0;
    }

    @Override
    public int getSmallMiniPortWidth() {
        return 0;
    }

    @Override
    public int getSmallMiniPortHeight() {
        return 0;
    }

    @Override
    public int getSmallMiniOpticonYSpacing() {
        return 0;
    }

    @Override
    public int getSmallMiniOpticonYOffset() {
        return 0;
    }

    @Override
    public int getSmallerPortConn1Y() {
        return 0;
    }

    @Override
    public int getSmallerPortConn2Y() {
        return 0;
    }

    @Override
    public int getPortX(int n, int n2) {
        if (n == 0) {
            return 130 + 29 * n2;
        }
        return 130 + 15 * n2;
    }

    @Override
    public int getPortY(int n, int n2) {
        return 45 + 0 * n2;
    }

    @Override
    public int getSmallPortWidth() {
        return 13;
    }

    @Override
    public int getSmallPortHeight() {
        return 0;
    }

    @Override
    public int getPortConn1X() {
        return 8;
    }

    @Override
    public int getPortConn2X() {
        return 18;
    }

    @Override
    public int getPortConn1Y() {
        return 6;
    }

    @Override
    public int getPortConn2Y() {
        return 6;
    }

    @Override
    public int getSmallPortConn1Y() {
        return 0;
    }

    @Override
    public int getSmallPortConn2Y() {
        return 0;
    }

    @Override
    public int getSmallPortConn1X() {
        return 4;
    }

    @Override
    public int getSmallPortConn2X() {
        return 8;
    }

    @Override
    public int getPortLoopbackDist() {
        return 4;
    }

    @Override
    public int getMiniOpticonXSpacing() {
        return 15;
    }

    private Color getExtractorColor(int n, boolean bl) {
        return bl ? Color.white : (n == 1 && this.cg.hasProvisionedCard() ? Color.lightGray : null);
    }
}

