/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc310masdh.ui.shelf;

import cerent.cms.model.OrderwireModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.aic.AicProvOrderwirePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class OrderwireProvPane
extends AicProvOrderwirePane
implements ActionListener {
    private static final int NUM_SLIDERS = 2;
    private static final int[] rawValuesL2RX_aici = new int[]{117, 111, 104, 99, 92, 88, 83, 78, 74, 70, 66};
    private static final int[] rawValuesL2TX_aici = new int[]{95, 100, 106, 113, 119, 126, 134, 141, 150, 159, 169, 179, 189, 200, 212, 223};
    protected JCheckBox buzzerCheckBox;

    public OrderwireProvPane(String string, TabbedView tabbedView, OrderwireModel orderwireModel) {
        super(string, tabbedView, orderwireModel, null);
    }

    @Override
    protected void init() {
        this.rawValues[1] = rawValuesL2RX_aici;
        this.rawValues[2] = rawValuesL2TX_aici;
        this.minSliderValues[0] = 0;
        this.minSliderValues[1] = -15;
    }

    @Override
    protected JPanel getOrderwireGainPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 2, 4));
        jPanel.setPreferredSize(owgDimension);
        this.lev2Panel = new JPanel();
        this.lev2Panel.setBorder(BorderFactory.createTitledBorder("2-Wire Level"));
        this.lev2Panel.add(this.getGainSliderPanel(0, "RX :"));
        this.lev2Panel.add(this.getGainSliderPanel(1, "TX :"));
        jPanel.add(this.lev2Panel);
        this.setOrientation();
        return jPanel;
    }

    @Override
    protected JPanel getOrderwireBuzzerPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Buzzer"));
        this.buzzerCheckBox = new JCheckBox("Buzzer On");
        if (this.isUserAuthorized()) {
            this.buzzerCheckBox.addActionListener(this);
        } else {
            this.buzzerCheckBox.setEnabled(false);
        }
        jPanel.add((Component)this.buzzerCheckBox, "West");
        return jPanel;
    }

    @Override
    protected boolean getBuzzerValue() {
        return this.buzzerCheckBox.isSelected();
    }

    @Override
    protected void setBuzzerValue(boolean bl) {
        this.buzzerCheckBox.setSelected(bl);
    }

    @Override
    protected int getNumSliders() {
        return 2;
    }

    @Override
    protected JSlider createSlider(int n, int n2) {
        int n3 = this.minSliderValues[n2];
        int n4 = n3 + this.rawValues[n2].length - 1;
        JSlider jSlider = new JSlider(n, n3, n4, n3);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        if (n2 == 0) {
            hashtable.put(new Integer(0), new JLabel("0.0"));
            hashtable.put(new Integer(5), new JLabel("2.5"));
            hashtable.put(new Integer(10), new JLabel("5.0"));
            jSlider.setLabelTable(hashtable);
        } else if (n2 == 1) {
            hashtable.put(new Integer(-15), new JLabel("-7.5"));
            hashtable.put(new Integer(-10), new JLabel("-5.0"));
            hashtable.put(new Integer(-5), new JLabel("-2.5"));
            hashtable.put(new Integer(0), new JLabel("0.0"));
            jSlider.setLabelTable(hashtable);
        }
        return jSlider;
    }

    @Override
    protected void setSliderValueLabel(int n, int n2) {
        JLabel jLabel = this.sliderValueLabels[n];
        if (n2 >= 0) {
            if (n == 0 || n == 1) {
                jLabel.setText("+" + Double.toString((double)n2 / 2.0));
            } else {
                jLabel.setText("+" + Integer.toString(n2));
            }
        } else if (n == 0 || n == 1) {
            jLabel.setText(Double.toString((double)n2 / 2.0));
        } else {
            jLabel.setText(Integer.toString(n2));
        }
        this.sliders[n].setEnabled(false);
        jLabel.repaint();
    }

    @Override
    protected void setOrientation() {
        int n;
        int n2;
        if (this.sliderOrientation == 1) {
            n2 = 1;
            n = 2;
        } else {
            n2 = 2;
            n = 1;
        }
        this.lev2Panel.setLayout(new GridLayout(n2, n, 4, 4));
        for (int i = 0; i < this.sliders.length; ++i) {
            this.sliders[i].setOrientation(this.sliderOrientation);
        }
        this.lev2Panel.invalidate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setDirty();
    }

    @Override
    protected void refreshFromNe() {
        this.settings = this.model.settings();
        this.setSliderFromRawValue(0, this.settings.level2wRcv);
        this.setSliderFromRawValue(1, this.settings.level2wXmt);
        this.setBuzzerValue(this.settings.buzzer);
    }

    @Override
    public void updateSettings() {
        this.settings.level2wRcv = this.getSliderRawValue(0);
        this.settings.level2wXmt = this.getSliderRawValue(1);
        this.settings.buzzer = this.getBuzzerValue();
    }

    @Override
    public boolean hasSubTabs() {
        return false;
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.OrderwireProvPane;
    }
}

