/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.ui;

import cerent.cms.idl.Equipment.sMfgData_2_01;
import cerent.cms.model.Ds3xmModuleModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.CardViewController;
import cerent.cms.ui.ds3ec1.Ds3Ec1CardView;
import cerent.cms.ui.ml2.ML2CardView;
import cerent.cms.ui.ml2.ML2EnhCardView;
import cerent.cms.ui.mrc.MrcCardView;
import cerent.cms.ui.ransvc.RanSvcCardView;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.AiciCardView;
import cerent.cms.ui.shelf.Ds1E156CardView;
import cerent.cms.ui.shelf.G1000CardView;
import cerent.util.SDebug;
import cerent.util.gui.MultiLineLabelUI;
import com.cisco.ctc454.ui.shelf.Ds3xm12CardView;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.plaf.LabelUI;

public class CardViewPanel
extends AbstractCardViewPanel {
    private static final SDebug db = new SDebug("CardViewPanel");

    public CardViewPanel(ModuleModel moduleModel, CardViewController cardViewController) {
        super(moduleModel, cardViewController);
    }

    @Override
    protected void initPanel() {
        Object object;
        this.cardName = this.model.getEqLabel();
        if (this.model.getEqType() == 356 || this.model.getEqType() == 358) {
            object = this.model.getMfgData();
            String string = ((sMfgData_2_01)object).productId;
            if (string.startsWith("15454-40E-MXP-C")) {
                this.cardName = this.cardName + " (EP)";
            }
            if (string.startsWith("15454-40ME-MXP-C")) {
                this.cardName = this.cardName + " (ME)";
            }
            if (string.startsWith("15454-40E-TXP-C")) {
                this.cardName = this.cardName + " (EP)";
            }
            if (string.startsWith("15454-40ME-TXP-C")) {
                this.cardName = this.cardName + " (ME)";
            }
        }
        this.cardNameLabel = AbstractShelfLayout.formatLabel(new JLabel(this.cardName));
        this.add(this.cardNameLabel, 0, 1, 2, 1);
        this.setupCardView();
        this.add(this.cardView, 1, 2, 1, -1);
        if (this.model.getEqType() == 145) {
            if (((Ds3xmModuleModel)this.model).isOneForNProtectModule()) {
                object = new JLabel(" \nThe DS3XM-12 1:N protect card will assume the port configuration of the working card it protects.");
                ((JLabel)object).setUI((LabelUI)new MultiLineLabelUI());
                object = AbstractShelfLayout.formatLabel((JLabel)object);
                this.add((Component)object, 0, 3, 2, 0);
            } else if (((Ds3xmModuleModel)this.model).isOneForOneProtectModule()) {
                object = new JLabel(" \nThe DS3XM-12 1:1 protect card will assume the port configuration of the working card it protects.");
                ((JLabel)object).setUI((LabelUI)new MultiLineLabelUI());
                object = AbstractShelfLayout.formatLabel((JLabel)object);
                this.add((Component)object, 0, 3, 2, 0);
            }
        }
    }

    @Override
    protected void setupCardView() {
        switch (this.model.getEqType()) {
            case 97: {
                this.cardView = new AiciCardView(this.model);
                break;
            }
            case 102: 
            case 103: 
            case 221: {
                if (!(this.model instanceof L2scModuleModel)) break;
                L2scModuleModel l2scModuleModel = (L2scModuleModel)this.model;
                this.cardView = new ML2CardView(l2scModuleModel, l2scModuleModel.getL2scEtherPorts(), l2scModuleModel.getL2scPosPorts());
                break;
            }
            case 62: {
                this.cardView = new G1000CardView(this.model);
                break;
            }
            case 187: 
            case 229: 
            case 283: {
                if (!(this.model instanceof ML2ModuleModel)) break;
                ML2ModuleModel mL2ModuleModel = (ML2ModuleModel)this.model;
                this.cardView = new ML2CardView(mL2ModuleModel, mL2ModuleModel.getEtherPortModels(), mL2ModuleModel.getPosPortModels(), mL2ModuleModel.isInMapperMode());
                break;
            }
            case 285: {
                this.cardView = new ML2EnhCardView(this.model);
                break;
            }
            case 219: 
            case 220: 
            case 254: {
                this.cardView = new MrcCardView((PluggableCarrierModel)this.model);
                break;
            }
            case 185: {
                this.cardView = new Ds3Ec1CardView(this.model);
                break;
            }
            case 145: {
                this.cardView = new Ds3xm12CardView(this.model);
                break;
            }
            case 218: {
                this.cardView = new Ds1E156CardView(this.model);
                break;
            }
            case 248: {
                this.cardView = new RanSvcCardView(this.model);
                break;
            }
            default: {
                super.setupCardView();
            }
        }
        if (db.on()) {
            db.println("setupCardView cardView is " + this.cardView);
        }
    }
}

