/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.ui.ds3xm12;

import cerent.cms.model.Attribute;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.LoInfo;
import cerent.cms.ui.ds123.Ds123LineTableModel;
import cerent.util.HoLoHelper;
import cerent.util.SDebug;

public class Ds3xm12Ds1LineTableModel
extends Ds123LineTableModel {
    private static final SDebug db = new SDebug("Ds3xm12Ds1LineTable");

    public Ds3xm12Ds1LineTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray) {
        super(iNodeModel, ds123LineModelArray);
    }

    @Override
    protected String getPortNum(int n) {
        short s = (short)(n % 28 + 1);
        int n2 = n / 28 + 1;
        short s2 = HoLoHelper.getGroupNum(0, s);
        short s3 = HoLoHelper.getNumInGroup(0, s);
        LoInfo loInfo = new LoInfo(0, s2, s3, true, "");
        String string = "Port " + n2 + " DS1 " + loInfo.toString();
        return string;
    }

    @Override
    protected Attribute getLineType(int n) throws NoSuchInterface, WrongInterfaceType {
        int n2 = n / 28 + 1;
        if (n2 > 12 && n2 % 2 == 0) {
            return new Attribute("N/A", 0);
        }
        return super.getLineType(n);
    }

    @Override
    protected boolean canEditLineType(int n) {
        int n2 = n / 28 + 1;
        return n2 <= 12 || n2 % 2 != 0;
    }

    @Override
    protected boolean canEditAdminState(int n) {
        return false;
    }

    @Override
    protected Attribute getFdlModeAttributeFor(int n) {
        return this.getAttributeMap().getAttributeForVal("DS3XM12DS1.FdlModeMask", n);
    }

    @Override
    protected Attribute getDetectedAttributeFor(Object object, int n) {
        return this.getAttributeMap().getAttributeForVal("DS3XM12DS1." + object.getClass().getName() + ".detected", n);
    }

    @Override
    protected Attribute getAttributeFor(Object object, int n) {
        return this.getAttributeMap().getAttributeForVal("DS3XM12DS1." + object.getClass().getName(), n);
    }

    public void refreshMyLines(Ds123LineModel[] ds123LineModelArray) {
        this.model = ds123LineModelArray;
        this.init();
        this.fireTableDataChanged();
    }
}

