/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.ui.shelf;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ICardPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class CardPainter
implements ICardPainter {
    public static final float CARD_H_TO_CARD_W_RATIO = 9.166667f;
    private static final float PORT_W_TO_CARD_W_RATIO = 0.41666666f;
    private static final float OPTICON_Y_OFFSET_TO_CARD_H_RATIO = 0.3181818f;
    private static final float OPTICON_Y_SPACING_TO_CARD_H_RATIO = 0.11363637f;
    public static final int CARD_WIDTH = 30;
    public final int CARD_HEIGHT = Math.round((float)this.getCardWidth() * 9.166667f);
    private final int PORT_WIDTH = Math.round((float)this.getCardWidth() * 0.41666666f);
    private final int PORT_HEIGHT = this.PORT_WIDTH * 2;
    private final int SMALL_PORT_HEIGHT = this.PORT_WIDTH;
    private static final int PORT_LOOPBACK_DIST = 3;
    private final int PORT_CONN1_X;
    private final int PORT_CONN2_X = this.PORT_CONN1_X = this.PORT_WIDTH / 2;
    private final int PORT_CONN1_Y = this.PORT_HEIGHT / 3;
    private final int PORT_CONN2_Y = this.PORT_CONN1_Y * 2;
    private final int SMALL_PORT_CONN1_Y = this.SMALL_PORT_HEIGHT / 3;
    private final int SMALL_PORT_CONN2_Y = this.SMALL_PORT_CONN1_Y * 2;
    final int OPTICON_X_OFFSET = (this.getCardWidth() - this.PORT_WIDTH) / 2;
    private final int MULTIPORT_OPTICON_X_OFFSET = (this.getCardWidth() - this.PORT_WIDTH) / 2;
    private final int OPTICON_Y_OFFSET = Math.round((float)this.CARD_HEIGHT * 0.3181818f);
    private final int HEIGHT = this.CARD_HEIGHT;
    private static final float RECT_H_TO_CARD_H_RATIO = 0.013636364f;
    private static final float RECT_OFFSET_TO_CARD_H_RATIO = 0.23636363f;
    private static final float BOTTOM_RECT_OFFSET_TO_CARD_H_RATIO = 0.81363636f;
    private static final float EXTRACTOR_H_TO_CARD_H_RATIO = 0.11818182f;
    private static final float EXTRACTOR_W_TO_EXTRACTOR_H_RATIO = 0.46153846f;
    private static final float NAME_X_OFFSET_TO_CARD_W_RATIO = 0.083333336f;
    private static final float NAME_Y_OFFSET_TO_CARD_H_RATIO = 0.19545455f;
    private static final float ACTIVE_Y_LIGHT_OFFSET_TO_CARD_H_RATIO = 0.27272728f;
    private static final float ACTIVE_LIGHT_W_TO_CARD_W_RATIO = 0.25f;
    private static final float ACTIVE_LIGHT_H_TO_CARD_H_RATIO = 0.018181818f;
    private final int RECT_HEIGHT = Math.round((float)this.CARD_HEIGHT * 0.013636364f);
    private final int RECT_OFFSET;
    private final int TOP_RECT_OFFSET = this.RECT_OFFSET = Math.round((float)this.CARD_HEIGHT * 0.23636363f);
    private final int TOP_RECT_HEIGHT = this.RECT_HEIGHT;
    private final int BOTTOM_RECT_OFFSET = Math.round((float)this.CARD_HEIGHT * 0.81363636f);
    private final int BOTTOM_RECT_HEIGHT = this.RECT_HEIGHT;
    private final int EXTRACTOR_HEIGHT = Math.round((float)this.CARD_HEIGHT * 0.11818182f);
    private final int EXTRACTOR_WIDTH = Math.round((float)this.EXTRACTOR_HEIGHT * 0.46153846f);
    private static final int TAB_MARGIN = 2;
    private final int TAB_RADIUS = (this.getCardWidth() - this.EXTRACTOR_WIDTH) / 2;
    private final int TAB_DIAMETER = this.TAB_RADIUS * 2;
    private final int TAB_ARC_WIDTH = this.getCardWidth() - this.EXTRACTOR_WIDTH - this.TAB_RADIUS;
    private final int TAB_ARC_HEIGHT = this.EXTRACTOR_HEIGHT - this.TAB_DIAMETER;
    private final int BOTTOM_EXTRACTOR_OFFSET = this.CARD_HEIGHT - this.EXTRACTOR_HEIGHT - 1;
    private final int BOTTOM_EXTRACTOR_HEIGHT = this.EXTRACTOR_HEIGHT;
    private static final int TOP_EXTRACTOR_OFFSET = 0;
    private final int TOP_EXTRACTOR_HEIGHT = this.EXTRACTOR_HEIGHT;
    private final int NAME_X_OFFSET = Math.round((float)this.getCardWidth() * 0.083333336f) - 1;
    private final int NAME_Y_OFFSET = Math.round((float)this.CARD_HEIGHT * 0.19545455f);
    private final int ACTIVE_LIGHT_Y_OFFSET = Math.round((float)this.CARD_HEIGHT * 0.27272728f);
    private final int ACTIVE_LIGHT_WIDTH = Math.round((float)this.getCardWidth() * 0.25f) - 1;
    private final int ACTIVE_LIGHT_HEIGHT = Math.round((float)this.CARD_HEIGHT * 0.018181818f);
    private static final int OPTICON_X_SPACING = 0;
    private final int OPTICON_Y_SPACING = Math.round((float)this.CARD_HEIGHT * 0.11363637f);
    private final int SMALL_OPTICON_Y_SPACING = Math.round((float)((double)((float)this.CARD_HEIGHT * 0.11363637f) * 0.75));
    private final int MINI_PORT_WIDTH = this.PORT_WIDTH;
    private final int MINI_PORT_HEIGHT = Math.round((float)this.getCardWidth() * 0.41666666f * 1.15f);
    private final int MINI_MULTIPORT_OPTICON_X_OFFSET = (this.getCardWidth() - this.MINI_PORT_WIDTH) / 2;
    private final int MINI_OPTICON_Y_OFFSET = this.OPTICON_Y_OFFSET - 4;
    private final int SMALL_MINI_PORT_WIDTH = this.PORT_WIDTH;
    private final int SMALL_MINI_PORT_HEIGHT = Math.round((float)this.getCardWidth() * 0.41666666f * 0.9f);
    private final int SMALL_MINI_OPTICON_Y_SPACING = this.SMALL_MINI_PORT_HEIGHT + 3;
    private final int SMALLER_PORT_CONN1_Y = this.SMALL_MINI_PORT_HEIGHT / 3;
    private final int SMALLER_PORT_CONN2_Y = this.SMALLER_PORT_CONN1_Y * 2 + 1;
    private static final int MINI_OPTICON_X_SPACING = 0;
    private final int MINI_OPTICON_Y_SPACING = this.MINI_PORT_HEIGHT + 3;
    private static final float[] dash1 = new float[]{1.5f};
    public final Rectangle topExtractorRectangle = new Rectangle(2, 2, this.EXTRACTOR_WIDTH - 4, this.TOP_EXTRACTOR_HEIGHT - 4);
    public final Rectangle bottomExtractorRectangle = new Rectangle(2, this.BOTTOM_EXTRACTOR_OFFSET + 2, this.EXTRACTOR_WIDTH - 4, this.BOTTOM_EXTRACTOR_HEIGHT - 4);
    public final Arc2D.Double topExtractorMain = new Arc2D.Double(this.EXTRACTOR_WIDTH, 0 - this.TAB_ARC_HEIGHT, 2 * this.TAB_ARC_WIDTH, 2 * this.TAB_ARC_HEIGHT, 180.0, 90.0, 0);
    public final Arc2D.Double topExtractorSmall = new Arc2D.Double(this.EXTRACTOR_WIDTH, 0 + this.TAB_ARC_HEIGHT, this.TAB_DIAMETER, this.TAB_DIAMETER, 90.0, -180.0, 0);
    public final Line2D.Double topExtractorLine = new Line2D.Double(0.0, this.EXTRACTOR_HEIGHT, this.EXTRACTOR_WIDTH + this.TAB_ARC_WIDTH, this.EXTRACTOR_HEIGHT);
    public final Arc2D.Double bottomExtractorMain = new Arc2D.Double(this.EXTRACTOR_WIDTH, this.BOTTOM_EXTRACTOR_OFFSET + this.TAB_DIAMETER, 2 * this.TAB_ARC_WIDTH, 2 * this.TAB_ARC_HEIGHT, 180.0, -90.0, 0);
    public final Arc2D.Double bottomExtractorSmall = new Arc2D.Double(this.EXTRACTOR_WIDTH, this.BOTTOM_EXTRACTOR_OFFSET, this.TAB_DIAMETER, this.TAB_DIAMETER, -90.0, 180.0, 0);
    public final Line2D.Double bottomExtractorLine = new Line2D.Double(0.0, this.BOTTOM_EXTRACTOR_OFFSET, this.EXTRACTOR_WIDTH + this.TAB_ARC_WIDTH, this.BOTTOM_EXTRACTOR_OFFSET);
    private final int WIDTH;
    private final Rectangle topRectangle;
    private final Rectangle bottomRectangle;
    private final Rectangle mainRectangle;
    protected CardGraphic cg;
    private Rectangle topBackgroundRectangle;
    private Rectangle bottomBackgroundRectangle;
    protected OpticsLineModel[] linemodels;
    protected OpticsMultiplexSectionModel[] bandmodels;
    protected OpticsChannelModel[] models;
    public static final String[] BandWavelengthStrings = new String[]{"UNKNOWN", "1530.33", "1534.25", "1538.19", "1542.14", "1546.12", "1550.12", "1554.13", "1558.17"};

    public CardPainter(CardGraphic cardGraphic) {
        OpticsModuleModel opticsModuleModel;
        this.cg = cardGraphic;
        this.WIDTH = cardGraphic.getSlotsOccupied() * this.getCardWidth();
        this.topRectangle = new Rectangle(0, this.TOP_RECT_OFFSET, this.WIDTH, this.TOP_RECT_HEIGHT);
        this.bottomRectangle = new Rectangle(0, this.BOTTOM_RECT_OFFSET, this.WIDTH, this.BOTTOM_RECT_HEIGHT);
        this.mainRectangle = new Rectangle(0, 0, this.WIDTH, this.HEIGHT);
        int n = this.getCardWidth();
        this.topBackgroundRectangle = new Rectangle(0, 0, n, this.TOP_EXTRACTOR_HEIGHT);
        this.bottomBackgroundRectangle = new Rectangle(0, this.BOTTOM_RECT_OFFSET, n, this.HEIGHT);
        if (this.cg.getModel() instanceof OpticsModuleModel && (opticsModuleModel = (OpticsModuleModel)this.cg.getModel()).getState() != eEqState.DELETED) {
            this.models = opticsModuleModel.getOpticsChannelModels();
            this.bandmodels = opticsModuleModel.getOpticsOMSModels();
            this.linemodels = opticsModuleModel.getOpticsLineModels();
        }
    }

    @Override
    public void updateWidth() {
    }

    @Override
    public int getOpticonXOffset() {
        return this.OPTICON_X_OFFSET;
    }

    @Override
    public int getOpticonYOffset() {
        return this.OPTICON_Y_OFFSET;
    }

    @Override
    public int getMultiPortOpticonXOffset() {
        return this.MULTIPORT_OPTICON_X_OFFSET;
    }

    @Override
    public int getOpticonXSpacing() {
        return 0;
    }

    @Override
    public int getOpticonYSpacing() {
        return this.OPTICON_Y_SPACING;
    }

    @Override
    public int getMiniMultiPortOticonXOffset() {
        return this.MINI_MULTIPORT_OPTICON_X_OFFSET;
    }

    @Override
    public int getCardWidth() {
        return 30;
    }

    @Override
    public int getCardHeight() {
        return this.CARD_HEIGHT;
    }

    @Override
    public Rectangle getMainRectangle() {
        return this.mainRectangle;
    }

    @Override
    public int getPortWidth() {
        return this.PORT_WIDTH;
    }

    @Override
    public int getPortHeight() {
        return this.PORT_HEIGHT;
    }

    @Override
    public int getMiniPortWidth() {
        return this.MINI_PORT_WIDTH;
    }

    @Override
    public int getMiniPortHeight() {
        return this.MINI_PORT_HEIGHT;
    }

    @Override
    public int getMiniOpticonXSpacing() {
        return 0;
    }

    @Override
    public int getMiniOpticonYSpacing() {
        return this.MINI_OPTICON_Y_SPACING;
    }

    @Override
    public int getMiniOpticonYOffset() {
        return this.MINI_OPTICON_Y_OFFSET;
    }

    @Override
    public int getSmallMiniPortWidth() {
        return this.getMiniPortWidth();
    }

    @Override
    public int getSmallMiniPortHeight() {
        return this.SMALL_MINI_PORT_HEIGHT;
    }

    @Override
    public int getSmallMiniOpticonYSpacing() {
        return this.SMALL_MINI_OPTICON_Y_SPACING;
    }

    @Override
    public int getSmallMiniOpticonYOffset() {
        return this.getMiniOpticonYOffset();
    }

    @Override
    public int getPortX(int n, int n2) {
        return this.MULTIPORT_OPTICON_X_OFFSET + 0 * n2;
    }

    @Override
    public int getPortY(int n, int n2) {
        if (n == 0) {
            return this.OPTICON_Y_OFFSET + this.OPTICON_Y_SPACING * n2;
        }
        return this.OPTICON_Y_OFFSET + this.SMALL_OPTICON_Y_SPACING * n2;
    }

    @Override
    public int getSmallPortWidth() {
        return this.PORT_WIDTH;
    }

    @Override
    public int getSmallPortHeight() {
        return this.SMALL_PORT_HEIGHT;
    }

    @Override
    public int getPortConn1X() {
        return this.PORT_CONN1_X;
    }

    @Override
    public int getPortConn2X() {
        return this.PORT_CONN2_X;
    }

    @Override
    public int getPortConn1Y() {
        return this.PORT_CONN1_Y;
    }

    @Override
    public int getPortConn2Y() {
        return this.PORT_CONN2_Y;
    }

    @Override
    public int getSmallPortConn1Y() {
        return this.SMALL_PORT_CONN1_Y;
    }

    @Override
    public int getSmallPortConn2Y() {
        return this.SMALL_PORT_CONN2_Y;
    }

    @Override
    public int getSmallPortConn1X() {
        return 0;
    }

    @Override
    public int getSmallPortConn2X() {
        return 0;
    }

    @Override
    public int getSmallerPortConn1Y() {
        return this.SMALLER_PORT_CONN1_Y;
    }

    @Override
    public int getSmallerPortConn2Y() {
        return this.SMALLER_PORT_CONN2_Y;
    }

    @Override
    public int getPortLoopbackDist() {
        return 3;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.cg.getCurrentColor());
        graphics2D.fill(this.mainRectangle);
        this.paintActual(graphics2D);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.draw(this.mainRectangle);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(Color.gray);
        graphics2D.draw(this.topExtractorRectangle);
        graphics2D.draw(this.bottomExtractorRectangle);
        graphics2D.setColor(Color.black);
        graphics2D.draw(this.topExtractorMain);
        graphics2D.draw(this.topExtractorSmall);
        graphics2D.draw(this.topExtractorLine);
        graphics2D.draw(this.bottomExtractorMain);
        graphics2D.draw(this.bottomExtractorSmall);
        graphics2D.draw(this.bottomExtractorLine);
        int n3 = this.cg.getState();
        String string = "";
        Color color = graphics2D.getColor();
        Color color2 = this.cg.getCurrentColor();
        switch (n3) {
            case 5: {
                string = "Act";
                color2 = Color.green;
                break;
            }
            case 4: {
                string = "Sby";
                color2 = Color.yellow;
                break;
            }
            case 2: {
                string = "Ldg";
                color2 = Color.white;
                break;
            }
            case 3: {
                string = "Fail";
                break;
            }
            case 1: {
                string = "Mis";
                break;
            }
            case 0: {
                string = "NP";
                break;
            }
            case 6: {
                string = "Del";
                break;
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, 2, this.ACTIVE_LIGHT_Y_OFFSET + this.ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(color2);
        graphics2D.fillRect(this.getCardWidth() - this.ACTIVE_LIGHT_WIDTH - 2, this.ACTIVE_LIGHT_Y_OFFSET, this.ACTIVE_LIGHT_WIDTH, this.ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(this.getCardWidth() - this.ACTIVE_LIGHT_WIDTH - 2, this.ACTIVE_LIGHT_Y_OFFSET, this.ACTIVE_LIGHT_WIDTH, this.ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(color);
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 3.0f, dash1, 0.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(this.topRectangle);
        graphics2D.draw(this.bottomRectangle);
        graphics2D.setColor(Color.black);
        int n4 = 174;
        String string2 = this.cg.getEqLabel();
        Font font = graphics.getFont();
        Font font2 = null;
        FontMetrics fontMetrics = component.getFontMetrics(font);
        int n5 = fontMetrics.getAscent();
        int n6 = n2 + this.NAME_Y_OFFSET;
        if (string2.length() > 4 || string2.startsWith("4MD")) {
            String string3 = string2;
            String string4 = "";
            String string5 = "";
            if (string2.startsWith("OC")) {
                if (string2.equals("OC48AS")) {
                    string3 = string2.substring(0, 4);
                    string4 = string2.substring(4, string2.length());
                } else if (string2.startsWith("OC192XFP")) {
                    string3 = string2.substring(0, 5);
                    string4 = string2.substring(5, string2.length());
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "_");
                    try {
                        string3 = stringTokenizer.nextToken();
                        string4 = stringTokenizer.nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
            } else if (string2.startsWith("DS3_E")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "_");
                try {
                    string3 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {}
            } else if (string2.startsWith("DS1_E")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "_");
                try {
                    string3 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {}
            } else if (string2.startsWith("DS")) {
                string3 = string2.substring(0, 3);
                string4 = string2.substring(3, string2.length());
            } else if (string2.startsWith("ETH")) {
                string3 = string2.substring(0, 3);
                string4 = string2.substring(3, string2.length());
            } else if (string2.endsWith("XP") || string2.endsWith("XPE")) {
                string3 = string2.substring(0, string2.indexOf("_"));
                string4 = string2.substring(string2.indexOf("_") + 1, string2.length());
            } else if (string2.startsWith("XC")) {
                string3 = string2.substring(0, 2);
                string4 = string2.substring(2, string2.length());
                if (string4.length() > 3) {
                    string4 = string4.substring(0, string4.indexOf(32));
                }
            } else if (string2.startsWith("G1000")) {
                graphics.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize() - 1));
                string3 = string2.substring(0, 5);
                if (string2.endsWith("(TXP)")) {
                    string4 = string2.substring(6);
                }
            } else if (string2.startsWith("ML100")) {
                graphics.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize() - 1));
                string3 = string2.substring(0, 2);
                string4 = string2.substring(2, string2.length());
                string4 = string4.replaceFirst("-8", "");
            } else if (string2.startsWith("ML2")) {
                graphics.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize() - 1));
                string3 = string2.substring(0, 3);
                string4 = string2.substring(4, 8);
            } else if (string2.startsWith("MS-I")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "-");
                try {
                    string3 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {}
            } else if (string2.startsWith("CE")) {
                graphics.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize() - 1));
                if (string2.startsWith("CE-MR")) {
                    string3 = "CE";
                    string4 = "MR";
                } else {
                    string3 = string2.substring(0, 2);
                    string4 = string2.substring(3, 7);
                }
            } else if (string2.startsWith("TXP") || string2.startsWith("MXP")) {
                int n7;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "_");
                String string6 = null;
                try {
                    string3 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                    string6 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                if (string6 != null) {
                    int n8 = fontMetrics.getAscent() / 2;
                    int n9 = (this.BOTTOM_EXTRACTOR_OFFSET - (this.BOTTOM_RECT_OFFSET + this.BOTTOM_RECT_HEIGHT)) / 2;
                    int n10 = (n + this.getCardWidth() - fontMetrics.stringWidth(string6)) / 2;
                    int n11 = n2 + this.BOTTOM_RECT_OFFSET + this.BOTTOM_RECT_HEIGHT + n9 + n8;
                    graphics2D.drawString(string6, n10, n11);
                }
                if ((n7 = string5.length() - 4) > 0) {
                    font2 = new Font(font.getFontName(), font.getStyle(), font.getSize() - (n7 == 1 ? 1 : 3));
                }
            } else if (string2.startsWith("FC-MR") || string2.startsWith("ML-MR")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "-");
                try {
                    string3 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {}
            } else if (string2.startsWith("AD-1B")) {
                string3 = "AD1B";
                n4 = this.getBandWave();
                string4 = n4 != 0 ? BandWavelengthStrings[n4].substring(2, 6) : "XX.X";
            } else if (string2.startsWith("AD-4B")) {
                string3 = "AD4B";
                n4 = this.getBandWave();
                string4 = n4 != 0 ? BandWavelengthStrings[n4].substring(2, 6) : "XX.X";
            } else if (string2.startsWith("AD-1C")) {
                string3 = "AD1C";
                n4 = this.getWave();
                string4 = n4 != 0 && n4 != 174 ? Wavelength.getWavelengthStringFromWavelength(n4).substring(2, 6) : "XX.X";
            } else if (string2.startsWith("AD-2C")) {
                string3 = "AD2C";
                n4 = this.getWave();
                string4 = n4 != 0 && n4 != 174 ? Wavelength.getWavelengthStringFromWavelength(n4).substring(2, 6) : "XX.X";
            } else if (string2.startsWith("AD-4C")) {
                string3 = "AD4C";
                n4 = this.getWave();
                string4 = n4 != 0 && n4 != 174 ? Wavelength.getWavelengthStringFromWavelength(n4).substring(2, 6) : "XX.X";
            } else if (string2.startsWith("OPT-BST E")) {
                string3 = "OPT";
                string4 = "BST";
                string5 = "E";
            } else if (string2.equals("OPT-BST")) {
                string3 = "OPT";
                string4 = "BST";
            } else if (string2.equals("OPT-BST L")) {
                string3 = "OPT";
                string4 = "BST";
                string5 = "L";
            } else if (string2.startsWith("OPT-PRE")) {
                string3 = "OPT";
                string4 = "PRE";
            } else if (string2.startsWith("OPT-RAMP")) {
                string3 = "        OPT";
                string4 = "        RAMP";
                string5 = this.cg.getEqType() == 287 ? "        C" : "       CE";
            } else if (string2.startsWith("OPT-AMP L")) {
                string3 = "OPT";
                string4 = "AMP";
                string5 = "L";
            } else if (string2.equals("OPT-AMP 17")) {
                string3 = "OPT";
                string4 = "AMP";
                string5 = "17";
            } else if (string2.equals("OPT-AMP 23")) {
                string3 = "OPT";
                string4 = "AMP";
                string5 = "23";
            } else if (string2.startsWith("OPT-AMP C")) {
                string3 = "OPT";
                string4 = "AMP";
                string5 = "C";
            } else if (string2.startsWith("OSC M")) {
                string3 = "OSCM";
                string4 = "";
            } else if (string2.startsWith("OSC-CSM")) {
                string3 = "OSC";
                string4 = "CSM";
            } else if (string2.equals("32 WSS L")) {
                string3 = "      32 WSS L";
                string4 = "";
            } else if (string2.equals("32 WSS")) {
                string3 = "     32 WSS";
                string4 = "";
            } else if (string2.equals("40 WXC")) {
                string3 = "      40 WXC";
                string4 = "";
            } else if (string2.equals("40 WXC L")) {
                string3 = "     40 WXC L";
                string4 = "";
            } else if (string2.equals("80 WXC C")) {
                string3 = "         80 WXC C";
                string4 = "";
            } else if (string2.equals("32 DMX L")) {
                string3 = "32";
                string4 = "DMX";
                string5 = "L";
            } else if (string2.equals("32 DMX")) {
                string3 = "32";
                string4 = "DMX";
            } else if (string2.startsWith("4MD")) {
                string3 = "4MD";
                n4 = this.getWave();
                string4 = n4 != 0 && n4 != 174 ? Wavelength.getWavelengthStringFromWavelength(n4).substring(2, 6) : "XX.X";
            } else if (string2.startsWith("32 MUXO")) {
                string3 = "       32 MUXO";
                string4 = "";
            } else if (string2.equals("32 DMXO")) {
                string3 = "       32 DMXO";
                string4 = "";
            } else if (string2.equals("MRC25G_4")) {
                string3 = string2.substring(0, 3);
                string4 = string2.substring(3, string2.length());
            } else if (string2.equals("40 DMX CE")) {
                string3 = "40";
                string4 = "DMX";
                string5 = n3 == 6 ? "C" : "CE";
            } else if (string2.equals("40 DMX CO")) {
                string3 = "40";
                string4 = "DMX";
                string5 = n3 == 6 ? "C" : "CO";
            } else if (string2.equals("40 DMX L")) {
                string3 = "40";
                string4 = "DMX";
                string5 = "L";
            } else if (string2.equals("40 MUX")) {
                string3 = "40";
                string4 = "MUX";
            } else if (string2.equals("40 MUX L")) {
                string3 = "40";
                string4 = "MUX";
                string5 = "L";
            } else if (string2.equals("40 WSS CE")) {
                string3 = n3 == 6 ? "       \t  40 WSS C" : "       \t  40 WSS CE";
                string4 = " ";
            } else if (string2.equals("40 WSS CO")) {
                string3 = n3 == 6 ? "       \t  40 WSS C" : "       \t  40 WSS CO";
                string4 = " ";
            } else if (string2.equals("40 WSS L")) {
                string3 = "       \t  40 WSS L";
                string4 = " ";
            } else if (string2.startsWith("MRC")) {
                string3 = string2.substring(0, 3);
                string4 = string2.substring(4, string2.length());
            } else if (string2.startsWith("PPM")) {
                string3 = "";
                string4 = "";
            } else if (string2.startsWith("TCC2P")) {
                string3 = string2.substring(0, 4);
                string4 = string2.substring(4, string2.length());
            } else if (string2.startsWith("RAN_SVC")) {
                string3 = "RAN";
                string4 = "SVC";
            } else if (string2.equals("ADM_10G")) {
                string3 = "        ADM";
                string4 = "        10G";
            } else if (string2.equals("XP_4_10G")) {
                string3 = "OTU";
                string4 = "2";
                string5 = "XP";
            } else if (string2.equals("40G-TXP-C")) {
                string3 = "        40G";
                string4 = "        TXP C";
            } else if (string2.equals("40E-TXP-C")) {
                string3 = "        40E";
                string4 = "        TXP C";
                String string7 = this.cg.getMfgProductId();
                if (string7.startsWith("15454-40E-TXP-C")) {
                    string5 = "        (EP)";
                }
                if (string7.startsWith("15454-40ME-TXP-C")) {
                    string5 = "        (ME)";
                }
            } else if (string2.equals("40G-MXP-C")) {
                string3 = "        40G";
                string4 = "        MXP C";
            } else if (string2.equals("40E-MXP-C")) {
                string3 = "        40E";
                string4 = "        MXP C";
                String string8 = this.cg.getMfgProductId();
                if (string8.startsWith("15454-40E-MXP-C")) {
                    string5 = "        (EP)";
                }
                if (string8.startsWith("15454-40ME-MXP-C")) {
                    string5 = "        (ME)";
                }
            } else if (string2.equals("40 SMR1 C")) {
                string3 = "40";
                string4 = "SMR1";
                string5 = "C";
            } else if (string2.equals("40 SMR2 C")) {
                string3 = "40";
                string4 = "SMR2";
                string5 = "C";
            } else if (string2.equals("80 SMR1 C")) {
                string3 = "80";
                string4 = "SMR1";
                string5 = "C";
            } else if (string2.equals("C TDCU")) {
                string3 = "C";
                string4 = "TDCU";
            } else if (string2.equals("F TDCU")) {
                string3 = "F";
                string4 = "TDCU";
            }
            if (string4.length() != 0 && string5.length() != 0) {
                n6 -= n5;
            }
            int n12 = fontMetrics.stringWidth(string3);
            graphics2D.drawString(string3, (n + this.getCardWidth() - n12) / 2, n6);
            if (string4.length() > 0) {
                n12 = fontMetrics.stringWidth(string4);
                graphics2D.drawString(string4, (n + this.getCardWidth() - n12) / 2, n6 += n5);
            }
            if (string5.length() > 0) {
                n6 += n5;
                if (font2 != null) {
                    fontMetrics = component.getFontMetrics(font2);
                    graphics2D.setFont(font2);
                }
                n12 = fontMetrics.stringWidth(string5);
                graphics2D.drawString(string5, (n + this.getCardWidth() - n12) / 2, n6);
            }
        } else if (string2 != null) {
            int n13 = 0;
            if (string2.startsWith("UNK")) {
                n13 = -1;
            }
            graphics2D.drawString(string2, n + this.NAME_X_OFFSET + n13, n6);
            if (string2.startsWith("PSM") && (n4 = this.getPSMWavelength()) != 0 && n4 != 174) {
                String string9 = Wavelength.getWavelengthStringFromWavelength(n4).substring(2, 6);
                int n14 = fontMetrics.stringWidth(string9);
                graphics2D.drawString(string9, (n + this.getCardWidth() - n14) / 2, n6 += n5);
            }
        }
        graphics2D.setStroke(stroke);
    }

    public void paintActual(Graphics2D graphics2D) {
        int n = this.cg.getState();
        int n2 = this.cg.getSlot();
        int n3 = this.cg.getSlotsOccupied();
        String string = null;
        int n4 = this.getCardWidth();
        boolean bl = false;
        ArrayList arrayList = null;
        try {
            arrayList = ((EntityModel)this.cg.getModel()).getNodeModelDelegate().getMfgData(this.cg.getModel().getShelfId());
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            // empty catch block
        }
        for (int i = 0; i < n3; ++i) {
            block8: {
                block10: {
                    block9: {
                        block7: {
                            bl = false;
                            if (arrayList != null && arrayList.size() < n2 + i - 1) {
                                string = (String)arrayList.get(n2 + i - 1);
                            }
                            this.topBackgroundRectangle = new Rectangle(i * n4, 0, n4, this.TOP_EXTRACTOR_HEIGHT);
                            this.bottomBackgroundRectangle = new Rectangle(i * n4, this.BOTTOM_RECT_OFFSET, n4, this.HEIGHT);
                            if (string == null || !string.equals("FILLER")) break block7;
                            graphics2D.setColor(Color.white);
                            graphics2D.fill(this.topBackgroundRectangle);
                            graphics2D.fill(this.bottomBackgroundRectangle);
                            bl = true;
                            break block8;
                        }
                        if (i != 0) break block9;
                        if (this.cg.getState() == 1 && this.cg.hasProvisionedCard()) break block10;
                    }
                    if (i <= 0 || string == null || string.equals("")) break block8;
                }
                graphics2D.setColor(this.cg.getCurrentColor());
                graphics2D.fill(this.topBackgroundRectangle);
                graphics2D.fill(this.bottomBackgroundRectangle);
                bl = true;
            }
            if (!bl || i <= 0) continue;
            Rectangle rectangle = new Rectangle(i * n4 + 2, 2, this.EXTRACTOR_WIDTH - 4, this.TOP_EXTRACTOR_HEIGHT - 4);
            Rectangle rectangle2 = new Rectangle(i * n4 + 2, this.BOTTOM_EXTRACTOR_OFFSET + 2, this.EXTRACTOR_WIDTH - 4, this.BOTTOM_EXTRACTOR_HEIGHT - 4);
            Arc2D.Double double_ = new Arc2D.Double(i * n4 + this.EXTRACTOR_WIDTH, 0 - this.TAB_ARC_HEIGHT, 2 * this.TAB_ARC_WIDTH, 2 * this.TAB_ARC_HEIGHT, 180.0, 90.0, 0);
            Arc2D.Double double_2 = new Arc2D.Double(i * n4 + this.EXTRACTOR_WIDTH, 0 + this.TAB_ARC_HEIGHT, this.TAB_DIAMETER, this.TAB_DIAMETER, 90.0, -180.0, 0);
            Line2D.Double double_3 = new Line2D.Double(i * n4, this.EXTRACTOR_HEIGHT, this.EXTRACTOR_WIDTH + this.TAB_ARC_WIDTH + i * n4, this.EXTRACTOR_HEIGHT);
            Arc2D.Double double_4 = new Arc2D.Double(i * n4 + this.EXTRACTOR_WIDTH, this.BOTTOM_EXTRACTOR_OFFSET + this.TAB_DIAMETER, 2 * this.TAB_ARC_WIDTH, 2 * this.TAB_ARC_HEIGHT, 180.0, -90.0, 0);
            Arc2D.Double double_5 = new Arc2D.Double(i * n4 + this.EXTRACTOR_WIDTH, this.BOTTOM_EXTRACTOR_OFFSET, this.TAB_DIAMETER, this.TAB_DIAMETER, -90.0, 180.0, 0);
            Line2D.Double double_6 = new Line2D.Double(i * n4, this.BOTTOM_EXTRACTOR_OFFSET, this.EXTRACTOR_WIDTH + this.TAB_ARC_WIDTH + i * n4, this.BOTTOM_EXTRACTOR_OFFSET);
            Line2D.Double double_7 = new Line2D.Double(i * n4, 0.0, i * n4, this.EXTRACTOR_HEIGHT);
            Line2D.Double double_8 = new Line2D.Double(i * (n4 * 2), 0.0, i * (n4 * 2), this.EXTRACTOR_HEIGHT);
            Line2D.Double double_9 = new Line2D.Double(i * n4, this.BOTTOM_RECT_OFFSET, i * n4, this.BOTTOM_EXTRACTOR_OFFSET + this.EXTRACTOR_HEIGHT);
            Line2D.Double double_10 = new Line2D.Double(i * (n4 * 2), this.BOTTOM_RECT_OFFSET, i * (n4 * 2), this.BOTTOM_EXTRACTOR_OFFSET + this.EXTRACTOR_HEIGHT);
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.draw(this.mainRectangle);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setColor(Color.gray);
            graphics2D.draw(rectangle);
            graphics2D.draw(rectangle2);
            graphics2D.setColor(Color.black);
            graphics2D.draw(double_);
            graphics2D.draw(double_2);
            graphics2D.draw(double_3);
            graphics2D.draw(double_4);
            graphics2D.draw(double_5);
            graphics2D.draw(double_6);
            graphics2D.draw(double_8);
            graphics2D.draw(double_7);
            graphics2D.draw(double_10);
            graphics2D.draw(double_9);
        }
    }

    private int getWave() {
        int n;
        try {
            n = this.models[0].getExpectedWaveLength();
        }
        catch (Exception exception) {
            return 174;
        }
        return n;
    }

    private int getPSMWavelength() {
        int n;
        try {
            n = this.linemodels[0].getExpectedWaveLength();
        }
        catch (Exception exception) {
            return 174;
        }
        return n;
    }

    private int getBandWave() {
        int n = 0;
        try {
            n = this.bandmodels[0].getExpectedBand().value();
        }
        catch (Exception exception) {
            return 0;
        }
        return n;
    }
}

