/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.idl.OnsError.eProvDataError;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AdminState;
import cerent.cms.model.AsapEtherLineModel;
import cerent.cms.model.AsapModuleModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.EtherLineUpdate;
import cerent.cms.model.IOpticsProvExtModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OpticsProvExtModel;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.OpticsProvExtHelper;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.VariComboBoxCellEditor;
import cerent.util.AnnotatedException;
import cerent.util.CEMC;
import cerent.util.ErrorMsg;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.SoakTimeCellEditor;
import cerent.util.gui.SpinCellEditor;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import com.cisco.ctc600.ui.asap.AsapEtherPortTableModel;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AsapEtherPortProvPane
extends NodeProvPane
implements TableModelListener,
PropertyChangeListener {
    private AsapEtherPortTableModel dataModel = null;
    private AsapEtherLineModel[] etherLineModels = null;
    private ObservableManager obsMgr = null;
    private IOpticsProvExtModel[] opticModels;
    private static final SDebug db = new SDebug("AsapEtherPortProvPane");

    public AsapEtherPortProvPane(String string, TabbedView tabbedView, AsapEtherLineModel[] asapEtherLineModelArray) {
        super(string, tabbedView);
        this.etherLineModels = asapEtherLineModelArray;
        this.opticModels = OpticsProvExtModel.getModels(asapEtherLineModelArray);
        this.dataModel = new AsapEtherPortTableModel((AsapModuleModel)this.getUiModel(), asapEtherLineModelArray);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.add((Component)uScrollPane);
        this.customizedProvPane();
        this.table.sizeColumnsToFit(-1);
        this.registerWithModel();
    }

    private void customizedProvPane() {
        TableColumn tableColumn = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField()));
        tableColumn.setPreferredWidth(200);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[6]);
        tableColumn.setPreferredWidth(100);
        this.setCellEditorAdminState();
        this.setCellEditorFrameSize();
        tableColumn = this.table.getColumn(this.dataModel.columnNames[9]);
        tableColumn.setCellEditor(new SpinCellEditor(this, 1, 10, 74));
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(this.dataModel.columnNames[10]);
        tableColumn.setCellEditor(new SpinCellEditor(this, 1, 11, 75));
        tableColumn.sizeWidthToFit();
        if (this.getUiModel() instanceof PluggableCarrierModel) {
            this.setOpticsExtCellEditor(11, (ModuleModel)this.getUiModel(), this.opticModels, db);
            this.setOpticsExtCellEditor(12, (ModuleModel)this.getUiModel(), this.opticModels, db);
        } else {
            this.removeColumn(11);
            this.removeColumn(12);
        }
        SoakTimeCellEditor soakTimeCellEditor = new SoakTimeCellEditor(this);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[13]);
        tableColumn.setCellEditor(soakTimeCellEditor);
        tableColumn.setMinWidth(soakTimeCellEditor.getPreferredWidth() + 10);
    }

    protected void setOpticsExtCellEditor(int n, ModuleModel moduleModel, IOpticsProvExtModel[] iOpticsProvExtModelArray, SDebug sDebug) {
        if (moduleModel instanceof PluggableCarrierModel) {
            TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[n]);
            Attribute[][] attributeArray = null;
            switch (n) {
                case 11: {
                    attributeArray = OpticsProvExtHelper.getCombinedReaches(moduleModel, iOpticsProvExtModelArray, sDebug);
                    break;
                }
                case 12: {
                    attributeArray = OpticsProvExtHelper.getCombinedWavelengths(moduleModel, iOpticsProvExtModelArray, sDebug);
                }
            }
            tableColumn.setCellEditor(new VariComboBoxCellEditor(attributeArray));
            tableColumn.sizeWidthToFit();
            tableColumn.setPreferredWidth(tableColumn.getWidth());
        }
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        this.table.removeColumn(tableColumn);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    protected void setCellEditorFrameSize() {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[8]);
        String[] stringArray = this.dataModel.getFrameSizes();
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setEditable(false);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn.sizeWidthToFit();
        tableColumn.setPreferredWidth(tableColumn.getWidth());
    }

    protected void setCellEditorAdminState() {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[2]);
        boolean bl = this.uiModel.getNodeModel().getTdmProtocolTypeObj().isSonet();
        AdminState[] adminStateArray = AdminState.getDefaultAdminStates(bl);
        JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
        jComboBox.setEditable(false);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn.sizeWidthToFit();
        tableColumn.setPreferredWidth(tableColumn.getWidth());
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        db.fine("enteringPage");
        this.getObsMgr().setPassing(true);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        db.fine("leavingPage");
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    @Override
    protected void registerWithModel() {
        super.registerWithModel();
        this.getObsMgr().setObservable((Observable[])this.etherLineModels);
    }

    protected ObservableManager getObsMgr() {
        if (this.obsMgr == null) {
            this.obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this.obsMgr;
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        db.fine("Got a ObjChangeMessage for " + observable);
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                AsapEtherPortProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.etherLineModels).indexOf(observable);
        if (n != -1) {
            db.fine("Refreshing Line " + n);
            this.dataModel.refreshLineFromModel(n);
            this.setOpticsExtCellEditor(11, (ModuleModel)this.getUiModel(), this.opticModels, db);
            this.setOpticsExtCellEditor(12, (ModuleModel)this.getUiModel(), this.opticModels, db);
        } else {
            db.fine("In AsapEtherPortProvPane change Message cannot find Model " + observable);
        }
    }

    @Override
    protected void refreshMyLines(Object object) {
        if (object instanceof EtherLineUpdate) {
            this.etherLineModels = (AsapEtherLineModel[])((EtherLineUpdate)object).getEtherLineModels();
            this.opticModels = OpticsProvExtModel.getModels(this.etherLineModels);
            this.getObsMgr().setObservable((Observable[])this.etherLineModels);
            db.fine("Refreshing lines, ether lines= " + this.etherLineModels.length);
            this.dataModel.refreshMyLines(this.etherLineModels);
            this.setOpticsExtCellEditor(11, (ModuleModel)this.getUiModel(), this.opticModels, db);
            this.setOpticsExtCellEditor(12, (ModuleModel)this.getUiModel(), this.opticModels, db);
        } else if (db.on()) {
            db.println("refreshMyLines received " + object);
        }
    }

    @Override
    public void dispose() {
        if (this.obsMgr != null) {
            this.obsMgr.removeObservable((Observable[])this.etherLineModels);
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.dispose();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.etherLineModels.length == 0) {
            return;
        }
        int n = tableModelEvent.getLastRow() > this.etherLineModels.length ? this.etherLineModels.length - 1 : tableModelEvent.getLastRow();
        for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void applyChangesToModel() throws AnnotatedException {
        try {
            if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.etherLineModels)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
                String string = AdminState.getSevWarningMsg(this.dataModel, this.etherLineModels, false, true);
                stringBuffer.append(string).append("\n\n").append(this.getApplyString(false));
                if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                    return;
                }
            }
            this.dataModel.applyToModels();
        }
        catch (ProvisionError provisionError) {
            eProvDataError eProvDataError2 = ((xProvisionError)provisionError.getUserException()).dataError;
            if (eProvDataError2 == eProvDataError.INVALID_ADMIN_STATE) {
                boolean bl = this.uiModel.getNodeModel().getTdmProtocolTypeObj().isSonet();
                if (bl) {
                    ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_FAIL_APPLY_CHANGES, "Provisioning Error: The Admin State should be either OOS,DSBLD or OOS,MT.");
                } else {
                    ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_FAIL_APPLY_CHANGES, "Provisioning Error: The Admin State should be either locked,disabled or locked,maintenance.");
                }
            }
            throw new AnnotatedException("An error occurred while applying changes.", (Exception)((Object)provisionError));
        }
        catch (Exception exception) {
            if (AsapEtherPortProvPane.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            throw new AnnotatedException("An error occurred while applying changes.", exception);
        }
        this.setDirty(false);
    }

    @Override
    public void refreshFromModel() {
        this.dataModel.refreshFromModel();
        this.dataModel.resetDirty();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.AsapEtherPortProvPane;
    }
}

