/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.idl.Equipment.eXconDiagResult;
import cerent.cms.idl.Equipment.sXconDiagInfo;
import cerent.cms.model.NodeModelDelegate;
import cerent.util.SDebug;
import cerent.util.gui.MultiLineLabelUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.plaf.LabelUI;

public class CrossConnectDiagnosticsDialog
extends JDialog {
    private JButton closeButton = new JButton("Close");
    private JTextArea textArea;
    private NodeModelDelegate nodeModel;
    private sXconDiagInfo[] xconnList;
    private static SDebug db = new SDebug("CrossConnectDiagnosticsDialog");

    public CrossConnectDiagnosticsDialog(Frame frame, NodeModelDelegate nodeModelDelegate, sXconDiagInfo[] sXconDiagInfoArray) {
        super(frame, "Cross Connect Diagnostics Errors", true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CrossConnectDiagnosticsDialog.this.dispose();
            }
        });
        this.nodeModel = nodeModelDelegate;
        this.xconnList = sXconDiagInfoArray;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getDescPanel(), "North");
        JScrollPane jScrollPane = this.getXconnPanel();
        container.add((Component)this.getXconnPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private JPanel getDescPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        String string = "The following cross connects failed the diagnostics test.";
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add(jLabel);
        return jPanel;
    }

    private JScrollPane getXconnPanel() {
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(150, 250));
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Slot/STS - PathA - PathB"));
        if (this.xconnList != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.xconnList.length; ++i) {
                eXconDiagResult eXconDiagResult2 = this.xconnList[i].pathAResult;
                eXconDiagResult eXconDiagResult3 = this.xconnList[i].pathBResult;
                stringBuffer.append("s" + this.xconnList[i].slot);
                stringBuffer.append("/S" + this.xconnList[i].sts);
                stringBuffer.append(" - " + this.pathResultStr(eXconDiagResult2));
                stringBuffer.append(" - " + this.pathResultStr(eXconDiagResult3) + "\n");
                this.textArea.append(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
            }
        }
        return jScrollPane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 5, 5));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CrossConnectDiagnosticsDialog.this.dispose();
            }
        });
        jPanel.add(this.closeButton);
        return jPanel;
    }

    private String pathResultStr(eXconDiagResult eXconDiagResult2) {
        String string = "UNKNOWN";
        switch (eXconDiagResult2.value()) {
            case 0: {
                string = "PASS";
                break;
            }
            case 1: {
                string = "FAIL";
                break;
            }
            case 2: {
                string = "NO PATH";
            }
        }
        return string;
    }
}

