/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctcutsXsdh.ui.ms;

import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.ms.AbstractMsShelfLayout;
import cerent.cms.ui.ms.BayViewPanel;
import cerent.cms.ui.ms.IMsShelfLayout;
import cerent.cms.ui.ms.MsCardPanel;
import cerent.cms.ui.ms.ShelfTransferHandler;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.util.gui.IconImpl;
import com.cisco.ctcutsXsdh.ui.ms.MsCardFactory;
import com.cisco.ctcutsXsdh.ui.ms.MsCardPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class MsShelfLayout
extends AbstractMsShelfLayout
implements IMsShelfLayout,
Observer {
    protected static final Border UNSELECTED_BORDER = BorderFactory.createLineBorder(Color.black, 1);
    private static final int SHELF_SLOT_COUNT = 8;
    private static final float FONT_TO_CARD_W_RATIO = 0.33333334f;
    private static final Font TEXT_FONT = new Font("Arial", 0, Math.round((float)MsCardPainter.CARD_WIDTH * 0.33333334f));
    private static final Font labelFont = new Font("Arial", 0, 10);
    private JLabel idLbl;

    public MsShelfLayout(IChassisModel iChassisModel, AbstractViewController abstractViewController, BayViewPanel bayViewPanel) {
        super(iChassisModel, abstractViewController, bayViewPanel);
    }

    @Override
    protected void refreshShelfColor() {
        this.setShelfColor(this.getState());
        this.labelsPanel.setBackground(this.currShelfColor);
        this.idLbl.setBackground(this.currShelfColor);
    }

    @Override
    protected Font getTextFont() {
        return TEXT_FONT;
    }

    @Override
    protected void createLabels() {
        if (this.labelsPanel == null) {
            this.labelsPanel = this.getInnerLabelPanel(new GridLayout(1, this.cards.length, 0, 0), this.chassis.getTDMTerminology());
            Dimension dimension = new Dimension(MsCardPainter.CARD_WIDTH, 10);
            this.labels = new JLabel[8];
            for (int i = 7; i >= 0; --i) {
                this.labels[i] = new JLabel("");
            }
            this.idLbl = new JLabel("Shelf " + this.chassis.getShelfId());
            this.idLbl.setFont(labelFont);
            this.idLbl.setPreferredSize(dimension);
            this.idLbl.setMinimumSize(dimension);
            this.idLbl.setHorizontalAlignment(0);
            this.labelsPanel.add(this.idLbl);
            this.refreshShelfColor();
        }
    }

    @Override
    protected void createSlotsPanel() {
        Object object;
        this.slotsPanel = new JPanel();
        this.slotsPanel.setLayout(new BoxLayout(this.slotsPanel, 1));
        Dimension dimension = new Dimension(MsCardPainter.CARD_WIDTH, 6);
        ShelfTransferHandler shelfTransferHandler = new ShelfTransferHandler(this.chassis.getNodeModelDelegate().getChassisModelsInstance(), this.bvp.getRVP().getMVP());
        for (int i = this.cards.length - 1; i >= 0; --i) {
            object = new IconImpl(dimension);
            this.cards[i] = new MsCardPanel((Icon)object, this);
            this.cards[i].addMouseListener(this.mouseListener);
            this.cards[i].addMouseMotionListener(this.mouseListener);
            this.cards[i].setTransferHandler(shelfTransferHandler);
            this.slotsPanel.add(this.cards[i]);
        }
        if (this.isM6Chassis()) {
            JPanel jPanel = new JPanel();
            object = new JPanel();
            IconImpl iconImpl = new IconImpl(new Dimension(dimension.width + 100, dimension.height * 8));
            MsCardPanel msCardPanel = new MsCardPanel(iconImpl, this);
            msCardPanel.setLayout(new GridBagLayout());
            jPanel.setSize(100, dimension.height * 8);
            ((Component)object).setSize(100, dimension.height * 8);
            msCardPanel.add(jPanel);
            msCardPanel.add(this.slotsPanel);
            msCardPanel.add((Component)object);
            this.slotsPanel = msCardPanel;
        }
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.setTransferHandler(shelfTransferHandler);
    }

    private boolean isM6Chassis() {
        return this.chassis.getShelfType() == 336;
    }

    @Override
    protected CardGraphic createCard(EntityModel entityModel) {
        return MsCardFactory.createMsCard(entityModel, this);
    }

    @Override
    public int getShelfSlotCount() {
        return 8;
    }
}

