/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf;

import com.jidesoft.plaf.vsnet.ConvertListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class ExtWindowsDesktopProperty
implements UIDefaults.ActiveValue {
    private static boolean updatePending;
    private WeakPCL pcl;
    private String[] keys;
    private Object[] value;
    private Object[] fallback;
    private ConvertListener listener;
    private Toolkit toolkit;

    private static synchronized void setUpdatePending(boolean bl) {
        updatePending = bl;
    }

    private static synchronized boolean isUpdatePending() {
        return updatePending;
    }

    private static void updateAllUIs() {
        Frame[] frameArray;
        for (Frame frame : frameArray = Frame.getFrames()) {
            ExtWindowsDesktopProperty.updateWindowUI(frame);
        }
    }

    private static void updateWindowUI(Window window) {
        Window[] windowArray;
        SwingUtilities.updateComponentTreeUI(window);
        for (Window window2 : windowArray = window.getOwnedWindows()) {
            ExtWindowsDesktopProperty.updateWindowUI(window2);
        }
    }

    public ExtWindowsDesktopProperty(String[] stringArray, Object[] objectArray, Toolkit toolkit, ConvertListener convertListener) {
        this.keys = stringArray;
        this.fallback = objectArray;
        this.toolkit = toolkit;
        this.listener = convertListener;
    }

    public Object createValue(UIDefaults uIDefaults) {
        if (this.value == null) {
            this.value = this.configureValue(this.getValueFromDesktop());
            if (this.value[0] == null) {
                this.value = this.configureValue(this.getDefaultValue());
            }
        }
        return this.listener.convert(this.value);
    }

    protected Object[] getValueFromDesktop() {
        if (this.toolkit == null) {
            this.toolkit = Toolkit.getDefaultToolkit();
        }
        this.pcl = new WeakPCL(this, this.toolkit);
        Object[] objectArray = new Object[this.getKeys().length];
        for (int i2 = 0; i2 < this.getKeys().length; ++i2) {
            objectArray[i2] = this.toolkit.getDesktopProperty(this.getKeys()[i2]);
            this.toolkit.addPropertyChangeListener(this.getKeys()[i2], this.pcl);
        }
        return objectArray;
    }

    protected Object[] getDefaultValue() {
        return this.fallback;
    }

    public void invalidate() {
        if (this.pcl != null) {
            for (int i2 = 0; i2 < this.getKeys().length; ++i2) {
                this.toolkit.removePropertyChangeListener(this.getKeys()[i2], this.pcl);
            }
            this.toolkit = null;
            this.pcl = null;
            this.value = null;
        }
    }

    protected void updateUI() {
        if (!ExtWindowsDesktopProperty.isUpdatePending()) {
            ExtWindowsDesktopProperty.setUpdatePending(true);
            Runnable runnable = new Runnable(){

                public void run() {
                    ExtWindowsDesktopProperty.updateAllUIs();
                    ExtWindowsDesktopProperty.setUpdatePending(false);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected Object[] configureValue(Object[] objectArray) {
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray[i2] = this.configureValue(objectArray[i2]);
            }
        }
        return objectArray;
    }

    protected Object configureValue(Object object) {
        if (object != null) {
            if (object instanceof Color) {
                return new ColorUIResource((Color)object);
            }
            if (object instanceof Font) {
                return new FontUIResource((Font)object);
            }
            if (object instanceof UIDefaults.ProxyLazyValue) {
                object = ((UIDefaults.ProxyLazyValue)object).createValue(null);
            } else if (object instanceof UIDefaults.ActiveValue) {
                object = ((UIDefaults.ActiveValue)object).createValue(null);
            }
        }
        return object;
    }

    protected String[] getKeys() {
        return this.keys;
    }

    private static class WeakPCL
    extends WeakReference
    implements PropertyChangeListener {
        private Toolkit kit;

        WeakPCL(Object object, Toolkit toolkit) {
            super(object);
            this.kit = toolkit;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ExtWindowsDesktopProperty extWindowsDesktopProperty = (ExtWindowsDesktopProperty)this.get();
            if (extWindowsDesktopProperty == null) {
                this.kit.removePropertyChangeListener(propertyChangeEvent.getPropertyName(), this);
            } else {
                extWindowsDesktopProperty.invalidate();
                extWindowsDesktopProperty.updateUI();
            }
        }
    }
}

