/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CheckBoxTreeSelectionModel
extends DefaultTreeSelectionModel
implements TreeModelListener {
    private TreeModel _model;
    private boolean _digIn = true;
    private CheckBoxTree _tree;
    private boolean _singleEventMode = false;
    private boolean _fireEvent = true;
    private boolean _batchMode = false;
    private List<TreePath> _toBeAdded = new ArrayList<TreePath>();
    private List<TreePath> _toBeRemoved = new ArrayList<TreePath>();

    public CheckBoxTreeSelectionModel(TreeModel treeModel) {
        this.setModel(treeModel);
        this.setSelectionMode(4);
    }

    void setTree(CheckBoxTree checkBoxTree) {
        this._tree = checkBoxTree;
    }

    public CheckBoxTreeSelectionModel(TreeModel treeModel, boolean bl) {
        this.setModel(treeModel);
        this._digIn = bl;
    }

    public TreeModel getModel() {
        return this._model;
    }

    public void setModel(TreeModel treeModel) {
        if (this._model != treeModel) {
            if (this._model != null) {
                this._model.removeTreeModelListener(this);
            }
            this._model = treeModel;
            if (this._model != null) {
                this._model.addTreeModelListener(this);
            }
        }
    }

    public boolean isDigIn() {
        return this._digIn;
    }

    public void setDigIn(boolean bl) {
        this._digIn = bl;
    }

    public boolean isPartiallySelected(TreePath treePath) {
        if (this.isPathSelected(treePath, true)) {
            return false;
        }
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return false;
        }
        for (TreePath treePath2 : treePathArray) {
            if (!this.isDescendant(treePath2, treePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isRowSelected(int n) {
        return this.isPathSelected(this._tree.getPathForRow(n), this._tree.isDigIn());
    }

    public boolean isPathSelected(TreePath treePath, boolean bl) {
        TreePath treePath2;
        if (treePath == null) {
            return false;
        }
        if (!bl) {
            return super.isPathSelected(treePath);
        }
        for (treePath2 = treePath; treePath2 != null && !super.isPathSelected(treePath2); treePath2 = treePath2.getParentPath()) {
        }
        if (treePath2 != null) {
            return true;
        }
        if (this._model == null) {
            return true;
        }
        Object object = treePath.getLastPathComponent();
        if (this._model.getChildCount(object) == 0) {
            return false;
        }
        boolean bl2 = true;
        for (int i2 = 0; i2 < this._model.getChildCount(object); ++i2) {
            Object object2 = this._model.getChild(object, i2);
            if (this.isPathSelected(treePath.pathByAddingChild(object2), true)) continue;
            bl2 = false;
            break;
        }
        if (this._tree.isCheckBoxVisible(treePath) && bl2) {
            this.addSelectionPaths(new TreePath[]{treePath});
        }
        return bl2;
    }

    private boolean isDescendant(TreePath treePath, TreePath treePath2) {
        Object[] objectArray;
        Object[] objectArray2 = treePath.getPath();
        if (objectArray2.length < (objectArray = treePath2.getPath()).length) {
            return false;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray2[i2] == objectArray[i2]) continue;
            return false;
        }
        return true;
    }

    protected void notifyPathChange(Vector vector, TreePath treePath) {
        if (this._fireEvent) {
            super.notifyPathChange(vector, treePath);
        }
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        if (!this.isDigIn() || this.selectionMode == 1) {
            super.setSelectionPaths(treePathArray);
        } else {
            this.clearSelection();
            this.addSelectionPaths(treePathArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionPaths(TreePath[] treePathArray) {
        if (!this.isDigIn()) {
            super.addSelectionPaths(treePathArray);
            return;
        }
        boolean bl = false;
        if (this.isSingleEventMode() && this._fireEvent) {
            this._fireEvent = false;
            bl = true;
        }
        try {
            Object object;
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            for (TreePath treePath : treePathArray) {
                object = this.getSelectionPaths();
                if (object == null) break;
                for (TreePath treePath2 : object) {
                    if (!this.isDescendant(treePath2, treePath)) continue;
                    arrayList.add(treePath2);
                }
            }
            if (arrayList.size() > 0) {
                this.delegateRemoveSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
            }
            for (TreePath treePath : treePathArray) {
                object = null;
                while (this.areSiblingsSelected(treePath)) {
                    object = treePath;
                    if (treePath.getParentPath() == null) break;
                    treePath = treePath.getParentPath();
                }
                if (object != null) {
                    if (((TreePath)object).getParentPath() != null) {
                        this.addSelectionPath(((TreePath)object).getParentPath());
                        continue;
                    }
                    if (!this.isSelectionEmpty()) {
                        this.removeSelectionPaths(this.getSelectionPaths(), !bl);
                    }
                    this.delegateAddSelectionPaths(new TreePath[]{object});
                    continue;
                }
                this.delegateAddSelectionPaths(new TreePath[]{treePath});
            }
        }
        finally {
            this._fireEvent = true;
            if (this.isSingleEventMode() && bl) {
                this.notifyPathChange(treePathArray, true, treePathArray[0]);
            }
        }
    }

    private boolean areSiblingsSelected(TreePath treePath) {
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            return true;
        }
        Object object = treePath.getLastPathComponent();
        Object object2 = treePath2.getLastPathComponent();
        int n = this._model.getChildCount(object2);
        for (int i2 = 0; i2 < n; ++i2) {
            Object object3 = this._model.getChild(object2, i2);
            if (object3 == object) continue;
            TreePath treePath3 = treePath2.pathByAddingChild(object3);
            if (this._tree != null && !this._tree.isCheckBoxVisible(treePath3) && !this.isPathSelected(treePath3, true)) {
                return false;
            }
            if (this.isPathSelected(treePath3)) continue;
            return false;
        }
        return true;
    }

    public void removeSelectionPaths(TreePath[] treePathArray) {
        this.removeSelectionPaths(treePathArray, true);
    }

    public void removeSelectionPaths(TreePath[] treePathArray, boolean bl) {
        if (!this.isDigIn()) {
            super.removeSelectionPaths(treePathArray);
            return;
        }
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        for (int i2 = 0; i2 < treePathArray.length; ++i2) {
            TreePath treePath = treePathArray[i2];
            if (treePath.getPathCount() == 1) {
                arrayList.add(treePath);
                continue;
            }
            this.toggleRemoveSelection(treePath, bl);
        }
        if (arrayList.size() > 0) {
            this.delegateRemoveSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void toggleRemoveSelection(TreePath treePath, boolean bl) {
        TreePath treePath2;
        Stack<TreePath> stack;
        boolean bl2;
        block9: {
            bl2 = false;
            if (bl && this.isSingleEventMode() && this._fireEvent) {
                this._fireEvent = false;
                bl2 = true;
            }
            stack = new Stack<TreePath>();
            for (treePath2 = treePath.getParentPath(); treePath2 != null && !this.isPathSelected(treePath2); treePath2 = treePath2.getParentPath()) {
                stack.push(treePath2);
            }
            if (treePath2 != null) {
                stack.push(treePath2);
                break block9;
            }
            this.delegateRemoveSelectionPaths(new TreePath[]{treePath});
            if (!bl) return;
            this._fireEvent = true;
            if (!this.isSingleEventMode() || !bl2) return;
            this.notifyPathChange(new TreePath[]{treePath}, false, treePath);
            return;
        }
        try {
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            while (!stack.isEmpty()) {
                TreePath treePath3 = (TreePath)stack.pop();
                TreePath treePath4 = stack.isEmpty() ? treePath : (TreePath)stack.peek();
                Object object = treePath3.getLastPathComponent();
                Object object2 = treePath4.getLastPathComponent();
                int n = this._model.getChildCount(object);
                for (int i2 = 0; i2 < n; ++i2) {
                    Object object3 = this._model.getChild(object, i2);
                    if (object3 == object2) continue;
                    TreePath treePath5 = treePath3.pathByAddingChild(object3);
                    arrayList.add(treePath5);
                }
            }
            if (arrayList.size() > 0) {
                this.delegateAddSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
            }
            this.delegateRemoveSelectionPaths(new TreePath[]{treePath2});
            if (!bl) return;
            this._fireEvent = true;
            if (!this.isSingleEventMode() || !bl2) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            this._fireEvent = true;
            if (!this.isSingleEventMode() || !bl2) throw throwable;
            this.notifyPathChange(new TreePath[]{treePath}, false, treePath);
            throw throwable;
        }
        this.notifyPathChange(new TreePath[]{treePath}, false, treePath);
    }

    public boolean isSingleEventMode() {
        return this._singleEventMode;
    }

    public void setSingleEventMode(boolean bl) {
        this._singleEventMode = bl;
    }

    protected void notifyPathChange(TreePath[] treePathArray, boolean bl, TreePath treePath) {
        if (this._fireEvent) {
            int n = treePathArray.length;
            boolean[] blArray = new boolean[n];
            for (int i2 = 0; i2 < n; ++i2) {
                blArray[i2] = bl;
            }
            TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, treePathArray, blArray, treePath, this.leadPath);
            this.fireValueChanged(treeSelectionEvent);
        }
    }

    private boolean isBatchMode() {
        return this._batchMode;
    }

    public void setBatchMode(boolean bl) {
        this._batchMode = bl;
        if (!this._batchMode) {
            super.addSelectionPaths(this._toBeAdded.toArray(new TreePath[this._toBeAdded.size()]));
            this._toBeAdded.clear();
            super.removeSelectionPaths(this._toBeRemoved.toArray(new TreePath[this._toBeRemoved.size()]));
            this._toBeRemoved.clear();
        }
    }

    private void delegateRemoveSelectionPaths(TreePath[] treePathArray) {
        if (!this.isBatchMode()) {
            super.removeSelectionPaths(treePathArray);
        } else {
            for (TreePath treePath : treePathArray) {
                this._toBeRemoved.add(treePath);
                this._toBeAdded.remove(treePath);
            }
        }
    }

    private void delegateRemoveSelectionPath(TreePath treePath) {
        if (!this.isBatchMode()) {
            super.removeSelectionPath(treePath);
        } else {
            this._toBeRemoved.add(treePath);
            this._toBeAdded.remove(treePath);
        }
    }

    private void delegateAddSelectionPaths(TreePath[] treePathArray) {
        if (!this.isBatchMode()) {
            super.addSelectionPaths(treePathArray);
        } else {
            for (TreePath treePath : treePathArray) {
                this._toBeAdded.add(treePath);
                this._toBeRemoved.remove(treePath);
            }
        }
    }

    private void delegateAddSelectionPath(TreePath treePath) {
        if (!this.isBatchMode()) {
            super.addSelectionPath(treePath);
        } else {
            this._toBeAdded.add(treePath);
            this._toBeRemoved.remove(treePath);
        }
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.revalidateSelectedTreePaths();
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.revalidateSelectedTreePaths();
    }

    private static boolean isTreePathValid(TreeModel treeModel, TreePath treePath) {
        Object object = treeModel.getRoot();
        for (int i2 = 0; i2 < treePath.getPathCount(); ++i2) {
            Object object2 = treePath.getPathComponent(i2);
            if (i2 == 0) {
                if (object2 == object) continue;
                return false;
            }
            boolean bl = false;
            for (int i3 = 0; i3 < treeModel.getChildCount(object); ++i3) {
                Object object3 = treeModel.getChild(object, i3);
                if (object3 != object2) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
            object = object2;
        }
        return true;
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.revalidateSelectedTreePaths();
    }

    private void revalidateSelectedTreePaths() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                if (treePath == null || CheckBoxTreeSelectionModel.isTreePathValid(this._model, treePath)) continue;
                super.removeSelectionPath(treePath);
            }
        }
    }
}

