/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MathUtils {
    protected MathUtils() {
    }

    public static double sum(List<Number> list) {
        double d2 = 0.0;
        for (Number number : list) {
            d2 += number.doubleValue();
        }
        return d2;
    }

    public static double mean(List<Number> list) {
        double d2 = MathUtils.sum(list);
        return d2 / (double)list.size();
    }

    public static double min(List<Number> list) {
        double d2 = 2.147483647E9;
        for (Number number : list) {
            double d3 = number.doubleValue();
            if (!(d3 < d2)) continue;
            d2 = d3;
        }
        return d2;
    }

    public static double max(List<Number> list) {
        double d2 = -2.147483648E9;
        for (Number number : list) {
            double d3 = number.doubleValue();
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        return d2;
    }

    public static double stddev(List<Number> list, boolean bl) {
        double d2 = Double.NaN;
        int n = list.size();
        if (n > 0) {
            d2 = n > 1 ? Math.sqrt(MathUtils.var(list, bl)) : 0.0;
        }
        return d2;
    }

    public static double var(List<Number> list, boolean bl) {
        int n = list.size();
        if (n == 0) {
            return Double.NaN;
        }
        if (n == 1) {
            return 0.0;
        }
        double d2 = MathUtils.mean(list);
        ArrayList<Number> arrayList = new ArrayList<Number>();
        for (Number number : list) {
            double d3 = number.doubleValue() - d2;
            arrayList.add(Math.pow(d3, 2.0));
        }
        double d4 = MathUtils.sum(arrayList);
        return d4 / (double)(bl ? n - 1 : n);
    }
}

