/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class ThreadCheckingRepaintManager
extends RepaintManager {
    private int tabCount = 0;
    private boolean checkIsShowing = false;

    public ThreadCheckingRepaintManager() {
    }

    public ThreadCheckingRepaintManager(boolean bl) {
        this.checkIsShowing = bl;
    }

    public synchronized void addInvalidComponent(JComponent jComponent) {
        this.checkThread(jComponent);
        super.addInvalidComponent(jComponent);
    }

    private void checkThread(JComponent jComponent) {
        if (!SwingUtilities.isEventDispatchThread() && this.checkIsShowing(jComponent)) {
            System.out.println("----------Wrong Thread START");
            System.out.println(this.getStracktraceAsString(new Exception()));
            this.dumpComponentTree(jComponent);
            System.out.println("----------Wrong Thread END");
        }
    }

    private String getStracktraceAsString(Exception exception) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        exception.printStackTrace(printStream);
        printStream.flush();
        return byteArrayOutputStream.toString();
    }

    private boolean checkIsShowing(JComponent jComponent) {
        if (!this.checkIsShowing) {
            return true;
        }
        return jComponent.isShowing();
    }

    public synchronized void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.checkThread(jComponent);
        super.addDirtyRegion(jComponent, n, n2, n3, n4);
    }

    private void dumpComponentTree(Component component) {
        System.out.println("----------Component Tree");
        this.resetTabCount();
        while (component != null) {
            this.printTabIndent();
            System.out.println(component);
            this.printTabIndent();
            System.out.println("Showing:" + component.isShowing() + " Visible: " + component.isVisible());
            this.incrementTabCount();
            component = component.getParent();
        }
    }

    private void resetTabCount() {
        this.tabCount = 0;
    }

    private void incrementTabCount() {
        ++this.tabCount;
    }

    private void printTabIndent() {
        for (int i2 = 0; i2 < this.tabCount; ++i2) {
            System.out.print("\t");
        }
    }
}

