/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChart3DProjector;
import ilog.views.chart.IlvChartDataPicker;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvLabelRenderer;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.util.IlvChartUtil;
import ilog.views.chart.util.internal.IlvMathUtil;
import ilog.views.chart.view3d.Ilv3DPoints;
import ilog.views.chart.view3d.Ilv3DUtil;
import ilog.views.chart.view3d.IlvChart3DScene;
import ilog.views.chart.view3d.IlvChart3DWalls;
import ilog.views.util.collections.IlvCollections;
import ilog.views.util.collections.IlvPreorderIterator;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Stroke;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IlvChart3DView
implements Serializable {
    private static final double a = 20.0;
    public static final int LEFT_WALL = 1;
    public static final int RIGHT_WALL = 2;
    public static final int TOP_WALL = 4;
    public static final int BOTTOM_WALL = 8;
    public static final int BACK_WALL = 16;
    public static final int ORTHOGRAPHIC = 0;
    public static final int OBLIQUE = 1;
    private IlvChart b;
    private int c = 20;
    private int d = 0;
    private double e = 1.0;
    private boolean f = true;
    private boolean g = false;
    private double h = 45.0;
    private double i = 35.0;
    private PropertyChangeSupport j;
    private transient IlvChart3DProjector k;
    private transient IlvChart3DScene l;
    private transient boolean m;
    ArrayList n = new ArrayList();

    IlvChart3DView(IlvChart ilvChart) {
        this.b = ilvChart;
        this.g();
        this.j = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.j.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.j.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.j.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.j.removePropertyChangeListener(string, propertyChangeListener);
    }

    private final void a(String string, double d2, double d3) {
        this.j.firePropertyChange(string, new Double(d2), new Double(d3));
    }

    public final IlvChart3DScene getScene() {
        return this.l;
    }

    public final IlvChart getChart() {
        return this.b;
    }

    public synchronized void draw(Graphics graphics) {
        this.getScene().draw(graphics);
    }

    void a(int n2, int n3, int n4, int n5) {
        this.getScene().setScreenPort(n2, n3, n4, n5);
    }

    public double getFrontDepth() {
        return 1.0;
    }

    public double getBackDepth() {
        return 0.0;
    }

    public final IlvLabelRenderer getZAnnotationRenderer() {
        return this.d().getZAnnotationRenderer();
    }

    public void setZAnnotationRenderer(IlvLabelRenderer ilvLabelRenderer) {
        IlvChartUtil.checkNullParam("renderer", ilvLabelRenderer);
        IlvLabelRenderer ilvLabelRenderer2 = this.getZAnnotationRenderer();
        if (ilvLabelRenderer != ilvLabelRenderer2) {
            this.d().setZAnnotationRenderer(ilvLabelRenderer);
            this.j.firePropertyChange("ZAnnotationRenderer", ilvLabelRenderer2, ilvLabelRenderer);
            if (this.isAutoScaling()) {
                this.getScene().invalidateTransform();
            }
            this.getChart().getChartArea().repaint();
        }
    }

    public final boolean isZAnnotationColorVarying() {
        return this.d().isZAnnotationColorVarying();
    }

    public void setZAnnotationColorVarying(boolean bl) {
        boolean bl2 = this.isZAnnotationColorVarying();
        if (bl != bl2) {
            this.d().setZAnnotationColorVarying(bl);
            this.j.firePropertyChange("ZAnnotationColorVarying", bl2, bl);
            this.getChart().getChartArea().repaint();
        }
    }

    public final boolean isZAnnotationVisible() {
        return this.d().isZAnnotationVisible();
    }

    public void setZAnnotationVisible(boolean bl) {
        boolean bl2 = this.isZAnnotationVisible();
        if (bl == bl2) {
            return;
        }
        this.d().setZAnnotationVisible(bl);
        this.j.firePropertyChange("ZAnnotationVisible", bl2, bl);
        this.getChart().getChartArea().repaint();
    }

    public final boolean isZGridVisible() {
        return this.d().isZGridVisible();
    }

    public void setZGridVisible(boolean bl) {
        boolean bl2 = this.isZGridVisible();
        if (bl == bl2) {
            return;
        }
        this.d().setZGridVisible(bl);
        this.j.firePropertyChange("ZGridVisible", bl2, bl);
        this.getChart().getChartArea().repaint();
    }

    public final Stroke getZGridStroke() {
        return this.d().getZGridStroke();
    }

    public void setZGridStroke(Stroke stroke) {
        Stroke stroke2 = this.getZGridStroke();
        if (stroke != stroke2) {
            this.d().setZGridStroke(stroke);
            this.j.firePropertyChange("ZGridStroke", stroke2, this.getZGridStroke());
            this.getChart().getChartArea().repaint();
        }
    }

    public final Paint getZGridPaint() {
        return this.d().getZGridPaint();
    }

    public void setZGridPaint(Paint paint) {
        Paint paint2 = this.getZGridPaint();
        if (paint != paint2) {
            this.d().setZGridPaint(paint);
            this.j.firePropertyChange("ZGridPaint", paint2, this.getZGridPaint());
            this.getChart().getChartArea().repaint();
        }
    }

    public final double getLightLatitude() {
        return this.getScene().getLightLatitude();
    }

    public void setLightLatitude(double d2) {
        double d3 = this.getLightLatitude();
        if (d3 == d2) {
            return;
        }
        this.getScene().setLightLatitude(d2);
        this.a("lightLatitude", d3, d2);
        this.getChart().getChartArea().repaint();
    }

    public final double getLightLongitude() {
        return this.getScene().getLightLongitude();
    }

    public void setLightLongitude(double d2) {
        double d3 = this.getLightLongitude();
        if (d3 == d2) {
            return;
        }
        this.getScene().setLightLongitude(d2);
        this.a("lightLongitude", d3, d2);
        this.getChart().getChartArea().repaint();
    }

    public final float getAmbientLight() {
        return this.getScene().getAmbientLight();
    }

    public void setAmbientLight(float f2) {
        float f3 = this.getAmbientLight();
        if (f2 != f3) {
            this.getScene().setAmbientLight(f2);
            this.j.firePropertyChange("ambientLight", new Float(f3), new Float(this.getAmbientLight()));
            this.getChart().getChartArea().repaint();
        }
    }

    public final int getProjectionType() {
        return this.getScene().getProjectionType();
    }

    public void setProjectionType(int n2) {
        int n3 = this.getProjectionType();
        if (n2 != n3) {
            this.getScene().setProjectionType(n2);
            this.j.firePropertyChange("projectionType", n3, this.getProjectionType());
            this.getChart().getChartArea().repaint();
        }
    }

    public final double getElevation() {
        return this.h;
    }

    public void setElevation(double d2) {
        double d3 = this.getElevation();
        if ((d2 = IlvMathUtil.clamp(d2, -90.0, 90.0)) == d3) {
            return;
        }
        this.h = d2;
        this.getScene().invalidateTransform();
        this.a("elevation", d3, d2);
        this.getChart().getChartArea().repaint();
    }

    public final double getRotation() {
        if (this.f()) {
            return this.i;
        }
        return IlvMathUtil.clamp(this.i, -90.0, 90.0);
    }

    public void setRotation(double d2) {
        double d3 = this.getRotation();
        if (d2 == d3) {
            return;
        }
        this.i = d2;
        this.getScene().invalidateTransform();
        this.a("rotation", d3, this.getRotation());
        this.getChart().getChartArea().repaint();
    }

    public void setViewAngles(double d2, double d3) {
        this.setRotation(d2);
        this.setElevation(d3);
    }

    public final int getDepth() {
        return this.c;
    }

    public void setDepth(int n2) {
        int n3 = this.getDepth();
        if ((n2 = IlvMathUtil.clamp(n2, 1, 100)) == n3) {
            return;
        }
        this.c = n2;
        this.getScene().invalidateTransform();
        this.j.firePropertyChange("depth", n3, this.getDepth());
        this.getChart().getChartArea().revalidateLayout();
    }

    public final int getDepthGap() {
        return this.d;
    }

    public void setDepthGap(int n2) {
        int n3 = this.getDepthGap();
        if ((n2 = IlvMathUtil.clamp(n2, 0, 100)) == n3) {
            return;
        }
        this.d = n2;
        this.c();
        this.j.firePropertyChange("depthGap", n3, this.getDepthGap());
        this.getChart().getChartArea().revalidateLayout();
    }

    public final double getZoom() {
        return this.e;
    }

    public void setZoom(double d2) {
        double d3 = this.getZoom();
        if ((d2 = IlvMathUtil.clamp(d2, 0.0, 20.0)) == d3) {
            return;
        }
        this.e = d2;
        this.getScene().invalidateTransform();
        this.a("zoom", d3, this.getZoom());
        this.getChart().getChartArea().repaint();
    }

    public final boolean isAutoScaling() {
        return this.f;
    }

    public void setAutoScaling(boolean bl) {
        boolean bl2 = this.isAutoScaling();
        if (bl == bl2) {
            return;
        }
        this.f = bl;
        this.getScene().invalidateTransform();
        this.j.firePropertyChange("autoScaling", bl2, this.isAutoScaling());
        this.getChart().getChartArea().repaint();
    }

    final boolean a() {
        return this.g;
    }

    void a(boolean bl) {
        this.g = bl;
    }

    public void setWallStyle(int n2, IlvStyle ilvStyle) {
        IlvChart3DWalls ilvChart3DWalls = this.d();
        if ((n2 & 8) != 0) {
            ilvChart3DWalls.getFace(4).setStyle(ilvStyle);
        }
        if ((n2 & 4) != 0) {
            ilvChart3DWalls.getFace(3).setStyle(ilvStyle);
        }
        if ((n2 & 1) != 0) {
            ilvChart3DWalls.getFace(1).setStyle(ilvStyle);
        }
        if ((n2 & 2) != 0) {
            ilvChart3DWalls.getFace(2).setStyle(ilvStyle);
        }
        if ((n2 & 0x10) != 0) {
            ilvChart3DWalls.getFace(0).setStyle(ilvStyle);
        }
    }

    IlvDisplayPoint a(IlvChartDataPicker ilvChartDataPicker) {
        return this.getScene().getDisplayItem(ilvChartDataPicker);
    }

    List<IlvDisplayPoint> b(IlvChartDataPicker ilvChartDataPicker) {
        return this.getScene().getDisplayItems(ilvChartDataPicker);
    }

    final IlvChart3DProjector b() {
        return this.k;
    }

    final Ilv3DPoints a(Ilv3DPoints ilv3DPoints, int n2) {
        this.getChart().a(ilv3DPoints, n2);
        return this.a(ilv3DPoints);
    }

    public IlvDoublePoints toDisplay(IlvDoublePoints ilvDoublePoints, int n2, double d2) {
        this.getChart().a(ilvDoublePoints, n2);
        return this.a(ilvDoublePoints, d2);
    }

    final Ilv3DPoints a(Ilv3DPoints ilv3DPoints) {
        return Ilv3DUtil.toScreen(this.getScene().getValidatedTransform(), ilv3DPoints);
    }

    IlvDoublePoints a(IlvDoublePoints ilvDoublePoints, double d2) {
        return Ilv3DUtil.toScreen(this.getScene().getValidatedTransform(), ilvDoublePoints, d2);
    }

    public List getZLayers() {
        this.e();
        return Collections.unmodifiableList(this.n);
    }

    private void e() {
        if (this.m) {
            return;
        }
        this.n.clear();
        IlvPreorderIterator ilvPreorderIterator = new IlvPreorderIterator(this.getChart()){

            protected Iterator getChildren(Object object) {
                if (object instanceof IlvChart) {
                    return ((IlvChart)object).getRendererIterator();
                }
                IlvChartRenderer ilvChartRenderer = (IlvChartRenderer)object;
                if (ilvChartRenderer.isViewable()) {
                    return ilvChartRenderer.getChildIterator();
                }
                return IlvCollections.emptyIterator();
            }
        };
        while (ilvPreorderIterator.hasNext()) {
            IlvSingleChartRenderer ilvSingleChartRenderer;
            Object e2 = ilvPreorderIterator.next();
            if (!(e2 instanceof IlvSingleChartRenderer) || !(ilvSingleChartRenderer = (IlvSingleChartRenderer)e2).isViewable()) continue;
            this.a(ilvSingleChartRenderer);
        }
        this.m = true;
    }

    private void a(IlvSingleChartRenderer ilvSingleChartRenderer) {
        double[] dArray = ilvSingleChartRenderer.getDepths();
        if (dArray == null) {
            return;
        }
        ZLayer zLayer = null;
        int n2 = this.n.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ZLayer zLayer2 = (ZLayer)this.n.get(i2);
            if (dArray[0] != zLayer2.getZMax() || dArray[1] != zLayer2.getZMin()) continue;
            zLayer = zLayer2;
            break;
        }
        if (zLayer == null) {
            this.n.add(new ZLayer(ilvSingleChartRenderer, dArray[1], dArray[0]));
        } else {
            zLayer.a.add(ilvSingleChartRenderer);
        }
    }

    private final boolean f() {
        return this.getChart().getType() == 3;
    }

    final void c() {
        this.getScene().invalidateAll();
        this.m = false;
    }

    final IlvChart3DWalls d() {
        return this.getScene().getWalls();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.g();
    }

    private void g() {
        this.l = new IlvChart3DScene(this);
        this.k = new IlvChart3DProjector(this);
    }

    public static final class ZLayer
    implements Serializable {
        private ArrayList a = new ArrayList(4);
        private double b;
        private double c;

        ZLayer(IlvSingleChartRenderer ilvSingleChartRenderer, double d2, double d3) {
            this.b = d2;
            this.c = d3;
            this.a.add(ilvSingleChartRenderer);
        }

        public double getZMin() {
            return this.b;
        }

        public double getZMax() {
            return this.c;
        }

        public List getRenderers() {
            return Collections.unmodifiableList(this.a);
        }
    }
}

