/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.graphic;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartDecoration;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvLabelRenderer;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.util.IlvGraphicUtil;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class IlvDataIndicator
extends IlvChartDecoration {
    public static final int X_VALUE = 0;
    public static final int Y_VALUE = 1;
    public static final int X_RANGE = 2;
    public static final int Y_RANGE = 3;
    public static final int WINDOW = 4;
    private double a;
    private IlvDataWindow b;
    private IlvStyle c;
    private int d;
    private int e;
    private String f;
    private IlvLabelRenderer g = new IlvLabelRenderer();

    public IlvDataIndicator(int n2, double d2, String string) {
        this.f = string;
        this.a(n2, d2);
    }

    public IlvDataIndicator(int n2, IlvDataInterval ilvDataInterval, String string) {
        this.f = string;
        this.a(n2, ilvDataInterval);
    }

    public IlvDataIndicator(int n2, IlvDataWindow ilvDataWindow, String string) {
        this.f = string;
        this.a(n2, ilvDataWindow);
    }

    public boolean has3DSupport() {
        return this.getChart() != null && this.getChart().getType() == 1;
    }

    public final int getAxisIndex() {
        return this.e;
    }

    public String getText() {
        return this.f;
    }

    public void setText(String string) {
        boolean bl;
        if (this.f == null ? string == null : this.f.equals(string)) {
            return;
        }
        Rectangle2D rectangle2D = null;
        boolean bl2 = bl = this.getChart() != null && this.isVisible();
        if (this.f != null && bl) {
            rectangle2D = this.getBounds(rectangle2D);
        }
        this.f = string;
        if (this.f != null && bl) {
            Rectangle2D rectangle2D2 = rectangle2D = rectangle2D != null ? IlvGraphicUtil.addToRect(rectangle2D, this.getBounds(null)) : this.getBounds(null);
        }
        if (rectangle2D != null && bl) {
            this.getChart().getChartArea().repaint2D(rectangle2D);
        }
    }

    public final int getType() {
        return this.d;
    }

    void a(int n2) {
        this.d = n2;
    }

    public final double getValue() {
        if (this.getType() == 0 || this.getType() == 1) {
            return this.a;
        }
        return 0.0;
    }

    public void setValue(double d2) {
        if (this.getType() != 0 && this.getType() != 1) {
            throw new UnsupportedOperationException("Invalid indicator type");
        }
        if (d2 != this.a) {
            Rectangle2D rectangle2D = null;
            if (this.getChart() != null && this.isVisible()) {
                rectangle2D = this.getBounds(rectangle2D);
            }
            this.a = d2;
            if (this.getChart() != null && this.isVisible()) {
                rectangle2D = rectangle2D != null ? IlvGraphicUtil.addToRect(rectangle2D, this.getBounds(null)) : this.getBounds(null);
                this.getChart().getChartArea().repaint2D(rectangle2D);
            }
        }
    }

    void a(int n2, double d2) {
        this.e = n2;
        this.b = null;
        this.a(n2 == -1 ? 0 : 1);
        this.a = d2;
        this.repaint();
    }

    public final IlvDataInterval getRange() {
        if (this.getType() != 2 && this.getType() != 3) {
            return null;
        }
        IlvDataInterval ilvDataInterval = this.getType() == 2 ? this.b.xRange : this.b.yRange;
        return new IlvDataInterval(ilvDataInterval);
    }

    public void setRange(IlvDataInterval ilvDataInterval) {
        if (this.getType() == 2) {
            if (!this.b.xRange.equals(ilvDataInterval)) {
                this.a(ilvDataInterval.getMin(), ilvDataInterval.getMax(), -1.7976931348623157E308, Double.MAX_VALUE);
            }
        } else if (this.getType() == 3) {
            if (!this.b.yRange.equals(ilvDataInterval)) {
                this.a(-1.7976931348623157E308, Double.MAX_VALUE, ilvDataInterval.getMin(), ilvDataInterval.getMax());
            }
        } else {
            throw new UnsupportedOperationException("Invalid indicator type");
        }
    }

    void a(int n2, IlvDataInterval ilvDataInterval) {
        this.e = n2;
        if (n2 == -1) {
            this.a(ilvDataInterval.getMin(), ilvDataInterval.getMax(), -1.7976931348623157E308, Double.MAX_VALUE);
            this.a(2);
        } else {
            this.a(-1.7976931348623157E308, Double.MAX_VALUE, ilvDataInterval.getMin(), ilvDataInterval.getMax());
            this.a(3);
        }
        this.repaint();
    }

    public final IlvDataWindow getDataWindow() {
        if (this.getType() == 0 || this.getType() == 1) {
            return null;
        }
        return this.b == null ? null : new IlvDataWindow(this.b);
    }

    public void setDataWindow(IlvDataWindow ilvDataWindow) {
        this.setDataWindow(ilvDataWindow.getXMin(), ilvDataWindow.getXMax(), ilvDataWindow.getYMin(), ilvDataWindow.getYMax());
    }

    public void setDataWindow(double d2, double d3, double d4, double d5) {
        if (this.getType() != 4) {
            throw new UnsupportedOperationException("Invalid indicator type");
        }
        this.a(d2, d3, d4, d5);
    }

    void a(int n2, IlvDataWindow ilvDataWindow) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Y axis index must be positive");
        }
        this.e = n2;
        this.a(4);
        this.a(ilvDataWindow.getXMin(), ilvDataWindow.getXMax(), ilvDataWindow.getYMin(), ilvDataWindow.getYMax());
        this.repaint();
    }

    public IlvStyle getDrawStyle() {
        IlvStyle ilvStyle = this.getStyle();
        if (ilvStyle == null) {
            ilvStyle = this.getType() == 0 || this.getType() == 1 ? IlvStyle.createStroked(this.getChart().getChartArea().getForeground()) : new IlvStyle(this.getChart().getChartArea().getForeground(), (Paint)this.getChart().getChartArea().getBackground());
        }
        return ilvStyle;
    }

    public boolean contains(int n2, int n3) {
        Shape shape = this.getShape();
        if (shape == null) {
            return false;
        }
        return this.getDrawStyle().shapeContains(shape, n2, n3);
    }

    private void a(double d2, double d3, double d4, double d5) {
        if (this.b == null || d2 != this.b.xRange.getMin() || d3 != this.b.xRange.getMax() || d4 != this.b.yRange.getMin() || d5 != this.b.yRange.getMax()) {
            Rectangle2D rectangle2D = null;
            if (this.getChart() != null && this.isVisible()) {
                rectangle2D = this.getBounds(rectangle2D);
            }
            if (this.b == null) {
                this.b = new IlvDataWindow(d2, d3, d4, d5);
            } else {
                this.b.xRange.set(d2, d3);
                this.b.yRange.set(d4, d5);
            }
            if (this.getChart() != null && this.isVisible()) {
                rectangle2D = rectangle2D != null ? IlvGraphicUtil.addToRect(rectangle2D, this.getBounds(null)) : this.getBounds(null);
                this.getChart().getChartArea().repaint2D(rectangle2D);
            }
        }
    }

    public final IlvLabelRenderer getLabelRenderer() {
        return this.g;
    }

    public void setLabelRenderer(IlvLabelRenderer ilvLabelRenderer) {
        if (ilvLabelRenderer == null) {
            throw new IllegalArgumentException("LabelRenderer cannot be null.");
        }
        if (ilvLabelRenderer != this.g) {
            boolean bl = this.getChart() != null && this.isVisible();
            Rectangle2D rectangle2D = null;
            if (bl) {
                rectangle2D = this.getBounds(null);
            }
            this.g = ilvLabelRenderer;
            if (bl) {
                rectangle2D = rectangle2D != null ? IlvGraphicUtil.addToRect(rectangle2D, this.getBounds(null)) : this.getBounds(null);
                this.getChart().getChartArea().repaint2D(rectangle2D);
            }
        }
    }

    public final IlvStyle getStyle() {
        return this.c;
    }

    public void setStyle(IlvStyle ilvStyle) {
        if (ilvStyle != this.c) {
            this.c = ilvStyle;
            if (this.getChart() != null && this.isVisible()) {
                this.getChart().getChartArea().repaint();
            }
        }
    }

    public void beforeDraw(Graphics graphics) {
        if (this.getChart() == null) {
            return;
        }
        if (this.getType() == 0 || this.getType() == 1) {
            this.a(graphics, true);
        } else {
            this.b(graphics, true);
        }
    }

    public void draw(Graphics graphics) {
    }

    public void afterDraw(Graphics graphics) {
        if (this.getChart() == null) {
            return;
        }
        if (this.getType() == 0 || this.getType() == 1) {
            this.a(graphics, false);
        } else {
            this.b(graphics, false);
        }
    }

    protected IlvDoublePoint computeLabelLocation(IlvDataWindow ilvDataWindow) {
        int n2;
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(1);
        if (this.getType() == 0 || this.getType() == 1) {
            int n3 = n2 = this.e == -1 ? 1 : 2;
            if (n2 == 1) {
                ilvDoublePoints.add(this.a, (ilvDataWindow.getYMin() + ilvDataWindow.getYMax()) / 2.0);
            } else {
                ilvDoublePoints.add((ilvDataWindow.getXMin() + ilvDataWindow.getXMax()) / 2.0, this.a);
            }
        } else {
            ilvDoublePoints.add((ilvDataWindow.getXMin() + ilvDataWindow.getXMax()) / 2.0, (ilvDataWindow.getYMin() + ilvDataWindow.getYMax()) / 2.0);
        }
        int n4 = n2 = this.e > 0 ? this.e : 0;
        if (this.getChart().is3D()) {
            this.getChart().get3DView().toDisplay(ilvDoublePoints, n2, this.getChart().get3DView().getBackDepth());
        } else {
            this.getChart().toDisplay(ilvDoublePoints, n2);
        }
        IlvDoublePoint ilvDoublePoint = new IlvDoublePoint(ilvDoublePoints.getX(0), ilvDoublePoints.getY(0));
        ilvDoublePoints.dispose();
        return ilvDoublePoint;
    }

    public Rectangle2D getBounds(Rectangle2D rectangle2D) {
        IlvChart ilvChart = this.getChart();
        if (ilvChart == null) {
            return new Rectangle();
        }
        int n2 = this.e > 0 ? this.e : 0;
        IlvCoordinateSystem ilvCoordinateSystem = ilvChart.getCoordinateSystem(n2);
        IlvDoublePoint ilvDoublePoint = null;
        if (this.getType() == 4 || this.getType() == 2 || this.getType() == 3) {
            IlvDataWindow ilvDataWindow = new IlvDataWindow(this.b);
            ilvDataWindow.intersection(ilvCoordinateSystem.getVisibleWindow());
            if (ilvDataWindow.isEmpty()) {
                return new Rectangle();
            }
            Shape shape = ilvChart.getProjector().getShape(ilvDataWindow, ilvChart.getChartArea().getPlotRect(), ilvCoordinateSystem);
            rectangle2D = this.getDrawStyle().getShapeBounds(shape);
            if (this.getText() != null) {
                ilvDoublePoint = this.computeLabelLocation(ilvDataWindow);
            }
        } else {
            IlvAxis ilvAxis;
            int n3;
            if (this.e == -1) {
                n3 = 1;
                ilvAxis = ilvCoordinateSystem.getXAxis();
            } else {
                n3 = 2;
                ilvAxis = ilvCoordinateSystem.getYAxis();
            }
            if (!ilvAxis.getVisibleRange().isInside(this.a)) {
                return new Rectangle();
            }
            Shape shape = ilvChart.getProjector().getShape(this.a, n3, ilvChart.getChartArea().getPlotRect(), ilvCoordinateSystem);
            rectangle2D = this.getDrawStyle().getShapeBounds(shape);
            if (this.getText() != null) {
                ilvDoublePoint = this.computeLabelLocation(ilvCoordinateSystem.getVisibleWindow());
            }
        }
        if (ilvDoublePoint != null) {
            rectangle2D = IlvGraphicUtil.addToRect(rectangle2D, this.g.getBounds(ilvChart.getChartArea(), ilvDoublePoint.xFloor(), ilvDoublePoint.yFloor(), this.getText(), null));
        }
        return rectangle2D;
    }

    protected void chartConnected(IlvChart ilvChart, IlvChart ilvChart2) {
        if (this.e >= 0 && ilvChart2 != null && this.e >= ilvChart2.getYAxisCount()) {
            throw new IndexOutOfBoundsException("Cannot add indicator: invalid y-axis index");
        }
        super.chartConnected(ilvChart, ilvChart2);
    }

    private void a(Graphics graphics, boolean bl) {
        if (bl || !this.a().getVisibleRange().isInside(this.a)) {
            return;
        }
        IlvChart ilvChart = this.getChart();
        int n2 = this.e >= 0 ? this.e : 0;
        IlvCoordinateSystem ilvCoordinateSystem = this.getChart().getCoordinateSystem(n2);
        int n3 = this.e == -1 ? 1 : 2;
        Shape shape = ilvChart.getProjector().getShape(this.a, n3, ilvChart.getChartArea().getPlotRect(), ilvCoordinateSystem);
        this.getDrawStyle().draw(graphics, shape);
        if (this.getText() != null) {
            IlvDoublePoint ilvDoublePoint = this.computeLabelLocation(ilvCoordinateSystem.getVisibleWindow());
            this.g.paintLabel(this.getChart().getChartArea(), graphics, this.getText(), ilvDoublePoint.xFloor(), ilvDoublePoint.yFloor());
        }
    }

    private void b(Graphics graphics, boolean bl) {
        Object object;
        int n2 = this.e >= 0 ? this.e : 0;
        IlvChart ilvChart = this.getChart();
        IlvCoordinateSystem ilvCoordinateSystem = ilvChart.getCoordinateSystem(n2);
        IlvDataWindow ilvDataWindow = new IlvDataWindow(this.b);
        ilvDataWindow.intersection(ilvCoordinateSystem.getVisibleWindow());
        if (ilvDataWindow.isEmpty()) {
            return;
        }
        Rectangle rectangle = ilvChart.getChartArea().getPlotRect();
        boolean bl2 = true;
        if (!ilvChart.is3D() && (object = graphics.getClipBounds()) != null) {
            object = (Rectangle)((RectangularShape)object).clone();
            this.getDrawStyle().expand((Rectangle2D)object);
            bl2 = this.getChart().getProjector().toDataWindow((Rectangle)object, rectangle, ilvCoordinateSystem).intersects(ilvDataWindow);
        }
        if (bl) {
            if (bl2) {
                object = ilvChart.getProjector().getShape(ilvDataWindow, rectangle, ilvCoordinateSystem);
                this.getDrawStyle().setStrokeOn(false).renderShape(graphics, (Shape)object);
            }
        } else {
            if (bl2) {
                object = ilvChart.getProjector().getShape(ilvDataWindow, rectangle, ilvCoordinateSystem);
                this.getDrawStyle().setFillOn(false).renderShape(graphics, (Shape)object);
            }
            if (this.getText() != null) {
                object = this.computeLabelLocation(ilvDataWindow);
                this.g.paintLabel(this.getChart().getChartArea(), graphics, this.getText(), ((IlvDoublePoint)object).xFloor(), ((IlvDoublePoint)object).yFloor());
            }
        }
    }

    private final IlvAxis a() {
        return this.e == -1 ? this.getChart().getXAxis() : this.getChart().getYAxis(this.e);
    }

    public Shape getShape() {
        Shape shape;
        IlvChart ilvChart = this.getChart();
        if (ilvChart == null) {
            return null;
        }
        int n2 = this.e > 0 ? this.e : 0;
        IlvCoordinateSystem ilvCoordinateSystem = ilvChart.getCoordinateSystem(n2);
        if (this.getType() == 4 || this.getType() == 2 || this.getType() == 3) {
            IlvDataWindow ilvDataWindow = new IlvDataWindow(this.b);
            ilvDataWindow.intersection(ilvCoordinateSystem.getVisibleWindow());
            shape = ilvDataWindow.isEmpty() ? null : ilvChart.getProjector().getShape(ilvDataWindow, ilvChart.getChartArea().getPlotRect(), ilvCoordinateSystem);
        } else {
            int n3 = this.e == -1 ? 1 : 2;
            shape = ilvChart.getProjector().getShape(this.a, n3, ilvChart.getChartArea().getPlotRect(), ilvCoordinateSystem);
        }
        return shape;
    }
}

