/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.renderer;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartProjector;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvScale;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.graphic.IlvDataRenderingHint;
import ilog.views.chart.renderer.IlvBarChartRenderer;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.renderer.IlvSuperimposedRenderer;
import ilog.views.chart.renderer.IlvVariableWidthRenderer;
import ilog.views.chart.renderer.internal.IlvDataSetRendererProperty;
import ilog.views.chart.renderer.internal.IlvStackedDataSet;
import ilog.views.chart.renderer.internal.IlvVirtualDataSet;
import ilog.views.chart.servlet.IlvIMapArea;
import ilog.views.chart.servlet.IlvIMapAttributes;
import ilog.views.chart.servlet.IlvIMapDefinition;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.view3d.IlvChart3DBar;
import ilog.views.chart.view3d.IlvChart3DObject;
import ilog.views.chart.view3d.IlvChart3DScene;
import ilog.views.util.IlvColorUtil;
import ilog.views.util.collections.internal.IlvIntToObjectHashMap;
import ilog.views.util.collections.internal.IlvIntToObjectMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class IlvSingleBarRenderer
extends IlvSingleChartRenderer
implements IlvVariableWidthRenderer {
    private static boolean a = true;
    private static int b;
    private double c;
    private boolean d = false;
    private int e = 2;
    private IlvBarChartRenderer f;
    private int g;
    public static final int SHAPE_QUADRILATERAL = 1;
    public static final int SHAPE_POLYGON = 2;
    public static final int SHAPE_EXACT = 3;

    public static int getStrokeThreshold() {
        return b;
    }

    public static void setStrokeThreshold(int n2) {
        b = n2;
    }

    public IlvSingleBarRenderer() {
        this(null);
    }

    public IlvSingleBarRenderer(IlvStyle ilvStyle) {
        this(ilvStyle, 80.0);
    }

    public IlvSingleBarRenderer(IlvStyle ilvStyle, double d2) {
        super(ilvStyle);
        this.setWidthPercent(d2);
    }

    int b() {
        return 1;
    }

    public double getSpecWidthPercent() {
        return this.c;
    }

    public void setWidthPercent(double d2) {
        if (d2 < 0.0 || d2 > 100.0) {
            throw new IllegalArgumentException("Percentage must be in [0..100]");
        }
        if (d2 != this.c) {
            this.c = d2;
            this.triggerChange(4);
        }
    }

    public double getWidthPercent() {
        if (this.f != null && this.f.getMode() == 1 && this.getChart() != null && this.getChart().is3D()) {
            return this.f.getWidthPercent();
        }
        return this.c;
    }

    public double getWidth() {
        return this.getWidthPercent() * this.p() / 100.0;
    }

    public boolean isUseCategorySpacingAtBorders() {
        return this.d;
    }

    public void setUseCategorySpacingAtBorders(boolean bl) {
        if (bl != this.d) {
            this.d = bl;
            if (this.getChart() != null) {
                this.getChart().updateDataRange();
                this.getChart().getChartArea().repaint();
            }
        }
    }

    public int getBarShape() {
        return this.e;
    }

    public void setBarShape(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid barShape " + n2);
            }
        }
        this.e = n2;
    }

    double b(int n2) {
        double d2;
        if (this.g != 0 && this.f != null && this.f.getMode() == 3 && !Double.isNaN(d2 = ((IlvStackedDataSet)this.g()).getPreviousYData(n2))) {
            return Math.max(this.i().getVisibleMin(), d2);
        }
        return Math.max(this.i().getVisibleMin(), this.getCoordinateSystem().getXCrossingValue());
    }

    final void c(int n2) {
        this.g = n2;
    }

    public void setParent(IlvChartRenderer ilvChartRenderer) {
        this.f = ilvChartRenderer instanceof IlvBarChartRenderer ? (IlvBarChartRenderer)ilvChartRenderer : null;
        super.setParent(ilvChartRenderer);
    }

    public boolean has3DSupport() {
        return true;
    }

    public double[] getDepths() {
        if (this.f == null || this.f.getMode() == 1) {
            return super.getDepths();
        }
        double[] dArray = this.f.getDepths();
        if (dArray != null) {
            double d2 = (dArray[0] - dArray[1]) * (double)this.getChart().get3DView().getDepthGap() / 200.0;
            dArray[0] = dArray[0] - d2;
            dArray[1] = dArray[1] + d2;
        }
        return dArray;
    }

    void a(IlvSingleChartRenderer.Points points, boolean bl) {
        double d2 = this.getWidth() / 2.0;
        if (d2 == 0.0) {
            return;
        }
        IlvCoordinateSystem ilvCoordinateSystem = this.getCoordinateSystem();
        Rectangle rectangle = this.getPlotRect();
        IlvChartProjector ilvChartProjector = this.getChart().getLocalProjector2D(rectangle, ilvCoordinateSystem);
        BarItem barItem = new BarItem(2);
        int n2 = points.size();
        Double d3 = points.getDataSet().getUndefValue();
        double d4 = d3 != null ? d3 : 0.0;
        IlvChart3DScene ilvChart3DScene = this.getChart().get3DView().getScene();
        double[] dArray = this.getDepths();
        IlvIntToObjectMap<IlvChart3DObject> ilvIntToObjectMap = this.l();
        IlvIntToObjectHashMap<IlvChart3DObject> ilvIntToObjectHashMap = bl ? new IlvIntToObjectHashMap<IlvChart3DObject>() : null;
        Iterator<IlvChart3DObject> iterator = null;
        IlvDataWindow ilvDataWindow = ilvCoordinateSystem.getVisibleWindow();
        if (bl) {
            iterator = ilvIntToObjectMap.values().iterator();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvChart3DBar ilvChart3DBar;
            double d5 = points.getYData(i2);
            if (d3 != null && d5 == d4 || Double.isNaN(d5)) continue;
            int n3 = points.getDataIndex(i2);
            barItem.a(points, i2, d2);
            if (!barItem.a(ilvDataWindow)) continue;
            ilvChartProjector.toDisplay(barItem, rectangle, ilvCoordinateSystem);
            if (bl) {
                ilvChart3DBar = iterator.hasNext() ? ((IlvChart3DBar)iterator.next()).setGeometry(barItem, dArray, n3) : new IlvChart3DBar(ilvChart3DScene, barItem, dArray, this, n3);
                ilvChart3DScene.addObject(ilvChart3DBar);
                ilvIntToObjectHashMap.put(n3, ilvChart3DBar);
                continue;
            }
            ilvChart3DBar = (IlvChart3DBar)ilvIntToObjectMap.get(n3);
            if (ilvChart3DBar != null) {
                ilvChart3DBar.setGeometry(barItem, dArray, n3);
                continue;
            }
            ilvChart3DBar = new IlvChart3DBar(ilvChart3DScene, barItem, dArray, this, n3);
            ilvChart3DScene.addObject(ilvChart3DBar, true);
            ilvIntToObjectMap.put(n3, ilvChart3DBar);
        }
        if (bl) {
            this.a(ilvIntToObjectHashMap);
            while (iterator.hasNext()) {
                ilvChart3DScene.removeObject(iterator.next());
            }
        }
    }

    public String getZAnnotationText() {
        if (this.f == null || this.f.getMode() == 1) {
            return this.getDefaultLegendText();
        }
        return null;
    }

    int c() {
        return 1;
    }

    int d() {
        return 0;
    }

    void a(IlvSingleChartRenderer.Points points, IlvSingleChartRenderer.ItemAction itemAction) {
        boolean bl;
        double d2 = this.getWidth() / 2.0;
        if (d2 == 0.0) {
            return;
        }
        IlvCoordinateSystem ilvCoordinateSystem = this.getCoordinateSystem();
        Rectangle rectangle = this.getPlotRect();
        IlvChartProjector ilvChartProjector = this.getChart().getLocalProjector2D(rectangle, ilvCoordinateSystem);
        BarItem barItem = new BarItem(7);
        int n2 = points.size();
        IlvStyle ilvStyle = this.getStyle();
        IlvDataSet ilvDataSet = points.getDataSet();
        Double d3 = ilvDataSet.getUndefValue();
        double d4 = d3 != null ? d3 : 0.0;
        double d5 = this.getChart().getProjector().getAxisLength(rectangle, this.j());
        boolean bl2 = bl = 2.0 * d5 * d2 / this.j().getVisibleRange().getLength() > (double)IlvSingleBarRenderer.getStrokeThreshold();
        if (ilvStyle.isFillOn() && !bl) {
            ilvStyle = ilvStyle.setStrokeOn(false);
        }
        if (this.s()) {
            IlvStyle ilvStyle2 = ilvStyle;
            int[] nArray = points.getIndices();
            IlvDisplayPoint ilvDisplayPoint = new IlvDisplayPoint(this, ilvDataSet);
            for (int i2 = 0; i2 < n2; ++i2) {
                double d6 = points.getYData(i2);
                if (d3 != null && d6 == d4 || Double.isNaN(d6)) continue;
                barItem.a(points, i2, d2);
                ilvChartProjector.toDisplay(barItem, rectangle, ilvCoordinateSystem);
                ilvDisplayPoint.dataSet = ilvDataSet;
                ilvDisplayPoint.set(nArray[i2], 0.0, 0.0);
                IlvDataRenderingHint ilvDataRenderingHint = this.b(ilvDisplayPoint);
                if (ilvDataRenderingHint != null) {
                    ilvStyle2 = ilvDataRenderingHint.getStyle(ilvDisplayPoint, ilvStyle);
                    if (ilvStyle2 == null) {
                        continue;
                    }
                } else {
                    ilvStyle2 = ilvStyle;
                }
                itemAction.processItem(points, i2, barItem, ilvStyle2);
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                double d7 = points.getYData(i3);
                if (d3 != null && d7 == d4 || Double.isNaN(d7)) continue;
                barItem.a(points, i3, d2);
                ilvChartProjector.toDisplay(barItem, rectangle, ilvCoordinateSystem);
                itemAction.processItem(points, i3, barItem, ilvStyle);
            }
        }
    }

    public Point computeDataLabelLocation(IlvDisplayPoint ilvDisplayPoint, Dimension dimension) {
        Object object;
        IlvDataSet ilvDataSet = ilvDisplayPoint.getDataSet();
        IlvVirtualDataSet ilvVirtualDataSet = IlvDataSetRendererProperty.getVirtualDataSet(this, ilvDataSet);
        if (ilvVirtualDataSet != null) {
            ilvDisplayPoint = (IlvDisplayPoint)ilvDisplayPoint.clone();
            ilvVirtualDataSet.map(ilvDisplayPoint);
            ilvDataSet = ilvVirtualDataSet;
        }
        if (this.getDataLabelLayout() == 2) {
            IlvDoublePoint ilvDoublePoint = new IlvDoublePoint(ilvDisplayPoint.getXCoord(), ilvDisplayPoint.getYCoord());
            double d2 = ilvDataSet.getYData(ilvDisplayPoint.getIndex());
            double d3 = d2 >= this.b(ilvDisplayPoint.getIndex()) ? 3.0 : -3.0;
            return this.a(ilvDoublePoint, dimension, d3, true);
        }
        if (this.k() && (object = this.e(ilvDisplayPoint.getIndex())) != null) {
            return ((IlvChart3DObject)object).computeDataLabelLocation(ilvDisplayPoint, dimension);
        }
        object = new IlvDoublePoints(ilvDataSet.getXData(ilvDisplayPoint.getIndex()), (this.b(ilvDisplayPoint.getIndex()) + ilvDataSet.getYData(ilvDisplayPoint.getIndex())) / 2.0);
        this.toDisplay((IlvDoublePoints)object);
        double d4 = ((IlvDoublePoints)object).getX(0);
        double d5 = ((IlvDoublePoints)object).getY(0);
        ((IlvDoublePoints)object).dispose();
        return new Point(IlvGraphicUtil.toInt(d4), IlvGraphicUtil.toInt(d5));
    }

    IlvDataWindow a(IlvDataWindow ilvDataWindow) {
        double d2;
        double d3 = this.getXShift();
        if (d3 != 0.0) {
            ilvDataWindow.xRange.translate(d3);
        }
        if ((d2 = this.getWidth() / 2.0) > 0.0) {
            ilvDataWindow.xRange.expand(d2);
        }
        return ilvDataWindow;
    }

    public IlvDataInterval getXRange(IlvDataInterval ilvDataInterval) {
        IlvScale ilvScale;
        IlvChart ilvChart;
        IlvDataInterval ilvDataInterval2 = super.getXRange(ilvDataInterval);
        boolean bl = false;
        if (this.isUseCategorySpacingAtBorders() && (ilvChart = this.getChart()) != null && (ilvScale = ilvChart.getXScale()) != null) {
            bl = ilvScale.isCategory();
        }
        if (bl) {
            ilvDataInterval2.expand(this.p() / 2.0);
        } else {
            ilvDataInterval2.expand(this.getWidth() / 2.0);
        }
        return ilvDataInterval2;
    }

    IlvStyle a(Paint paint, Paint paint2, Stroke stroke) {
        Color color;
        IlvStyle ilvStyle = super.a(paint, paint2, stroke);
        IlvChartRenderer ilvChartRenderer = this.getParent();
        if (ilvStyle != null && this.isFilled() && ilvChartRenderer instanceof IlvSuperimposedRenderer && ((IlvSuperimposedRenderer)((Object)ilvChartRenderer)).isSuperimposed() && ((IlvSuperimposedRenderer)((Object)ilvChartRenderer)).isAutoTransparency() && (color = ilvStyle.getFillColor()) != null) {
            ilvStyle = ilvStyle.setFillPaint(IlvColorUtil.setAlpha(color, 0.5f));
        }
        return ilvStyle;
    }

    static {
        IlvChartRenderer.register("SingleBar", IlvSingleBarRenderer.class);
        try {
            a = !Boolean.getBoolean("ilog.views.chart.polyBar");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        b = 6;
    }

    class BarItem
    extends IlvSingleChartRenderer.DefaultItem {
        private boolean a;
        private Shape b;

        public BarItem(int n2) {
            super(IlvSingleBarRenderer.this, n2);
            this.a = IlvSingleBarRenderer.this.getChart().getType() == 1;
        }

        void a(IlvSingleChartRenderer.Points points, int n2, double d2) {
            double d3 = points.getXData(n2) + IlvSingleBarRenderer.this.getXShift();
            double d4 = IlvSingleBarRenderer.this.b(points.getDataIndex(n2));
            double d5 = points.getYData(n2);
            if (this.a && (a || IlvSingleBarRenderer.this.k())) {
                this.set(0, d3 - d2, d4);
                this.set(1, d3 + d2, d5);
                this.setSize(2);
                this.b = null;
            } else if (IlvSingleBarRenderer.this.e == 1 || IlvSingleBarRenderer.this.e == 2) {
                double[] dArray = this.getXValues();
                double[] dArray2 = this.getYValues();
                dArray[0] = d3 - d2;
                dArray2[0] = d4;
                dArray[1] = dArray[0];
                dArray2[1] = d5;
                if (IlvSingleBarRenderer.this.e == 1 || this.a) {
                    dArray[2] = d3 + d2;
                    dArray2[2] = dArray2[1];
                    dArray[3] = dArray[2];
                    dArray2[3] = dArray2[0];
                    dArray[4] = dArray[0];
                    dArray2[4] = dArray2[0];
                    this.setSize(5);
                } else {
                    dArray[2] = d3;
                    dArray2[2] = dArray2[1];
                    dArray[3] = d3 + d2;
                    dArray2[3] = dArray2[1];
                    dArray[4] = dArray[3];
                    dArray2[4] = dArray2[0];
                    dArray[5] = dArray[0];
                    dArray2[5] = dArray2[0];
                    this.setSize(6);
                }
                this.b = null;
            } else if (IlvSingleBarRenderer.this.e == 3) {
                IlvDataWindow ilvDataWindow = new IlvDataWindow(d3 - d2, d3 + d2, d4, d5);
                this.b = IlvSingleBarRenderer.this.getChart().getProjector().getShape(ilvDataWindow, IlvSingleBarRenderer.this.getPlotRect(), IlvSingleBarRenderer.this.getCoordinateSystem());
            }
        }

        public void draw(Graphics graphics, IlvStyle ilvStyle) {
            if (this.a && a) {
                ilvStyle.renderRect(graphics, this.getX(0), this.getY(0), this.getX(1), this.getY(1));
            } else if (this.b != null) {
                ilvStyle.renderShape(graphics, this.b);
                if (!ilvStyle.isStrokeOn()) {
                    IlvSingleBarRenderer.this.getStyle().draw(graphics, this.b);
                }
            } else {
                super.draw(graphics, ilvStyle);
            }
        }

        public Rectangle2D getBounds(IlvStyle ilvStyle, Rectangle2D rectangle2D) {
            if (!(this.a && a || this.b == null)) {
                return ilvStyle.getShapeBounds(this.b);
            }
            return super.getBounds(ilvStyle, rectangle2D);
        }

        public boolean contains(IlvStyle ilvStyle, double d2, double d3) {
            if (this.a && a) {
                return this.getBounds(ilvStyle, null).contains(d2, d3);
            }
            if (this.b != null) {
                return ilvStyle.shapeContains(this.b, d2, d3);
            }
            return super.contains(ilvStyle, d2, d3);
        }

        public IlvIMapArea getMapArea(IlvIMapDefinition ilvIMapDefinition, IlvStyle ilvStyle, IlvIMapAttributes ilvIMapAttributes) {
            Rectangle rectangle;
            int n2 = 0;
            int n3 = 0;
            if (ilvIMapDefinition.isChartOrigin()) {
                rectangle = IlvSingleBarRenderer.this.m();
                n2 = rectangle.x;
                n3 = rectangle.y;
            }
            if (this.a && a) {
                rectangle = this.getBounds(ilvStyle, null).getBounds();
                rectangle.translate(n2, n3);
                return new IlvIMapArea(rectangle, ilvIMapAttributes);
            }
            if (this.b != null) {
                return new IlvIMapArea(this.b, (double)n2, (double)n3, ilvIMapAttributes);
            }
            return super.getMapArea(ilvIMapDefinition, ilvStyle, ilvIMapAttributes);
        }

        boolean a(IlvDataWindow ilvDataWindow) {
            if (this.getX(0) < ilvDataWindow.getXMin()) {
                if (this.getX(1) < ilvDataWindow.getXMin()) {
                    return false;
                }
                this.setX(0, ilvDataWindow.getXMin());
            } else if (this.getX(0) > ilvDataWindow.getXMax()) {
                if (this.getX(1) > ilvDataWindow.getXMax()) {
                    return false;
                }
                this.setX(0, ilvDataWindow.getXMax());
            }
            if (this.getX(1) < ilvDataWindow.getXMin()) {
                this.setX(1, ilvDataWindow.getXMin());
            } else if (this.getX(1) > ilvDataWindow.getXMax()) {
                this.setX(1, ilvDataWindow.getXMax());
            }
            if (this.getY(0) < ilvDataWindow.getYMin()) {
                if (this.getY(1) < ilvDataWindow.getYMin()) {
                    return false;
                }
                this.setY(0, ilvDataWindow.getYMin());
            } else if (this.getY(0) > ilvDataWindow.getYMax()) {
                if (this.getY(1) > ilvDataWindow.getYMax()) {
                    return false;
                }
                this.setY(0, ilvDataWindow.getYMax());
            }
            if (this.getY(1) < ilvDataWindow.getYMin()) {
                this.setY(1, ilvDataWindow.getYMin());
            } else if (this.getY(1) > ilvDataWindow.getYMax()) {
                this.setY(1, ilvDataWindow.getYMax());
            }
            return true;
        }
    }
}

