/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.renderer;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartProjector;
import ilog.views.chart.IlvChartRenderer;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvLegendItem;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataPoints;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.graphic.IlvDataRenderingHint;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.renderer.IlvVariableWidthRenderer;
import ilog.views.chart.renderer.internal.IlvHiLoDataSet;
import ilog.views.chart.servlet.IlvIMapArea;
import ilog.views.chart.servlet.IlvIMapAttributes;
import ilog.views.chart.servlet.IlvIMapDefinition;
import ilog.views.chart.styling.IlvDataSetStyle;
import ilog.views.chart.styling.IlvStylingSupport;
import java.awt.Graphics;
import java.awt.Rectangle;

public class IlvSingleHiLoRenderer
extends IlvSingleChartRenderer
implements IlvVariableWidthRenderer {
    public static final int STICK = 0;
    public static final int BAR = 1;
    public static final int ARROW = 2;
    public static final int MARKED = 3;
    private static int a = 6;
    private IlvStyle b;
    private double c;
    private int d;

    public static int getStrokeThreshold() {
        return a;
    }

    public static void setStrokeThreshold(int n2) {
        a = n2;
    }

    public IlvSingleHiLoRenderer() {
        this(null, null);
    }

    public IlvSingleHiLoRenderer(IlvStyle ilvStyle, IlvStyle ilvStyle2) {
        this(ilvStyle, ilvStyle2, 1, 80.0);
    }

    public IlvSingleHiLoRenderer(IlvStyle ilvStyle, IlvStyle ilvStyle2, int n2, double d2) {
        super(ilvStyle);
        this.setFallStyle(ilvStyle2);
        this.setType(n2);
        this.setWidthPercent(d2);
    }

    public int getMinDataSetCount() {
        return 2;
    }

    public boolean isFilled() {
        return this.getType() == 1 || this.getType() == 2;
    }

    public IlvStyle getRiseStyle() {
        return this.getStyle();
    }

    public void setRiseStyle(IlvStyle ilvStyle) {
        this.setStyle(ilvStyle);
    }

    public IlvStyle getFallStyle() {
        return this.b;
    }

    public void setFallStyle(IlvStyle ilvStyle) {
        if (ilvStyle != this.b) {
            this.b = ilvStyle;
            this.triggerChange(4);
        }
    }

    public IlvStyle[] getStyles() {
        if (this.getRiseStyle() == null && this.getFallStyle() == null) {
            return new IlvStyle[0];
        }
        if (this.getFallStyle() == null) {
            return new IlvStyle[]{this.getRiseStyle(), this.getRiseStyle()};
        }
        if (this.getRiseStyle() == null) {
            return new IlvStyle[]{this.getFallStyle(), this.getFallStyle()};
        }
        return new IlvStyle[]{this.getRiseStyle(), this.getFallStyle()};
    }

    public void setStyles(IlvStyle[] ilvStyleArray) {
        if (ilvStyleArray.length >= 2) {
            this.setRiseStyle(ilvStyleArray[0]);
            this.setFallStyle(ilvStyleArray[1]);
        } else {
            this.setRiseStyle(ilvStyleArray[0]);
            this.setFallStyle(ilvStyleArray[0]);
        }
    }

    IlvStyle b(IlvDataSet ilvDataSet, int n2) {
        if (ilvDataSet == this.e()) {
            return this.getRiseStyle();
        }
        return this.getFallStyle();
    }

    public void applyStyles(boolean bl) throws Exception {
        super.applyStyles(bl);
        IlvStylingSupport ilvStylingSupport = IlvStylingSupport.get(this.getChart());
        if (ilvStylingSupport == null) {
            return;
        }
        IlvDataSet ilvDataSet = this.getDataSource().getDataSet(1);
        if (ilvDataSet == null) {
            return;
        }
        IlvDataSetStyle ilvDataSetStyle = IlvDataSetStyle.get(this.getChart(), ilvDataSet);
        if (ilvDataSetStyle != null && !bl) {
            return;
        }
        ilvDataSetStyle = IlvChartRenderer.applyStyles(ilvDataSet, null, ilvStylingSupport);
        if (ilvDataSetStyle != null) {
            this.a(ilvDataSetStyle);
        }
    }

    private void a(IlvDataSetStyle ilvDataSetStyle) {
        if (ilvDataSetStyle.getColor1() == null) {
            this.b = null;
            this.setFallStyle(this.a(this.isFilled() ? this.getStyle().getFillPaint() : this.getStyle().getStrokePaint(), ilvDataSetStyle.getColor2(), ilvDataSetStyle.getUsedStroke()));
        } else {
            IlvStyle ilvStyle = ilvDataSetStyle.getStyle(this, this.getStyle());
            this.setFallStyle(ilvStyle);
        }
    }

    public double getWidthPercent() {
        return this.c * 100.0;
    }

    public void setWidthPercent(double d2) {
        if (d2 < 0.0 || d2 > 100.0) {
            throw new IllegalArgumentException("Percentage must be in [0..100]");
        }
        if ((d2 /= 100.0) != this.c) {
            this.c = d2;
            this.triggerChange(4);
        }
    }

    public double getWidth() {
        return this.c * this.p();
    }

    public final int getType() {
        return this.d;
    }

    public void setType(int n2) {
        this.b(n2);
        if (n2 != this.d) {
            this.d = n2;
            this.triggerChange(4);
        }
    }

    private void b(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + n2);
            }
        }
    }

    void a(IlvDataSet ilvDataSet, IlvDataSet ilvDataSet2) {
        this.getDataSource().setDataSets(new IlvDataSet[]{ilvDataSet, ilvDataSet2});
    }

    IlvDataSet e() {
        return this.getDataSource().getDataSet(0);
    }

    IlvDataSet t() {
        return this.getDataSource().getDataSet(1);
    }

    IlvDataPoints a(Rectangle rectangle) {
        IlvDataPoints ilvDataPoints = super.a(rectangle);
        if (ilvDataPoints == null) {
            return null;
        }
        IlvDataSet ilvDataSet = this.g();
        IlvDataInterval ilvDataInterval = this.i().getVisibleRange();
        if (ilvDataInterval.contains(ilvDataSet.getYRange(null))) {
            return ilvDataPoints;
        }
        int n2 = ilvDataPoints.size();
        if (n2 < 2) {
            return ilvDataPoints;
        }
        int n3 = 0;
        if (ilvDataPoints.getIndex(n3) % 2 == 1) {
            ++n3;
            --n2;
        }
        if (n2 % 2 == 1) {
            --n2;
        }
        if (n2 == 0) {
            return ilvDataPoints;
        }
        int[] nArray = ilvDataPoints.getIndices();
        double[] dArray = ilvDataPoints.getXValues();
        double[] dArray2 = ilvDataPoints.getYValues();
        IlvDataPoints ilvDataPoints2 = new IlvDataPoints(ilvDataSet, n2);
        IlvDataInterval ilvDataInterval2 = new IlvDataInterval();
        while (n3 < n2) {
            double d2 = dArray2[n3 + 1];
            double d3 = dArray2[n3];
            if (d2 > d3) {
                ilvDataInterval2.setMin(d3);
                ilvDataInterval2.setMax(d2);
            } else {
                ilvDataInterval2.setMin(d2);
                ilvDataInterval2.setMax(d3);
            }
            if (ilvDataInterval2.intersects(ilvDataInterval)) {
                ilvDataPoints2.add(dArray[n3], d3, nArray[n3]);
                ilvDataPoints2.add(dArray[n3 + 1], d2, nArray[n3 + 1]);
            }
            n3 += 2;
        }
        ilvDataPoints.dispose();
        return ilvDataPoints2;
    }

    int c() {
        return 1;
    }

    protected void chartConnected(IlvChart ilvChart, IlvChart ilvChart2) {
        super.chartConnected(ilvChart, ilvChart2);
        if (ilvChart2 != null && this.getFallStyle() == null) {
            this.setFallStyle(this.makeDefaultStyle());
        }
    }

    protected void dataSetsRemoved(int n2, int n3, IlvDataSet[] ilvDataSetArray) {
        super.dataSetsRemoved(n2, n3, ilvDataSetArray);
        this.u();
    }

    protected void dataSetsAdded(int n2, int n3, IlvDataSet[] ilvDataSetArray) {
        super.dataSetsAdded(n2, n3, ilvDataSetArray);
        this.u();
    }

    void u() {
        int n2 = this.getDataSource().getDataSetCount();
        if (n2 == 2) {
            IlvHiLoDataSet ilvHiLoDataSet = new IlvHiLoDataSet(this.e(), this.t());
            boolean bl = this.a(this.e(), ilvHiLoDataSet, false);
            if ((bl |= this.a(this.t(), ilvHiLoDataSet, true)) && this.getChart() != null) {
                this.getChart().updateDataRange();
            }
        }
    }

    void a(IlvSingleChartRenderer.Points points, IlvSingleChartRenderer.ItemAction itemAction) {
        block18: {
            HiLoItem hiLoItem;
            IlvStyle ilvStyle;
            IlvStyle ilvStyle2;
            IlvStyle ilvStyle3;
            double d2;
            double d3;
            Double d4;
            IlvChartProjector ilvChartProjector;
            Rectangle rectangle;
            IlvCoordinateSystem ilvCoordinateSystem;
            boolean bl;
            IlvDataInterval ilvDataInterval;
            int n2;
            int n3;
            block14: {
                n3 = points.size();
                if (n3 < 2) {
                    return;
                }
                n2 = 0;
                if (points.getDataIndex(n2) % 2 == 1) {
                    ++n2;
                    --n3;
                }
                if (n3 % 2 == 1) {
                    --n3;
                }
                if (n3 == 0) {
                    return;
                }
                IlvDataSet ilvDataSet = points.getDataSet();
                ilvDataInterval = this.i().getVisibleRange();
                bl = !ilvDataInterval.contains(ilvDataSet.getYRange(null));
                ilvCoordinateSystem = this.getCoordinateSystem();
                rectangle = this.getPlotRect();
                ilvChartProjector = this.getChart().getLocalProjector2D(rectangle, ilvCoordinateSystem);
                d4 = ilvDataSet.getUndefValue();
                d3 = d4 != null ? d4 : 0.0;
                d2 = this.getWidth() / 2.0;
                ilvStyle3 = this.getRiseStyle();
                ilvStyle2 = this.getFallStyle();
                if (this.getType() == 1 || this.getType() == 2) {
                    boolean bl2;
                    double d5 = ilvChartProjector.getAxisLength(rectangle, this.j());
                    boolean bl3 = bl2 = 2.0 * d5 * d2 / this.j().getVisibleRange().getLength() > (double)IlvSingleHiLoRenderer.getStrokeThreshold();
                    if (ilvStyle3.isFillOn() && !bl2) {
                        ilvStyle3 = ilvStyle3.setStrokeOn(false);
                    }
                    if (ilvStyle2.isFillOn() && !bl2) {
                        ilvStyle2 = ilvStyle2.setStrokeOn(false);
                    }
                }
                IlvStyle ilvStyle4 = null;
                ilvStyle = null;
                hiLoItem = new HiLoItem(32);
                if (!this.s()) break block14;
                int[] nArray = points.getIndices();
                IlvDisplayPoint ilvDisplayPoint = new IlvDisplayPoint(this, ilvDataSet);
                while (n2 < n3) {
                    block15: {
                        double d6;
                        double d7;
                        block17: {
                            block16: {
                                d7 = points.getYData(n2);
                                d6 = points.getYData(n2 + 1);
                                if (d4 != null && (d7 == d3 || d6 == d3) || Double.isNaN(d7) || Double.isNaN(d6)) break block15;
                                ilvDisplayPoint.dataSet = ilvDataSet;
                                if (d7 < d6) {
                                    ilvStyle4 = ilvStyle3;
                                    ilvDisplayPoint.set(nArray[n2], 0.0, 0.0);
                                } else {
                                    ilvStyle4 = ilvStyle2;
                                    ilvDisplayPoint.set(nArray[n2 + 1], 0.0, 0.0);
                                }
                                IlvDataRenderingHint ilvDataRenderingHint = this.b(ilvDisplayPoint);
                                if (ilvDataRenderingHint == null) break block16;
                                ilvStyle = ilvDataRenderingHint.getStyle(ilvDisplayPoint, ilvStyle4);
                                if (ilvStyle != null) break block17;
                                break block15;
                            }
                            ilvStyle = ilvStyle4;
                        }
                        if (bl) {
                            d7 = ilvDataInterval.clamp(d7);
                            d6 = ilvDataInterval.clamp(d6);
                        }
                        hiLoItem.a(points, n2, d7, d6, d2);
                        ilvChartProjector.toDisplay(hiLoItem, rectangle, ilvCoordinateSystem);
                        itemAction.processItem(points, n2, hiLoItem, ilvStyle);
                    }
                    n2 += 2;
                }
                break block18;
            }
            while (n2 < n3) {
                double d8 = points.getYData(n2);
                double d9 = points.getYData(n2 + 1);
                if ((d4 == null || d8 != d3 && d9 != d3) && !Double.isNaN(d8) && !Double.isNaN(d9)) {
                    IlvStyle ilvStyle5 = ilvStyle = d8 < d9 ? ilvStyle3 : ilvStyle2;
                    if (bl) {
                        d8 = ilvDataInterval.clamp(d8);
                        d9 = ilvDataInterval.clamp(d9);
                    }
                    hiLoItem.a(points, n2, d8, d9, d2);
                    ilvChartProjector.toDisplay(hiLoItem, rectangle, ilvCoordinateSystem);
                    itemAction.processItem(points, n2, hiLoItem, ilvStyle);
                }
                n2 += 2;
            }
        }
    }

    IlvDataWindow a(IlvDataWindow ilvDataWindow) {
        double d2 = this.getWidth() / 2.0;
        if (d2 > 0.0) {
            ilvDataWindow.xRange.expand(d2);
        }
        return ilvDataWindow;
    }

    public IlvDataInterval getXRange(IlvDataInterval ilvDataInterval) {
        IlvDataInterval ilvDataInterval2 = super.getXRange(ilvDataInterval);
        double d2 = this.getWidth() / 2.0;
        if (d2 > 0.0) {
            ilvDataInterval2.min -= d2;
            ilvDataInterval2.max += d2;
        }
        return ilvDataInterval2;
    }

    public void drawLegendSymbol(IlvLegendItem ilvLegendItem, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = Math.min(n4, n5);
        n2 += (n4 - n6) / 2;
        n3 += (n5 - n6) / 2;
        switch (this.d) {
            case 1: {
                this.getRiseStyle().renderRect(graphics, n2, (int)((double)n3 + 0.2 * (double)n5), n6, (int)((double)n5 * 0.4));
                this.getFallStyle().renderRect(graphics, n2, (int)((double)n3 + (double)n5 * 0.6 - 1.0), n6, (int)((double)n5 * 0.3));
                break;
            }
            case 3: {
                this.getLegendStyle().drawLine(graphics, n2, n3 + 2 * n6 / 3, n2 + n6 / 2, n3 + 2 * n6 / 3);
                this.getLegendStyle().drawLine(graphics, n2 + n6 / 2, n3 + n6 / 3, n2 + n6, n3 + n6 / 3);
                break;
            }
            case 2: {
                int[] nArray = new int[]{n2 + n6 / 4, n2 + n6 / 4, n2, n2 + n6 / 2, n2 + n6, n2 + 3 * n6 / 4, n2 + 3 * n6 / 4, n2 + n6 / 4};
                int[] nArray2 = new int[]{n3 + n6 / 2, n3 + n6 / 3, n3 + n6 / 3, n3, n3 + n6 / 3, n3 + n6 / 3, n3 + n6 / 2, n3 + n6 / 2};
                this.getRiseStyle().renderPoints(graphics, nArray, nArray2, 8);
                nArray = new int[]{n2 + n6 / 4, n2 + n6 / 4, n2, n2 + n6 / 2, n2 + n6, n2 + 3 * n6 / 4, n2 + 3 * n6 / 4, n2 + n6 / 4};
                nArray2 = new int[]{n3 + n6 / 2, n3 + 2 * n6 / 3, n3 + 2 * n6 / 3, n3 + n6, n3 + 2 * n6 / 3, n3 + 2 * n6 / 3, n3 + n6 / 2, n3 + n6 / 2};
                this.getFallStyle().renderPoints(graphics, nArray, nArray2, 8);
                break;
            }
            default: {
                this.getLegendStyle().drawLine(graphics, n2 + n6 / 2, n3, n2 + n6 / 2, n3 + n6);
            }
        }
    }

    class HiLoItem
    extends IlvSingleChartRenderer.DefaultItem {
        boolean a;

        HiLoItem(int n2) {
            super(n2);
            this.a = IlvSingleHiLoRenderer.this.getChart().getType() == 1 && IlvSingleHiLoRenderer.this.getType() == 1;
        }

        public void draw(Graphics graphics, IlvStyle ilvStyle) {
            if (IlvSingleHiLoRenderer.this.getType() == 3) {
                ilvStyle.drawLine(graphics, this.getX(0), this.getY(0), this.getX(1), this.getY(1));
                ilvStyle.drawLine(graphics, this.getX(2), this.getY(2), this.getX(3), this.getY(3));
            } else if (this.a) {
                ilvStyle.renderRect(graphics, this.getX(0), this.getY(0), this.getX(1), this.getY(1));
            } else {
                super.draw(graphics, ilvStyle);
            }
        }

        public boolean contains(IlvStyle ilvStyle, double d2, double d3) {
            if (this.a) {
                return this.getBounds(ilvStyle, null).contains(d2, d3);
            }
            return super.contains(ilvStyle, d2, d3);
        }

        void a(IlvSingleChartRenderer.Points points, int n2, double d2, double d3, double d4) {
            double d5 = IlvSingleHiLoRenderer.this.getXShift();
            if (this.a) {
                this.set(0, points.getXData(n2) + d5 - d4, d2);
                this.set(1, points.getXData(n2 + 1) + d5 + d4, d3);
                this.setSize(2);
            } else {
                double[] dArray = this.getXValues();
                double[] dArray2 = this.getYValues();
                int n3 = 0;
                double d6 = points.getXData(n2);
                double d7 = points.getXData(n2 + 1);
                if (d5 != 0.0) {
                    d6 += d5;
                    d7 += d5;
                }
                if (IlvSingleHiLoRenderer.this.getType() == 1) {
                    dArray[0] = d6 - d4;
                    dArray2[0] = d2;
                    dArray[1] = d7 - d4;
                    dArray2[1] = d3;
                    dArray[2] = d7 + d4;
                    dArray2[2] = dArray2[1];
                    dArray[3] = d6 + d4;
                    dArray2[3] = dArray2[0];
                    dArray[4] = dArray[0];
                    dArray2[4] = dArray2[0];
                    n3 = 5;
                } else if (IlvSingleHiLoRenderer.this.getType() == 0) {
                    dArray[0] = d6;
                    dArray2[0] = d2;
                    dArray[1] = d7;
                    dArray2[1] = d3;
                    n3 = 2;
                } else if (IlvSingleHiLoRenderer.this.getType() == 3) {
                    dArray[0] = d6 - d4;
                    dArray2[0] = d2;
                    dArray[1] = d6;
                    dArray2[1] = d2;
                    dArray[2] = d7;
                    dArray2[2] = d3;
                    dArray[3] = d7 + d4;
                    dArray2[3] = d3;
                    n3 = 4;
                } else if (IlvSingleHiLoRenderer.this.getType() == 2) {
                    double d8 = d3 - d2;
                    dArray[0] = d6 - d4 / 2.0;
                    dArray2[0] = d2;
                    dArray[1] = d7 - d4 / 2.0;
                    dArray2[1] = d2 + d8 * 0.8;
                    dArray[2] = dArray[1] - d4 / 2.0;
                    dArray2[2] = dArray2[1];
                    dArray[3] = dArray[1] + d4 / 2.0;
                    dArray2[3] = d3;
                    dArray[4] = d6 + d4;
                    dArray2[4] = dArray2[2];
                    dArray[5] = d6 + d4 / 2.0;
                    dArray2[5] = dArray2[4];
                    dArray[6] = dArray[5];
                    dArray2[6] = dArray2[0];
                    dArray[7] = dArray[0];
                    dArray2[7] = dArray2[0];
                    n3 = 8;
                }
                this.setSize(n3);
            }
        }

        public IlvIMapArea getMapArea(IlvIMapDefinition ilvIMapDefinition, IlvStyle ilvStyle, IlvIMapAttributes ilvIMapAttributes) {
            if (this.a) {
                Rectangle rectangle = this.getBounds(ilvStyle, null).getBounds();
                if (ilvIMapDefinition.isChartOrigin()) {
                    Rectangle rectangle2 = IlvSingleHiLoRenderer.this.m();
                    if (rectangle2.x != 0 || rectangle2.y != 0) {
                        rectangle.translate(rectangle2.x, rectangle2.y);
                    }
                }
                return new IlvIMapArea(rectangle, ilvIMapAttributes);
            }
            return super.getMapArea(ilvIMapDefinition, ilvStyle, ilvIMapAttributes);
        }
    }
}

