/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.util;

import ilog.views.chart.IlvStyle;
import ilog.views.chart.graphic.IlvMarker;
import ilog.views.chart.graphic.IlvMarkerFactory;
import ilog.views.util.IlvColorUtil;
import ilog.views.util.java2d.internal.IlvStrokeUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;

public class IlvSelectionUtil {
    private static final Stroke a = new BasicStroke(2.0f, 0, 2, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
    private static final Stroke b = new BasicStroke(1.0f, 0, 2);
    private static final Stroke c = new BasicStroke(7.0f);
    private static IlvStyle d = new IlvStyle(b, IlvColorUtil.darker(Color.red), Color.red);
    private static IlvStyle e = new IlvStyle(a, (Paint)Color.red);
    private static IlvMarker f = IlvMarkerFactory.getSquareMarker();
    private static int g = 3;

    public static void setSelectionStyle(IlvStyle ilvStyle) {
        if (ilvStyle == null) {
            throw new IllegalArgumentException("selection style cannot be null.");
        }
        e = ilvStyle;
        d = ilvStyle.setFillOn(true).setStroke(b);
    }

    public static IlvStyle getHandleStyle() {
        return d;
    }

    public static IlvStyle getSelectionStyle() {
        return e;
    }

    public static IlvMarker getHandleMarker() {
        return f;
    }

    public static void setHandleMarker(IlvMarker ilvMarker) {
        if (ilvMarker == null) {
            throw new IllegalArgumentException("selection marker cannot be null.");
        }
        f = ilvMarker;
    }

    public static int getHandleSize() {
        return g;
    }

    public static void setHandleSize(int n2) {
        g = n2;
    }

    public static void drawSelectionHandle(Graphics graphics, int n2, int n3) {
        f.draw(graphics, n2, n3, g, d);
    }

    public static void drawGenericSelection(Graphics graphics, Rectangle rectangle) {
        IlvSelectionUtil.drawGenericSelection(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void drawGenericSelection(Graphics graphics, int n2, int n3, int n4, int n5) {
        IlvSelectionUtil.getSelectionStyle().renderRect(graphics, n2, n3, n4, n5);
        IlvSelectionUtil.drawSelectionHandle(graphics, n2, n3);
        IlvSelectionUtil.drawSelectionHandle(graphics, n2 + n4, n3);
        IlvSelectionUtil.drawSelectionHandle(graphics, n2, n3 + n5);
        IlvSelectionUtil.drawSelectionHandle(graphics, n2 + n4, n3 + n5);
    }

    public static Shape getStrokedShape(Shape shape, IlvStyle ilvStyle) {
        float f2;
        Stroke stroke = ilvStyle.getStroke();
        Stroke stroke2 = stroke == null ? c : ((f2 = IlvStrokeUtil.getWidth(stroke, null)) > 1.0f ? stroke : c);
        return stroke2.createStrokedShape(shape);
    }
}

