/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.view3d;

import java.io.Serializable;

public final class Ilv3DVector
implements Serializable {
    static final Ilv3DVector a = new Ilv3DVector(1.0, 0.0, 0.0);
    static final Ilv3DVector b = new Ilv3DVector(0.0, 1.0, 0.0);
    static final Ilv3DVector c = new Ilv3DVector(0.0, 0.0, 1.0);
    public double x;
    public double y;
    public double z;

    public Ilv3DVector() {
        this(0.0, 0.0, 0.0);
    }

    public Ilv3DVector(Ilv3DVector ilv3DVector) {
        this(ilv3DVector.x, ilv3DVector.y, ilv3DVector.z);
    }

    public Ilv3DVector(double d2, double d3, double d4) {
        this.set(d2, d3, d4);
    }

    public Ilv3DVector copy() {
        return new Ilv3DVector(this);
    }

    public void set(double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
    }

    public void set(Ilv3DVector ilv3DVector) {
        this.set(ilv3DVector.x, ilv3DVector.y, ilv3DVector.z);
    }

    public void cross(Ilv3DVector ilv3DVector) {
        double d2 = this.x;
        double d3 = this.y;
        double d4 = this.z;
        double d5 = ilv3DVector.x;
        double d6 = ilv3DVector.y;
        double d7 = ilv3DVector.z;
        this.x = d3 * d7 - d4 * d6;
        this.y = d4 * d5 - d2 * d7;
        this.z = d2 * d6 - d3 * d5;
    }

    public Ilv3DVector cross(Ilv3DVector ilv3DVector, Ilv3DVector ilv3DVector2) {
        if (ilv3DVector2 == null) {
            ilv3DVector2 = new Ilv3DVector(this);
        } else if (ilv3DVector2 != this) {
            ilv3DVector2.set(this);
        }
        ilv3DVector2.cross(ilv3DVector);
        return ilv3DVector2;
    }

    public double dot(Ilv3DVector ilv3DVector) {
        return this.x * ilv3DVector.x + this.y * ilv3DVector.y + this.z * ilv3DVector.z;
    }

    public boolean isCollinear(Ilv3DVector ilv3DVector) {
        return this.y * ilv3DVector.z == this.z * ilv3DVector.y && this.z * ilv3DVector.x == this.x * ilv3DVector.z && this.x * ilv3DVector.y == this.y * ilv3DVector.x;
    }

    public Ilv3DVector normalize() {
        double d2 = this.length();
        if (d2 > 0.0) {
            this.x /= d2;
            this.y /= d2;
            this.z /= d2;
        }
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Ilv3DVector)) {
            return false;
        }
        Ilv3DVector ilv3DVector = (Ilv3DVector)object;
        return this.x == ilv3DVector.x && this.y == ilv3DVector.y && this.z == ilv3DVector.z;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void scale(double d2) {
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
    }

    public void add(Ilv3DVector ilv3DVector) {
        this.x += ilv3DVector.x;
        this.y += ilv3DVector.y;
        this.z += ilv3DVector.z;
    }

    public void sub(Ilv3DVector ilv3DVector) {
        this.x -= ilv3DVector.x;
        this.y -= ilv3DVector.y;
        this.z -= ilv3DVector.z;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

