/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.dxf;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.dxf.DXFBulgeUtil;
import ilog.views.dxf.DXFElement;
import ilog.views.dxf.DXFGroup;
import ilog.views.dxf.IlvDXFGraphicFactory;
import ilog.views.dxf.IlvDXFReaderConfigurator;
import ilog.views.graphic.IlvPolyline;
import ilog.views.graphic.IlvText;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;

public class IlvDXFReader {
    private IlvDXFReaderConfigurator a;
    private IlvGraphicBag b;
    private IlvManager c;
    private IlvDXFGraphicFactory d;
    private BufferedReader e;
    private IlvTransformer f;
    private IlvPoint g = new IlvPoint();
    private IlvPoint h = new IlvPoint();
    private boolean i;
    private DXFGroup j;
    private boolean k;
    private int l;
    private ArrayList m;
    private LinkedHashMap n;
    private HashMap o;
    private ArrayList p;
    private ArrayList q;
    private ArrayList r;
    private Color s;
    private float t;
    private boolean u;
    private DXFElement v;
    private short w;
    private boolean x = false;
    private ArrayList y;
    private HashMap z;
    private Color[] aa;
    private boolean ab = true;
    private static final String ac = "AutoCAD Binary DXF\r\n\u001a";
    private static final String ad = "Monospaced";
    private static final Font ae = new Font("Monospaced", 0, 12);

    public IlvDXFReader() {
        this(new IlvDXFReaderConfigurator());
    }

    public IlvDXFReader(IlvDXFReaderConfigurator ilvDXFReaderConfigurator) {
        this.a = ilvDXFReaderConfigurator;
    }

    public final IlvDXFReaderConfigurator getConfigurator() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(URL uRL, IlvGraphicBag ilvGraphicBag) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            this.read(inputStream, ilvGraphicBag);
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String string, IlvGraphicBag ilvGraphicBag) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            this.read(fileInputStream, ilvGraphicBag);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream inputStream, IlvGraphicBag ilvGraphicBag) throws IOException {
        block7: {
            if (inputStream == null) {
                throw new IllegalArgumentException("dxfStream cannot be null");
            }
            if (ilvGraphicBag == null) {
                throw new IllegalArgumentException("bag cannot be null");
            }
            this.d = this.getConfigurator().getGraphicFactory();
            this.b = ilvGraphicBag;
            this.c = ilvGraphicBag instanceof IlvManager ? (IlvManager)ilvGraphicBag : null;
            DXFGroup dXFGroup = new DXFGroup();
            dXFGroup.a(0, "POLYLINE");
            this.v = new DXFElement(dXFGroup);
            try {
                this.a(inputStream);
                this.a();
                while (true) {
                    this.l();
                    if (this.j.b(0, "EOF")) {
                        break block7;
                    }
                    if (!this.j.b(0, "SECTION")) break;
                    this.c();
                }
                throw new IOException("Bad group code " + this.j.b() + " at offset " + this.l + ". Should be [0 - SECTION]");
            }
            finally {
                this.b = null;
                this.c = null;
                this.d = null;
            }
        }
    }

    private void a(InputStream inputStream) {
        this.e = new BufferedReader(new InputStreamReader(inputStream));
        this.f = new IlvTransformer(1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
        this.ab = true;
        this.g.move(0.0f, 0.0f);
        this.h.move(0.0f, 0.0f);
        this.i = false;
        this.j = new DXFGroup();
        this.k = false;
        this.l = 0;
        this.m = null;
        this.n = null;
        this.o = null;
        this.p = null;
        this.q = new ArrayList();
        this.r = new ArrayList();
        this.u = false;
        this.y = null;
        this.z = new HashMap();
    }

    private void a() throws IOException {
        int n2;
        int n3 = ac.length();
        this.e.mark(n3 + 10);
        try {
            char[] cArray = new char[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                cArray[n2] = (char)this.e.read();
                if (ac.charAt(n2) == cArray[n2]) {
                    continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            n2 = 0;
        }
        if (n2 == n3) {
            this.i = true;
            this.l = n3;
            this.e.read();
        } else {
            this.e.reset();
        }
    }

    private static boolean a(char c2) {
        return c2 == ' ' || c2 == '\t';
    }

    private void b() {
        IlvRect ilvRect = this.getConfigurator().getExtents();
        if (ilvRect == null) {
            return;
        }
        if (ilvRect.width == 0.0f || ilvRect.height == 0.0f) {
            throw new IllegalArgumentException("Cannot set empty rectangle");
        }
        float f2 = ilvRect.width / (this.h.x - this.g.x);
        float f3 = ilvRect.height / (this.h.y - this.g.y);
        if (this.getConfigurator().isKeepAspectRatio() && f2 < f3) {
            f3 = f2;
        }
        float f4 = ilvRect.x - f2 * this.g.x;
        float f5 = ilvRect.y + ilvRect.height + f3 * this.g.y;
        this.f.setValues(f2, 0.0, 0.0, -f3, f4, f5);
        this.ab = false;
    }

    private IlvPoint a(float f2, float f3) {
        if (this.ab) {
            return new IlvPoint(f2, -f3);
        }
        IlvPoint ilvPoint = new IlvPoint(f2, f3);
        this.f.apply(ilvPoint);
        return ilvPoint;
    }

    private void a(IlvPoint[] ilvPointArray) {
        int n2 = ilvPointArray != null ? ilvPointArray.length : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a(ilvPointArray[i2]);
        }
    }

    private IlvPoint a(IlvPoint ilvPoint) {
        if (ilvPoint == null) {
            return null;
        }
        if (this.ab) {
            ilvPoint.y = -ilvPoint.y;
        } else {
            this.f.apply(ilvPoint);
        }
        return ilvPoint;
    }

    private double a(double d2) {
        return this.ab ? d2 : d2 * this.f.zoomFactor();
    }

    private void c() throws IOException {
        while (true) {
            this.l();
            if (this.j.b(0, "ENDSEC")) {
                return;
            }
            if (this.j.b(2, "HEADER")) {
                this.d();
                this.b();
            }
            if (this.j.b(2, "TABLES")) {
                this.e();
            }
            if (this.j.b(2, "BLOCKS")) {
                this.i();
            }
            if (!this.j.b(2, "ENTITIES")) continue;
            this.a(false);
        }
    }

    private void d() throws IOException {
        block0: do {
            this.l();
            if (this.j.b(9, "$ANGBASE")) {
                this.l();
                continue;
            }
            if (this.j.b(9, "$ANGDIR")) {
                this.l();
                continue;
            }
            if (this.j.b(9, "$EXTMIN")) {
                while (true) {
                    this.l();
                    if (this.j.b() == 9 || this.j.b() == 0) {
                        this.k();
                        continue block0;
                    }
                    if (this.j.b() == 10) {
                        this.g.x = (float)this.j.d();
                    }
                    if (this.j.b() != 20) continue;
                    this.g.y = (float)this.j.d();
                }
            }
            if (!this.j.b(9, "$EXTMAX")) continue;
            while (true) {
                this.l();
                if (this.j.b() == 9 || this.j.b() == 0) {
                    this.k();
                    continue block0;
                }
                if (this.j.b() == 10) {
                    this.h.x = (float)this.j.d();
                }
                if (this.j.b() != 20) continue;
                this.h.y = (float)this.j.d();
            }
        } while (!this.j.b(0, "ENDSEC"));
        this.k();
    }

    private void e() throws IOException {
        do {
            this.l();
            if (!this.j.b(0, "TABLE")) continue;
            this.l();
            if (this.j.b() != 2) {
                throw new IOException("Should be a 2 group at line/byte " + this.l);
            }
            this.a(this.j.e());
        } while (!this.j.b(0, "ENDSEC"));
        this.k();
        this.f();
    }

    private void a(String string) throws IOException {
        while (true) {
            this.l();
            if (this.j.b(0, "LTYPE")) {
                this.g();
                continue;
            }
            if (this.j.b(0, "LAYER")) {
                this.h();
                continue;
            }
            if (this.j.b(0, "ENDTAB")) break;
        }
        this.k();
    }

    private void f() {
        int n2;
        Set set;
        if (this.c == null) {
            return;
        }
        Set set2 = set = this.n != null ? this.n.keySet() : null;
        if (set == null) {
            return;
        }
        Object[] objectArray = set.toArray();
        int n3 = n2 = objectArray != null ? objectArray.length : 0;
        if (n2 == 0) {
            return;
        }
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            String string = (String)objectArray[i2];
            this.b(string);
        }
    }

    private int b(String string) {
        IlvManagerLayer ilvManagerLayer = this.d.prepareLayer(this.c, string);
        if (!this.a.isQuadTreeEnabled()) {
            ilvManagerLayer.setQuadtreeEnabled(false);
        }
        int n2 = ilvManagerLayer.getIndex();
        this.z.put(string, new Integer(n2));
        return n2;
    }

    private void g() throws IOException {
        DXFElement dXFElement = new DXFElement(new DXFGroup(this.j));
        if (this.m == null) {
            this.m = new ArrayList(10);
        }
        this.m.add(dXFElement);
        while (true) {
            this.l();
            if (this.j.b() == 0) {
                this.k();
                return;
            }
            dXFElement.a(this.j);
        }
    }

    private void h() throws IOException {
        DXFElement dXFElement = new DXFElement(new DXFGroup(this.j));
        if (this.n == null) {
            this.n = new LinkedHashMap();
        }
        while (true) {
            this.l();
            if (this.j.b() == 0) break;
            dXFElement.a(this.j);
        }
        this.k();
        DXFGroup dXFGroup = dXFElement.a(2);
        if (dXFGroup != null) {
            Object object = dXFGroup.f();
            this.n.put(object, dXFElement);
        }
    }

    private void i() throws IOException {
        while (true) {
            this.l();
            if (this.j.b(0, "BLOCK")) {
                this.l();
                this.j();
                continue;
            }
            if (this.j.b(0, "ENDSEC")) break;
        }
    }

    private void j() throws IOException {
        DXFElement dXFElement = new DXFElement(new DXFGroup(this.j));
        if (this.o == null) {
            this.o = new HashMap();
        }
        while (true) {
            this.l();
            if (this.j.b(0, "ENDBLK")) break;
            if (this.j.b() == 0) {
                this.k();
                try {
                    this.a(true);
                    dXFElement.a(this.p);
                    this.p = null;
                }
                catch (IOException iOException) {}
                continue;
            }
            dXFElement.a(this.j);
        }
        DXFGroup dXFGroup = dXFElement.a(2);
        if (dXFGroup != null) {
            this.o.put(dXFGroup.f(), dXFElement);
        }
    }

    private void a(boolean bl) throws IOException {
        DXFElement dXFElement = null;
        this.b(true);
        try {
            while (true) {
                this.a(dXFElement);
                if (this.j.b() == 0) {
                    Object object;
                    if (dXFElement != null) {
                        if (bl) {
                            if (this.p == null) {
                                this.p = new ArrayList(100);
                            }
                            this.p.add(dXFElement);
                        } else {
                            object = this.c(dXFElement);
                            if (object != null) {
                                if (this.u) {
                                    this.a((IlvGraphic)object, this.b(this.v));
                                    this.u = false;
                                } else {
                                    this.a((IlvGraphic)object, this.b(dXFElement));
                                }
                            }
                        }
                    }
                    if (this.j.b(0, "ENDBLK") || this.j.b(0, "ENDSEC")) {
                        this.k();
                        return;
                    }
                    if (!bl && dXFElement != null) {
                        dXFElement.a();
                        dXFElement.a(this.j);
                    } else {
                        dXFElement = new DXFElement(new DXFGroup(this.j));
                    }
                    object = this.j.e();
                    if (((String)object).equalsIgnoreCase("LWPOLYLINE")) {
                        dXFElement.f();
                        continue;
                    }
                    if (((String)object).equalsIgnoreCase("SPLINE")) {
                        dXFElement.g();
                        continue;
                    }
                    dXFElement.h();
                    continue;
                }
                if (dXFElement == null) {
                    throw new IOException("Group 0 in entities expected at line/byte %ld" + this.l);
                }
                dXFElement.a(this.j);
            }
        }
        finally {
            this.b(false);
        }
    }

    private void b(boolean bl) {
        if (this.c != null) {
            this.c.setContentsAdjusting(bl);
        }
    }

    private void a(IlvGraphic ilvGraphic, int n2) {
        if (this.c != null) {
            this.d.addObject(ilvGraphic, this.c, n2);
        } else {
            this.d.addObject(ilvGraphic, this.b);
        }
    }

    private void k() {
        this.k = true;
    }

    private void l() throws IOException {
        this.a((DXFElement)null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(DXFElement dXFElement) throws IOException {
        int n2;
        int n3;
        String string;
        if (this.k) {
            this.k = false;
            return;
        }
        this.j.a();
        if (this.i) {
            int n4 = this.e.read();
            ++this.l;
            if (n4 < 0) {
                throw new IOException();
            }
            if (n4 < 10 || n4 >= 1000 && n4 < 1010) {
                int n5;
                StringBuffer stringBuffer = new StringBuffer(10);
                while ((n5 = this.e.read()) != 0) {
                    stringBuffer.append((char)n5);
                }
                String string2 = stringBuffer.toString();
                int n6 = string2.lastIndexOf(13, string2.length());
                if (n6 != -1) {
                    string2 = string2.substring(0, n6);
                }
                this.j.a(n4, string2);
                this.l += string2.length() + 1;
                return;
            } else if (n4 >= 10 && n4 < 60 || n4 >= 140 && n4 < 148 || n4 >= 210 && n4 < 240 || n4 >= 1010 && n4 < 1060) {
                int n7 = this.e.read();
                int n8 = this.e.read();
                int n9 = this.e.read();
                int n10 = this.e.read();
                int n11 = this.e.read();
                int n12 = this.e.read();
                int n13 = this.e.read();
                int n14 = this.e.read();
                long l2 = ((long)n14 << 56) + ((long)n13 << 48) + ((long)n12 << 40) + ((long)n11 << 32) + ((long)n10 << 24) + ((long)n9 << 16) + ((long)n8 << 8) + (long)n7;
                this.j.a(n4, Double.longBitsToDouble(l2));
                this.l += 8;
                return;
            } else {
                if (!(n4 >= 60 && n4 < 80 || n4 >= 170 && n4 < 176)) {
                    if (n4 < 1060) return;
                    if (n4 >= 1080) return;
                }
                int n15 = this.e.read();
                int n16 = this.e.read();
                short s2 = (short)((n16 << 8) + n15);
                this.j.a(n4, s2);
                this.l += 2;
            }
            return;
        }
        do {
            int n17;
            string = this.e.readLine();
            ++this.l;
            if (string == null) {
                throw new EOFException();
            }
            n3 = string.length();
            for (n2 = 0; n2 < n3 && IlvDXFReader.a(string.charAt(n2)); ++n2) {
            }
            for (n17 = n3 - 1; n17 >= 0 && IlvDXFReader.a(string.charAt(n17)); --n17) {
            }
            if (n2 <= n17) {
                if (n2 == 0 && n17 == n3 - 1) continue;
                string = string.substring(n2, n17 + 1);
                continue;
            }
            string = null;
        } while (string == null);
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("number expected instead of " + string);
        }
        string = this.e.readLine();
        if (string == null) {
            throw new EOFException();
        }
        ++this.l;
        if (n3 == 999) {
            this.l();
            return;
        }
        if (n3 < 0) {
            throw new IOException("bad code for group");
        }
        if (n3 < 10 || n3 == 100 || n3 == 102 || n3 >= 410 && n3 < 420 || n3 >= 1000 && n3 < 1010) {
            this.j.a(n3, string);
            return;
        }
        if (n3 >= 10 && n3 < 60 || n3 >= 110 && n3 < 140 || n3 >= 210 && n3 < 240 || n3 >= 460 && n3 < 470 || n3 >= 1010 && n3 < 1060) {
            try {
                string = string.trim();
                double d2 = Double.valueOf(string);
                boolean bl = false;
                if (dXFElement != null) {
                    if (dXFElement.d()) {
                        if (n3 == 10) {
                            dXFElement.a(d2);
                            return;
                        }
                        if (n3 == 20) {
                            dXFElement.b(d2);
                            return;
                        }
                        if (n3 == 42) {
                            dXFElement.g(d2);
                            return;
                        }
                    } else if (dXFElement.e()) {
                        if (n3 == 10) {
                            dXFElement.c(d2);
                            return;
                        }
                        if (n3 == 20) {
                            dXFElement.d(d2);
                            return;
                        }
                        if (n3 == 11) {
                            dXFElement.e(d2);
                            return;
                        }
                        if (n3 == 21) {
                            dXFElement.f(d2);
                            return;
                        }
                    }
                }
                if (bl) return;
                this.j.a(n3, d2);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("invalid format double expected in group " + string);
            }
        }
        if (n3 == 90) {
            string = string.trim();
            n2 = Integer.valueOf(string);
            if (dXFElement == null) return;
            if (!dXFElement.d()) return;
            dXFElement.b(n2);
            return;
        }
        if (!(n3 >= 60 && n3 < 80 || n3 >= 170 && n3 < 180 || n3 >= 270 && n3 < 290 || n3 >= 370 && n3 < 390 || n3 >= 400 && n3 < 410)) {
            if (n3 < 1060) return;
            if (n3 >= 1080) return;
        }
        try {
            string = string.trim();
            n2 = Short.valueOf(string).shortValue();
            if (dXFElement != null && dXFElement.e()) {
                switch (n3) {
                    case 73: {
                        dXFElement.c(n2);
                        break;
                    }
                    case 74: {
                        dXFElement.d(n2);
                    }
                }
            }
            this.j.a(n3, (short)n2);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("invalid format short expected in group " + string);
        }
    }

    private Color a(int n2) {
        return this.m()[n2 & 0xFF];
    }

    private Color[] m() {
        if (this.aa == null) {
            boolean bl = this.a.isInvertBlackAndWhite();
            this.aa = new Color[256];
            this.aa[1] = Color.red;
            this.aa[2] = Color.yellow;
            this.aa[3] = Color.green;
            this.aa[4] = Color.cyan;
            this.aa[5] = Color.blue;
            this.aa[6] = Color.magenta;
            this.aa[8] = Color.gray;
            this.aa[9] = Color.lightGray;
            if (bl) {
                this.aa[0] = Color.white;
                this.aa[7] = Color.white;
            } else {
                this.aa[0] = Color.black;
                this.aa[7] = Color.black;
            }
            this.aa[10] = new Color(255, 0, 0);
            this.aa[11] = new Color(255, 128, 128);
            this.aa[12] = new Color(166, 0, 0);
            this.aa[13] = new Color(166, 83, 83);
            this.aa[14] = new Color(128, 0, 0);
            this.aa[15] = new Color(128, 64, 64);
            this.aa[16] = new Color(77, 0, 0);
            this.aa[17] = new Color(77, 38, 38);
            this.aa[18] = new Color(38, 0, 0);
            this.aa[19] = new Color(38, 19, 19);
            this.aa[20] = new Color(255, 64, 0);
            this.aa[21] = new Color(255, 160, 128);
            this.aa[22] = new Color(166, 42, 0);
            this.aa[23] = new Color(166, 104, 83);
            this.aa[24] = new Color(128, 32, 0);
            this.aa[25] = new Color(128, 80, 64);
            this.aa[26] = new Color(77, 19, 0);
            this.aa[27] = new Color(77, 48, 38);
            this.aa[28] = new Color(38, 10, 0);
            this.aa[29] = new Color(38, 24, 19);
            this.aa[30] = new Color(255, 128, 0);
            this.aa[31] = new Color(255, 192, 0);
            this.aa[32] = new Color(166, 83, 0);
            this.aa[33] = new Color(166, 125, 83);
            this.aa[34] = new Color(128, 64, 0);
            this.aa[35] = new Color(128, 96, 64);
            this.aa[36] = new Color(77, 38, 0);
            this.aa[37] = new Color(77, 58, 38);
            this.aa[38] = new Color(38, 19, 0);
            this.aa[39] = new Color(38, 29, 19);
            this.aa[40] = new Color(255, 192, 0);
            this.aa[41] = new Color(255, 224, 128);
            this.aa[42] = new Color(166, 125, 0);
            this.aa[43] = new Color(166, 146, 83);
            this.aa[44] = new Color(128, 96, 0);
            this.aa[45] = new Color(128, 112, 64);
            this.aa[46] = new Color(77, 58, 0);
            this.aa[47] = new Color(77, 67, 38);
            this.aa[48] = new Color(38, 29, 0);
            this.aa[49] = new Color(38, 34, 19);
            this.aa[50] = new Color(255, 255, 0);
            this.aa[51] = new Color(255, 255, 128);
            this.aa[52] = new Color(166, 166, 0);
            this.aa[53] = new Color(166, 166, 83);
            this.aa[54] = new Color(128, 128, 0);
            this.aa[55] = new Color(128, 128, 64);
            this.aa[56] = new Color(77, 77, 0);
            this.aa[57] = new Color(77, 77, 38);
            this.aa[58] = new Color(38, 38, 0);
            this.aa[59] = new Color(38, 38, 19);
            this.aa[60] = new Color(192, 255, 0);
            this.aa[61] = new Color(224, 255, 128);
            this.aa[62] = new Color(125, 166, 0);
            this.aa[63] = new Color(146, 166, 83);
            this.aa[64] = new Color(96, 128, 0);
            this.aa[65] = new Color(112, 128, 64);
            this.aa[66] = new Color(58, 77, 0);
            this.aa[67] = new Color(67, 77, 38);
            this.aa[68] = new Color(29, 38, 0);
            this.aa[69] = new Color(34, 38, 19);
            this.aa[70] = new Color(128, 255, 0);
            this.aa[71] = new Color(192, 255, 128);
            this.aa[72] = new Color(83, 166, 0);
            this.aa[73] = new Color(125, 166, 83);
            this.aa[74] = new Color(64, 128, 0);
            this.aa[75] = new Color(96, 128, 64);
            this.aa[76] = new Color(38, 77, 0);
            this.aa[77] = new Color(58, 77, 38);
            this.aa[78] = new Color(19, 38, 0);
            this.aa[79] = new Color(29, 38, 19);
            this.aa[80] = new Color(64, 255, 0);
            this.aa[81] = new Color(160, 255, 128);
            this.aa[82] = new Color(42, 160, 0);
            this.aa[83] = new Color(104, 160, 80);
            this.aa[84] = new Color(32, 128, 0);
            this.aa[85] = new Color(80, 128, 64);
            this.aa[86] = new Color(19, 77, 0);
            this.aa[87] = new Color(48, 77, 38);
            this.aa[88] = new Color(10, 38, 0);
            this.aa[89] = new Color(24, 38, 19);
            this.aa[90] = new Color(0, 255, 0);
            this.aa[91] = new Color(128, 255, 128);
            this.aa[92] = new Color(0, 166, 0);
            this.aa[93] = new Color(83, 166, 83);
            this.aa[94] = new Color(0, 128, 0);
            this.aa[95] = new Color(64, 128, 64);
            this.aa[96] = new Color(0, 77, 0);
            this.aa[97] = new Color(38, 77, 38);
            this.aa[98] = new Color(0, 38, 0);
            this.aa[99] = new Color(19, 38, 19);
            this.aa[100] = new Color(0, 255, 64);
            this.aa[101] = new Color(128, 255, 160);
            this.aa[102] = new Color(0, 166, 42);
            this.aa[103] = new Color(83, 166, 118);
            this.aa[104] = new Color(0, 128, 32);
            this.aa[105] = new Color(64, 128, 80);
            this.aa[106] = new Color(0, 77, 19);
            this.aa[107] = new Color(38, 77, 48);
            this.aa[108] = new Color(0, 38, 10);
            this.aa[109] = new Color(19, 38, 24);
            this.aa[110] = new Color(0, 255, 128);
            this.aa[111] = new Color(128, 255, 192);
            this.aa[112] = new Color(0, 166, 83);
            this.aa[113] = new Color(83, 166, 125);
            this.aa[114] = new Color(0, 128, 64);
            this.aa[115] = new Color(64, 128, 96);
            this.aa[116] = new Color(0, 77, 38);
            this.aa[117] = new Color(38, 77, 58);
            this.aa[118] = new Color(0, 38, 19);
            this.aa[119] = new Color(19, 38, 29);
            this.aa[120] = new Color(0, 255, 192);
            this.aa[121] = new Color(128, 255, 224);
            this.aa[122] = new Color(0, 166, 125);
            this.aa[123] = new Color(83, 166, 146);
            this.aa[124] = new Color(0, 128, 96);
            this.aa[125] = new Color(64, 128, 112);
            this.aa[126] = new Color(0, 77, 58);
            this.aa[127] = new Color(38, 77, 67);
            this.aa[128] = new Color(0, 38, 29);
            this.aa[129] = new Color(19, 38, 34);
            this.aa[130] = new Color(0, 255, 255);
            this.aa[131] = new Color(128, 255, 255);
            this.aa[132] = new Color(0, 166, 166);
            this.aa[133] = new Color(83, 166, 166);
            this.aa[134] = new Color(0, 128, 128);
            this.aa[135] = new Color(64, 128, 128);
            this.aa[136] = new Color(0, 77, 77);
            this.aa[137] = new Color(38, 77, 77);
            this.aa[138] = new Color(0, 38, 38);
            this.aa[139] = new Color(19, 38, 38);
            this.aa[140] = new Color(0, 192, 255);
            this.aa[141] = new Color(128, 224, 255);
            this.aa[142] = new Color(0, 125, 166);
            this.aa[143] = new Color(83, 146, 166);
            this.aa[144] = new Color(0, 96, 128);
            this.aa[145] = new Color(64, 112, 128);
            this.aa[146] = new Color(0, 58, 77);
            this.aa[147] = new Color(38, 67, 77);
            this.aa[148] = new Color(0, 29, 38);
            this.aa[149] = new Color(19, 34, 38);
            this.aa[150] = new Color(0, 128, 255);
            this.aa[151] = new Color(128, 192, 255);
            this.aa[152] = new Color(0, 83, 166);
            this.aa[153] = new Color(83, 125, 166);
            this.aa[154] = new Color(0, 64, 128);
            this.aa[155] = new Color(64, 96, 128);
            this.aa[156] = new Color(0, 38, 77);
            this.aa[157] = new Color(38, 58, 77);
            this.aa[158] = new Color(0, 19, 38);
            this.aa[159] = new Color(19, 29, 38);
            this.aa[160] = new Color(0, 64, 255);
            this.aa[161] = new Color(128, 160, 255);
            this.aa[162] = new Color(0, 42, 166);
            this.aa[163] = new Color(83, 104, 166);
            this.aa[164] = new Color(0, 32, 128);
            this.aa[165] = new Color(64, 80, 128);
            this.aa[166] = new Color(0, 19, 77);
            this.aa[167] = new Color(38, 48, 77);
            this.aa[168] = new Color(0, 10, 38);
            this.aa[169] = new Color(19, 24, 38);
            this.aa[170] = new Color(0, 0, 255);
            this.aa[171] = new Color(128, 128, 255);
            this.aa[172] = new Color(0, 0, 166);
            this.aa[173] = new Color(83, 83, 166);
            this.aa[174] = new Color(0, 0, 128);
            this.aa[175] = new Color(64, 64, 128);
            this.aa[176] = new Color(0, 0, 77);
            this.aa[177] = new Color(38, 38, 77);
            this.aa[178] = new Color(0, 0, 38);
            this.aa[179] = new Color(19, 19, 38);
            this.aa[180] = new Color(64, 0, 255);
            this.aa[181] = new Color(160, 128, 255);
            this.aa[182] = new Color(42, 0, 166);
            this.aa[183] = new Color(104, 83, 166);
            this.aa[184] = new Color(32, 0, 128);
            this.aa[185] = new Color(80, 64, 128);
            this.aa[186] = new Color(19, 0, 77);
            this.aa[187] = new Color(48, 38, 77);
            this.aa[188] = new Color(10, 0, 38);
            this.aa[189] = new Color(24, 19, 38);
            this.aa[190] = new Color(128, 0, 255);
            this.aa[191] = new Color(192, 128, 255);
            this.aa[192] = new Color(83, 0, 166);
            this.aa[193] = new Color(125, 83, 166);
            this.aa[194] = new Color(64, 0, 128);
            this.aa[195] = new Color(96, 64, 128);
            this.aa[196] = new Color(38, 0, 77);
            this.aa[197] = new Color(58, 38, 77);
            this.aa[198] = new Color(19, 0, 38);
            this.aa[199] = new Color(29, 19, 38);
            this.aa[200] = new Color(192, 0, 255);
            this.aa[201] = new Color(224, 128, 255);
            this.aa[202] = new Color(125, 0, 166);
            this.aa[203] = new Color(146, 83, 166);
            this.aa[204] = new Color(96, 0, 128);
            this.aa[205] = new Color(112, 64, 128);
            this.aa[206] = new Color(58, 0, 77);
            this.aa[207] = new Color(67, 38, 77);
            this.aa[208] = new Color(29, 0, 38);
            this.aa[209] = new Color(34, 19, 38);
            this.aa[210] = new Color(255, 0, 255);
            this.aa[211] = new Color(255, 128, 255);
            this.aa[212] = new Color(166, 0, 166);
            this.aa[213] = new Color(166, 83, 166);
            this.aa[214] = new Color(128, 0, 128);
            this.aa[215] = new Color(128, 64, 128);
            this.aa[216] = new Color(77, 0, 77);
            this.aa[217] = new Color(77, 38, 77);
            this.aa[218] = new Color(38, 0, 38);
            this.aa[219] = new Color(38, 19, 38);
            this.aa[220] = new Color(255, 0, 192);
            this.aa[221] = new Color(255, 128, 224);
            this.aa[222] = new Color(166, 0, 125);
            this.aa[223] = new Color(166, 83, 146);
            this.aa[224] = new Color(128, 0, 96);
            this.aa[225] = new Color(128, 64, 112);
            this.aa[226] = new Color(77, 0, 58);
            this.aa[227] = new Color(77, 38, 67);
            this.aa[228] = new Color(38, 0, 29);
            this.aa[229] = new Color(38, 19, 34);
            this.aa[230] = new Color(255, 0, 128);
            this.aa[231] = new Color(255, 128, 192);
            this.aa[232] = new Color(166, 0, 83);
            this.aa[233] = new Color(166, 83, 125);
            this.aa[234] = new Color(128, 0, 64);
            this.aa[235] = new Color(128, 64, 96);
            this.aa[236] = new Color(77, 0, 38);
            this.aa[237] = new Color(77, 38, 58);
            this.aa[238] = new Color(38, 0, 19);
            this.aa[239] = new Color(38, 19, 29);
            this.aa[240] = new Color(255, 0, 64);
            this.aa[241] = new Color(255, 128, 160);
            this.aa[242] = new Color(166, 0, 42);
            this.aa[243] = new Color(166, 83, 104);
            this.aa[244] = new Color(128, 0, 32);
            this.aa[245] = new Color(128, 64, 80);
            this.aa[246] = new Color(77, 0, 19);
            this.aa[247] = new Color(77, 38, 48);
            this.aa[248] = new Color(38, 0, 10);
            this.aa[249] = new Color(38, 19, 24);
            if (bl) {
                this.aa[250] = new Color(51, 51, 51);
                this.aa[251] = new Color(91, 91, 91);
                this.aa[252] = new Color(132, 132, 132);
                this.aa[253] = new Color(173, 173, 173);
                this.aa[254] = new Color(214, 214, 214);
                this.aa[255] = new Color(255, 255, 255);
            } else {
                this.aa[250] = new Color(0, 0, 0);
                this.aa[251] = new Color(45, 45, 45);
                this.aa[252] = new Color(91, 91, 91);
                this.aa[253] = new Color(137, 137, 137);
                this.aa[254] = new Color(183, 183, 183);
                this.aa[255] = new Color(179, 179, 179);
            }
        }
        return this.aa;
    }

    private Color a(String string, int n2) {
        Color color;
        Color color2 = color = n2 == -1 ? null : this.a(n2);
        if (color != null || this.n == null) {
            return color;
        }
        DXFElement dXFElement = (DXFElement)this.n.get(string.toLowerCase());
        if (dXFElement != null) {
            if (dXFElement.c() != null) {
                Color color3 = (Color)dXFElement.c();
                return color3;
            }
            DXFGroup dXFGroup = dXFElement.a(62);
            color = dXFGroup != null ? this.a(dXFGroup.c()) : (this.a.isInvertBlackAndWhite() ? Color.white : Color.black);
            dXFElement.a(color);
        }
        return color;
    }

    private ArrayList c(String string) {
        if (this.o == null) {
            return null;
        }
        DXFElement dXFElement = (DXFElement)this.o.get(string.toLowerCase());
        return dXFElement != null ? (ArrayList)dXFElement.c() : null;
    }

    private int b(DXFElement dXFElement) {
        if (this.c == null) {
            return -1;
        }
        DXFGroup dXFGroup = dXFElement.a(0);
        if (dXFGroup == null) {
            return 0;
        }
        DXFGroup dXFGroup2 = dXFElement.a(8);
        if (dXFGroup2 != null) {
            Object object = dXFGroup2.f();
            Integer n2 = (Integer)this.z.get(object);
            if (n2 == null) {
                if (object instanceof String) {
                    String string = (String)object;
                    return this.b(string);
                }
                throw new RuntimeException("Internal error: unexpected layer group key type");
            }
            return n2;
        }
        return 0;
    }

    private IlvGraphic c(DXFElement dXFElement) throws IOException {
        Color color;
        String string;
        DXFGroup dXFGroup = dXFElement.a(0);
        if (dXFGroup == null) {
            return null;
        }
        String string2 = dXFGroup.e();
        DXFGroup dXFGroup2 = dXFElement.a(6);
        DXFGroup dXFGroup3 = dXFGroup2 != null && dXFGroup2.e().equalsIgnoreCase("bylayer") ? null : dXFElement.a(62);
        DXFGroup dXFGroup4 = dXFElement.a(8);
        String string3 = string = dXFGroup4 != null ? dXFGroup4.e() : null;
        Color color2 = string != null ? (dXFGroup3 != null ? this.a(string, (int)dXFGroup3.c()) : this.a(string, -1)) : (color = null);
        if (color == null) {
            color = this.a.isInvertBlackAndWhite() ? Color.white : Color.black;
        }
        IlvGraphic ilvGraphic = null;
        if (string2.equalsIgnoreCase("POINT")) {
            IlvPoint ilvPoint = this.a((float)dXFElement.getDouble(10), (float)dXFElement.getDouble(20));
            float f2 = (float)this.a(dXFElement.getDouble(39));
            ilvGraphic = this.d.createPoint(ilvPoint, f2, color);
        } else if (string2.equalsIgnoreCase("LINE")) {
            IlvPoint ilvPoint = this.a((float)dXFElement.getDouble(10), (float)dXFElement.getDouble(20));
            IlvPoint ilvPoint2 = this.a((float)dXFElement.getDouble(11), (float)dXFElement.getDouble(21));
            float f3 = (float)this.a(dXFElement.getDouble(39));
            ilvGraphic = this.d.createLine(ilvPoint, ilvPoint2, f3, color);
        } else if (string2.equalsIgnoreCase("ARC")) {
            double d2;
            double d3;
            double d4 = dXFElement.getDouble(50);
            if (d4 == (d3 = dXFElement.getDouble(51))) {
                return null;
            }
            IlvPoint ilvPoint = this.a((float)dXFElement.getDouble(10), (float)dXFElement.getDouble(20));
            float f4 = (float)Math.abs(this.a(dXFElement.getDouble(40)));
            float f5 = (float)this.a(dXFElement.getDouble(39));
            if (d4 > 180.0) {
                d4 -= 360.0;
            }
            if (d4 < -180.0) {
                d4 += 360.0;
            }
            if ((d2 = d3 - d4) > 180.0) {
                d2 -= 360.0;
            }
            if (d2 < -180.0) {
                d2 += 360.0;
            }
            ilvGraphic = this.d.createArc(ilvPoint, f4, (float)d4, (float)d2, f5, color);
        } else if (string2.equalsIgnoreCase("CIRCLE")) {
            IlvPoint ilvPoint = this.a((float)dXFElement.getDouble(10), (float)dXFElement.getDouble(20));
            float f6 = (float)Math.abs(this.a(dXFElement.getDouble(40)));
            float f7 = (float)this.a(dXFElement.getDouble(39));
            ilvGraphic = this.d.createCircle(ilvPoint, f6, f7, color);
        } else if (string2.equalsIgnoreCase("POLYLINE")) {
            float f8;
            this.s = color;
            this.t = (float)this.a(dXFElement.getDouble(39));
            float f9 = (float)this.a(dXFElement.getDouble(40));
            float f10 = (f9 + (f8 = (float)this.a(dXFElement.getDouble(41)))) / 2.0f;
            if (f10 > this.t) {
                this.t = f10;
            }
            this.v.a();
            this.v.a(dXFElement.a(0));
            if (dXFGroup4 != null) {
                this.v.a(dXFGroup4);
            }
            this.u = true;
            this.w = dXFElement.getShort(70);
        } else if (string2.equalsIgnoreCase("LWPOLYLINE")) {
            float f11 = (float)this.a(dXFElement.getDouble(39));
            short s2 = dXFElement.getShort(70);
            boolean bl = (s2 & 1) != 0;
            IlvPoint[] ilvPointArray = dXFElement.i();
            this.a(ilvPointArray);
            if (dXFElement.m()) {
                double[] dArray = dXFElement.l();
                ilvPointArray = DXFBulgeUtil.createPointsWithBulge(ilvPointArray, dArray, (int)s2);
            }
            ilvGraphic = this.d.createPolyline(ilvPointArray, bl, false, f11, color);
        } else if (string2.equalsIgnoreCase("SPLINE")) {
            short s3 = dXFElement.getShort(70);
            IlvPoint[] ilvPointArray = this.d(dXFElement);
            this.a(ilvPointArray);
            float f12 = 0.0f;
            boolean bl = (s3 & 1) != 0;
            ilvGraphic = this.d.createSpline(ilvPointArray, bl, f12, color);
        } else if (string2.equalsIgnoreCase("VERTEX")) {
            if (this.u) {
                this.q.add(this.a((float)dXFElement.getDouble(10), (float)dXFElement.getDouble(20)));
                double d5 = dXFElement.getDouble(42);
                if (d5 > 0.0) {
                    this.x = true;
                }
                this.r.add(d5 == 0.0 ? null : new Double(d5));
            }
        } else if (string2.equalsIgnoreCase("SEQEND")) {
            if (this.u) {
                boolean bl = (this.w & 1) != 0;
                boolean bl2 = (this.w & 0x10) != 0;
                IlvPoint[] ilvPointArray = new IlvPoint[this.q.size()];
                this.q.toArray(ilvPointArray);
                if (this.x) {
                    Double[] doubleArray = new Double[this.r.size()];
                    this.r.toArray(doubleArray);
                    ilvPointArray = DXFBulgeUtil.createPointsWithBulge(ilvPointArray, doubleArray, (int)this.w);
                }
                ilvGraphic = this.d.createPolyline(ilvPointArray, bl, bl2, this.t, this.s);
                if (this.x && ilvGraphic instanceof IlvPolyline) {
                    ((IlvPolyline)ilvGraphic).setEndCap(1);
                }
                this.q.clear();
                this.x = false;
                this.r.clear();
                this.s = null;
            } else {
                if (this.y != null) {
                    this.y = null;
                    return null;
                }
                this.d("Unexpected SEQEND entity");
            }
        } else if (string2.equalsIgnoreCase("DIMENSION")) {
            ilvGraphic = this.c(dXFElement, color);
        } else if (string2.equalsIgnoreCase("TEXT")) {
            ilvGraphic = this.a(dXFElement, color);
        } else if (string2.equalsIgnoreCase("MTEXT")) {
            ilvGraphic = this.b(dXFElement, color);
        } else if (string2.equalsIgnoreCase("TRACE")) {
            IlvPoint[] ilvPointArray = new IlvPoint[4];
            ilvPointArray[0] = this.a((float)dXFElement.getDouble(10), (float)dXFElement.getDouble(20));
            ilvPointArray[1] = this.a((float)dXFElement.getDouble(11), (float)dXFElement.getDouble(21));
            ilvPointArray[3] = this.a((float)dXFElement.getDouble(12), (float)dXFElement.getDouble(22));
            ilvPointArray[2] = this.a((float)dXFElement.getDouble(13), (float)dXFElement.getDouble(23));
            float f13 = (float)this.a(dXFElement.getDouble(39));
            ilvGraphic = this.d.createTrace(ilvPointArray, f13, color);
        } else if (string2.equalsIgnoreCase("SOLID")) {
            IlvPoint[] ilvPointArray = new IlvPoint[4];
            ilvPointArray[0] = this.a((float)dXFElement.getDouble(10), (float)dXFElement.getDouble(20));
            ilvPointArray[1] = this.a((float)dXFElement.getDouble(11), (float)dXFElement.getDouble(21));
            ilvPointArray[3] = this.a((float)dXFElement.getDouble(12), (float)dXFElement.getDouble(22));
            ilvPointArray[2] = this.a((float)dXFElement.getDouble(13), (float)dXFElement.getDouble(23));
            float f14 = (float)this.a(dXFElement.getDouble(39));
            ilvGraphic = this.d.createSolid(ilvPointArray, f14, color);
        } else if (string2.equalsIgnoreCase("3DFACE")) {
            IlvPoint[] ilvPointArray = new IlvPoint[]{this.a((float)dXFElement.getDouble(10), (float)dXFElement.getDouble(20)), this.a((float)dXFElement.getDouble(11), (float)dXFElement.getDouble(21)), this.a((float)dXFElement.getDouble(12), (float)dXFElement.getDouble(22)), this.a((float)dXFElement.getDouble(13), (float)dXFElement.getDouble(23))};
            ilvGraphic = this.d.create3DFace(ilvPointArray, color);
        } else if (string2.equalsIgnoreCase("INSERT")) {
            DXFElement dXFElement2;
            String string4 = dXFElement.getString(2);
            ArrayList arrayList = this.o == null ? null : this.c(string4);
            DXFElement dXFElement3 = dXFElement2 = arrayList == null ? null : (DXFElement)this.o.get(dXFElement.getString(2).toLowerCase());
            if (dXFElement2 != null) {
                DXFGroup dXFGroup5;
                DXFGroup dXFGroup6 = dXFElement.a(41);
                double d6 = dXFGroup6 != null ? dXFGroup6.d() : 1.0;
                dXFGroup6 = dXFElement.a(42);
                double d7 = dXFGroup6 != null ? dXFGroup6.d() : 1.0;
                dXFGroup6 = dXFElement.a(70);
                if (dXFGroup6 != null && dXFGroup6.c() != 1) {
                    this.d("Column count " + dXFGroup6.c() + " for INSERT not supported");
                }
                if ((dXFGroup6 = dXFElement.a(71)) != null && dXFGroup6.c() != 1) {
                    this.d("Row count " + dXFGroup6.c() + " for INSERT not supported");
                }
                if ((dXFGroup6 = dXFElement.a(44)) != null && dXFGroup6.d() != 0.0) {
                    this.d("Column spacing " + dXFGroup6.d() + " for INSERT not supported");
                }
                if ((dXFGroup6 = dXFElement.a(45)) != null && dXFGroup6.d() != 0.0) {
                    this.d("Row spacing " + dXFGroup6.d() + " for INSERT not supported");
                }
                if ((dXFGroup5 = dXFElement.a(66)) != null && (dXFGroup5.c() & 1) != 0) {
                    this.y = arrayList;
                }
                IlvTransformer ilvTransformer = new IlvTransformer(this.f);
                IlvTransformer ilvTransformer2 = new IlvTransformer();
                ilvTransformer2.translate(-((float)dXFElement2.getDouble(10)), -((float)dXFElement2.getDouble(20)));
                ilvTransformer2.scale(0.0, 0.0, (float)d6, (float)d7);
                dXFGroup6 = dXFElement.a(50);
                if (dXFGroup6 != null) {
                    ilvTransformer2.rotate(0.0, 0.0, (float)dXFGroup6.d());
                }
                ilvTransformer2.translate((float)dXFElement.getDouble(10), (float)dXFElement.getDouble(20));
                boolean bl = this.ab;
                ilvTransformer2.compose(this.f);
                this.ab = false;
                this.f = ilvTransformer2;
                if (arrayList != null) {
                    int n2;
                    IlvGraphicVector ilvGraphicVector = null;
                    for (DXFElement dXFElement4 : arrayList) {
                        IlvGraphic ilvGraphic2 = this.c(dXFElement4);
                        if (ilvGraphic2 == null) continue;
                        if (ilvGraphicVector == null) {
                            ilvGraphicVector = new IlvGraphicVector();
                        }
                        ilvGraphicVector.addElement(ilvGraphic2);
                    }
                    int n3 = n2 = ilvGraphicVector != null ? ilvGraphicVector.size() : 0;
                    if (n2 > 0) {
                        ilvGraphic = this.d.createInsert(ilvGraphicVector, string4, color);
                    }
                }
                this.f = ilvTransformer;
                this.ab = bl;
            }
        } else if (string2.equalsIgnoreCase("ATTRIB")) {
            if (this.y != null) {
                return null;
            }
            this.d("Unexpected ATTRIB entity");
        } else if (string2.equalsIgnoreCase("ATTDEF")) {
            return null;
        }
        return ilvGraphic;
    }

    private IlvPoint[] d(DXFElement dXFElement) {
        IlvPoint[] ilvPointArray = dXFElement.j();
        if (ilvPointArray != null && ilvPointArray.length > 0) {
            return ilvPointArray;
        }
        return dXFElement.k();
    }

    private void d(String string) {
        System.err.println(string);
    }

    /*
     * Unable to fully structure code
     */
    private IlvGraphic a(DXFElement var1_1, Color var2_2) {
        block13: {
            block12: {
                var3_3 = var1_1.getString(1);
                var4_4 = this.a(var1_1.getDouble(40));
                var6_5 = 1.0;
                if (var1_1.a(41) != null) {
                    var6_5 = var1_1.getDouble(41);
                }
                var8_6 = var1_1.getShort(72);
                var9_7 = var1_1.getShort(73);
                var10_8 = var8_6 == 0 && var9_7 == 0 || var1_1.a(11) == null || var1_1.a(21) == null;
                var11_9 = new IlvPoint(this.a((float)var1_1.getDouble(10), (float)var1_1.getDouble(20)));
                var12_10 = var10_8 != false ? null : new IlvPoint(this.a((float)var1_1.getDouble(11), (float)var1_1.getDouble(21)));
                var13_11 = var11_9;
                if (var3_3.startsWith("%%u")) ** GOTO lbl-1000
                if (var3_3.startsWith("%%U")) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = var14_12 = false;
                }
                if (var14_12 && (var15_13 = var3_3.length()) > 3 != 0) {
                    var3_3 = var3_3.substring(3, (int)var15_13);
                }
                var15_13 = this.getConfigurator().isTextAntialiasing();
                var16_14 = this.d.createText(var13_11, var3_3, var14_12, var15_13, IlvDXFReader.ae, var2_2);
                var17_15 = IlvDXFReader.a(var16_14, (float)var4_4);
                if (var6_5 != 1.0) {
                    var16_14.scale(var6_5, 1.0);
                }
                var18_16 = IlvDXFReader.a(var16_14);
                var19_17 = var18_16.width;
                var20_18 = var18_16.height;
                if (var8_6 != 1) break block12;
                var21_19 = var11_9.x - var18_16.x;
                var16_14.translate(var21_19, 0.0f);
                break block13;
            }
            if (var8_6 == 2) ** GOTO lbl37
            if (var8_6 == 4) {
lbl37:
                // 2 sources

                var21_19 = var12_10.x - (var18_16.x + var19_17 * 0.5f);
                var22_21 = var8_6 == 5 && var9_7 == 0 ? var12_10.y - (var18_16.y + var20_18 * 0.5f) : 0.0f;
                var16_14.translate(var21_19, var22_21);
            } else if (var8_6 == 5 && var12_10 != null) {
                var21_19 = Math.abs(var12_10.x - var11_9.x);
                var16_14.resize(var21_19, var17_15);
            }
        }
        if (var9_7 == 2) {
            var16_14.translate(0.0f, -var20_18 / 2.0f);
        } else if (var9_7 == 3) {
            var16_14.translate(0.0f, var20_18);
        }
        var21_20 = var1_1.getDouble(50);
        if (var21_20 != 0.0) {
            var23_22 = var13_11;
            var16_14.rotate(var23_22, -var21_20);
        }
        return var16_14;
    }

    private static IlvRect a(IlvGraphic ilvGraphic) {
        if (ilvGraphic instanceof IlvText) {
            return ((IlvText)ilvGraphic).getLabelBBox(null);
        }
        return ilvGraphic.boundingBox(null);
    }

    private static float a(IlvGraphic ilvGraphic, float f2) {
        float f3 = f2 * 2.0f;
        IlvText ilvText = ilvGraphic instanceof IlvText ? (IlvText)ilvGraphic : null;
        IlvRect ilvRect = null;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (ilvText != null) {
            IlvPoint ilvPoint = ilvText.getAnchorPoint();
            f4 = ilvPoint.x;
            f5 = ilvPoint.y;
            ilvRect = ilvText.getLabelBBox(null);
        } else {
            ilvRect = ilvGraphic.boundingBox(null);
            f4 = ilvRect.x;
            f5 = ilvRect.y + ilvRect.height;
        }
        float f6 = ilvRect.width;
        float f7 = ilvRect.height;
        float f8 = f3 / f7;
        ilvGraphic.resize(f6 * f8, f3);
        IlvRect ilvRect2 = ilvText != null ? ilvText.getLabelBBox(null) : ilvGraphic.boundingBox(null);
        float f9 = f4 - ilvRect2.x;
        float f10 = f5 - ilvRect2.y - ilvRect2.height * 0.75f;
        ilvGraphic.translate(f9, f10);
        return f3;
    }

    private IlvGraphic b(DXFElement dXFElement, Color color) {
        String string = dXFElement.getString(1);
        double d2 = this.a(dXFElement.getDouble(40));
        IlvPoint ilvPoint = new IlvPoint(this.a((float)dXFElement.getDouble(10), (float)dXFElement.getDouble(20)));
        string = this.e(string);
        boolean bl = this.getConfigurator().isTextAntialiasing();
        IlvGraphic ilvGraphic = this.d.createText(ilvPoint, string, false, bl, ae, color);
        IlvDXFReader.a(ilvGraphic, (float)d2);
        short s2 = dXFElement.getShort(71);
        IlvRect ilvRect = IlvDXFReader.a(ilvGraphic);
        float f2 = 0.0f;
        float f3 = 0.0f;
        switch (s2) {
            case 1: {
                f2 = ilvRect.x;
                f3 = ilvRect.y;
                break;
            }
            case 2: {
                f2 = ilvRect.x + ilvRect.width * 0.5f;
                f3 = ilvRect.y;
                break;
            }
            case 3: {
                f2 = ilvRect.x + ilvRect.width;
                f3 = ilvRect.y;
                break;
            }
            case 4: {
                f2 = ilvRect.x;
                f3 = ilvRect.y + ilvRect.height * 0.5f;
                break;
            }
            case 5: {
                f2 = ilvRect.x + ilvRect.width * 0.5f;
                f3 = ilvRect.y + ilvRect.height * 0.5f;
                break;
            }
            case 6: {
                f2 = ilvRect.x + ilvRect.width;
                f3 = ilvRect.y + ilvRect.height * 0.5f;
                break;
            }
            case 7: {
                f2 = ilvRect.x;
                f3 = ilvRect.y + ilvRect.height;
                break;
            }
            case 8: {
                f2 = ilvRect.x + ilvRect.width * 0.5f;
                f3 = ilvRect.y + ilvRect.height;
                break;
            }
            case 9: {
                f2 = ilvRect.x + ilvRect.width;
                f3 = ilvRect.y + ilvRect.height;
            }
        }
        float f4 = ilvPoint.x - f2;
        float f5 = ilvPoint.y - f3;
        ilvGraphic.translate(f4, f5);
        double d3 = dXFElement.getDouble(50);
        if (d3 != 0.0) {
            IlvPoint ilvPoint2 = ilvPoint;
            ilvGraphic.rotate(ilvPoint2, -d3);
        }
        return ilvGraphic;
    }

    private String e(String string) {
        int n2 = string.indexOf(";");
        if (n2 >= 0) {
            string = string.substring(n2 + 1, string.length() - 1);
        }
        return IlvDXFReader.a(string, "\\P", "\n");
    }

    private static String a(String string, String string2, String string3) {
        int n2 = string.indexOf(string2);
        if (n2 < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        do {
            stringBuffer.append(string.substring(n3, n2));
            stringBuffer.append(string3);
        } while ((n2 = string.indexOf(string, n3 = n2 + string2.length())) >= 0);
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    private IlvGraphic c(DXFElement dXFElement, Color color) {
        IlvPoint ilvPoint = new IlvPoint(this.a((float)dXFElement.getDouble(10), (float)dXFElement.getDouble(20)));
        IlvPoint ilvPoint2 = new IlvPoint(this.a((float)dXFElement.getDouble(11), (float)dXFElement.getDouble(21)));
        IlvPoint ilvPoint3 = new IlvPoint(this.a((float)dXFElement.getDouble(12), (float)dXFElement.getDouble(22)));
        IlvPoint ilvPoint4 = new IlvPoint(this.a((float)dXFElement.getDouble(13), (float)dXFElement.getDouble(23)));
        IlvPoint ilvPoint5 = new IlvPoint(this.a((float)dXFElement.getDouble(14), (float)dXFElement.getDouble(24)));
        IlvPoint ilvPoint6 = new IlvPoint(this.a((float)dXFElement.getDouble(15), (float)dXFElement.getDouble(25)));
        IlvPoint ilvPoint7 = new IlvPoint(this.a((float)dXFElement.getDouble(16), (float)dXFElement.getDouble(26)));
        String string = dXFElement.getString(1);
        short s2 = dXFElement.getShort(70);
        IlvGraphic ilvGraphic = this.d.createDimension(string, s2, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, ilvPoint5, ilvPoint6, ilvPoint7);
        return ilvGraphic;
    }
}

