/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvGeneralPath;
import ilog.views.graphic.IlvZoomableLabel;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.io.IOException;

public class IlvDefaultCollapsedGraphic
extends IlvGeneralPath
implements IlvLabelInterface {
    private static final float a = 30.0f;
    private static final float b = 20.0f;
    private IlvZoomableLabel c;

    public IlvDefaultCollapsedGraphic() {
        super(IlvDefaultCollapsedGraphic.b());
        this.setPointEditionAllowed(false);
        this.setFillPaint(Color.yellow);
        this.setStrokePaint(Color.black);
        this.c = new IlvZoomableLabel(new IlvPoint(0.0f, 0.0f), "Untitled", false);
        this.c.setAntialiasing(true);
        this.setLabel("Untitled");
    }

    public IlvDefaultCollapsedGraphic(IlvDefaultCollapsedGraphic ilvDefaultCollapsedGraphic) {
        super(ilvDefaultCollapsedGraphic);
        this.c = (IlvZoomableLabel)ilvDefaultCollapsedGraphic.c.copy();
    }

    public IlvDefaultCollapsedGraphic(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        super(ilvInputStream);
        this.c = (IlvZoomableLabel)ilvInputStream.readObject("label");
    }

    public IlvGraphic copy() {
        return new IlvDefaultCollapsedGraphic(this);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("label", this.c);
    }

    public void setLabel(String string) {
        IlvRect ilvRect = super.boundingBox(null);
        this.c.setLabel(string != null ? string : "");
        IlvRect ilvRect2 = this.c.boundingBox();
        this.c.move(ilvRect.x + ilvRect.width / 2.0f - ilvRect2.width / 2.0f, ilvRect.y + ilvRect.height + 2.0f);
    }

    public String getLabel() {
        return this.c.getLabel();
    }

    public boolean supportMultiline() {
        return this.c.supportMultiline();
    }

    public IlvRect getLabelBBox(IlvTransformer ilvTransformer) {
        return this.c.getLabelBBox(ilvTransformer);
    }

    public void setFont(Font font) {
        this.c.setFont(font);
    }

    public Font getFont() {
        return this.c.getFont();
    }

    public void setLabelFillPaint(Paint paint) {
        this.c.setFillPaint(paint);
    }

    public Paint getLabelFillPaint() {
        return this.c.getFillPaint();
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        super.draw(graphics, ilvTransformer);
        if (this.getLabel() != null && this.getLabel().length() != 0) {
            this.c.draw(graphics, ilvTransformer);
        }
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        super.applyTransform(ilvTransformer);
        if (this.getLabel() != null && this.getLabel().length() != 0) {
            this.c.applyTransform(ilvTransformer);
        }
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (super.contains(ilvPoint, ilvPoint2, ilvTransformer)) {
            return true;
        }
        if (this.getLabel() != null && this.getLabel().length() != 0) {
            return this.c.contains(ilvPoint, ilvPoint2, ilvTransformer);
        }
        return false;
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = super.boundingBox(ilvTransformer);
        if (this.getLabel() != null && this.getLabel().length() != 0) {
            ilvRect.add(this.c.boundingBox(ilvTransformer));
        }
        return ilvRect;
    }

    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        IlvPoint ilvPoint3 = super.getIntersectionWithOutline(ilvPoint, ilvPoint2, ilvTransformer);
        if (this.getLabel() != null && this.getLabel().length() != 0) {
            IlvPoint ilvPoint4 = this.c.getIntersectionWithOutline(ilvPoint, ilvPoint2, ilvTransformer);
            IlvPoint[] ilvPointArray = new IlvPoint[]{ilvPoint3, ilvPoint4};
            ilvPoint3 = IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, ilvPointArray, 2);
        }
        return ilvPoint3;
    }

    private static Shape b() {
        GeneralPath generalPath = new GeneralPath();
        float f2 = 2.0f;
        generalPath.moveTo(0.0f, f2);
        generalPath.quadTo(0.0f, 0.0f, f2, 0.0f);
        generalPath.lineTo(30.0f - f2, 0.0f);
        generalPath.quadTo(30.0f, 0.0f, 30.0f, f2);
        generalPath.lineTo(30.0f, 20.0f - f2);
        generalPath.quadTo(30.0f, 20.0f, 30.0f - f2, 20.0f);
        generalPath.lineTo(f2, 20.0f);
        generalPath.quadTo(0.0f, 20.0f, 0.0f, 20.0f - f2);
        generalPath.closePath();
        float f3 = 1.0f;
        float f4 = 19.800001f;
        float f5 = 4.0f;
        generalPath.moveTo(f3, 0.0f);
        generalPath.quadTo(f3, -f5, f3 + f5, -f5);
        generalPath.lineTo(f3 + f4 - f5, -f5);
        generalPath.quadTo(f3 + f4, -f5, f3 + f4, 0.0f);
        generalPath.closePath();
        return generalPath;
    }
}

