/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.internal.DataStreamHandler;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class IlvIcon
extends IlvGraphic
implements ImageObserver {
    protected final IlvRect drawrect;
    private Image a;
    private String b;
    private URL c;
    private boolean d;
    private boolean e;
    private IlvTransformer f;
    private boolean g;
    private RenderedImage h;
    private float i;

    public IlvIcon() {
        this.drawrect = new IlvRect();
        this.c = null;
        this.d = false;
        this.e = false;
        this.f = null;
        this.g = false;
        this.i = 1.0f;
        this.drawrect.x = 0.0f;
        this.drawrect.y = 0.0f;
        this.drawrect.width = 10.0f;
        this.drawrect.height = 10.0f;
        this.g = true;
        this.f = new IlvTransformer();
    }

    public IlvIcon(RenderedImage renderedImage, IlvRect ilvRect) {
        this.drawrect = new IlvRect();
        this.c = null;
        this.d = false;
        this.e = false;
        this.f = null;
        this.g = false;
        this.i = 1.0f;
        this.a(ilvRect);
        this.h = renderedImage;
        this.f = new IlvTransformer();
    }

    public IlvIcon(Image image, IlvRect ilvRect) {
        this.drawrect = new IlvRect();
        this.c = null;
        this.d = false;
        this.e = false;
        this.f = null;
        this.g = false;
        this.i = 1.0f;
        this.a(ilvRect);
        this.a = image;
        this.f = new IlvTransformer();
    }

    public IlvIcon(URL uRL, IlvRect ilvRect) {
        this.drawrect = new IlvRect();
        this.c = null;
        this.d = false;
        this.e = false;
        this.f = null;
        this.g = false;
        this.i = 1.0f;
        this.b = uRL.toString();
        this.a(ilvRect);
        this.a = Toolkit.getDefaultToolkit().getImage(uRL);
        this.f = new IlvTransformer();
    }

    public IlvIcon(String string, IlvRect ilvRect) {
        this.drawrect = new IlvRect();
        this.c = null;
        this.d = false;
        this.e = false;
        this.f = null;
        this.g = false;
        this.i = 1.0f;
        this.b = string;
        this.a(ilvRect);
        this.a = Toolkit.getDefaultToolkit().getImage(string);
        this.f = new IlvTransformer();
    }

    public IlvIcon(IlvIcon ilvIcon) {
        super(ilvIcon);
        this.drawrect = new IlvRect();
        this.c = null;
        this.d = false;
        this.e = false;
        this.f = null;
        this.g = false;
        this.i = 1.0f;
        this.a(ilvIcon.drawrect);
        this.f = new IlvTransformer(ilvIcon.f);
        this.a = ilvIcon.a;
        this.h = ilvIcon.h;
        this.b = ilvIcon.b;
        this.e = ilvIcon.e;
        this.setClip(ilvIcon.getClip());
        this.setAlpha(ilvIcon.getAlpha());
        this.setAutoResizing(ilvIcon.isAutoResizing());
    }

    public IlvIcon(IlvInputStream ilvInputStream) throws IlvReadFileException {
        block16: {
            super(ilvInputStream);
            this.drawrect = new IlvRect();
            this.c = null;
            this.d = false;
            this.e = false;
            this.f = null;
            this.g = false;
            this.i = 1.0f;
            try {
                IlvRect ilvRect = ilvInputStream.readRect("rectangle");
                this.a(ilvRect);
                try {
                    this.f = ilvInputStream.readTransformer("transform");
                }
                catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                    this.f = new IlvTransformer();
                }
                String string = ilvInputStream.readString("location");
                this.a = null;
                this.d = false;
                this.b = string;
                try {
                    URL uRL = null;
                    uRL = string.startsWith("data:") ? new URL(null, string, DataStreamHandler.getInstance()) : new URL(string);
                    this.a = Toolkit.getDefaultToolkit().getImage(uRL);
                    this.c = null;
                }
                catch (MalformedURLException malformedURLException) {
                    if (ilvInputStream.getDocumentBase() == null) break block16;
                    try {
                        URL uRL = new URL(ilvInputStream.getDocumentBase(), string);
                        this.a = Toolkit.getDefaultToolkit().getImage(uRL);
                        this.c = ilvInputStream.getDocumentBase();
                    }
                    catch (MalformedURLException malformedURLException2) {
                        this.a = Toolkit.getDefaultToolkit().getImage(this.b);
                        this.c = null;
                    }
                }
            }
            catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                // empty catch block
            }
        }
        try {
            this.e = ilvInputStream.readBoolean("quality");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setClip(ilvInputStream.readShape("clip", "clipRule"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.g = ilvInputStream.readBoolean("autoResize");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setAlpha(ilvInputStream.readFloat("alpha"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    private void a(IlvRect ilvRect) {
        this.drawrect.x = ilvRect.x;
        this.drawrect.y = ilvRect.y;
        this.drawrect.width = ilvRect.width;
        this.drawrect.height = ilvRect.height;
        if (this.drawrect.width <= 0.0f) {
            this.drawrect.width = 1.0E-20f;
        }
        if (this.drawrect.height <= 0.0f) {
            this.drawrect.height = 1.0E-20f;
        }
    }

    public IlvGraphic copy() {
        return new IlvIcon(this);
    }

    public Image getImage() {
        return this.a;
    }

    public RenderedImage getRenderedImage() {
        return this.h;
    }

    public void setRenderedImage(RenderedImage renderedImage) {
        this.h = renderedImage;
        this.a = null;
    }

    public void setImage(Image image) {
        this.a = image;
        this.h = null;
        if (this.g) {
            this.a();
        }
    }

    public String getImageLocation() {
        return this.b;
    }

    public void setImageLocation(String string) {
        try {
            URL uRL = null;
            uRL = string.startsWith("data:") ? new URL(null, string, DataStreamHandler.getInstance()) : (this.c != null ? new URL(this.c, string) : new URL(string));
            this.a = Toolkit.getDefaultToolkit().getImage(uRL);
            this.h = null;
            if (this.g) {
                this.a();
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.a = null;
        }
        this.b = string;
    }

    public IlvTransformer getTransformer() {
        return new IlvTransformer(this.f);
    }

    public void setClip(Shape shape) {
        this.setProperty("__ClipProperty", shape);
    }

    public Shape getClip() {
        return (Shape)this.getProperty("__ClipProperty");
    }

    public void setAlpha(float f2) {
        if (f2 > 1.0f || f2 < 0.0f) {
            throw new IllegalArgumentException("alpha must be in the range [0.0, 1.0]");
        }
        this.i = f2;
    }

    public float getAlpha() {
        return this.i;
    }

    public void setHighQualityRendering(boolean bl) {
        this.e = bl;
    }

    public boolean isHighQualityRendering() {
        return this.e;
    }

    public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
        if (image == this.a) {
            if ((n2 & 0x40) != 0) {
                this.a = null;
                this.reDraw();
            }
            if ((n2 & 0x20) != 0) {
                this.reDraw();
            }
            if ((n2 & 0x10) != 0) {
                this.d = true;
                this.reDraw();
            }
            if (this.d && this.getGraphicBag() == null) {
                return false;
            }
            return (n2 & 0x60) == 0;
        }
        return false;
    }

    public void setGraphicBag(IlvGraphicBag ilvGraphicBag) {
        super.setGraphicBag(ilvGraphicBag);
        if (ilvGraphicBag != null && this.d && this.a != null) {
            Toolkit.getDefaultToolkit().prepareImage(this.a, -1, -1, this);
        }
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        Shape shape = null;
        Shape shape2 = this.getClip();
        if (shape2 != null) {
            shape = IlvGraphicUtil.AddClip(graphics, IlvGraphicUtil.CreateTransformedShape(shape2, ilvTransformer));
        }
        IlvRect ilvRect = new IlvRect(this.drawrect);
        IlvTransformer ilvTransformer2 = this.getTransformer();
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer2.compose(ilvTransformer);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = IlvUtility2D.SetComposedAlpha(graphics2D, this.getAlpha());
        if (this.h != null) {
            IlvGraphicUtil.DrawRenderedImage(graphics, ilvRect, this.h, ilvTransformer2, this.e);
        } else {
            IlvGraphicUtil.DrawImage(graphics, ilvRect, this.a, ilvTransformer2, this, this.e);
        }
        if (shape2 != null) {
            graphics.setClip(shape);
        }
        if (composite != null) {
            graphics2D.setComposite(composite);
        }
    }

    public IlvRect getDefinitionRect() {
        return new IlvRect(this.drawrect);
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect(this.drawrect);
        IlvTransformer ilvTransformer2 = this.getTransformer();
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer2.compose(ilvTransformer);
        }
        return IlvGraphicUtil.RectBBox(ilvRect, ilvTransformer2);
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.getClip() != null && !IlvGraphicUtil.PointInShape(ilvPoint, this.getClip())) {
            return false;
        }
        return super.contains(ilvPoint, ilvPoint2, ilvTransformer);
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        if (this.getClip() != null) {
            this.setClip(IlvGraphicUtil.CreateTransformedShape(this.getClip(), ilvTransformer));
        }
        this.f.compose(ilvTransformer);
    }

    public final void setAutoResizing(boolean bl) {
        this.g = bl;
    }

    private void a() {
        if (this.a == null) {
            return;
        }
        MediaTracker mediaTracker = new MediaTracker(new Container());
        mediaTracker.addImage(this.a, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!mediaTracker.isErrorID(0)) {
            this.drawrect.width = this.a.getWidth(null);
            this.drawrect.height = this.a.getHeight(null);
        }
        mediaTracker.removeImage(this.a);
    }

    public final boolean isAutoResizing() {
        return this.g;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        float f2;
        super.write(ilvOutputStream);
        ilvOutputStream.write("rectangle", this.drawrect);
        ilvOutputStream.write("transform", this.f);
        String string = this.getImageLocation();
        if (string != null) {
            ilvOutputStream.write("location", this.getImageLocation());
        }
        if (this.e) {
            ilvOutputStream.write("quality", true);
        }
        if (this.getClip() != null) {
            ilvOutputStream.write("clip", "clipRule", this.getClip());
        }
        if (this.g) {
            ilvOutputStream.write("autoResize", this.g);
        }
        if ((f2 = this.getAlpha()) != 1.0f) {
            ilvOutputStream.write("alpha", f2);
        }
    }
}

