/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.labellayout.annealing;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphlayout.labellayout.IlvLabelingModel;
import ilog.views.graphlayout.labellayout.annealing.IlvAnnealingLabelDescriptor;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public class IlvAnnealingPointLabelDescriptor
extends IlvAnnealingLabelDescriptor
implements IlvPersistentObject {
    private Object a;
    private IlvPoint b;
    private float c;
    private float d;
    private float e;
    private float f;
    private float g;
    private float h;
    private double i;
    private float j;
    private int k;
    private int l;
    private boolean m = false;
    public static final int ELLIPTIC = 0;
    public static final int RECTANGULAR = 1;

    public IlvAnnealingPointLabelDescriptor() {
        super(null);
        this.setHalfWidth(0.0f);
        this.setHalfHeight(0.0f);
        this.setMaxDistFromPath(0.0f);
        this.setPreferredDirection(8);
        this.setPreferredDistFromPath(0.0f);
        this.setShape(0);
    }

    public IlvAnnealingPointLabelDescriptor(Object object, Object object2, int n2, int n3) {
        this(object, object2, null, n2, 0.0f, 0.0f, 0.0f, 0.0f, n3);
    }

    public IlvAnnealingPointLabelDescriptor(Object object, Object object2, IlvPoint ilvPoint, float f2, float f3, int n2) {
        this(object, object2, ilvPoint, 0, f2, f2, f3 - f2, 0.0f, n2);
    }

    public IlvAnnealingPointLabelDescriptor(Object object, Object object2, IlvPoint ilvPoint, int n2, float f2, float f3, float f4, float f5, int n3) {
        super(object);
        this.setRelatedObstacle(object2);
        this.setReferencePoint(ilvPoint);
        this.setHalfWidth(f2);
        this.setHalfHeight(f3);
        this.setMaxDistFromPath(f4);
        this.setPreferredDirection(n3);
        this.setPreferredDistFromPath(f5);
        this.setShape(n2);
        this.c();
    }

    private final void c() {
        if (this.getPreferredDistFromPath() > this.getMaxDistFromPath()) {
            throw new IllegalArgumentException("The preferred distance must be smaller than the maximal distance");
        }
        if (this.getReferencePoint() == null && this.getRelatedObstacle() == null) {
            throw new IllegalArgumentException("You must specify a reference point or a related obstacle");
        }
    }

    public void initialize(IlvLabelingModel ilvLabelingModel) {
        IlvRect ilvRect = ilvLabelingModel.boundingBox(this.getObject());
        this.setBoundingBox(ilvRect);
        float f2 = ilvRect.width;
        float f3 = ilvRect.height;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.maxPathLocation;
        double d5 = this.actPathLocation;
        this.c();
        if (this.b == null) {
            IlvRect ilvRect2 = ilvLabelingModel.boundingBox(this.a);
            this.c = ilvRect2.x + 0.5f * ilvRect2.width;
            this.d = ilvRect2.y + 0.5f * ilvRect2.height;
            this.e = 0.5f * ilvRect2.width;
            this.f = 0.5f * ilvRect2.height;
        } else {
            this.c = this.b.x;
            this.d = this.b.y;
        }
        float f4 = Math.max(this.e, this.f);
        double d6 = 0.0;
        if (f4 <= 0.0f) {
            this.l = 1;
        }
        switch (this.l) {
            case 0: {
                this.g = f2;
                this.h = f3;
                d3 = 0.0;
                d2 = 1.5707963267948966 * (double)f4;
                this.maxPathLocation = 2.0 * (Math.PI * (double)f4 + (double)f2 + (double)f3);
                d6 = 0.0;
                break;
            }
            case 1: {
                this.g = 2.0f * this.e + f2;
                this.h = 2.0f * this.f + f3;
                d3 = this.f;
                d2 = this.e + this.f;
                this.maxPathLocation = 2.0f * (this.g + this.h);
                d6 = 1.5707963267948966 * (double)this.j;
                this.c += this.e;
                this.d += this.f;
            }
        }
        this.i = 0.0;
        switch (this.k) {
            case 4: {
                this.i = (double)(f3 + 0.5f * f2) + d2 + d3 + d6;
                break;
            }
            case 8: {
                this.i = (double)(2.0f * f3 + 1.5f * f2) + 3.0 * d2 + d3 + 3.0 * d6;
                break;
            }
            case 1: {
                this.i = 1.5 * (double)f3 + (double)f2 + 2.0 * d2 + d3 + 2.0 * d6;
                break;
            }
            case 2: {
                this.i = 0.5 * (double)f3 + d3;
            }
        }
        if (this.l == 1 && (double)this.j > 0.0) {
            double d7 = this.maxPathLocation + Math.PI * 2 * (double)this.j;
            this.i = this.i / d7 * this.maxPathLocation;
        }
        if (!this.m) {
            this.actPathLocation = this.i;
            this.actDistFromPath = this.j;
        } else if (d4 > 0.0) {
            this.actPathLocation = this.maxPathLocation * d5 / d4;
        }
        this.m = true;
    }

    public void setPosition(double d2, float f2) {
        if (this.maxPathLocation <= 0.0) {
            d2 = 0.0;
        }
        if (this.maxDistFromPath <= 0.0f) {
            f2 = 0.0f;
        }
        while (d2 > this.maxPathLocation) {
            d2 -= this.maxPathLocation;
        }
        while (d2 < 0.0) {
            d2 += this.maxPathLocation;
        }
        while (f2 < 0.0f) {
            f2 += this.maxDistFromPath;
        }
        this.actPathLocation = d2;
        this.actDistFromPath = f2;
        switch (this.l) {
            case 0: {
                this.b(d2, f2);
                break;
            }
            case 1: {
                this.a(d2, f2);
            }
        }
    }

    private void a(double d2, float f2) {
        if (f2 > 0.0f && this.maxPathLocation > 0.0) {
            double d3 = this.maxPathLocation + Math.PI * 2 * (double)f2;
            this.a(d2 * d3 / this.maxPathLocation, f2, f2, f2, this.g, this.h);
            return;
        }
        float f3 = (float)d2;
        if (f3 < this.h) {
            this.updatePosition(this.c, this.d - f3);
            return;
        }
        if ((f3 -= this.h) < this.g) {
            this.updatePosition(this.c - f3, this.d - this.h);
            return;
        }
        if ((f3 -= this.g) < this.h) {
            this.updatePosition(this.c - this.g, this.d - this.h + f3);
            return;
        }
        this.updatePosition(this.c - this.g + (f3 -= this.h), this.d);
    }

    private void b(double d2, float f2) {
        IlvRect ilvRect = this.getBoundingBox();
        float f3 = Math.max(this.e, this.f);
        this.a(d2, f3, this.e + f2, this.f + f2, ilvRect.width, ilvRect.height);
    }

    private void a(double d2, double d3, float f2, float f3, float f4, float f5) {
        double d4 = 1.5707963267948966 * d3;
        if (d2 < (double)f5) {
            this.updatePosition(this.c + f2, this.d - (float)d2);
            return;
        }
        if ((d2 -= (double)f5) < d4) {
            double d5 = (double)f2 * Math.cos(d2 / d3);
            double d6 = (double)f3 * Math.sin(d2 / d3);
            this.updatePosition(this.c + (float)d5, this.d - f5 - (float)d6);
            return;
        }
        if ((d2 -= d4) < (double)f4) {
            this.updatePosition(this.c - (float)d2, this.d - f5 - f3);
            return;
        }
        if ((d2 -= (double)f4) < d4) {
            double d7 = (double)f2 * Math.sin(d2 / d3);
            double d8 = (double)f3 * Math.cos(d2 / d3);
            this.updatePosition(this.c - f4 - (float)d7, this.d - f5 - (float)d8);
            return;
        }
        if ((d2 -= d4) < (double)f5) {
            this.updatePosition(this.c - f4 - f2, this.d - f5 + (float)d2);
            return;
        }
        if ((d2 -= (double)f5) < d4) {
            double d9 = (double)f2 * Math.cos(d2 / d3);
            double d10 = (double)f3 * Math.sin(d2 / d3);
            this.updatePosition(this.c - f4 - (float)d9, this.d + (float)d10);
            return;
        }
        if ((d2 -= d4) < (double)f4) {
            this.updatePosition(this.c - f4 + (float)d2, this.d + f3);
            return;
        }
        double d11 = (double)f2 * Math.sin((d2 -= (double)f4) / d3);
        double d12 = (double)f3 * Math.cos(d2 / d3);
        this.updatePosition(this.c + (float)d11, this.d + (float)d12);
    }

    public void setTowardsPreferredPosition(double d2, float f2, int n2, int n3) {
        double d3;
        double d4;
        double d5;
        double d6;
        while (d2 < 0.0) {
            d2 += this.maxPathLocation;
        }
        while (d2 > this.maxPathLocation) {
            d2 -= this.maxPathLocation;
        }
        while (f2 < 0.0f) {
            f2 += this.maxDistFromPath;
        }
        float f3 = f2 - (float)(n2 + 1) / (float)n3 * (f2 - this.j);
        double d7 = d2 > this.i ? ((d6 = d2 - this.i) < (d5 = this.maxPathLocation - d2 + this.i) ? d2 - (double)(n2 + 1) * d6 / (double)n3 : d2 + (double)(n2 + 1) * d5 / (double)n3) : ((d4 = this.i - d2) < (d3 = this.maxPathLocation - this.i + d2) ? d2 + (double)(n2 + 1) * d4 / (double)n3 : d2 - (double)(n2 + 1) * d3 / (double)n3);
        this.setPosition(d7, f3);
    }

    public double getPreferredPathLocation() {
        return this.i;
    }

    public boolean considerObstacle(Object object) {
        return object != this.a;
    }

    public void setRelatedObstacle(Object object) {
        this.a = object;
    }

    public final Object getRelatedObstacle() {
        return this.a;
    }

    public void setReferencePoint(IlvPoint ilvPoint) {
        this.b = this.a(ilvPoint);
    }

    public final IlvPoint getReferencePoint() {
        return this.a(this.b);
    }

    private IlvPoint a(IlvPoint ilvPoint) {
        if (ilvPoint == null) {
            return null;
        }
        return new IlvPoint(ilvPoint);
    }

    public void setShape(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Illegal shape " + n2);
        }
        this.l = n2;
    }

    public final int getShape() {
        return this.l;
    }

    public void setHalfWidth(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("The half width must be positive");
        }
        this.e = f2;
    }

    public final float getHalfWidth() {
        return this.e;
    }

    public void setHalfHeight(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("The half height must be positive");
        }
        this.f = f2;
    }

    public final float getHalfHeight() {
        return this.f;
    }

    public void setPreferredDistFromPath(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("The preferred distance must be positive");
        }
        this.j = f2;
    }

    public final float getPreferredDistFromPath() {
        return this.j;
    }

    public void setMaxDistFromPath(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("The maximal distance must be positive");
        }
        this.maxDistFromPath = f2;
    }

    public final float getMaxDistFromPath() {
        return this.maxDistFromPath;
    }

    public void setPreferredDirection(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal direction " + n2);
            }
        }
        this.k = n2;
    }

    public final int getPreferredDirection() {
        return this.k;
    }

    public IlvAnnealingPointLabelDescriptor(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        super(null);
        try {
            this.a = ilvInputStream.readObject("relatedObstacle");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.a = null;
        }
        try {
            this.b = ilvInputStream.readPoint("referencePoint");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.b = null;
        }
        this.l = ilvInputStream.readInt("shape");
        this.e = ilvInputStream.readFloat("halfWidth");
        this.f = ilvInputStream.readFloat("halfHeight");
        this.maxDistFromPath = ilvInputStream.readFloat("maxDistFromPath");
        this.j = ilvInputStream.readFloat("preferredDistFromPath");
        this.k = ilvInputStream.readInt("preferredDirection");
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        if (this.a != null && this.a instanceof IlvGraphic) {
            ilvOutputStream.write("relatedObstacle", (IlvGraphic)this.a);
        }
        if (this.b != null) {
            ilvOutputStream.write("referencePoint", this.b);
        }
        ilvOutputStream.write("shape", this.l);
        ilvOutputStream.write("halfWidth", this.e);
        ilvOutputStream.write("halfHeight", this.f);
        ilvOutputStream.write("maxDistFromPath", this.maxDistFromPath);
        ilvOutputStream.write("preferredDistFromPath", this.j);
        ilvOutputStream.write("preferredDirection", this.k);
    }
}

