/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.svg.css;

import ilog.views.svg.css.Declaration;
import ilog.views.svg.css.PrimitiveValue;
import ilog.views.svg.css.ValueList;
import java.awt.Color;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.w3c.dom.css.CSSValue;

class CSS2ValueFactory {
    private static String a = "inherit";
    private static CSSValue b = new CSSValue(){

        public String getCssText() {
            return a;
        }

        public void setCssText(String string) {
            throw new RuntimeException("Not supported");
        }

        public short getCssValueType() {
            return 0;
        }
    };
    protected static HashMap _colors = new HashMap(50);

    CSS2ValueFactory() {
    }

    public CSSValue createCSSValue(Declaration declaration) {
        return this.createCSSValue(declaration.getPropertyValue(), declaration.getPropertyName());
    }

    public CSSValue createCSSValue(String string, String string2) {
        if (string2.equals(a)) {
            return b;
        }
        return this.createCSSValueImp(string, string2);
    }

    protected CSSValue createCSSValueImp(String string, String string2) {
        if (string == "color") {
            return this.createColor(string2.toLowerCase().intern());
        }
        if (string == "font-family") {
            return this.createListOfIdendifiers(string2);
        }
        if (string == "font-size") {
            return this.createFontSize(string2);
        }
        if (string == "font-stretch") {
            return this.createIdentifier(string2);
        }
        if (string == "font-style") {
            return this.createIdentifier(string2);
        }
        if (string == "font-variant") {
            return this.createIdentifier(string2);
        }
        if (string == "font-weight") {
            return this.createIdentifier(string2);
        }
        if (string == "cursor" || string == "font") {
            return this.createString(string2);
        }
        return this.createString(string2);
    }

    private static int a(String string) {
        float f2 = Float.parseFloat(string);
        if (f2 < 0.0f) {
            return 0;
        }
        if (f2 > 100.0f) {
            return 255;
        }
        return (int)Math.floor(255.0f * f2 / 100.0f);
    }

    protected CSSValue createColor(String string) {
        Color color = null;
        PrimitiveValue primitiveValue = null;
        int n2 = string.length();
        if (string.charAt(0) == '#') {
            if (n2 == 7) {
                color = new Color(Integer.parseInt(string.substring(1, 3), 16), Integer.parseInt(string.substring(3, 5), 16), Integer.parseInt(string.substring(5, 7), 16));
                primitiveValue = new PrimitiveValue();
                primitiveValue.d = color;
                primitiveValue.c = (short)25;
                primitiveValue.e = string;
                return primitiveValue;
            }
            if (n2 == 4) {
                String string2 = null;
                string2 = string.substring(1, 2);
                int n3 = Integer.parseInt(string2 + string2, 16);
                string2 = string.substring(2, 3);
                int n4 = Integer.parseInt(string2 + string2, 16);
                string2 = string.substring(3, 4);
                int n5 = Integer.parseInt(string2 + string2, 16);
                primitiveValue = new PrimitiveValue();
                primitiveValue.d = new Color(n3, n4, n5);
                primitiveValue.c = (short)25;
                primitiveValue.e = string;
                return primitiveValue;
            }
        } else {
            if (string.startsWith("rgb")) {
                int n6;
                int n7;
                int n8;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "() ,");
                stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (string3.indexOf(37) == -1) {
                    n8 = Integer.parseInt(string3);
                    if (n8 > 255) {
                        n8 = 255;
                    } else if (n8 < 0) {
                        n8 = 0;
                    }
                } else {
                    n8 = CSS2ValueFactory.a(string3.substring(0, string3.length() - 1));
                }
                string3 = stringTokenizer.nextToken();
                if (string3.indexOf(37) == -1) {
                    n7 = Integer.parseInt(string3);
                    if (n7 > 255) {
                        n7 = 255;
                    } else if (n7 < 0) {
                        n7 = 0;
                    }
                } else {
                    n7 = CSS2ValueFactory.a(string3.substring(0, string3.length() - 1));
                }
                string3 = stringTokenizer.nextToken();
                if (string3.indexOf(37) == -1) {
                    n6 = Integer.parseInt(string3);
                    if (n6 > 255) {
                        n6 = 255;
                    } else if (n6 < 0) {
                        n6 = 0;
                    }
                } else {
                    n6 = CSS2ValueFactory.a(string3.substring(0, string3.length() - 1));
                }
                primitiveValue = new PrimitiveValue();
                primitiveValue.d = new Color(n8, n7, n6);
                primitiveValue.c = (short)25;
                primitiveValue.e = string;
                return primitiveValue;
            }
            color = (Color)_colors.get(string);
            if (color != null) {
                primitiveValue = new PrimitiveValue();
                primitiveValue.d = color;
                primitiveValue.c = (short)25;
                primitiveValue.e = string;
                return primitiveValue;
            }
        }
        return null;
    }

    protected CSSValue createIdentifier(String string) {
        PrimitiveValue primitiveValue = new PrimitiveValue();
        primitiveValue.c = (short)21;
        primitiveValue.a = string.toLowerCase().intern();
        primitiveValue.e = string;
        return primitiveValue;
    }

    protected CSSValue createString(String string) {
        PrimitiveValue primitiveValue = new PrimitiveValue();
        primitiveValue.c = (short)19;
        primitiveValue.a = string;
        primitiveValue.e = string;
        return primitiveValue;
    }

    protected CSSValue createLength(String string) {
        PrimitiveValue primitiveValue = new PrimitiveValue();
        primitiveValue.c = 1;
        primitiveValue.a = string;
        primitiveValue.e = string;
        try {
            primitiveValue.b = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            primitiveValue.b = -2.1474836E9f;
        }
        return primitiveValue;
    }

    protected CSSValue createNumber(String string) {
        return this.createLength(string);
    }

    protected CSSValue createFontSize(String string) {
        if (Character.isDigit(string.charAt(0))) {
            return this.createLength(string);
        }
        return this.createIdentifier(string);
    }

    protected CSSValue createListOfIdendifiers(String string) {
        if (string.indexOf(44) == -1) {
            return this.createIdentifier(string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ValueList valueList = new ValueList();
        valueList.a = string;
        while (stringTokenizer.hasMoreTokens()) {
            valueList.addItem(this.createIdentifier(stringTokenizer.nextToken()));
        }
        return valueList;
    }

    static {
        _colors.put("black", Color.black);
        _colors.put("silver", Color.lightGray);
        _colors.put("gray", Color.gray);
        _colors.put("white", Color.white);
        _colors.put("maroon", new Color(128, 0, 0));
        _colors.put("red", Color.red);
        _colors.put("purple", new Color(128, 0, 128));
        _colors.put("green", new Color(0, 128, 0));
        _colors.put("lime", Color.green);
        _colors.put("olive", new Color(128, 128, 0));
        _colors.put("yellow", Color.yellow);
        _colors.put("navy", new Color(0, 0, 128));
        _colors.put("blue", Color.blue);
        _colors.put("teal", new Color(0, 128, 128));
        _colors.put("aqua", new Color(0, 255, 255));
    }
}

