/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.print;

import ilog.views.util.print.IlvFlowGraphicAttribute;
import ilog.views.util.print.IlvFlowObject;
import ilog.views.util.print.IlvPage;
import ilog.views.util.print.IlvPrintableDocument;
import ilog.views.util.print.IlvPrintableText;
import ilog.views.util.print.MutableAttributedString;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.font.GraphicAttribute;
import java.awt.font.ImageGraphicAttribute;
import java.awt.font.TextAttribute;
import java.util.ArrayList;

public class IlvFlow {
    private boolean a;
    private IlvPrintableDocument b;
    private ArrayList c = new ArrayList();
    private static final TextStyle d = new TextStyle();
    public static final int BOTTOM_ALIGNMENT = -2;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;
    public static final int ROMAN_BASELINE = 0;
    public static final int TOP_ALIGNMENT = -1;

    IlvFlow(IlvPrintableDocument ilvPrintableDocument) {
        this.b = ilvPrintableDocument;
        this.a = true;
    }

    public IlvPrintableDocument getDocument() {
        return this.b;
    }

    public void invalidate() {
        this.a = false;
    }

    public boolean isValid() {
        return this.a;
    }

    public void layout() {
        IlvPage ilvPage = null;
        if (this.a) {
            return;
        }
        TextStyle textStyle = d;
        int n2 = d.getAlignment();
        this.b.removeAll();
        IlvPrintableText ilvPrintableText = null;
        int n3 = this.c.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object;
            Object e2 = this.c.get(i2);
            if (e2 instanceof GraphicAttribute) {
                if (e2 instanceof IlvFlowGraphicAttribute) {
                    ((IlvFlowGraphicAttribute)e2).computeSize();
                }
                object = new MutableAttributedString("X");
                ((MutableAttributedString)object).addAttribute(TextAttribute.CHAR_REPLACEMENT, (GraphicAttribute)e2, 0, 1);
                while (object != null) {
                    if (ilvPrintableText == null) {
                        ilvPrintableText = new IlvPrintableText(this.b.getImageableBounds(), n2);
                        if (ilvPage == null) {
                            ilvPage = new IlvPage();
                        }
                        ilvPage.addPrintableObject(ilvPrintableText);
                    }
                    if ((object = ilvPrintableText.add((MutableAttributedString)object)) == null) continue;
                    if (ilvPage != null) {
                        this.b.addPage(ilvPage);
                    }
                    ilvPage = null;
                    ilvPrintableText = null;
                }
                continue;
            }
            if (e2 instanceof PageBreak) {
                if (ilvPage != null) {
                    this.b.addPage(ilvPage);
                }
                ilvPage = null;
                ilvPrintableText = null;
                n2 = textStyle.getAlignment();
                continue;
            }
            if (e2 instanceof LineBreak) {
                if (ilvPrintableText == null) {
                    ilvPrintableText = new IlvPrintableText(this.b.getImageableBounds(), n2);
                    if (ilvPage == null) {
                        ilvPage = new IlvPage();
                    }
                    ilvPage.addPrintableObject(ilvPrintableText);
                }
                if (ilvPrintableText.newLine(textStyle.getAlignment(), textStyle.getFont())) {
                    if (ilvPage != null) {
                        this.b.addPage(ilvPage);
                    }
                    ilvPage = null;
                    ilvPrintableText = null;
                }
                n2 = textStyle.getAlignment();
                continue;
            }
            if (e2 instanceof String) {
                object = (String)e2;
                MutableAttributedString mutableAttributedString = new MutableAttributedString((String)object);
                mutableAttributedString.addAttribute(TextAttribute.FONT, textStyle.getFont(), 0, ((String)object).length());
                mutableAttributedString.addAttribute(TextAttribute.FOREGROUND, textStyle.getForeground(), 0, ((String)object).length());
                mutableAttributedString.addAttribute(TextAttribute.BACKGROUND, textStyle.getBackground(), 0, ((String)object).length());
                if (textStyle.isUnderline()) {
                    mutableAttributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, 0, ((String)object).length());
                }
                if (textStyle.getSuperscript() != 0) {
                    mutableAttributedString.addAttribute(TextAttribute.SUPERSCRIPT, new Integer(textStyle.getSuperscript()), 0, ((String)object).length());
                }
                if (textStyle.isStrikeThrough()) {
                    mutableAttributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, 0, ((String)object).length());
                }
                while (mutableAttributedString != null) {
                    if (ilvPrintableText == null) {
                        ilvPrintableText = new IlvPrintableText(this.b.getImageableBounds(), n2);
                        if (ilvPage == null) {
                            ilvPage = new IlvPage();
                        }
                        ilvPage.addPrintableObject(ilvPrintableText);
                    }
                    if ((mutableAttributedString = ilvPrintableText.add(mutableAttributedString)) == null) continue;
                    if (ilvPage != null) {
                        this.b.addPage(ilvPage);
                    }
                    ilvPage = null;
                    ilvPrintableText = null;
                }
                continue;
            }
            if (!(e2 instanceof TextStyle)) continue;
            textStyle = (TextStyle)e2;
            if (this.getDocument().getNumberOfPages() != 0) continue;
            n2 = textStyle.getAlignment();
        }
        if (ilvPage != null) {
            this.b.addPage(ilvPage);
        }
        this.a = true;
    }

    public void setTextStyle(TextStyle textStyle) {
        this.c.add(textStyle.clone());
        this.invalidate();
    }

    public void add(String string) {
        this.c.add(string);
        this.invalidate();
    }

    public void add(Image image, int n2) {
        this.c.add(new ImageGraphicAttribute(image, n2));
        this.invalidate();
    }

    public void add(IlvFlowObject ilvFlowObject, int n2) {
        this.c.add(new IlvFlowGraphicAttribute(ilvFlowObject, n2));
        this.invalidate();
    }

    public void newLine() {
        this.c.add(LineBreak.a());
        this.invalidate();
    }

    public void newPage() {
        this.c.add(PageBreak.a());
        this.invalidate();
    }

    private static class LineBreak {
        static LineBreak a;

        private LineBreak() {
        }

        static LineBreak a() {
            if (a == null) {
                a = new LineBreak();
            }
            return a;
        }
    }

    private static class PageBreak {
        static PageBreak a;

        private PageBreak() {
        }

        static PageBreak a() {
            if (a == null) {
                a = new PageBreak();
            }
            return a;
        }
    }

    public static final class TextStyle
    implements Cloneable {
        public static final int LEFT_ALIGNMENT = 0;
        public static final int CENTER_ALIGNMENT = 1;
        public static final int RIGHT_ALIGNMENT = 2;
        public static final int JUSTIFY_ALIGNMENT = 3;
        private static Font a = new Font("SansSerif", 0, 10);
        private Color b = Color.black;
        private Color c = Color.white;
        private Font d = a;
        private boolean e;
        private boolean f;
        private int g = 0;
        private int h = 0;

        public Color getForeground() {
            return this.b;
        }

        public void setForeground(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("color should not be null");
            }
            this.b = color;
        }

        public Color getBackground() {
            return this.c;
        }

        public void setBackground(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("color should not be null");
            }
            this.c = color;
        }

        public void setFont(Font font) {
            if (font == null) {
                throw new IllegalArgumentException("font should not be null");
            }
            this.d = font;
        }

        public Font getFont() {
            return this.d;
        }

        public void setAlignment(int n2) {
            if (n2 != 1 && n2 != 0 && n2 != 2 && n2 != 3) {
                throw new IllegalArgumentException("bad alignement");
            }
            this.h = n2;
        }

        public int getAlignment() {
            return this.h;
        }

        public void setUnderline(boolean bl) {
            this.f = bl;
        }

        public boolean isUnderline() {
            return this.f;
        }

        public void setSuperscript(int n2) {
            this.g = n2;
        }

        public int getSuperscript() {
            return this.g;
        }

        public void setStrikeThrough(boolean bl) {
            this.e = bl;
        }

        public boolean isStrikeThrough() {
            return this.e;
        }

        public Object clone() {
            TextStyle textStyle = new TextStyle();
            textStyle.setFont(this.getFont());
            textStyle.setForeground(this.getForeground());
            textStyle.setBackground(this.getBackground());
            textStyle.setStrikeThrough(this.isStrikeThrough());
            textStyle.setUnderline(this.isUnderline());
            textStyle.setSuperscript(this.getSuperscript());
            textStyle.setAlignment(this.getAlignment());
            return textStyle;
        }
    }
}

