/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ANS;

import cerent.cms.idl.OpticsTopology.eOrigin;
import cerent.cms.idl.OpticsTopology.eParCalcInfo;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ANSNode {
    protected boolean dirty = false;
    protected final String name;
    protected eOrigin origin = eOrigin.ORI_DEFAULT;
    protected eParCalcInfo info = eParCalcInfo.INFO_OK;
    private ANSNode parent = null;
    private final List<ANSNode> children;

    public ANSNode(String string) {
        this(string, null, new ArrayList<ANSNode>());
    }

    public ANSNode(String string, ANSNode aNSNode) {
        this(string, aNSNode, new ArrayList<ANSNode>());
    }

    public ANSNode(String string, ANSNode aNSNode, ArrayList<ANSNode> arrayList) {
        this.name = string;
        this.parent = aNSNode;
        this.children = arrayList;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        if (this.parent == null) {
            return this.name;
        }
        if (this.parent.getParent() == null) {
            return this.name;
        }
        return this.parent.getFullName() + "." + this.name;
    }

    public ANSNode getParent() {
        return this.parent;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty() {
        if (!this.dirty) {
            this.dirty = true;
            if (this.parent != null) {
                this.parent.setDirty();
            }
        }
    }

    public void resetDirty() {
        if (this.dirty) {
            this.dirty = false;
            for (ANSNode aNSNode : this.children) {
                aNSNode.resetDirty();
            }
        }
    }

    protected void recalcDirty() {
        this.dirty = false;
        for (ANSNode aNSNode : this.children) {
            if (!aNSNode.isDirty()) continue;
            this.setDirty();
        }
        if (this.parent != null && !this.dirty) {
            this.parent.recalcDirty();
        }
    }

    public eOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(eOrigin eOrigin2) {
        this.origin = eOrigin2;
        if (this.parent != null) {
            this.parent.setOrigin(eOrigin2);
        }
    }

    public eParCalcInfo getInfo() {
        return this.info;
    }

    public void setInfo(eParCalcInfo eParCalcInfo2) {
        this.info = eParCalcInfo2;
        if (this.parent != null && eParCalcInfo2 != eParCalcInfo.INFO_OK) {
            this.parent.setInfo(eParCalcInfo2);
        }
    }

    public void setParent(ANSNode aNSNode) {
        this.parent = aNSNode;
    }

    public ANSNode[] getChildren() {
        return this.children.toArray(new ANSNode[0]);
    }

    public ANSNode getChildOfKey(String string) {
        for (ANSNode aNSNode : this.children) {
            if (!aNSNode.getName().equals(string)) continue;
            return aNSNode;
        }
        return null;
    }

    public void addChild(ANSNode aNSNode) {
        this.children.add(aNSNode);
        aNSNode.setParent(this);
    }

    public String toString() {
        return this.getName();
    }
}

