/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.sEtherMacAddr;
import cerent.cms.idl.Dwdm.General;
import cerent.cms.idl.Dwdm.eAisSquelchMode;
import cerent.cms.idl.Dwdm.eDataRate;
import cerent.cms.idl.Dwdm.eDwdmFecMode;
import cerent.cms.idl.Dwdm.eDwdmLineType;
import cerent.cms.idl.Dwdm.eMonitorType;
import cerent.cms.idl.Dwdm.ePayloadType;
import cerent.cms.idl.Dwdm.eTermMode;
import cerent.cms.idl.Dwdm.s8B10BPmStats;
import cerent.cms.idl.Dwdm.s8B10BPmThresholds;
import cerent.cms.idl.Dwdm.sDwdmCardConfig;
import cerent.cms.idl.Dwdm.sDwdmLineConfig;
import cerent.cms.idl.Dwdm.sGeneralLineAttributes;
import cerent.cms.idl.Dwdm.sLaserThresholds;
import cerent.cms.idl.Dwdm.sLinePmStats;
import cerent.cms.idl.Dwdm.sOpticsCurrentValues;
import cerent.cms.idl.Dwdm.sOpticsPmStats;
import cerent.cms.idl.Dwdm.xDetailedConfigError;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.EtherMedia.sGmacLineAdminInfo;
import cerent.cms.idl.FCMedia.sFCLineAdminInfo;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.sLineSyncConfig;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.SonetMedia.sLineThresholds;
import cerent.cms.idl.SonetMedia.sSectionThresholds;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AdminState;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitExists;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmOTULineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.IAdminLineAccess;
import cerent.cms.model.IDwdmLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IOpticsPmModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmLineModel;
import cerent.cms.model.InService;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidCardMode;
import cerent.cms.model.InvalidLoopbackProvision;
import cerent.cms.model.InvalidMaxFrameSize;
import cerent.cms.model.InvalidQuality;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OhCircuitType;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SyncProvBusy;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmLineStats;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.YCableModel;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.UserException;

public abstract class AbstractDwdmLineModel
extends InterfaceModel
implements IDwdmLineModel,
IOpticsPmModel,
IAdminLineAccess {
    static Map portRateMap = null;
    private LaserTCAThresholds laserTCATh;
    private LaserAlmThresholds laserAlmTh;
    private DwdmLineStats dwdmLineStats;
    private OpticsStats opticsStats;
    private Loopback loopback;
    private LineType lineType;
    private FramingType framingType;
    private PayloadDataType payloadDataType;
    private TermMode termMode;
    private AisSquelchMode aisSquelchMode;
    private MacAddr macAddr;
    private Dwdm8B10BStats dwdm8B10BStats;
    private Dwdm8B10BThresholds dwdm8B10BTh;
    private ClientInterface clientInterface;
    private OTNInterface otnInterface;
    private CardConfig dwdmCardConfig;
    private DwdmLineConfig dwdmLineConfig;
    private CurrentValues currentValues;
    public static final int PM_THRESHOLDS_VALIDATION_GROUP = 0;
    public static final int FEC_THRESHOLDS_VALIDATION_GROUP = 1;
    public static final int OTN_THRESHOLDS_VALIDATION_GROUP = 2;
    private static final float ALS_PULSE_WIDTH = 10.0f;

    public AbstractDwdmLineModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2) {
        super(nodeModelDelegate, n, sInterface2, nodeModelDelegate.getChildDebug(AbstractDwdmLineModel.class));
        this.index = n;
        this.laserTCATh = new LaserTCAThresholds("laserTCAThresholds", nodeModelDelegate);
        this.laserAlmTh = new LaserAlmThresholds("laserAlmThresholds", nodeModelDelegate);
        this.dwdmLineStats = new DwdmLineStats("dwdmLineStats", nodeModelDelegate);
        this.opticsStats = new OpticsStats("opticsStats", nodeModelDelegate);
        this.loopback = new Loopback("loopback", nodeModelDelegate);
        this.lineType = new LineType("lineType", nodeModelDelegate);
        this.framingType = new FramingType("framingType", nodeModelDelegate);
        this.payloadDataType = new PayloadDataType("paylaodDataType", nodeModelDelegate);
        this.termMode = new TermMode(nodeModelDelegate, "termMode");
        this.aisSquelchMode = new AisSquelchMode(nodeModelDelegate, "aisSquelchMode");
        this.macAddr = new MacAddr(nodeModelDelegate, "macAddr");
        this.clientInterface = new ClientInterface(nodeModelDelegate, "DwdmCliLineModel::clientInterface");
        this.otnInterface = new OTNInterface(nodeModelDelegate, "DwdmCliLineModel::otnInterface");
        this.dwdm8B10BTh = new Dwdm8B10BThresholds("dwdm8B10BThresholds", nodeModelDelegate);
        this.dwdm8B10BStats = new Dwdm8B10BStats("dwdm8B10BStats", nodeModelDelegate);
        this.dwdmCardConfig = new CardConfig("dwdmCardConfig", nodeModelDelegate);
        this.dwdmLineConfig = new DwdmLineConfig("dwdmLineConfig", nodeModelDelegate);
        this.currentValues = new CurrentValues(nodeModelDelegate, "currentValues");
    }

    public void dispose() {
        this.loopback.dispose();
        this.lineType.dispose();
        this.framingType.dispose();
        this.payloadDataType.dispose();
        this.termMode.dispose();
        this.aisSquelchMode.dispose();
        this.macAddr.dispose();
        this.dwdmCardConfig.dispose();
        super.dispose();
    }

    protected void updateLocal(long l) {
        this.lineType.update();
        this.loopback.update();
        this.framingType.update();
        this.payloadDataType.update();
        this.termMode.update();
        this.aisSquelchMode.update();
        this.macAddr.update();
        this.dwdmCardConfig.update();
        this.dwdmLineConfig.update();
        this.clientInterface.update();
        this.otnInterface.update();
        super.updateLocal(l);
    }

    public static int mapFramingType(int n) {
        switch (n) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 37: {
                return 1;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 36: {
                return 0;
            }
            case 9: {
                return 2;
            }
            case 38: {
                return 6;
            }
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 30: 
            case 39: {
                return 3;
            }
            case 27: {
                return 4;
            }
        }
        return 5;
    }

    public int getFramingType() throws NoSuchInterface, WrongInterfaceType {
        int n = 0;
        n = this.getDataRate();
        return AbstractDwdmLineModel.mapFramingType(n);
    }

    public void setLoopback(eLoopback eLoopback2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        try {
            this.loopback.set(eLoopback2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (UserException userException) {
            throw this.doUnknown("setLoopback", userException);
        }
    }

    public eLoopback getLoopback() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eLoopback)this.loopback.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getLoopback", userException);
        }
    }

    public void setLoopbackAsInt(int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        this.setLoopback(eLoopback.from_int(n));
    }

    public int getLoopbackAsInt() throws NoSuchInterface, WrongInterfaceType {
        return this.getLoopback().value();
    }

    public boolean supportsAINS() {
        boolean bl;
        block5: {
            bl = true;
            try {
                int n = this.getDataRate();
                switch (n) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 20: 
                    case 28: 
                    case 34: 
                    case 35: {
                        bl = false;
                    }
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block5;
                this.db.println("Exception occurred retrieving a Dwdm Line's data rate.");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return bl;
    }

    public void setAdminStateNoLpbk(eAdminState eAdminState2) throws NoSuchInterface, UnsupportedOperation, LoopbackActive, WrongInterfaceType, DetailedConfigError, SyncProvError, InvalidState, InvalidLoopbackProvision, ProvisionError {
        if (this.getLoopbackAsInt() != 0 && !AdminState.admitsLoopback(eAdminState2)) {
            this.setLoopback(eLoopback.NO_LOOPBACK);
        }
        this.setAdminState(eAdminState2);
    }

    public eDwdmLineType getLineType() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eDwdmLineType)this.lineType.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getLineType", userException);
        }
    }

    public void setPayloadType(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            this.framingType.set(ePayloadType.from_int(n));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setPayloadType", userException);
        }
    }

    public void setPayloadTypeEnum(ePayloadType ePayloadType2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        this.setPayloadType(ePayloadType2.value());
    }

    public int getPayloadType() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((ePayloadType)this.framingType.get()).value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPayloadType", userException);
        }
    }

    public ePayloadType getPayloadTypeEnum() throws NoSuchInterface, WrongInterfaceType {
        return ePayloadType.from_int(this.getPayloadType());
    }

    public void setDataRate(int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        this.setDataRateEnum(eDataRate.from_int(n));
    }

    public void setDataRateEnum(eDataRate eDataRate2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        try {
            this.payloadDataType.set(eDataRate2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (UserException userException) {
            throw this.doUnknown("setPayloadType", userException);
        }
    }

    public int getDataRate() throws NoSuchInterface, WrongInterfaceType {
        return this.getDataRateEnum().value();
    }

    public eDataRate getDataRateEnum() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eDataRate)this.payloadDataType.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setPayloadType", userException);
        }
    }

    public eEqType getEqTypeFromDataRate() throws NoSuchInterface, WrongInterfaceType {
        this.db.fine("getEqTypeFromDataRate() : dataRate " + this.getDataRate());
        return AbstractDwdmLineModel.getEqTypeFromDataRate(this.getDataRate());
    }

    public static eEqType getEqTypeFromDataRate(int n) {
        eEqType eEqType2;
        if (portRateMap == null) {
            portRateMap = new HashMap();
            portRateMap.put(String.valueOf(0), eEqType.OC3_PORT);
            portRateMap.put(String.valueOf(1), eEqType.OC12_PORT);
            portRateMap.put(String.valueOf(2), eEqType.OC48_PORT);
            portRateMap.put(String.valueOf(3), eEqType.OC192_PORT);
            portRateMap.put(String.valueOf(36), eEqType.OC768_PORT);
            portRateMap.put(String.valueOf(30), eEqType.FE_PORT);
            portRateMap.put(String.valueOf(8), eEqType.ONE_GE_PORT);
            portRateMap.put(String.valueOf(9), eEqType.TEN_GE_PORT);
            portRateMap.put(String.valueOf(38), eEqType.FORTY_GE_PORT);
            portRateMap.put(String.valueOf(12), eEqType.ESCON_PORT);
            portRateMap.put(String.valueOf(13), eEqType.DV6000_PORT);
            portRateMap.put(String.valueOf(14), eEqType.SDI_D1_VIDEO_PORT);
            portRateMap.put(String.valueOf(15), eEqType.HDTV_PORT);
            portRateMap.put(String.valueOf(16), eEqType.PASS_THRU_PORT);
            portRateMap.put(String.valueOf(20), eEqType.ETR_CLO_PORT);
            portRateMap.put(String.valueOf(21), eEqType.ISC_PORT);
            portRateMap.put(String.valueOf(35), eEqType.ISC1_PORT);
            portRateMap.put(String.valueOf(22), eEqType.ISC3_PORT);
            portRateMap.put(String.valueOf(29), eEqType.IB_PORT);
            portRateMap.put(String.valueOf(39), eEqType.IB_5G_PORT);
            portRateMap.put(String.valueOf(10), eEqType.FC1G_PORT);
            portRateMap.put(String.valueOf(11), eEqType.FC2G_PORT);
            portRateMap.put(String.valueOf(17), eEqType.FC10G_PORT);
            portRateMap.put(String.valueOf(18), eEqType.FICON1G_PORT);
            portRateMap.put(String.valueOf(19), eEqType.FICON2G_PORT);
            portRateMap.put(String.valueOf(23), eEqType.FC4G_PORT);
            portRateMap.put(String.valueOf(24), eEqType.FICON4G_PORT);
            portRateMap.put(String.valueOf(25), eEqType.ISC3_1G_PORT);
            portRateMap.put(String.valueOf(26), eEqType.ISC3_2G_PORT);
            portRateMap.put(String.valueOf(27), eEqType.OTU2_PORT);
            portRateMap.put(String.valueOf(4), eEqType.OC3_PORT);
            portRateMap.put(String.valueOf(5), eEqType.OC12_PORT);
            portRateMap.put(String.valueOf(6), eEqType.OC48_PORT);
            portRateMap.put(String.valueOf(7), eEqType.OC192_PORT);
            portRateMap.put(String.valueOf(37), eEqType.OC768_PORT);
            portRateMap.put(String.valueOf(34), eEqType.DVB_ASI_PORT);
        }
        return (eEqType2 = (eEqType)portRateMap.get(String.valueOf(n))) == null ? eEqType.INVALID : eEqType2;
    }

    public sLaserThresholds getOpticsTCAThresholds(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        try {
            return (sLaserThresholds)this.laserTCATh.get(eIntervalType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsTCAThresholds", userException);
        }
    }

    public void setOpticsTCAThresholds(sLaserThresholds sLaserThresholds2, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{sLaserThresholds2, eIntervalType2};
            this.laserTCATh.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setOpticsTCAThresholds", userException);
        }
    }

    public sLaserThresholds getOpticsAlmThresholds() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        try {
            return (sLaserThresholds)this.laserAlmTh.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsTCAThresholds", userException);
        }
    }

    public void setOpticsAlmThresholds(sLaserThresholds sLaserThresholds2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            this.laserAlmTh.set(sLaserThresholds2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setOpticsTCAThresholds", userException);
        }
    }

    public void clearStats(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            this.dwdmLineStats.set(eIntervalType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearStats", userException);
        }
    }

    public sLinePmStats getStats(boolean bl, eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, new Short(s)};
            sLinePmStats sLinePmStats2 = (sLinePmStats)this.dwdmLineStats.get(objectArray);
            return sLinePmStats2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getStats", userException);
        }
    }

    public void clearOpticsStats(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            this.opticsStats.set(eIntervalType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearOpticsStats", userException);
        }
    }

    public sOpticsCurrentValues getOpticsCurrentValues() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        try {
            return (sOpticsCurrentValues)this.currentValues.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getCliCurrentValues", userException);
        }
    }

    public sOpticsPmStats getOpticsStats(eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[3];
            objectArray[0] = eIntervalType2;
            objectArray[1] = new Short(s);
            sOpticsPmStats sOpticsPmStats2 = (sOpticsPmStats)this.opticsStats.get(objectArray);
            return sOpticsPmStats2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsStats", userException);
        }
    }

    public s8B10BPmThresholds get8B10BThresholds(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType {
        try {
            return (s8B10BPmThresholds)this.dwdm8B10BTh.get(eIntervalType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("get8B10BThresholds", userException);
        }
    }

    public void set8B10BThresholds(s8B10BPmThresholds s8B10BPmThresholds2, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{s8B10BPmThresholds2, eIntervalType2};
            this.dwdm8B10BTh.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("set8B10BThresholds", userException);
        }
    }

    public void clear8B10BStats(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            this.dwdm8B10BStats.set(eIntervalType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clear8B10BStats", userException);
        }
    }

    public s8B10BPmStats get8B10BStats(eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[3];
            objectArray[0] = eIntervalType2;
            objectArray[1] = new Short(s);
            s8B10BPmStats s8B10BPmStats2 = (s8B10BPmStats)this.dwdm8B10BStats.get(objectArray);
            return s8B10BPmStats2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("get8B10BStats", userException);
        }
    }

    public short getBerLevel() throws NoSuchInterface, WrongInterfaceType {
        return this.getTdmLineModel().getBerLevel();
    }

    public short getSdBerLevel() throws NoSuchInterface, WrongInterfaceType {
        return this.getTdmLineModel().getSdBerLevel();
    }

    public void setSdBerLevel(short s) throws NoSuchInterface, WrongInterfaceType, ConfigError, EMCProvisionError {
        this.getTdmLineModel().setSdBerLevel(s);
    }

    public short getSfBerLevel() throws NoSuchInterface, WrongInterfaceType {
        return this.getTdmLineModel().getSfBerLevel();
    }

    public void setSfBerLevel(short s) throws NoSuchInterface, WrongInterfaceType, ConfigError, EMCProvisionError {
        this.getTdmLineModel().setSfBerLevel(s);
    }

    public void clearSonetStats(boolean bl, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.getTdmLineModel().clearStats(bl, eIntervalType2);
    }

    public TdmLineStats getSonetStats(boolean bl, eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        return this.getTdmLineModel().getStats(bl, eIntervalType2, s);
    }

    public void setAttributes(sGeneralLineAttributes sGeneralLineAttributes2, long l) {
        super.setAttributes(sGeneralLineAttributes2.base, l);
    }

    public void getPmThresholds(boolean bl, eIntervalType eIntervalType2, sSectionThresholds sSectionThresholds2, sLineThresholds sLineThresholds2) throws NoSuchInterface, WrongInterfaceType {
        this.getTdmLineModel().getPmThresholds(bl, eIntervalType2, sSectionThresholds2, sLineThresholds2);
    }

    public void setPmThresholds(boolean bl, eIntervalType eIntervalType2, sSectionThresholds sSectionThresholds2, sLineThresholds sLineThresholds2) throws NoSuchInterface, WrongInterfaceType, ConfigError, EMCProvisionError {
        this.getTdmLineModel().setPmThresholds(bl, eIntervalType2, sSectionThresholds2, sLineThresholds2);
    }

    public sLineThresholds getLinePmThresholds(eIntervalType eIntervalType2, boolean bl) throws NoSuchInterface, WrongInterfaceType {
        return this.getTdmLineModel().getLinePmThresholds(eIntervalType2, bl);
    }

    public sSectionThresholds getSectionPmThresholds(eIntervalType eIntervalType2, boolean bl) throws NoSuchInterface, WrongInterfaceType {
        return this.getTdmLineModel().getSectionPmThresholds(eIntervalType2, bl);
    }

    public void setLinePmThresholds(eIntervalType eIntervalType2, boolean bl, sLineThresholds sLineThresholds2) throws NoSuchInterface, WrongInterfaceType, ConfigError, EMCProvisionError {
        this.getTdmLineModel().setLinePmThresholds(eIntervalType2, bl, sLineThresholds2);
    }

    public void setSectionPmThresholds(eIntervalType eIntervalType2, boolean bl, sSectionThresholds sSectionThresholds2) throws NoSuchInterface, WrongInterfaceType, ConfigError, EMCProvisionError {
        this.getTdmLineModel().setSectionPmThresholds(eIntervalType2, bl, sSectionThresholds2);
    }

    public boolean isWorkingLine() {
        boolean bl = false;
        try {
            ElementModel elementModel = this.getElementModel();
            if (elementModel instanceof YCableModel) {
                bl = this.getIndex() != ((YCableModel)elementModel).getProtectEntityIndex();
            }
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
        }
        return bl;
    }

    public boolean isDataRateISC() {
        boolean bl = false;
        try {
            if (this.getDataRate() == 22 || this.getDataRate() == 25 || this.getDataRate() == 26) {
                bl = true;
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return bl;
    }

    public boolean isProtectLine() {
        boolean bl = false;
        try {
            ElementModel elementModel = this.getElementModel();
            if (elementModel instanceof YCableModel) {
                bl = this.getIndex() == ((YCableModel)elementModel).getProtectEntityIndex();
            }
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
        }
        return bl;
    }

    public boolean isSplitterProtectedLine() {
        boolean bl = false;
        try {
            ElementModel elementModel = this.getElementModel();
            if (elementModel instanceof YCableModel && elementModel.getType() == 5) {
                bl = true;
            }
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
        }
        return bl;
    }

    public boolean isCatinaccioTrunk() {
        boolean bl;
        block3: {
            bl = false;
            try {
                if (this.isTrunk() && this.getModuleModel().getEqType() == 293) {
                    bl = true;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return bl;
    }

    public void setTermMode(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            this.termMode.set(eTermMode.from_int(n));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setTermMode", userException);
        }
    }

    public void setTermModeEnum(eTermMode eTermMode2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        this.setTermMode(eTermMode2.value());
    }

    public int getTermMode() throws NoSuchInterface, WrongInterfaceType {
        int n = 0;
        try {
            n = ((eTermMode)this.termMode.get()).value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getTermMode", userException);
        }
        return n;
    }

    public eAisSquelchMode getAisSquelchMode() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eAisSquelchMode)this.aisSquelchMode.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAisSquelchMode", userException);
        }
    }

    public void setAisSquelchMode(eAisSquelchMode eAisSquelchMode2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            this.aisSquelchMode.set(eAisSquelchMode2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            this.doUnknown("setAisSquelchMode", userException);
        }
    }

    public boolean isSonetSdhPayload() {
        boolean bl = false;
        try {
            bl = this.getPayloadType() == 0 || this.getPayloadType() == 1;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return bl;
    }

    public boolean isTransparent() {
        boolean bl = false;
        try {
            bl = this.getTermMode() == 0;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return bl;
    }

    public boolean isSectionTerminated() {
        boolean bl = false;
        try {
            bl = this.getTermMode() == 1;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return bl;
    }

    public boolean isLineTerminated() {
        boolean bl = false;
        try {
            bl = this.getTermMode() == 2;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return bl;
    }

    public boolean isClient() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Boolean)this.clientInterface.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("isClient", userException);
        }
    }

    public boolean isOTNSupported() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Boolean)this.otnInterface.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("isOTNSupported", userException);
        }
    }

    public eTermMode getTermModeEnum() throws NoSuchInterface, WrongInterfaceType {
        return eTermMode.from_int(this.getTermMode());
    }

    public void setMacAddress(sEtherMacAddr sEtherMacAddr2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            this.macAddr.set(sEtherMacAddr2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setMacAddress", userException);
        }
    }

    public sEtherMacAddr getMacAddress() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sEtherMacAddr)this.macAddr.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getMacAddr", userException);
        }
    }

    public boolean supportsAutoALS() {
        return this.isSonetSdhPayload();
    }

    public boolean supportOpticsMon() {
        return true;
    }

    public boolean supportOHCircuitTypes(OhCircuitType ohCircuitType) throws AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType {
        if (this.isSonetSdhPayload()) {
            eTermMode eTermMode2 = this.getTermModeEnum();
            switch (this.getModuleModel().getEqType()) {
                case 118: {
                    return ohCircuitType.equals((Object)OhCircuitType.LOW_CIRCUIT_OBJ) && eTermMode2 != eTermMode.TERM_TRANSPARENT;
                }
            }
            return ohCircuitType.equals((Object)OhCircuitType.LOW_CIRCUIT_OBJ) && eTermMode2 != eTermMode.TERM_TRANSPARENT || ohCircuitType.equals((Object)OhCircuitType.EOW_CIRCUIT_OBJ) && eTermMode2 == eTermMode.TERM_LINE;
        }
        return false;
    }

    public sLineSyncConfig getSonetConfig() throws NoSuchInterface, UnsupportedOperation, WrongInterfaceType, AbstractCmsNoSuchEntityException {
        return this.getTdmLineModel().getSonetConfig();
    }

    public void setSonetConfig(sLineSyncConfig sLineSyncConfig2) throws NoSuchInterface, UnsupportedOperation, EMCProvisionError, SyncProvBusy, InvalidQuality, WrongInterfaceType, AbstractCmsNoSuchEntityException {
        this.getTdmLineModel().setSonetConfig(sLineSyncConfig2);
    }

    public int getMaxFrame() throws NoSuchInterface, WrongInterfaceType {
        return this.getEtherLineModel().getGmacLineAdminInfo().maxFrame;
    }

    public void setMaxFrame(int n) throws NoSuchInterface, WrongInterfaceType, InvalidMaxFrameSize, InService, EMCProvisionError {
        EtherLineModel etherLineModel = this.getEtherLineModel();
        sGmacLineAdminInfo sGmacLineAdminInfo2 = etherLineModel.getGmacLineAdminInfo();
        sGmacLineAdminInfo2.maxFrame = n;
        etherLineModel.setGmacLineAdminInfo(sGmacLineAdminInfo2);
    }

    public void setDwdmCardConfig(sDwdmCardConfig sDwdmCardConfig2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        try {
            this.dwdmCardConfig.set(sDwdmCardConfig2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (UserException userException) {
            throw this.doUnknown("setDwdmCardConfig", userException);
        }
    }

    public sDwdmCardConfig getDwdmCardConfig() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sDwdmCardConfig)this.dwdmCardConfig.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getDwdmCardConfig", userException);
        }
    }

    public void setDwdmLineConfig(sDwdmLineConfig sDwdmLineConfig2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        try {
            this.dwdmLineConfig.set(sDwdmLineConfig2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (UserException userException) {
            throw this.doUnknown("setDwdmLineConfig", userException);
        }
    }

    public sDwdmLineConfig getDwdmLineConfig() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sDwdmLineConfig)this.dwdmLineConfig.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getDwdmCardConfig", userException);
        }
    }

    private boolean testHigherLayer1(sDwdmCardConfig sDwdmCardConfig2) {
        int n = 0;
        if (n == 3 || n == 5) {
            return true;
        }
        try {
            DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getModuleModel();
            if (dwdmModuleModel.testHigherLayer()) {
                this.db.info("Testing: HigherLayers seems ok! by " + Thread.currentThread());
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.db.info("Testing: HigherLayer has not matured! " + this + " by " + Thread.currentThread());
        return false;
    }

    public InterfaceModel getPayloadModel() {
        InterfaceModel interfaceModel = this.getPayloadModel(this.getHigherLayerModels());
        if (interfaceModel == null) {
            this.updateLayerIndexes();
            interfaceModel = this.getPayloadModel(this.getHigherLayerModels());
        }
        return interfaceModel;
    }

    private InterfaceModel getPayloadModel(InterfaceModel[] interfaceModelArray) {
        return interfaceModelArray != null && interfaceModelArray.length > 0 ? interfaceModelArray[0] : null;
    }

    public ITdmLineModel getITdmLineModel() throws WrongInterfaceType {
        return this.getTdmLineModel();
    }

    public TdmLineModel getTdmLineModel() throws WrongInterfaceType {
        InterfaceModel interfaceModel = this.getPayloadModel();
        if (interfaceModel instanceof TdmLineModel) {
            return (TdmLineModel)interfaceModel;
        }
        throw new WrongInterfaceType("The payload is not SONET/SDH.");
    }

    public DwdmOTULineModel getDwdmOTULineModel() throws WrongInterfaceType {
        InterfaceModel interfaceModel = this.getPayloadModel();
        if (interfaceModel != null && interfaceModel instanceof DwdmOTULineModel) {
            return (DwdmOTULineModel)interfaceModel;
        }
        throw new WrongInterfaceType(ErrorMsg.getString((EID)EMC.EID_PAYLOAD_NOT_OTU2));
    }

    public FcmrLineModel getFcmrLineModel() throws WrongInterfaceType {
        InterfaceModel interfaceModel = this.getPayloadModel();
        if (interfaceModel instanceof FcmrLineModel) {
            return (FcmrLineModel)interfaceModel;
        }
        throw new WrongInterfaceType("The payload is not FC/FICON.");
    }

    protected EtherLineModel getEtherLineModel() throws WrongInterfaceType {
        InterfaceModel interfaceModel = this.getPayloadModel();
        if (interfaceModel instanceof EtherLineModel) {
            return (EtherLineModel)interfaceModel;
        }
        throw new WrongInterfaceType("The payload is not 10G Ethernet.");
    }

    public sFCLineAdminInfo getDistanceExtensionInfo() throws NoSuchInterface, WrongInterfaceType {
        return this.getFcmrLineModel().getFcLineAdminInfo();
    }

    public void setDistanceExtensionInfo(sFCLineAdminInfo sFCLineAdminInfo2) throws NoSuchInterface, WrongInterfaceType, CircuitExists, InvalidState, UnsupportedOperation, InvalidCardMode, ProvisionError {
        this.getFcmrLineModel().setFcLineAdminInfo(sFCLineAdminInfo2);
    }

    private String payloadDataTypeToStr() {
        String string = "";
        eDataRate eDataRate2 = null;
        try {
            eDataRate2 = eDataRate.from_int(this.getDataRate());
        }
        catch (NoSuchInterface noSuchInterface) {
            this.db.severe(noSuchInterface.toString());
            return string;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            this.db.severe(wrongInterfaceType.toString());
            return string;
        }
        IPortModel iPortModel = null;
        try {
            iPortModel = this.getPortModel();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.severe(abstractCmsNoSuchEntityException.toString());
            return string;
        }
        IEntityModel iEntityModel = iPortModel.getParent();
        boolean bl = iEntityModel.getNodeModel().getTdmProtocolTypeObj().isSdh();
        switch (eDataRate2.value()) {
            case 0: 
            case 4: {
                if (bl) {
                    string = "stm1";
                    break;
                }
                string = "oc3";
                break;
            }
            case 1: 
            case 5: {
                if (bl) {
                    string = "stm4";
                    break;
                }
                string = "oc12";
                break;
            }
            case 2: 
            case 6: {
                if (bl) {
                    string = "stm16";
                    break;
                }
                string = "oc48";
                break;
            }
            case 8: {
                string = "1gethernet";
                break;
            }
            case 9: {
                string = "10gethernet";
                break;
            }
            case 10: {
                string = "1gfiberchannel/ficon";
                break;
            }
            case 11: {
                string = "2gfiberchannel/ficon";
                break;
            }
        }
        return string;
    }

    private String endToStr(boolean bl) {
        return bl ? "nearend" : "farend";
    }

    private String intervalToStr(eIntervalType eIntervalType2) {
        return eIntervalType2 == eIntervalType.INTERVAL_15_MIN ? "15min" : "1day";
    }

    private String fecToStr(eDwdmFecMode eDwdmFecMode2) {
        return eDwdmFecMode2 == eDwdmFecMode.STANDARD_FEC ? "standard" : "enhanced";
    }

    private String monitorTypeToStr(eMonitorType eMonitorType2) {
        String string = "";
        switch (eMonitorType2.value()) {
            case 0: {
                string = "sm";
                break;
            }
            case 1: {
                string = "pm";
                break;
            }
        }
        return string;
    }

    private String buildPmThresholdsValidationPrefix(eIntervalType eIntervalType2) {
        return "pmthresholds." + this.payloadDataTypeToStr() + "." + "8b10b" + "." + this.intervalToStr(eIntervalType2) + ".";
    }

    private String buildFecThresholdsValidationPrefix(eIntervalType eIntervalType2) {
        String string = "";
        int n = 0;
        try {
            n = this.getPortModel().getParent().getEqType();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.severe(abstractCmsNoSuchEntityException.toString());
            return string;
        }
        string = n == 120 || n == 121 ? "fecthresholds.trunk." + this.payloadDataTypeToStr() + "." + this.intervalToStr(eIntervalType2) + "." : "fecthresholds.trunk." + this.intervalToStr(eIntervalType2) + ".";
        return string;
    }

    private String newbuildFecThresholdsValidationPrefix(eIntervalType eIntervalType2, eDwdmFecMode eDwdmFecMode2) {
        String string = "";
        int n = 0;
        try {
            n = this.getPortModel().getParent().getEqType();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.severe(abstractCmsNoSuchEntityException.toString());
            return string;
        }
        string = n == 120 || n == 121 ? "otn.fecthresholds." + this.payloadDataTypeToStr() + "." + this.intervalToStr(eIntervalType2) + "." : "otn.fecthresholds." + this.fecToStr(eDwdmFecMode2) + "." + this.intervalToStr(eIntervalType2) + ".";
        return string;
    }

    private String buildOtnThresholdsValidationPrefix(boolean bl, eIntervalType eIntervalType2, eMonitorType eMonitorType2) {
        return "otn.g709thresholds." + this.monitorTypeToStr(eMonitorType2) + "." + this.endToStr(bl) + "." + this.intervalToStr(eIntervalType2) + ".";
    }

    public String getValidationPrefix(int n, eIntervalType eIntervalType2) {
        String string = "";
        switch (n) {
            case 0: {
                string = this.buildPmThresholdsValidationPrefix(eIntervalType2);
                break;
            }
            case 1: {
                string = this.buildFecThresholdsValidationPrefix(eIntervalType2);
            }
        }
        return string.toLowerCase();
    }

    public String getValidationPrefix(int n, eIntervalType eIntervalType2, eDwdmFecMode eDwdmFecMode2) {
        String string = "";
        switch (n) {
            case 0: {
                string = this.buildPmThresholdsValidationPrefix(eIntervalType2);
                break;
            }
            case 1: {
                string = this.newbuildFecThresholdsValidationPrefix(eIntervalType2, eDwdmFecMode2);
            }
        }
        return string.toLowerCase();
    }

    public String getValidationPrefix(int n, boolean bl, eIntervalType eIntervalType2, eMonitorType eMonitorType2) {
        String string = "";
        switch (n) {
            case 2: {
                string = this.buildOtnThresholdsValidationPrefix(bl, eIntervalType2, eMonitorType2);
                break;
            }
        }
        return string.toLowerCase();
    }

    protected abstract boolean isTrunk();

    public boolean supportsTxPower() {
        return true;
    }

    public boolean supportsLaserBias() {
        return true;
    }

    public InterfaceModel getInterfaceModel() {
        return this;
    }

    protected abstract General getDwdmRef();

    public abstract sLaserThresholds getDefaultOpticsThresholds(eIntervalType var1, NeDefaultsModel var2) throws Exception;

    public sLineThresholds getDefaultLinePmThresholds(boolean bl, eIntervalType eIntervalType2, eDwdmLineType eDwdmLineType2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefLineThr(eEqType2, eEqType3, eDwdmLineType2, bl, eIntervalType2);
    }

    public sLineThresholds getDefaultLinePmThresholds(boolean bl, eIntervalType eIntervalType2, eDataRate eDataRate2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefLineThr(eEqType2, eEqType3, eDataRate2, bl, eIntervalType2);
    }

    public sSectionThresholds getDefaultSectionPmThresholds(boolean bl, eIntervalType eIntervalType2, eDwdmLineType eDwdmLineType2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefSectionThr(eEqType2, eEqType3, eDwdmLineType2, bl, eIntervalType2);
    }

    public sSectionThresholds getDefaultSectionPmThresholds(boolean bl, eIntervalType eIntervalType2, eDataRate eDataRate2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefSectionThr(eEqType2, eEqType3, eDataRate2, bl, eIntervalType2);
    }

    class AisSquelchMode
    extends CachedValue {
        public AisSquelchMode(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return AbstractDwdmLineModel.this.getDwdmRef().getAisSquelchMode(AbstractDwdmLineModel.this.getIndex());
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xConfigError, xNoSuchInterface {
            AbstractDwdmLineModel.this.getDwdmRef().setAisSquelchMode(AbstractDwdmLineModel.this.getIndex(), (eAisSquelchMode)object);
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    private class CardConfig
    extends CachedValue {
        public CardConfig(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return AbstractDwdmLineModel.this.getDwdmRef().getDwdmCardConfig(AbstractDwdmLineModel.this.getIndex());
        }

        protected void setValue(Object object) throws xDetailedConfigError, xWrongInterfaceType, xNoSuchInterface {
            AbstractDwdmLineModel.this.getDwdmRef().setDwdmCardConfig(AbstractDwdmLineModel.this.getIndex(), (sDwdmCardConfig)object);
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    private class ClientInterface
    extends CachedValue {
        public ClientInterface(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Boolean(AbstractDwdmLineModel.this.getDwdmRef().isClient(AbstractDwdmLineModel.this.getIndex()));
        }

        protected void setValue(Object object) {
        }

        protected Object cloneValue() {
            return new Boolean((Boolean)this.value);
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    private class CurrentValues
    extends NonCachedValue {
        public CurrentValues(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface, xInternalCommError, xUnsupportedOperation {
            return AbstractDwdmLineModel.this.getDwdmRef().getOpticsCurrentValues(AbstractDwdmLineModel.this.getIndex());
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    private class Dwdm8B10BStats
    extends NonCachedValue {
        public Dwdm8B10BStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xInternalCommError, xNoSuchInterface, xUnsupportedOperation {
            AbstractDwdmLineModel.this.getDwdmRef().clear8B10BStats(AbstractDwdmLineModel.this.getIndex(), (eIntervalType)object);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xInternalCommError, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            short s = (Short)objectArray[1];
            s8B10BPmStats s8B10BPmStats2 = AbstractDwdmLineModel.this.getDwdmRef().get8B10BStats(AbstractDwdmLineModel.this.getIndex(), (eIntervalType)objectArray[0], s);
            return s8B10BPmStats2;
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    private class Dwdm8B10BThresholds
    extends NonCachedValue {
        public Dwdm8B10BThresholds(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            s8B10BPmThresholds s8B10BPmThresholds2 = AbstractDwdmLineModel.this.getDwdmRef().get8B10BThresholds(AbstractDwdmLineModel.this.getIndex(), (eIntervalType)object);
            return s8B10BPmThresholds2;
        }

        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            AbstractDwdmLineModel.this.getDwdmRef().set8B10BThresholds(AbstractDwdmLineModel.this.getIndex(), (s8B10BPmThresholds)objectArray[0], (eIntervalType)objectArray[1]);
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    private class DwdmLineConfig
    extends CachedValue {
        public DwdmLineConfig(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return AbstractDwdmLineModel.this.getDwdmRef().getDwdmLineConfig(AbstractDwdmLineModel.this.getIndex());
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xNoSuchInterface, xDetailedConfigError {
            AbstractDwdmLineModel.this.getDwdmRef().setDwdmLineConfig(AbstractDwdmLineModel.this.getIndex(), (sDwdmLineConfig)object);
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    private class DwdmLineStats
    extends NonCachedValue {
        public DwdmLineStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xInternalCommError, xNoSuchInterface, xUnsupportedOperation {
            AbstractDwdmLineModel.this.getDwdmRef().clearLineStats(AbstractDwdmLineModel.this.getIndex(), true, (eIntervalType)object);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xInternalCommError, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            boolean bl = (Boolean)objectArray[0];
            short s = (Short)objectArray[2];
            sLinePmStats sLinePmStats2 = AbstractDwdmLineModel.this.getDwdmRef().getLineStats(AbstractDwdmLineModel.this.getIndex(), bl, (eIntervalType)objectArray[1], s);
            return sLinePmStats2;
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    private class FramingType
    extends CachedValue {
        public FramingType(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xInternalCommError, xNoSuchInterface {
            return AbstractDwdmLineModel.this.getDwdmRef().getPayloadType(AbstractDwdmLineModel.this.getIndex());
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    private class LaserAlmThresholds
    extends NonCachedValue {
        public LaserAlmThresholds(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            sLaserThresholds sLaserThresholds2 = AbstractDwdmLineModel.this.getDwdmRef().getOpticsAlmThresholds(AbstractDwdmLineModel.this.getIndex());
            return sLaserThresholds2;
        }

        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            AbstractDwdmLineModel.this.getDwdmRef().setOpticsAlmThresholds(AbstractDwdmLineModel.this.getIndex(), (sLaserThresholds)object);
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    private class LaserTCAThresholds
    extends NonCachedValue {
        public LaserTCAThresholds(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            sLaserThresholds sLaserThresholds2 = AbstractDwdmLineModel.this.getDwdmRef().getOpticsTCAThresholds(AbstractDwdmLineModel.this.getIndex(), (eIntervalType)object);
            return sLaserThresholds2;
        }

        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            Object[] objectArray = (Object[])object;
            AbstractDwdmLineModel.this.getDwdmRef().setOpticsTCAThresholds(AbstractDwdmLineModel.this.getIndex(), (sLaserThresholds)objectArray[0], (eIntervalType)objectArray[1]);
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    private class LineType
    extends CachedValue {
        public LineType(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return AbstractDwdmLineModel.this.getDwdmRef().getLineType(AbstractDwdmLineModel.this.getIndex());
        }

        protected void setValue(Object object) throws UserException {
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    private class Loopback
    extends CachedValue {
        public Loopback(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return AbstractDwdmLineModel.this.getDwdmRef().getLoopback(AbstractDwdmLineModel.this.getIndex());
        }

        protected void setValue(Object object) throws xDetailedConfigError, xWrongInterfaceType, xNoSuchInterface {
            AbstractDwdmLineModel.this.getDwdmRef().setLoopback(AbstractDwdmLineModel.this.getIndex(), (eLoopback)object);
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    class MacAddr
    extends CachedValue {
        public MacAddr(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return AbstractDwdmLineModel.this.getDwdmRef().getMacAddress(AbstractDwdmLineModel.this.getIndex());
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xConfigError, xNoSuchInterface {
            AbstractDwdmLineModel.this.getDwdmRef().setMacAddress(AbstractDwdmLineModel.this.getIndex(), (sEtherMacAddr)object);
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    private class OTNInterface
    extends CachedValue {
        public OTNInterface(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Boolean(AbstractDwdmLineModel.this.getDwdmRef().isOTNConfigurable(AbstractDwdmLineModel.this.getIndex()));
        }

        protected void setValue(Object object) {
        }

        protected Object cloneValue() {
            return new Boolean((Boolean)this.value);
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    private class OpticsStats
    extends NonCachedValue {
        public OpticsStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xInternalCommError, xNoSuchInterface, xUnsupportedOperation {
            AbstractDwdmLineModel.this.getDwdmRef().clearOpticsStats(AbstractDwdmLineModel.this.getIndex(), (eIntervalType)object);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xInternalCommError, xNoSuchInterface, xUnsupportedOperation {
            Object[] objectArray = (Object[])object;
            short s = (Short)objectArray[1];
            sOpticsPmStats sOpticsPmStats2 = AbstractDwdmLineModel.this.getDwdmRef().getOpticsStats(AbstractDwdmLineModel.this.getIndex(), (eIntervalType)objectArray[0], s);
            return sOpticsPmStats2;
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    private class PayloadDataType
    extends CachedValue {
        public PayloadDataType(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return AbstractDwdmLineModel.this.getDwdmRef().getDataRate(AbstractDwdmLineModel.this.getIndex());
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }

    class TermMode
    extends CachedValue {
        public TermMode(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return AbstractDwdmLineModel.this.getDwdmRef().getTermMode(AbstractDwdmLineModel.this.getIndex());
        }

        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            AbstractDwdmLineModel.this.getDwdmRef().setTermMode(AbstractDwdmLineModel.this.getIndex(), (eTermMode)object);
        }

        public Object outer() {
            return AbstractDwdmLineModel.this;
        }
    }
}

