/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Optics.sRange;
import cerent.cms.idl.OpticsTopology.eOrigin;
import cerent.cms.idl.OpticsTopology.sParameterInfo;
import cerent.cms.idl.OpticsTopology.sParameterInfoHolder;
import cerent.cms.idl.OpticsTopology.sParameterKey;
import cerent.cms.idl.OpticsTopology.sParameterValue;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class AnsParamModel
extends Model {
    private NodeModelDelegate nmd;
    private ParamDelete paramDelete;
    private sParameterInfo paraminfo;
    private GetParamInfo getParamInfo;
    private EventDispatcher dispatcher;

    public void delete() throws Exception {
        if (this.db.on()) {
            this.db.println("AnsParamModel::delete()");
        }
        try {
            this.paramDelete.set(null);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public AnsParamModel(NodeModelDelegate nodeModelDelegate, sParameterInfo sParameterInfo2) {
        super(nodeModelDelegate.getChildDebug(AnsParamModel.class));
        this.nmd = nodeModelDelegate;
        this.paraminfo = sParameterInfo2;
        this.paramDelete = new ParamDelete(this.nmd, "AnsParamModel::deleteParam");
        this.getParamInfo = new GetParamInfo(this.nmd, "AnsParamModel::getParamInfo", sParameterInfo2);
        this.dispatcher = null;
    }

    public void init() {
        super.init0();
        if (this.db.on()) {
            this.db.println("AnsParamModel::init()");
        }
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectDwdmOpticalParam, this.paraminfo.index, (Observer)this);
        }
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("AnsParamModel::dispose()");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectDwdmOpticalParam, this.paraminfo.index, (Observer)this);
            this.dispatcher = null;
        }
        this.getParamInfo.dispose();
        super.dispose();
    }

    public int getParamIndex() {
        if (this.db.on()) {
            this.db.println("EtherThresholdModel::getThresholdIndex()");
        }
        return this.paraminfo.index;
    }

    public sParameterInfo getParamInfo() {
        sParameterInfo sParameterInfo2 = null;
        try {
            sParameterInfo2 = (sParameterInfo)this.getParamInfo.get();
        }
        catch (Exception exception) {
            System.out.println("getParamInfo" + exception.getMessage());
        }
        return sParameterInfo2;
    }

    public sParameterKey getParamKey() {
        return this.getParamInfo().key;
    }

    public void setParamValue(int n) throws UserException {
        sParameterInfo sParameterInfo2 = new sParameterInfo(this.paraminfo.index, this.paraminfo.key, new sParameterValue(false, n, eOrigin.ORI_PROVISIONED, this.paraminfo.value.info, new sRange(-500, 300)));
        this.getParamInfo.set(sParameterInfo2);
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((ObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println("Object deleted. id=" + this.paraminfo.index);
                    }
                    this.nmd.getANSManager().getNeANSModel().deleteParamByRef(this);
                    this.destroy();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println("Making local changes. id=" + this.paraminfo.index);
                    }
                    this.updateLocal();
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("update(): Unrecognized Observable id =" + this.paraminfo.index + " from=" + observable + ", arg = " + object);
        }
    }

    protected void updateLocal() {
        this.getParamInfo.update();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    class GetParamInfo
    extends CachedValue {
        public GetParamInfo(NodeModelDelegate nodeModelDelegate, String string, Object object) {
            super(nodeModelDelegate, string, object);
        }

        protected Object getValue() throws UserException {
            sParameterInfoHolder sParameterInfoHolder2 = new sParameterInfoHolder();
            this.node.getIorRepository().getDwdmOpticalSetupRef().getParam(((AnsParamModel)AnsParamModel.this).paraminfo.key, sParameterInfoHolder2);
            return sParameterInfoHolder2;
        }

        protected void setValue(Object object) throws UserException {
            this.node.getIorRepository().getDwdmOpticalSetupRef().setParam((sParameterInfo)object);
        }

        protected Object cloneValue() {
            sParameterInfo sParameterInfo2 = null;
            sParameterInfo2 = this.value instanceof sParameterInfoHolder ? ((sParameterInfoHolder)this.value).value : (sParameterInfo)this.value;
            sParameterInfo sParameterInfo3 = new sParameterInfo(sParameterInfo2.index, sParameterInfo2.key, new sParameterValue(sParameterInfo2.value.isReadOnly, sParameterInfo2.value.currentValue, sParameterInfo2.value.origin, sParameterInfo2.value.info, sParameterInfo2.value.range));
            return sParameterInfo3;
        }

        public Object outer() {
            return AnsParamModel.this;
        }
    }

    class ParamDelete
    extends NonCachedValue {
        public ParamDelete(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        public Object outer() {
            return AnsParamModel.this;
        }
    }
}

