/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Node.General;
import cerent.cms.model.CachedValue;
import cerent.cms.model.IDelayedUpgradeModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.util.SDebug;
import java.util.Observable;
import org.omg.CORBA.UserException;

public class DelayedUpgradeModel
extends Model
implements IDelayedUpgradeModel {
    private static NodeSingletonFactory<DelayedUpgradeModel> sfactory = new NodeSingletonFactory<DelayedUpgradeModel>(DelayedUpgradeModel.class);
    private NodeModelDelegate node;
    private EnableDelayedUpgrade enableDelayedUpgrade;
    private VersionUpSoftwareUpgradeInProgress versionUpSoftwareUpgradeInProgress;

    public boolean getAllowDelayedUpgrades() {
        try {
            return this.node.getNeDefaultsModel().getAllowDelayedUpgrades();
        }
        catch (Exception exception) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
    }

    public boolean getDefaultDelayedUpgrades() {
        try {
            return this.node.getNeDefaultsModel().getDefaultDelayedUpgrades();
        }
        catch (Exception exception) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
    }

    public void setEnableDelayedUpgrade(boolean bl) throws Exception {
        this.enableDelayedUpgrade.set(new Boolean(bl));
    }

    public boolean getVersionUpSoftwareUpgradeInProgress() throws Exception {
        return (Boolean)this.versionUpSoftwareUpgradeInProgress.getValue();
    }

    public static IDelayedUpgradeModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    protected DelayedUpgradeModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(DelayedUpgradeModel.class));
        this.node = nodeModelDelegate;
        this.index = 0;
        this.enableDelayedUpgrade = new EnableDelayedUpgrade(nodeModelDelegate, "DelayedUpgradeModel.enableDelayedUpgrade");
        this.versionUpSoftwareUpgradeInProgress = new VersionUpSoftwareUpgradeInProgress(nodeModelDelegate, "DelayedUpgradeModel.versionUpSoftwareUpgradeInProgress");
    }

    public void init() throws IllegalArgumentException {
        super.init0();
    }

    public void dispose() {
        this.versionUpSoftwareUpgradeInProgress.update();
        super.dispose();
    }

    public void destroy() {
        this.versionUpSoftwareUpgradeInProgress.dispose();
        super.destroy();
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    public void update(Observable observable, Object object) {
        this.versionUpSoftwareUpgradeInProgress.update();
    }

    private General getNodeRef() {
        return this.node.getIorRepository().getNodeRef();
    }

    class EnableDelayedUpgrade
    extends NonCachedValue {
        public EnableDelayedUpgrade(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            DelayedUpgradeModel.this.getNodeRef().setEnableDelayedUpgrade((Boolean)object);
        }

        public Object outer() {
            return DelayedUpgradeModel.this;
        }
    }

    class VersionUpSoftwareUpgradeInProgress
    extends CachedValue {
        public VersionUpSoftwareUpgradeInProgress(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return DelayedUpgradeModel.this.getNodeRef().versionUpSoftwareUpgradeInProgress();
        }

        public Object outer() {
            return DelayedUpgradeModel.this;
        }
    }
}

