/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.util.BuildInfo;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class DownloadChecker {
    private static final SDebug db = new SDebug("DownloadChecker");
    private static final String CERENT_454 = "Cerent 454";
    private static final String CISCO_15454 = "Cisco 15454";
    private static final String CISCO_15327 = "Cisco 15327";
    private static final String CISCO_15454SDH = "Cisco 15454SDH";
    private static final String CISCO_15600 = "Cisco 15600";
    private static final String CISCO_15310 = "Cisco 15310";
    private static final String CISCO_15600SDH = "Cisco 15600SDH";
    private static final String CISCO_15310MA = "Cisco 15310MA";
    private static final String CISCO_15310MASDH = "Cisco 15310MASDH";
    private String packageType = "";
    private String fullVersion = "";
    private String version = "";
    private String filename = "";
    public static final String PREF_PATH = "ctc";
    private static final String PREF_SONET_SDH_DOWNLOADENABLED = "sonetSdhDownloadEnable";
    private int sonetSdhDownloadEnable = 0;

    public DownloadChecker(String string) throws Exception {
        this.filename = string;
        FilterInputStream filterInputStream = null;
        byte[] byArray = new byte[100];
        try {
            filterInputStream = new BufferedInputStream(new FileInputStream(string));
            if (filterInputStream.read(byArray, 0, byArray.length) > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(new String(byArray));
                this.packageType = stringTokenizer.nextToken("!");
                stringTokenizer.nextToken(":");
                stringTokenizer.nextToken(":");
                this.fullVersion = stringTokenizer.nextToken(";");
                this.version = this.fullVersion.indexOf("DEV") != -1 ? this.fullVersion : this.fullVersion.substring(1, 6);
                this.fullVersion = BuildInfo.sanitize(this.fullVersion.substring(1, this.fullVersion.length()));
                if (db.on()) {
                    db.println("NE type: " + this.packageType);
                }
                if (db.on()) {
                    db.println("Full version: " + this.fullVersion);
                }
                if (db.on()) {
                    db.println("Version: " + this.version);
                }
                if (!(this.packageType.equals(CERENT_454) || this.packageType.equals(CISCO_15454) || this.packageType.equals(CISCO_15454SDH) || this.packageType.equals(CISCO_15327) || this.packageType.equals(CISCO_15600) || this.packageType.equals(CISCO_15600SDH) || this.packageType.equals(CISCO_15310) || this.packageType.equals(CISCO_15310MA) || this.packageType.equals(CISCO_15310MASDH))) {
                    throw new Exception("The file " + string + " is not a valid package.");
                }
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            throw new Exception("The file " + string + " is not a valid package.");
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isCompatible(INodeModel iNodeModel) {
        boolean bl = this.isCompatibleNeType(iNodeModel);
        if (!bl) {
            block9: {
                try {
                    if (db.on()) {
                        db.println(iNodeModel.getName() + " is not a " + this.packageType);
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block9;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            return bl;
        }
        try {
            if (this.version.indexOf("DEV") != -1) {
                return true;
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
        bl = this.isCompatibleWithNodeTCC(iNodeModel);
        if (!bl) {
            return bl;
        }
        return true;
    }

    private boolean isCompatibleWithNodeTCC(INodeModel iNodeModel) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = 1;
        try {
            ArrayList arrayList = Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF) ? iNodeModel.getMfgData(n) : iNodeModel.getMfgData();
            for (String string : arrayList) {
                if (string == null) continue;
                if (string.equals("TCC")) {
                    bl = true;
                    continue;
                }
                if (string.equals("TCC+")) {
                    bl2 = true;
                    continue;
                }
                if (string.equals("TCCI")) {
                    bl3 = true;
                    continue;
                }
                if (string.equals("TCC2")) {
                    bl4 = true;
                    continue;
                }
                if (string.equals("TSC") || string.equals("15600-TSC")) {
                    bl5 = true;
                    continue;
                }
                if (!string.equals("CTX-2500")) continue;
                bl6 = true;
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return true;
        }
        if (!this.hasCompatibleTCCs(bl, bl2, bl3, bl4)) {
            return false;
        }
        boolean bl7 = iNodeModel.getTdmProtocolTypeObj().isSdh();
        if (bl7) {
            if (db.on()) {
                db.println("SDH : " + bl3 + " " + bl2 + " " + bl4);
            }
            return bl3 || bl2 || bl4 || bl5 || bl6;
        }
        if (this.version.compareTo("02.30") >= 0 && bl) {
            block24: {
                try {
                    if (DownloadChecker.db.on) {
                        db.println(iNodeModel.getName() + " requires TCC+");
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block24;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            return false;
        }
        if (this.version.compareTo("02.20") < 0 && (bl2 || bl4)) {
            block25: {
                try {
                    if (DownloadChecker.db.on) {
                        db.println(iNodeModel.getName() + " requires TCC");
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block25;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            return false;
        }
        if (this.version.compareTo("04.00") < 0 && bl4) {
            block26: {
                try {
                    if (DownloadChecker.db.on) {
                        db.println(iNodeModel.getName() + "requires TCCPlus");
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block26;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            return false;
        }
        return true;
    }

    private boolean isCompatibleNeType(INodeModel iNodeModel) {
        String string;
        Preferences preferences = Preferences.instance();
        this.sonetSdhDownloadEnable = preferences.getInt(PREF_PATH, PREF_SONET_SDH_DOWNLOADENABLED, 0);
        try {
            string = iNodeModel.getNeType();
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            string = "unknown";
        }
        if (string.equals("15454") && (this.packageType.equals(CERENT_454) || this.packageType.equals(CISCO_15454))) {
            return true;
        }
        if (string.equals("15327") && this.packageType.equals(CISCO_15327)) {
            return true;
        }
        if (string.equals("15454SDH") && this.packageType.equals(CISCO_15454SDH)) {
            return true;
        }
        if (string.equals("15600") && this.packageType.equals(CISCO_15600)) {
            return true;
        }
        if (string.equals("15600SDH") && this.packageType.equals(CISCO_15600SDH)) {
            return true;
        }
        if (string.equals("15310CL") && this.packageType.equals(CISCO_15310)) {
            return true;
        }
        if (string.equals("15310MA") && this.packageType.equals(CISCO_15310MA)) {
            return true;
        }
        if (string.equals("15310MASDH") && this.packageType.equals(CISCO_15310MASDH)) {
            return true;
        }
        return !(this.sonetSdhDownloadEnable != 1 || !string.equals("15310MASDH") && !string.equals("15310MA") || !this.packageType.equals(CISCO_15310MASDH) && !this.packageType.equals(CISCO_15310MA));
    }

    public boolean hasCompatibleTCCs(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = true;
        if (bl) {
            if (bl2 || bl3 || bl4) {
                bl5 = false;
            }
        } else if (bl2) {
            if (bl3 || bl4) {
                bl5 = false;
            }
        } else if (bl3 && bl4) {
            bl5 = false;
        }
        return bl5;
    }

    public String getFullVersion() {
        return this.fullVersion;
    }

    public String getVersion() {
        return this.version;
    }
}

