/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.eReach;
import cerent.cms.idl.Dwdm.Client;
import cerent.cms.idl.Dwdm.General;
import cerent.cms.idl.Dwdm.eClientOpticsVariant;
import cerent.cms.idl.Dwdm.sClientLineAttributes;
import cerent.cms.idl.Dwdm.sLaserThresholds;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.IOpticsProvExtModel;
import cerent.cms.model.ISupportsOpticsProvExtModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.util.SDebug;
import org.omg.CORBA.UserException;

public class DwdmCliLineModel
extends AbstractDwdmLineModel {
    private CurrentPayloadLabel currentPayloadLabel;

    public DwdmCliLineModel(NodeModelDelegate nodeModelDelegate, int n) {
        this(nodeModelDelegate, n, (sInterface)null);
    }

    public DwdmCliLineModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2) {
        super(nodeModelDelegate, n, sInterface2);
        this.index = n;
        this.currentPayloadLabel = new CurrentPayloadLabel(nodeModelDelegate, "currentPayloadLabel");
    }

    public byte getCurrentPayloadLabel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Byte)this.currentPayloadLabel.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getCurrentPayloadLabel", userException);
        }
    }

    public void setAttributes(sClientLineAttributes sClientLineAttributes2, long l) {
        super.setAttributes(sClientLineAttributes2.general, l);
    }

    protected General getDwdmRef() {
        return this.getDwdmCliRef();
    }

    private Client getDwdmCliRef() {
        return this.getNodeModelDelegate().getIorRepository().getDwdmCliRef();
    }

    public boolean supportOpticsMon() {
        boolean bl = true;
        try {
            switch (this.getDataRate()) {
                case 12: {
                    if (((DwdmModuleModel)this.getModuleModel()).isMxpMr25G()) break;
                    bl = false;
                }
            }
            if (bl) {
                InterfaceModel interfaceModel = this.getPayloadModel();
                if (interfaceModel == null) {
                    this.db.severe("No InterfaceModel as PayloadModel available");
                } else if (interfaceModel instanceof ISupportsOpticsProvExtModel) {
                    IOpticsProvExtModel iOpticsProvExtModel = ((ISupportsOpticsProvExtModel)((Object)interfaceModel)).getOpticsProvExtModel();
                    if (iOpticsProvExtModel == null) {
                        this.db.severe("No OpticsProvExtModel available");
                    } else {
                        switch (iOpticsProvExtModel.getLineReach().value()) {
                            case 0: {
                                bl = false;
                            }
                        }
                    }
                } else {
                    this.db.severe("No PayloadModel  available");
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return bl;
    }

    protected boolean isTrunk() {
        return false;
    }

    public boolean isAlsSettable() {
        try {
            return this.getDataRate() != 9 && this.getDataRate() != 17 || !this.isNxpCard();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return super.isAlsSettable();
        }
    }

    private boolean isNxpCard() throws AbstractCmsNoSuchEntityException {
        return this.getModuleModel().getEqType() == 181;
    }

    public sLaserThresholds getDefaultOpticsThresholds(eIntervalType eIntervalType2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        InterfaceModel interfaceModel = this.getPayloadModel();
        eEqType eEqType3 = ((PortModel)interfaceModel.getPortModel()).getEqTypeEnum();
        eClientOpticsVariant eClientOpticsVariant2 = eClientOpticsVariant.DEFAULT_CLIENT_OPTICS;
        eReach eReach2 = eReach.from_int(0);
        if (interfaceModel instanceof ISupportsOpticsProvExtModel) {
            IOpticsProvExtModel iOpticsProvExtModel = ((ISupportsOpticsProvExtModel)((Object)interfaceModel)).getOpticsProvExtModel();
            eReach2 = iOpticsProvExtModel.getLineReach();
        }
        if (this.db.on()) {
            this.db.println(" get Client Defaults:\n\t eqType  = " + eEqType2.value() + "\n\t portType = " + eEqType3.value() + "\n\t thrVar = " + eClientOpticsVariant2.value() + "\n\t reach = " + eReach2.value() + "\n\t intervalType = " + eIntervalType2.value());
        }
        if (eReach2.value() == 0) {
            if (this.db.on()) {
                this.db.println(" get Client Defaults: Reach not set, returning null");
            }
            return null;
        }
        return neDefaultsModel.getDefClientOpticsThr(eEqType2, eEqType3, eClientOpticsVariant2, eReach2, eIntervalType2);
    }

    public boolean supportsTxPower() {
        try {
            if (((DwdmModuleModel)this.getModuleModel()).isMxpMr25G()) {
                return this.getDataRate() != 12;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return true;
    }

    public boolean supportsLaserBias() {
        return this.supportsTxPower();
    }

    private class CurrentPayloadLabel
    extends NonCachedValue {
        public CurrentPayloadLabel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Byte(DwdmCliLineModel.this.getDwdmCliRef().getCurrentPayloadLabel(DwdmCliLineModel.this.getIndex()));
        }

        public Object outer() {
            return DwdmCliLineModel.this;
        }
    }
}

