/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Dwdm.eDataRate;
import cerent.cms.idl.Dwdm.ePayloadType;
import cerent.cms.idl.Dwdm.eTermMode;
import cerent.cms.idl.Dwdm.sDwdmCardConfig;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eModuleOp;
import cerent.cms.idl.Equipment.sCardPeerInfo;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Equipment.xWrongEquipmentType;
import cerent.cms.idl.OnsError.eProvDataError;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.OpticsTopology.sOpticalPatchCord;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AlreadyLocked;
import cerent.cms.model.Busy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.DuplexLocked;
import cerent.cms.model.DuplexUnlocked;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmOTUPortModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.GfpLineModel;
import cerent.cms.model.GfpPortModel;
import cerent.cms.model.HdGeLineModel;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IDwdmPatchordManager;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IOpticsPmModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.ISupportsRMON;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InvalidState;
import cerent.cms.model.MrSlot;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.ProtectActive;
import cerent.cms.model.ProtectFailedOrMissing;
import cerent.cms.model.ProtectLocked;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RmonModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WorkingFailedOrMissing;
import cerent.cms.model.WorkingLocked;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.view.fv.helper.OpticalPatchCord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.omg.CORBA.UserException;

public class DwdmModuleModel
extends PluggableCarrierModel
implements IDwdmModuleModel,
IDwdmPatchordManager {
    public final String C_BAND = "C";
    public final String L_BAND = "L";
    private final String DEFAULT_BAND = "UNAVAILABLE";
    private final String DEFAULT_CARD_TYPE_NAME = "UNKNOWN";
    public final String SRB_CARD_TYPE_NAME = "Skane, Rockwell, Bernina";
    public final String MARMOLADA_CARD_TYPE_NAME = "Marmolada";
    public final String MONVISO_CARD_TYPE_NAME = "Monviso";
    public final String BADILE_CARD_TYPE_NAME = "Badile";
    public final String ADAMELLO_CARD_TYPE_NAME = "Adamello";
    public final String CENGALO_CARD_TYPE_NAME = "Cengalo";
    public final String DISGRAZIA_CARD_TYPE_NAME = "Disgrazia";
    private final String BADILE_TXP_C_BAND_ACT_EQ_TYPE = "10E-L1-C";
    private final String BADILE_TXP_L_BAND_ACT_EQ_TYPE = "10E-L1-L";
    private final String BADILE_MXP_C_BAND_ACT_EQ_TYPE = "10ME-L1-C";
    private final String BADILE_MXP_L_BAND_ACT_EQ_TYPE = "10ME-L1-L";
    private final String MARMOLADA_WAVELENGTHS = "77.4 80.7 84.1 87.4 90.4";
    private String workingBand;
    private String cardTypeName;
    private ADMGroup admGroup;
    private static final String[] mlseCardNames = new String[]{"10EX-L1-C", "10MEX-L1-C", "10DMEX-C"};
    private static final int WL_PREFIX = 3;
    private static final String[] WL_ARRAY = EnumStrings.getStrings(eWavelength.class);

    public DwdmModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(DwdmModuleModel.class));
    }

    public DwdmModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, sDebug);
        this.index = n;
        this.setWorkingBand();
        this.admGroup = new ADMGroup("DwdmModuleModule.admGroup");
    }

    private void setEqLabel() {
        String string = this.getEqTypeName();
        switch (this.getEqType()) {
            case 181: 
            case 182: {
                if (!this.cardTypeName.equals("Badile")) break;
            }
            case 243: 
            case 274: 
            case 275: 
            case 276: 
            case 282: {
                if (this.getState().value() == 0) break;
                string = string + "_";
                string = string + this.workingBand;
            }
        }
        this.setEqLabel(string);
    }

    private boolean isMarmoladaWl(String string) {
        int n = string.lastIndexOf(45) + 1;
        try {
            String string2 = string.substring(n, n + 4);
            return "77.4 80.7 84.1 87.4 90.4".indexOf(string2) != -1;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return false;
        }
    }

    private void setWorkingBand() {
        this.workingBand = "UNAVAILABLE";
        this.cardTypeName = "UNKNOWN";
        int n = this.getEqType();
        if (n == 118 || n == 119 || n == 120 || n == 121 || n == 183 || n == 184) {
            this.cardTypeName = "Skane, Rockwell, Bernina";
            this.workingBand = "C";
        } else if (n == 181 || n == 182) {
            if (this.getState().value() != 0) {
                String string = this.getMfgData().name;
                if (this.db.on()) {
                    this.db.println("Actual Equipment type from Mfg data" + string);
                }
                if (string.indexOf("10E-L1-C") != -1 || string.indexOf("10ME-L1-C") != -1) {
                    this.cardTypeName = "Badile";
                    this.workingBand = "C";
                } else if (string.indexOf("10E-L1-L") != -1 || string.indexOf("10ME-L1-L") != -1) {
                    this.cardTypeName = "Badile";
                    this.workingBand = "L";
                } else if (this.isMarmoladaWl(string)) {
                    this.cardTypeName = "Marmolada";
                    this.workingBand = "L";
                } else {
                    this.cardTypeName = "Monviso";
                    this.workingBand = "C";
                }
            }
        } else if (n == 243 || n == 282) {
            this.cardTypeName = "Adamello";
            this.workingBand = this.getMfgData().name.indexOf("10DME-L") != -1 || this.getMfgData().name.indexOf("10DMEX-L") != -1 ? "L" : "C";
        } else if (n == 274 || n == 275 || n == 276) {
            this.cardTypeName = "Cengalo";
            this.workingBand = this.getMfgData().name.indexOf("-L1-L") != -1 ? "L" : "C";
        } else if (n == 273) {
            this.cardTypeName = "Disgrazia";
            this.workingBand = "C";
        }
        this.setEqLabel();
    }

    public boolean isLBandCard() {
        return this.workingBand == "L";
    }

    public String getEqLabel() {
        String[] stringArray;
        String string = super.getEqLabel();
        List<String> list = Arrays.asList(mlseCardNames);
        if (list.contains((stringArray = this.getMfgData().name.split(" "))[0])) {
            string = string + "X";
        }
        return string;
    }

    public String getWorkingBand() {
        return this.workingBand;
    }

    public boolean supportsCLBand() {
        switch (this.getEqType()) {
            case 181: 
            case 182: 
            case 243: 
            case 274: 
            case 275: 
            case 276: 
            case 282: {
                return true;
            }
        }
        return false;
    }

    public boolean hasPluggableTrunk() {
        return this.getEqType() == 273 || this.getEqType() == 271 || this.getEqType() == 293 || this.getEqType() == 272 || this.getEqType() == 300 || this.getEqType() == 301;
    }

    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("DwdmModuleModel.updateLocal(): entry");
        }
        this.admGroup.update();
        super.updateLocal();
        this.setWorkingBand();
        if (this.db.on()) {
            this.db.println("DwdmModuleModel.updateLocal(): exit");
        }
    }

    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        InterfaceModel[] interfaceModelArray;
        block5: {
            PortModel[] portModelArray;
            block8: {
                block7: {
                    block6: {
                        block4: {
                            portModelArray = this.getPortModels(eEqType2);
                            interfaceModelArray = null;
                            if (eEqType2 != null) break block4;
                            interfaceModelArray = super.getLineModels(null);
                            break block5;
                        }
                        if (eEqType2 != eEqType.DWDM_CLIENT_PORT) break block6;
                        interfaceModelArray = new DwdmCliLineModel[portModelArray.length];
                        for (int i = 0; i < portModelArray.length; ++i) {
                            interfaceModelArray[i] = (DwdmCliLineModel)portModelArray[i].getInterfaceModel();
                        }
                        break block5;
                    }
                    if (eEqType2 != eEqType.DWDM_TRUNK_PORT) break block7;
                    interfaceModelArray = new DwdmTrkLineModel[portModelArray.length];
                    for (int i = 0; i < portModelArray.length; ++i) {
                        interfaceModelArray[i] = (DwdmTrkLineModel)portModelArray[i].getInterfaceModel();
                    }
                    break block5;
                }
                if (eEqType2 != eEqType.GFP_PORT) break block8;
                interfaceModelArray = new GfpLineModel[portModelArray.length];
                for (int i = 0; i < portModelArray.length; ++i) {
                    interfaceModelArray[i] = (GfpLineModel)portModelArray[i].getInterfaceModel();
                }
                break block5;
            }
            if (eEqType2 != eEqType.INTERLINK_TRUNK_PORT) break block5;
            interfaceModelArray = new DwdmTrkLineModel[portModelArray.length];
            for (int i = 0; i < portModelArray.length; ++i) {
                interfaceModelArray[i] = (DwdmTrkLineModel)portModelArray[i].getInterfaceModel();
            }
        }
        return interfaceModelArray == null ? new InterfaceModel[]{} : interfaceModelArray;
    }

    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        if (eEqType2 == null) {
            portModelArray = super.getPortModels(eEqType2);
        } else {
            switch (eEqType2.value()) {
                case 186: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new GfpPortModel[0]);
                    break;
                }
                case 122: 
                case 123: 
                case 280: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new DwdmPortModel[0]);
                    break;
                }
                case 279: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new DwdmOTUPortModel[0]);
                    break;
                }
                default: {
                    this.db.println("Could not get ports for DWDM Card!");
                    if (!this.db.on()) break;
                    SDebug.printStackTrace((Throwable)new Exception());
                }
            }
        }
        return portModelArray == null ? new PortModel[]{} : portModelArray;
    }

    public DwdmPortModel[] getDwdmPorts() {
        DwdmPortModel[] dwdmPortModelArray = this.getDwdmCliPorts();
        DwdmPortModel[] dwdmPortModelArray2 = this.getDwdmTrkPorts();
        DwdmPortModel[] dwdmPortModelArray3 = new DwdmPortModel[dwdmPortModelArray.length + dwdmPortModelArray2.length];
        System.arraycopy(dwdmPortModelArray, 0, dwdmPortModelArray3, 0, dwdmPortModelArray.length);
        System.arraycopy(dwdmPortModelArray2, 0, dwdmPortModelArray3, dwdmPortModelArray.length, dwdmPortModelArray2.length);
        return dwdmPortModelArray3;
    }

    public GfpPortModel[] getGfpPorts() {
        return (GfpPortModel[])this.getPortModels(eEqType.GFP_PORT);
    }

    public AbstractDwdmLineModel[] getDwdmLineModels() {
        DwdmCliLineModel[] dwdmCliLineModelArray = this.getDwdmCliLineModels();
        DwdmTrkLineModel[] dwdmTrkLineModelArray = this.getDwdmTrkLineModels();
        if (this.getEqType() == 293 || this.getEqType() == 300 || this.getEqType() == 301) {
            dwdmTrkLineModelArray = this.getDwdmTrksAndClientLineModels();
        }
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = new AbstractDwdmLineModel[dwdmCliLineModelArray.length + dwdmTrkLineModelArray.length];
        System.arraycopy(dwdmCliLineModelArray, 0, abstractDwdmLineModelArray, 0, dwdmCliLineModelArray.length);
        System.arraycopy(dwdmTrkLineModelArray, 0, abstractDwdmLineModelArray, dwdmCliLineModelArray.length, dwdmTrkLineModelArray.length);
        return abstractDwdmLineModelArray;
    }

    public AbstractDwdmLineModel[] getAllDwdmLineModels() {
        DwdmCliLineModel[] dwdmCliLineModelArray = this.getDwdmCliLineModels();
        DwdmTrkLineModel[] dwdmTrkLineModelArray = this.getAllDwdmTrkLineModels();
        if (this.getEqType() == 293 || this.getEqType() == 300 || this.getEqType() == 301) {
            dwdmTrkLineModelArray = this.getDwdmTrksAndClientLineModels();
        }
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = new AbstractDwdmLineModel[dwdmCliLineModelArray.length + dwdmTrkLineModelArray.length];
        System.arraycopy(dwdmCliLineModelArray, 0, abstractDwdmLineModelArray, 0, dwdmCliLineModelArray.length);
        System.arraycopy(dwdmTrkLineModelArray, 0, abstractDwdmLineModelArray, dwdmCliLineModelArray.length, dwdmTrkLineModelArray.length);
        if (this.getEqType() == 293) {
            List<AbstractDwdmLineModel> list = Arrays.asList(abstractDwdmLineModelArray);
            Collections.sort(list);
            abstractDwdmLineModelArray = list.toArray(new AbstractDwdmLineModel[list.size()]);
        }
        return abstractDwdmLineModelArray;
    }

    public DwdmTrkLineModel[] getDwdmTrksAndClientLineModels() {
        ArrayList<DwdmTrkLineModel> arrayList = new ArrayList<DwdmTrkLineModel>();
        arrayList.addAll(this.getActualClientLineModels());
        arrayList.addAll(Arrays.asList(this.getDwdmTrkLineModels()));
        return arrayList.toArray(new DwdmTrkLineModel[arrayList.size()]);
    }

    public IOpticsPmModel[] getOpticsModels() {
        return this.getDwdmLineModels();
    }

    public GfpLineModel[] getGfpLineModels() {
        return (GfpLineModel[])this.getLineModels(eEqType.GFP_PORT);
    }

    public DwdmCliLineModel[] getDwdmCliLineModels() {
        return (DwdmCliLineModel[])this.getLineModels(eEqType.DWDM_CLIENT_PORT);
    }

    public DwdmTrkLineModel[] getDwdmTrkLineModels() {
        ArrayList<InterfaceModel> arrayList = new ArrayList<InterfaceModel>(Arrays.asList(this.getLineModels(eEqType.DWDM_TRUNK_PORT)));
        if (this.getEqType() == 293 || this.getEqType() == 300 || this.getEqType() == 301) {
            arrayList.removeAll(this.getActualClientLineModels());
        }
        return arrayList.toArray(new DwdmTrkLineModel[0]);
    }

    public DwdmTrkLineModel[] getDwdmOTNSupportedTrkLineModels() {
        ArrayList<InterfaceModel> arrayList = new ArrayList<InterfaceModel>(Arrays.asList(this.getLineModels(eEqType.DWDM_TRUNK_PORT)));
        ArrayList<DwdmTrkLineModel> arrayList2 = new ArrayList<DwdmTrkLineModel>();
        for (DwdmTrkLineModel dwdmTrkLineModel : arrayList) {
            try {
                if (!dwdmTrkLineModel.isOTNSupported()) continue;
                arrayList2.add(dwdmTrkLineModel);
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return arrayList2.toArray(new DwdmTrkLineModel[0]);
    }

    public List getActualClientLineModels() {
        ArrayList<DwdmTrkLineModel> arrayList = new ArrayList<DwdmTrkLineModel>();
        List<InterfaceModel> list = Arrays.asList(this.getLineModels(eEqType.DWDM_TRUNK_PORT));
        for (DwdmTrkLineModel dwdmTrkLineModel : list) {
            try {
                if (!dwdmTrkLineModel.isClient()) continue;
                arrayList.add(dwdmTrkLineModel);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return arrayList;
    }

    public DwdmTrkLineModel[] getAllDwdmTrkLineModels() {
        DwdmTrkLineModel[] dwdmTrkLineModelArray = (DwdmTrkLineModel[])this.getLineModels(eEqType.DWDM_TRUNK_PORT);
        if (this.getEqType() == 273) {
            DwdmTrkLineModel[] dwdmTrkLineModelArray2 = this.getIlkTrkLineModels();
            DwdmTrkLineModel[] dwdmTrkLineModelArray3 = new DwdmTrkLineModel[dwdmTrkLineModelArray.length + dwdmTrkLineModelArray2.length];
            System.arraycopy(dwdmTrkLineModelArray2, 0, dwdmTrkLineModelArray3, 0, dwdmTrkLineModelArray2.length);
            System.arraycopy(dwdmTrkLineModelArray, 0, dwdmTrkLineModelArray3, dwdmTrkLineModelArray2.length, dwdmTrkLineModelArray.length);
            return dwdmTrkLineModelArray3;
        }
        return dwdmTrkLineModelArray;
    }

    public DwdmTrkLineModel[] getIlkTrkLineModels() {
        return (DwdmTrkLineModel[])this.getLineModels(eEqType.INTERLINK_TRUNK_PORT);
    }

    public AbstractDwdmLineModel[] removeNonAINSLineModels(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        ArrayList<AbstractDwdmLineModel> arrayList = new ArrayList<AbstractDwdmLineModel>();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            if (!abstractDwdmLineModelArray[i].supportsAINS()) continue;
            arrayList.add(abstractDwdmLineModelArray[i]);
        }
        return arrayList.toArray(new AbstractDwdmLineModel[arrayList.size()]);
    }

    public AbstractDwdmLineModel[] removeIlkTrkLineModels(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        if (this.isADMCard()) {
            ArrayList<AbstractDwdmLineModel> arrayList = new ArrayList<AbstractDwdmLineModel>();
            for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
                if (abstractDwdmLineModelArray[i] instanceof DwdmTrkLineModel && ((DwdmTrkLineModel)abstractDwdmLineModelArray[i]).isInterlink()) continue;
                arrayList.add(abstractDwdmLineModelArray[i]);
            }
            return arrayList.toArray(new AbstractDwdmLineModel[arrayList.size()]);
        }
        return abstractDwdmLineModelArray;
    }

    public DwdmTrkLineModel[] removeIlkTrkLineModels(DwdmTrkLineModel[] dwdmTrkLineModelArray) {
        if (this.isADMCard()) {
            ArrayList<DwdmTrkLineModel> arrayList = new ArrayList<DwdmTrkLineModel>();
            for (int i = 0; i < dwdmTrkLineModelArray.length; ++i) {
                if (dwdmTrkLineModelArray[i].isInterlink()) continue;
                arrayList.add(dwdmTrkLineModelArray[i]);
            }
            return arrayList.toArray(new DwdmTrkLineModel[arrayList.size()]);
        }
        return dwdmTrkLineModelArray;
    }

    public int getFirstTrunkPort() {
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = this.getDwdmLineModels();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            if (!(abstractDwdmLineModelArray[i] instanceof DwdmTrkLineModel)) continue;
            return i;
        }
        return 0;
    }

    public DwdmTrkLineModel getFirstTrunkLine() {
        DwdmTrkLineModel[] dwdmTrkLineModelArray = this.getDwdmTrkLineModels();
        return dwdmTrkLineModelArray != null && dwdmTrkLineModelArray.length > 0 ? dwdmTrkLineModelArray[0] : null;
    }

    public DwdmCliLineModel getFirstClientLine() {
        DwdmCliLineModel[] dwdmCliLineModelArray = this.getDwdmCliLineModels();
        return dwdmCliLineModelArray != null && dwdmCliLineModelArray.length > 0 ? dwdmCliLineModelArray[0] : null;
    }

    public int getFirstTrunkEntityIndex() throws AbstractCmsNoSuchEntityException {
        DwdmTrkLineModel[] dwdmTrkLineModelArray = this.getDwdmTrkLineModels();
        if (dwdmTrkLineModelArray != null && dwdmTrkLineModelArray.length > 0) {
            return dwdmTrkLineModelArray[0].getPortModel().getEntityIndex();
        }
        return 0;
    }

    public void setPayloadTypeEnum(ePayloadType ePayloadType2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        dwdmTrkLineModel.setPayloadTypeEnum(ePayloadType2);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            SDebug.printStackTrace((Throwable)interruptedException);
        }
    }

    public void setTermModeEnum(eTermMode eTermMode2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        dwdmTrkLineModel.setTermModeEnum(eTermMode2);
    }

    public void setWavelengthEnum(eWavelength eWavelength2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, UnsupportedOperation, ConfigError, ProvisionError {
        this.getFirstTrunkLine().setWavelengthEnum(eWavelength2);
    }

    public void setRegenPeer(int n, int n2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        dwdmTrkLineModel.setRegenPeer(n, n2);
    }

    public void setDwdmCardConfig(sDwdmCardConfig sDwdmCardConfig2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        this.getFirstTrunkLine().setDwdmCardConfig(sDwdmCardConfig2);
    }

    public IEntityModel getRegenPeerModel() throws NoSuchInterface, WrongInterfaceType {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        if (dwdmTrkLineModel != null) {
            return dwdmTrkLineModel.getRegenPeer();
        }
        return null;
    }

    public short getRegenPeer() throws NoSuchInterface, WrongInterfaceType {
        IEntityModel iEntityModel = this.getRegenPeerModel();
        return iEntityModel != null ? (short)iEntityModel.getSlot() : (short)0;
    }

    public boolean hasRegenPeer() {
        try {
            return this.getRegenPeerModel() != null;
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return false;
    }

    public String toString() {
        return "Dwdm" + super.toString();
    }

    public boolean hasSplitterProtectedLine() {
        switch (this.getEqType()) {
            case 121: 
            case 184: {
                return true;
            }
            case 293: {
                return this.getFirstTrunkLine().isSplitterProtectedLine();
            }
        }
        return false;
    }

    public boolean supportSfpPort() {
        switch (this.getEqType()) {
            case 118: 
            case 300: {
                return false;
            }
        }
        return true;
    }

    public boolean supportsGfpPort() {
        switch (this.getEqType()) {
            case 183: 
            case 184: 
            case 243: 
            case 273: 
            case 282: {
                return true;
            }
        }
        return false;
    }

    public boolean supportTiming() {
        switch (this.getEqType()) {
            case 118: 
            case 120: 
            case 121: 
            case 184: 
            case 293: {
                return false;
            }
        }
        return true;
    }

    public boolean supportRegenGroup() {
        switch (this.getEqType()) {
            case 118: 
            case 120: 
            case 121: 
            case 181: 
            case 274: 
            case 275: 
            case 300: 
            case 301: {
                return true;
            }
        }
        return false;
    }

    public boolean supportADMGroup() {
        return this.getEqType() == 273;
    }

    public boolean supportSplitter() {
        switch (this.getEqType()) {
            case 121: 
            case 184: {
                return true;
            }
        }
        return false;
    }

    public boolean isDWDM10GCard() {
        switch (this.getEqType()) {
            case 118: 
            case 119: 
            case 181: 
            case 182: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTxp10ECard(int n) {
        switch (n) {
            case 181: 
            case 274: 
            case 275: {
                return true;
            }
        }
        return false;
    }

    public boolean supportSectionTermMode() {
        boolean bl = true;
        int n = this.getEqType();
        if (n == 118 || n == 119 || n == 300 || n == 301) {
            bl = false;
        }
        return bl;
    }

    public boolean supportTCM() {
        return false;
    }

    public int getFirstWavelength() {
        int n;
        block3: {
            n = 0;
            try {
                DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
                if (dwdmTrkLineModel != null) {
                    n = dwdmTrkLineModel.getActualWaveLength();
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return n;
    }

    public String getWavelengthAsString() {
        block4: {
            try {
                DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
                if (dwdmTrkLineModel != null) {
                    int n = dwdmTrkLineModel.getActualWaveLength();
                    if (n == 0) {
                        return (String)this.getExtraInfoMap().get("WL");
                    }
                    return WL_ARRAY[n];
                }
            }
            catch (Exception exception) {
                this.db.println("Excepion in " + this.getClass().getName() + ".getWavelengthAsString");
                if (!this.db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    public boolean hasOhCircuits() {
        HashSet<PortModel> hashSet = new HashSet<PortModel>();
        hashSet.addAll(Arrays.asList(this.getPortModels()));
        HashSet hashSet2 = new HashSet();
        OhConnectionModelsDelegate ohConnectionModelsDelegate = this.getChassis().getOhConnectionModels();
        ArrayList arrayList = new ArrayList(ohConnectionModelsDelegate.getOhTerms().getConnectionModels(this.getChassis()));
        arrayList.addAll(ohConnectionModelsDelegate.getOhXcons().getConnectionModels(this.getChassis()));
        for (ConnectionModel connectionModel : arrayList) {
            hashSet2.addAll(connectionModel.getPortModels());
        }
        hashSet2.retainAll(hashSet);
        return !hashSet2.isEmpty();
    }

    public boolean testHigherLayer() {
        boolean bl = true;
        InterfaceModel[] interfaceModelArray = this.getLineModels();
        for (int i = 0; i < interfaceModelArray.length; ++i) {
            InterfaceModel[] interfaceModelArray2 = interfaceModelArray[i].getHigherLayerModels();
            if (interfaceModelArray2 != null && interfaceModelArray2.length >= 1) continue;
            this.db.info("Higher is NULL!!! for " + interfaceModelArray[i]);
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isLineTerminated() {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        return dwdmTrkLineModel.isLineTerminated();
    }

    public boolean isSectionTerminated() {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        return dwdmTrkLineModel.isSectionTerminated();
    }

    public boolean isTransparent() {
        if (this.isADMCard()) {
            return false;
        }
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        return dwdmTrkLineModel.isTransparent();
    }

    public boolean supportsOTN() {
        switch (this.getEqType()) {
            case 183: 
            case 184: {
                return false;
            }
        }
        return true;
    }

    public boolean supportsAls() {
        return true;
    }

    public IRmonModel[] getRmonModels() {
        ArrayList<InterfaceModel> arrayList;
        block4: {
            int n;
            DwdmTrkLineModel[] dwdmTrkLineModelArray = this.getDwdmTrkLineModels();
            if (dwdmTrkLineModelArray.length > 0 && (n = this.getEqType()) != 183 && n != 184 && n != 243 && n != 282 && n != 273 && n != 293 && n != 300 && n != 301 && dwdmTrkLineModelArray[0].getRmonModel() == null) {
                return new IRmonModel[0];
            }
            arrayList = new ArrayList<InterfaceModel>();
            try {
                arrayList.addAll(Arrays.asList(this.getLineModels()));
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (!this.db.on()) break block4;
                SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            InterfaceModel interfaceModel = (InterfaceModel)iterator.next();
            if (interfaceModel instanceof ISupportsRMON && !(interfaceModel instanceof DwdmTrkLineModel)) continue;
            iterator.remove();
        }
        return RmonModel.getRmonModels(arrayList.toArray(new ISupportsRMON[arrayList.size()]));
    }

    public TdmLineModel[] getSonetLines() {
        return DwdmModuleModel.getTdmLineModels(this.getDwdmLineModels());
    }

    public TdmLineModel[] getNonRegenSonetModels(TdmLineModel[] tdmLineModelArray) {
        ArrayList<TdmLineModel> arrayList;
        block7: {
            arrayList = new ArrayList<TdmLineModel>();
            try {
                for (int i = 0; i < tdmLineModelArray.length; ++i) {
                    DwdmTrkLineModel dwdmTrkLineModel;
                    if (!(tdmLineModelArray[i].tdmToDwdm() instanceof DwdmTrkLineModel) || (dwdmTrkLineModel = (DwdmTrkLineModel)tdmLineModelArray[i].tdmToDwdm()).getRegenPeerLine() != null) continue;
                    arrayList.add(tdmLineModelArray[i]);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) break block7;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return arrayList.toArray(new TdmLineModel[0]);
    }

    public IRmonModel[] getNonRegenRmonModels(IRmonModel[] iRmonModelArray) {
        ArrayList<IRmonModel> arrayList = new ArrayList<IRmonModel>();
        for (int i = 0; i < iRmonModelArray.length; ++i) {
            try {
                DwdmPortModel dwdmPortModel;
                DwdmTrkLineModel dwdmTrkLineModel;
                IEntityModel iEntityModel = iRmonModelArray[i].getPortModel().getParent();
                List list = iEntityModel.getDescendantsOfEqType(123);
                if (list.size() < 1 || !(list.get(0) instanceof DwdmPortModel) || (dwdmTrkLineModel = (DwdmTrkLineModel)(dwdmPortModel = (DwdmPortModel)list.get(0)).getInterfaceModel()).getRegenPeerLine() != null) continue;
                arrayList.add(iRmonModelArray[i]);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return arrayList.toArray(new IRmonModel[0]);
    }

    public static TdmLineModel[] getTdmLineModels(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        ArrayList<TdmLineModel> arrayList = new ArrayList<TdmLineModel>();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            try {
                arrayList.add(abstractDwdmLineModelArray[i].getTdmLineModel());
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                // empty catch block
            }
        }
        return arrayList.toArray(new TdmLineModel[arrayList.size()]);
    }

    public static FcmrLineModel[] getFcmrLineModels(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        ArrayList<FcmrLineModel> arrayList = new ArrayList<FcmrLineModel>();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            try {
                arrayList.add(abstractDwdmLineModelArray[i].getFcmrLineModel());
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                // empty catch block
            }
        }
        return arrayList.toArray(new FcmrLineModel[arrayList.size()]);
    }

    public static EtherLineModel[] getEtherLineModels(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        ArrayList<EtherLineModel> arrayList = new ArrayList<EtherLineModel>();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            try {
                arrayList.add(abstractDwdmLineModelArray[i].getEtherLineModel());
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                // empty catch block
            }
        }
        return arrayList.toArray(new EtherLineModel[arrayList.size()]);
    }

    public static AbstractDwdmLineModel[] getTdmDwdmLineModels(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        ArrayList<AbstractDwdmLineModel> arrayList = new ArrayList<AbstractDwdmLineModel>();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            try {
                if (!abstractDwdmLineModelArray[i].isSonetSdhPayload()) continue;
                arrayList.add(abstractDwdmLineModelArray[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList.toArray(new AbstractDwdmLineModel[arrayList.size()]);
    }

    public DwdmPortModel[] getDwdmCliPorts() {
        return (DwdmPortModel[])this.getPortModels(eEqType.DWDM_CLIENT_PORT);
    }

    public DwdmPortModel[] getDwdmTrkPorts() {
        return (DwdmPortModel[])this.getPortModels(eEqType.DWDM_TRUNK_PORT);
    }

    public DwdmPortModel[] getDwdmIlkPorts() {
        return (DwdmPortModel[])this.getPortModels(eEqType.INTERLINK_TRUNK_PORT);
    }

    public DwdmOTUPortModel[] getDwdmOTU2Ports() {
        return (DwdmOTUPortModel[])this.getPortModels(eEqType.OTU2_PORT);
    }

    public boolean isMxpMr25G() {
        switch (this.getEqType()) {
            case 183: 
            case 184: {
                return true;
            }
        }
        return false;
    }

    public boolean supportPPM() {
        switch (this.getEqType()) {
            case 118: 
            case 300: {
                return false;
            }
        }
        return true;
    }

    public boolean supportUtilization() {
        switch (this.getEqType()) {
            case 120: 
            case 121: {
                return false;
            }
        }
        return true;
    }

    public MrSlot getMrSlot() {
        List list = this.getChildrenOfType(eEqType.MR_SLOT);
        int n = list == null ? 0 : list.size();
        return n == 1 ? (MrSlot)list.get(0) : null;
    }

    boolean isPortNumUnique(int n) {
        return false;
    }

    boolean allowsPortEditing(PpmModel ppmModel) {
        if (this.getEqType() == 273) {
            return ppmModel.getDescendantsOfEqType(280).size() == 0 && ppmModel.getDescendantsOfEqType(123).size() == 0;
        }
        return false;
    }

    public PortModel[] getAlarmablePorts() {
        ArrayList<PortModel> arrayList = new ArrayList<PortModel>(Arrays.asList(this.getPortModels()));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            InterfaceModel interfaceModel;
            PortModel portModel = (PortModel)iterator.next();
            if (portModel instanceof DwdmPortModel) continue;
            try {
                interfaceModel = (InterfaceModel)portModel.getInterfaceModel();
            }
            catch (Exception exception) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
                continue;
            }
            InterfaceModel[] interfaceModelArray = interfaceModel.getLowerLayerModels();
            if (interfaceModelArray != null && interfaceModelArray.length > 0 && interfaceModelArray[0] instanceof DwdmTrkLineModel) {
                iterator.remove();
            }
            if (this.getEqType() != 272 || !(interfaceModel instanceof Ds123LineModel)) continue;
            iterator.remove();
        }
        arrayList.removeAll(Arrays.asList(this.getDwdmCliPorts()));
        return arrayList.toArray(new PortModel[arrayList.size()]);
    }

    public IPortModel getPayloadPortModel(DwdmPortModel dwdmPortModel) throws AbstractCmsNoSuchEntityException {
        return ((AbstractDwdmLineModel)dwdmPortModel.getInterfaceModel()).getPayloadModel().getPortModel();
    }

    public boolean requireDEDirectionCompatible() {
        switch (this.getEqType()) {
            case 183: 
            case 184: 
            case 243: 
            case 282: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsDEParams() {
        switch (this.getEqType()) {
            case 183: 
            case 184: {
                return true;
            }
        }
        return false;
    }

    public boolean hasDWDMPatchCord() {
        NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
        if (this.parent != null) {
            int n = this.parent.getIndex();
            return nodeModelDelegate.getOpticalPatchCordModel().hasCardDWDMOpticalPatch(n);
        }
        return false;
    }

    public sOpticalPatchCord[] getDWDMPatchCords() throws NumberFormatException, FeatureUnsupported, NoSuchInterface {
        NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
        if (this.parent != null) {
            int n = this.parent.getIndex();
            return nodeModelDelegate.getOpticalPatchCordModel().getOptLinkModelByCard(new Integer(n));
        }
        return null;
    }

    public boolean supportsPortGroupMode() {
        switch (this.getEqType()) {
            case 243: 
            case 282: {
                return true;
            }
        }
        return false;
    }

    public boolean isInAdmPeerGroup() {
        try {
            return this.getAdmPeerGroupInfo() != null && this.getAdmPeerGroupInfo().peerIndex != 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public sCardPeerInfo getAdmPeerGroupInfo() throws AbstractCmsIOException, EMCProvisionError {
        sCardPeerInfo sCardPeerInfo2 = null;
        try {
            sCardPeerInfo2 = (sCardPeerInfo)this.admGroup.get();
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("getAdmPeerGroupInfo", userException);
        }
        return sCardPeerInfo2;
    }

    public void setAdmPeerGroupInfo(sCardPeerInfo sCardPeerInfo2) throws AbstractCmsIOException, EMCProvisionError {
        try {
            this.admGroup.set(sCardPeerInfo2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, "ADM peer group", this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setAdmPeerGroupInfo", userException);
        }
    }

    public boolean isSameADMGroup(IModuleModel iModuleModel) {
        block5: {
            try {
                sCardPeerInfo sCardPeerInfo2 = this.getAdmPeerGroupInfo();
                if (iModuleModel.getEntityIndex() == sCardPeerInfo2.peerIndex) {
                    return true;
                }
            }
            catch (EMCProvisionError eMCProvisionError) {
                if (this.db.on()) {
                    this.db.println("isSameADMGroup:" + (Object)((Object)eMCProvisionError));
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!this.db.on()) break block5;
                this.db.println("isSameADMGroup:" + (Object)((Object)abstractCmsIOException));
            }
        }
        return false;
    }

    public boolean isInSingleCardMode() {
        int n = this.getDwdmTrkPorts().length;
        return n > 1;
    }

    public boolean isADMCard() {
        return this.getEqType() == 273;
    }

    public boolean supportsMLSEModule() {
        return this.getEqType() == 243 || this.getEqType() == 181 || this.getEqType() == 182;
    }

    public AbstractDwdmLineModel[] get1GEthLines(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        AbstractDwdmLineModel[] abstractDwdmLineModelArray2 = abstractDwdmLineModelArray;
        if (abstractDwdmLineModelArray == null) {
            abstractDwdmLineModelArray2 = (AbstractDwdmLineModel[])this.getLineModels(eEqType.DWDM_CLIENT_PORT);
        }
        ArrayList<AbstractDwdmLineModel> arrayList = new ArrayList<AbstractDwdmLineModel>();
        eDataRate eDataRate2 = eDataRate.OC3;
        for (int i = 0; i < abstractDwdmLineModelArray2.length; ++i) {
            block6: {
                try {
                    eDataRate2 = eDataRate.from_int(abstractDwdmLineModelArray2[i].getDataRate());
                }
                catch (NoSuchInterface noSuchInterface) {
                    this.db.println("Cannot determine data rate for: " + abstractDwdmLineModelArray2[i]);
                    if (this.db.on()) {
                        SDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    this.db.println("Cannot determine data rate for: " + abstractDwdmLineModelArray2[i]);
                    if (!this.db.on()) break block6;
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            if (eDataRate2 != eDataRate.ONE_GE) continue;
            arrayList.add(abstractDwdmLineModelArray2[i]);
        }
        return arrayList.toArray(new AbstractDwdmLineModel[arrayList.size()]);
    }

    public AbstractDwdmLineModel[] get10GELines(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        AbstractDwdmLineModel[] abstractDwdmLineModelArray2 = abstractDwdmLineModelArray;
        if (abstractDwdmLineModelArray == null) {
            abstractDwdmLineModelArray2 = this.getAllDwdmLineModels();
        }
        ArrayList<AbstractDwdmLineModel> arrayList = new ArrayList<AbstractDwdmLineModel>();
        for (int i = 0; i < abstractDwdmLineModelArray2.length; ++i) {
            try {
                if (abstractDwdmLineModelArray2[i].getFramingType() != 2) continue;
                arrayList.add(abstractDwdmLineModelArray2[i]);
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return arrayList.toArray(new AbstractDwdmLineModel[arrayList.size()]);
    }

    public AbstractDwdmLineModel[] getEthGELines(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        AbstractDwdmLineModel[] abstractDwdmLineModelArray2 = abstractDwdmLineModelArray;
        if (abstractDwdmLineModelArray == null) {
            abstractDwdmLineModelArray2 = this.getAllDwdmLineModels();
        }
        ArrayList<AbstractDwdmLineModel> arrayList = new ArrayList<AbstractDwdmLineModel>();
        for (int i = 0; i < abstractDwdmLineModelArray2.length; ++i) {
            try {
                if (abstractDwdmLineModelArray2[i].getFramingType() != 2 && abstractDwdmLineModelArray2[i].getFramingType() != 6) continue;
                arrayList.add(abstractDwdmLineModelArray2[i]);
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return arrayList.toArray(new AbstractDwdmLineModel[arrayList.size()]);
    }

    IPortModel getADMGfpPortFromEth(HdGeLineModel hdGeLineModel) throws AbstractCmsNoSuchEntityException {
        GfpPortModel gfpPortModel = null;
        if (this.isADMCard()) {
            IEntityModel iEntityModel = hdGeLineModel.getPort().getParent();
            List list = iEntityModel.getChildren();
            for (IEntityModel iEntityModel2 : list) {
                if (!(iEntityModel2 instanceof GfpPortModel)) continue;
                gfpPortModel = (GfpPortModel)iEntityModel2;
                break;
            }
        }
        return gfpPortModel;
    }

    public void dispose() {
        this.admGroup.dispose();
        super.dispose();
    }

    public void forceFpgaUpdate() throws ProtectFailedOrMissing, WorkingFailedOrMissing, AlreadyLocked, ProtectLocked, WorkingLocked, ProtectActive, InvalidState, DuplexLocked, DuplexUnlocked, ProvisionError, Busy {
        if (!this.supportForceFpgaUpdate()) {
            throw new EMCProvisionError(eProvDataError.ENTITY_NOT_FOUND, this.node.getPlatform());
        }
        this.doCommand(eModuleOp.FORCE_FPGA_UPDATE);
    }

    public boolean supportForceFpgaUpdate() {
        return this.getEqType() == 243 || this.getEqType() == 282;
    }

    public boolean isTxp() {
        return true;
    }

    public DwdmTrkLineModel[] getAdmDwdmTrkLineModels() {
        ArrayList<AbstractDwdmLineModel> arrayList = new ArrayList<AbstractDwdmLineModel>();
        ArrayList<DwdmPortModel> arrayList2 = new ArrayList<DwdmPortModel>(Arrays.asList(this.getDwdmTrkPorts()));
        for (DwdmPortModel dwdmPortModel : arrayList2) {
            if (dwdmPortModel.getPortNum()[0] == 17) continue;
            arrayList.add(dwdmPortModel.getDwdmLineModel());
        }
        return arrayList.toArray(new DwdmTrkLineModel[arrayList.size()]);
    }

    public OpticalPatchCord[] getAllOpticalPatchCords() throws NumberFormatException, FeatureUnsupported, NoSuchInterface {
        sOpticalPatchCord[] sOpticalPatchCordArray = this.getDWDMPatchCords();
        OpticalPatchCord[] opticalPatchCordArray = new OpticalPatchCord[sOpticalPatchCordArray.length];
        for (int i = 0; i < sOpticalPatchCordArray.length; ++i) {
            sOpticalPatchCord sOpticalPatchCord2 = sOpticalPatchCordArray[i];
            int n = sOpticalPatchCord2.type.value();
            int n2 = sOpticalPatchCord2.creationType.value();
            int n3 = sOpticalPatchCord2.bandId.value();
            opticalPatchCordArray[i] = new OpticalPatchCord(sOpticalPatchCord2.creationTime, sOpticalPatchCord2.index, sOpticalPatchCord2.from, sOpticalPatchCord2.to, n, n2, n3, sOpticalPatchCord2.lambda.value());
        }
        return opticalPatchCordArray;
    }

    static {
        for (int i = 0; i < WL_ARRAY.length; ++i) {
            DwdmModuleModel.WL_ARRAY[i] = WL_ARRAY[i].substring(3).replace('_', '.');
        }
    }

    private class ADMGroup
    extends CachedValue {
        public ADMGroup(String string) {
            super(DwdmModuleModel.this.node, string);
        }

        protected void setValue(Object object) throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment {
            DwdmModuleModel.this.getCardModuleRef().setCardPeerGroup(DwdmModuleModel.this.entityIndex, (sCardPeerInfo)object);
        }

        protected Object getValue() throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment {
            return DwdmModuleModel.this.getCardModuleRef().getCardPeerGroup(DwdmModuleModel.this.entityIndex);
        }

        protected Object cloneValue() {
            sCardPeerInfo sCardPeerInfo2 = (sCardPeerInfo)this.value;
            return new sCardPeerInfo(sCardPeerInfo2.peerIndex, sCardPeerInfo2.peerGroupName);
        }

        public Object outer() {
            return DwdmModuleModel.this;
        }
    }
}

