/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EtherMediaModel;
import cerent.cms.model.IOpticsProvExtModel;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.ISupportsOpticsProvExtModel;
import cerent.cms.model.ISupportsRMON;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsProvExtModel;
import cerent.cms.model.PoolModel;
import cerent.cms.model.RmonModel;
import cerent.util.SDebug;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.UserException;

public class EtherLineModel
extends EtherMediaModel
implements ISupportsRMON,
ISupportsOpticsProvExtModel {
    private RmonModel rmonModel;
    private OpticsProvExtModel opticsProvExtModel;
    private PreServiceAlarmSuppress preServiceAlarmSuppress;

    public EtherLineModel(NodeModelDelegate nodeModelDelegate, int n) {
        this(nodeModelDelegate, n, nodeModelDelegate.getChildDebug(EtherLineModel.class));
    }

    public EtherLineModel(NodeModelDelegate nodeModelDelegate, int n, SDebug sDebug) {
        super(nodeModelDelegate, n, sDebug);
        boolean bl = true;
        try {
            if (this.getModuleModel() instanceof DwdmModuleModel) {
                bl = false;
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            // empty catch block
        }
        this.opticsProvExtModel = new OpticsProvExtModel(this);
        this.rmonModel = new RmonModel((NodeModelDelegate)this.getNodeModel(), this, bl);
        this.preServiceAlarmSuppress = new PreServiceAlarmSuppress(nodeModelDelegate, "EtherLineModel.preServiceAlarmSuppress");
    }

    public List getConnectionsList() {
        PoolModel poolModel = (PoolModel)this.getNodeModelDelegate().getPoolModels().getPoolModel(this.getIndex());
        if (poolModel != null) {
            return poolModel.getConnectionsList();
        }
        return new LinkedList();
    }

    public IRmonModel getRmonModel() {
        return this.rmonModel;
    }

    public IOpticsProvExtModel getOpticsProvExtModel() {
        return this.opticsProvExtModel;
    }

    protected void updateLocal(long l) {
        if (this.db.on()) {
            this.db.println("EtherLineModel::updateLocal(sequenceNum)");
        }
        this.preServiceAlarmSuppress.update();
        this.setChanged();
        super.updateLocal(l);
    }

    public Boolean getPreServiceAlarmSuppress() throws EMCProvisionError {
        Boolean bl;
        try {
            bl = (Boolean)this.preServiceAlarmSuppress.get();
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getPreServiceAlarmSuppress", userException);
        }
        return bl;
    }

    public void setPreServiceAlarmSuppress(Boolean bl) throws EMCProvisionError {
        try {
            this.preServiceAlarmSuppress.set(bl);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setPreServiceAlarmSuppress", userException);
        }
    }

    public void dispose() {
        this.rmonModel.dispose();
        this.opticsProvExtModel.dispose();
        super.dispose();
    }

    public void destroy() {
        this.rmonModel.destroy();
        this.opticsProvExtModel.destroy();
        super.destroy();
    }

    private class PreServiceAlarmSuppress
    extends CachedValue {
        public PreServiceAlarmSuppress(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xProvisionError, UserException {
            boolean bl = (Boolean)object;
            EtherLineModel.this.getEtherMediaRef().setPreServiceAlarmSuppress(EtherLineModel.this.getIndex(), bl);
        }

        protected Object getValue() throws xProvisionError, UserException {
            return new Boolean(EtherLineModel.this.getEtherMediaRef().getPreServiceAlarmSuppress(EtherLineModel.this.getIndex()));
        }

        public Object outer() {
            return EtherLineModel.this;
        }
    }
}

