/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.EtherMedia.General;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IosModuleModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public class IosAccessModel
extends Model {
    private NodeModelDelegate nodeModel;
    private ConsolePortAccess consolePortAccess;
    private RadiusRelayAccess radiusRelayAccess;
    private EventDispatcher dispatcher;

    public IosAccessModel(NodeModelDelegate nodeModelDelegate, int n) {
        super(nodeModelDelegate.getChildDebug(IosAccessModel.class));
        if (this.db.on) {
            this.db.println("Creating a new IosAccessModel for entityIndex=" + n);
        }
        this.index = n;
        this.nodeModel = nodeModelDelegate;
        this.dispatcher = nodeModelDelegate.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(2, this.index, (Observer)this);
            if (this.db.on) {
                this.db.println("ADDED observer for index: " + this.index);
            }
        } else if (this.db.on) {
            this.db.println("Could not register with EventDispatcher for IosAccessModel changes.");
        }
        this.consolePortAccess = new ConsolePortAccess(nodeModelDelegate, "IosAccessModel::ConsolePortAccess");
        this.radiusRelayAccess = new RadiusRelayAccess(nodeModelDelegate, "IosAccessModel::RadiusRelayAccess");
        this.init0();
    }

    public void setConsolePortAccess(boolean bl) throws xNoSuchEquipment, xNotSupportedOnEquipment {
        try {
            this.consolePortAccess.set(new Boolean(bl));
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            throw xNoSuchEquipment2;
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            SDebug.printStackTrace((Throwable)((Object)xNotSupportedOnEquipment2));
            throw xNotSupportedOnEquipment2;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            throw NodeModelDelegate.doUnknown(this.db, "setConsolePortAccess", userException);
        }
    }

    public boolean getConsolePortAccess() throws xNoSuchEquipment, xNotSupportedOnEquipment {
        try {
            return (Boolean)this.consolePortAccess.get();
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            throw xNoSuchEquipment2;
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            SDebug.printStackTrace((Throwable)((Object)xNotSupportedOnEquipment2));
            throw xNotSupportedOnEquipment2;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            throw NodeModelDelegate.doUnknown(this.db, "getConsolePortAccess", userException);
        }
    }

    public void setRadiusRelayAccess(boolean bl) throws xNoSuchEquipment, xNotSupportedOnEquipment {
        try {
            this.radiusRelayAccess.set(new Boolean(bl));
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            throw xNoSuchEquipment2;
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            SDebug.printStackTrace((Throwable)((Object)xNotSupportedOnEquipment2));
            throw xNotSupportedOnEquipment2;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            throw NodeModelDelegate.doUnknown(this.db, "setRadiusRelayAccess", userException);
        }
    }

    public boolean getRadiusRelayAccess() throws xNoSuchEquipment, xNotSupportedOnEquipment {
        try {
            return (Boolean)this.radiusRelayAccess.get();
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            throw xNoSuchEquipment2;
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            SDebug.printStackTrace((Throwable)((Object)xNotSupportedOnEquipment2));
            throw xNotSupportedOnEquipment2;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            throw NodeModelDelegate.doUnknown(this.db, "getRadiusRelayAccess", userException);
        }
    }

    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("IosAccessModel::dispose()");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(2, this.index, (Observer)this);
        }
        this.consolePortAccess.dispose();
        this.radiusRelayAccess.dispose();
        super.dispose();
    }

    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("IosAccessModel::updateLocal()");
        }
        this.consolePortAccess.update();
        this.radiusRelayAccess.update();
        this.setChanged();
        super.updateLocal();
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((ObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 1: {
                    if (this.db.on()) {
                        this.db.println("IosAccessModel making local changes.");
                    }
                    this.updateLocal();
                    break;
                }
            }
        } else {
            this.db.println("IosAccessModel update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    protected General getEtherMediaRef() {
        return this.nodeModel.getIorRepository().getEtherMediaRef();
    }

    protected UNKNOWN doUnknown(String string, UserException userException) {
        this.db.println("Caught unexpected exception in " + string);
        SDebug.printStackTrace((Throwable)userException);
        return new UNKNOWN("Caught unexpected exception in " + string + " : " + (Object)((Object)userException));
    }

    public static void xmlInit(NodeModelDelegate nodeModelDelegate, Class clazz, int n) {
        EntityTableModel entityTableModel = nodeModelDelegate.getEntityTableModel();
        IEntityModel iEntityModel = null;
        try {
            iEntityModel = entityTableModel.getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            // empty catch block
        }
        if (iEntityModel instanceof IosModuleModel) {
            ((IosModuleModel)iEntityModel).getIosAccess();
        }
    }

    private class ConsolePortAccess
    extends CachedValue {
        public ConsolePortAccess(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xNoSuchEquipment, xNotSupportedOnEquipment {
            return new Boolean(IosAccessModel.this.getEtherMediaRef().getIosConsolePortAccess(IosAccessModel.this.index));
        }

        protected void setValue(Object object) throws xNoSuchEquipment, xNotSupportedOnEquipment {
            IosAccessModel.this.getEtherMediaRef().setIosConsolePortAccess(IosAccessModel.this.index, (Boolean)object);
        }

        public Object outer() {
            return IosAccessModel.this;
        }
    }

    private class RadiusRelayAccess
    extends CachedValue {
        public RadiusRelayAccess(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xNoSuchEquipment, xNotSupportedOnEquipment {
            return new Boolean(IosAccessModel.this.getEtherMediaRef().getIosRadiusRelayAccess(IosAccessModel.this.index));
        }

        protected void setValue(Object object) throws xNoSuchEquipment, xNotSupportedOnEquipment {
            IosAccessModel.this.getEtherMediaRef().setIosRadiusRelayFunctionAccess(IosAccessModel.this.index, (Boolean)object);
        }

        public Object outer() {
            return IosAccessModel.this;
        }
    }
}

