/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.OpticsTopology.OchncCircuits;
import cerent.cms.idl.OpticsTopology.eOchncPathType;
import cerent.cms.idl.OpticsTopology.sOchPath;
import cerent.cms.idl.OpticsTopology.xAlreadyInUse;
import cerent.cms.idl.OpticsTopology.xWrongPathType;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AlreadyInUse;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.CmsNoSuchElementException;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeOpticsTopologyModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IPptListener;
import cerent.cms.model.ISideModel;
import cerent.cms.model.IYCableModel;
import cerent.cms.model.Model;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PptManager;
import cerent.cms.model.SOchPath;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.model.WrongPathType;
import cerent.cms.model.YCableModel;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.Wavelength;
import cerent.util.Pair;
import cerent.util.SDebug;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import org.omg.CORBA.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeOpticsTopologyModel
extends Model
implements INodeOpticsTopologyModel {
    private NodeModelDelegate nmd;
    private static NodeSingletonFactory<NodeOpticsTopologyModel> sfactory = new NodeSingletonFactory<NodeOpticsTopologyModel>(NodeOpticsTopologyModel.class);
    private OchTrailTrunkPort ochTrailTrunkPort;
    private AvailClientsForTrunk availClientsForTrunk;
    private AvailEntitiesForOchnc availEntitiesForOchnc;
    private AllOchListFromPort allOchListFromPort;
    private AvailEntitiesForOchcc availEntitiesForOchcc;
    private AvailEntitiesForOchTrail availEntitiesForOchTrail;
    private AvailOchncPathEntities availOchncPathEntities;
    private OchncLineReverseEntitiesPair ochncLineReverseEntitiesPair;
    private AvailAddEntitiesForOchnc availAddEntitiesForOchnc;
    private AvailOchccPorts availOchccPorts;
    private PptManager pptMgr;

    private NodeOpticsTopologyModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(NodeOpticsTopologyModel.class));
        this.nmd = nodeModelDelegate;
        this.index = 0;
        this.ochTrailTrunkPort = new OchTrailTrunkPort(this.nmd, "NodeOpticsTopologyModel::ochTrailTrunkPort");
        this.availClientsForTrunk = new AvailClientsForTrunk(this.nmd, "NodeOpticsTopologyModel::availClientsForTrunk");
        this.availEntitiesForOchnc = new AvailEntitiesForOchnc(this.nmd, "NodeOpticsTopologyModel::availEntitiesForOchnc");
        this.allOchListFromPort = new AllOchListFromPort(this.nmd, "NodeOpticsTopologyModel::allOchListFromPort");
        this.availAddEntitiesForOchnc = new AvailAddEntitiesForOchnc(this.nmd, "NodeOpticsTopologyModel::availAddEntitiesForOchnc");
        this.availOchccPorts = new AvailOchccPorts(this.nmd, "NodeOpticsTopologyModel::availOchccPorts");
        this.availEntitiesForOchcc = new AvailEntitiesForOchcc(this.nmd, "NodeOpticsTopologyModel::availEntitiesForOchcc");
        this.availEntitiesForOchTrail = new AvailEntitiesForOchTrail(this.nmd, "NodeOpticsTopologyModel::availEntitiesForOchTrail");
        this.availOchncPathEntities = new AvailOchncPathEntities(this.nmd, "NodeOpticsTopologyModel::availOchncPathEntities");
        this.ochncLineReverseEntitiesPair = new OchncLineReverseEntitiesPair(this.nmd, "NodeOpticsTopologyModel::ochncLineReverseEntitiesPair");
    }

    public static NodeOpticsTopologyModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("Got update from " + observable + " arg=" + object);
        }
    }

    public void init() throws CTCUserException {
        if (this.db.on()) {
            this.db.println("init()");
        }
        super.init0();
    }

    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose()");
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy()");
        }
        super.destroy();
    }

    public int[] getOchTrailTrunkPort(int n) throws NoSuchEquipment {
        try {
            return (int[])this.ochTrailTrunkPort.getValue(new Integer(n));
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getOchTrailTrunkPort", userException);
        }
    }

    public int[] getAvailEntitiesForOchnc(int n, int n2, boolean bl, boolean bl2) throws AlreadyInUse, WrongPathType {
        try {
            Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Boolean(bl), new Boolean(bl2)};
            return (int[])this.availEntitiesForOchnc.getValue(objectArray);
        }
        catch (xAlreadyInUse xAlreadyInUse2) {
            throw new AlreadyInUse((UserException)xAlreadyInUse2, xAlreadyInUse2.idxList);
        }
        catch (xWrongPathType xWrongPathType2) {
            throw new WrongPathType((UserException)xWrongPathType2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getAvailEntitiesForOchnc", userException);
        }
    }

    public int[] getAvailEntitiesForOchnc(int n, int n2, boolean bl) {
        throw new DeprecatedMethodCalled("NodeOpticsTopologyMOdel.getAvailEntitiesForOchnc(int, int, boolean): Deprecated.");
    }

    public SOchPath getAllOchListFromPort(int n) {
        try {
            return new SOchPath((sOchPath)this.allOchListFromPort.getValue(new Integer(n)));
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getAvailEntitiesForOchnc", userException);
        }
    }

    public int[] getAvailClientsForTrunk(int n) throws NoSuchEquipment {
        try {
            return (int[])this.availClientsForTrunk.getValue(new Integer(n));
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getAvailClientsForTrunk", userException);
        }
    }

    public int[] getAvailEntitiesForOchnc(int n, int n2) {
        throw new DeprecatedMethodCalled("NodeOpticsTopologyMOdel.getAvailEntitiesForOchnc(int, int): Deprecated.");
    }

    public int[] getAvailAddEntitiesForOchnc() {
        return (int[])this.availAddEntitiesForOchnc.getValue();
    }

    public int[] getAvailOchccPorts() {
        return (int[])this.availOchccPorts.getValue();
    }

    public int[] getAvailEntitiesForOchTrail(int n, int n2, boolean bl) throws AlreadyInUse {
        try {
            Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Boolean(bl)};
            return (int[])this.availEntitiesForOchTrail.getValue(objectArray);
        }
        catch (xAlreadyInUse xAlreadyInUse2) {
            throw new AlreadyInUse((UserException)xAlreadyInUse2, xAlreadyInUse2.idxList);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getAvailEntitiesForOchTrail", userException);
        }
    }

    public int[] getAvailEntitiesForOchTrail(int n, int n2) throws AlreadyInUse {
        throw new DeprecatedMethodCalled("NodeOpticsTopologyMOdel.getAvailEntitiesForOchTrail(int, int): Deprecated.");
    }

    public int[] getAvailEntitiesForOchcc(int n, int n2, boolean bl) throws AlreadyInUse {
        try {
            Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Boolean(bl)};
            return (int[])this.availEntitiesForOchcc.getValue(objectArray);
        }
        catch (xAlreadyInUse xAlreadyInUse2) {
            throw new AlreadyInUse((UserException)xAlreadyInUse2, xAlreadyInUse2.idxList);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getAvailEntitiesForOchcc", userException);
        }
    }

    public int[] getAvailEntitiesForOchcc(int n, int n2) throws AlreadyInUse {
        throw new DeprecatedMethodCalled("NodeOpticsTopologyMOdel.getAvailEntitiesForOchcc(int, int): Deprecated.");
    }

    public int[] getAvailOchncPathEntities(int n, int n2) throws AlreadyInUse, NoSuchEquipment {
        try {
            Integer[] integerArray = new Integer[]{new Integer(n), new Integer(n2)};
            return (int[])this.availOchncPathEntities.getValue(integerArray);
        }
        catch (xAlreadyInUse xAlreadyInUse2) {
            throw new AlreadyInUse((UserException)xAlreadyInUse2, xAlreadyInUse2.idxList);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getAvailOchncPathEntities", userException);
        }
    }

    public int[] getOchncLineReverseEntitiesPair(int n, int n2) throws AlreadyInUse, NoSuchEquipment, WrongPathType {
        throw new DeprecatedMethodCalled("NodeOpticsTopologyMOdel.getOchncLineReverseEntitiesPair(int, int, int): Deprecated.");
    }

    public int[] getOchncLineReverseEntitiesPair(int n, int n2, int n3) throws AlreadyInUse, NoSuchEquipment, WrongPathType {
        try {
            Object[] objectArray = new Object[]{new Integer(n2), new Integer(n3), eWavelength.from_int(n)};
            return (int[])this.ochncLineReverseEntitiesPair.getValue(objectArray);
        }
        catch (xAlreadyInUse xAlreadyInUse2) {
            throw new AlreadyInUse((UserException)xAlreadyInUse2, xAlreadyInUse2.idxList);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (xWrongPathType xWrongPathType2) {
            throw new WrongPathType((UserException)xWrongPathType2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getOchncLineReverseEntitiesPair", userException);
        }
    }

    public int getSideForOscPort(int n) throws FeatureUnsupported, CannotPerform, AbstractCmsNoSuchElementException {
        ISideModel[] iSideModelArray = this.nmd.getSideModels().getSides();
        ISideModel iSideModel = null;
        for (int i = 0; i < iSideModelArray.length; ++i) {
            if (iSideModelArray[i].getOsc() != n) continue;
            if (iSideModelArray[i].getRole() != 2) {
                return iSideModelArray[i].getId();
            }
            iSideModel = iSideModelArray[i];
        }
        if (iSideModel != null) {
            return iSideModel.getId();
        }
        throw new CmsNoSuchElementException("A side for the OSC port " + Integer.toHexString(n) + " cannot be found.");
    }

    public int getSideForOtsPort(int n) throws FeatureUnsupported, CannotPerform, AbstractCmsNoSuchElementException {
        ISideModel[] iSideModelArray = this.nmd.getSideModels().getSides();
        for (int i = 0; i < iSideModelArray.length; ++i) {
            if (iSideModelArray[i].getLineIn() == n) {
                return iSideModelArray[i].getId();
            }
            if (iSideModelArray[i].getLineOut() != n) continue;
            return iSideModelArray[i].getId();
        }
        throw new CmsNoSuchElementException("A side for the OTS port " + Integer.toHexString(n) + " cannot be found.");
    }

    public int getSideInputEntityIdx(int n) throws NoSuchEquipment {
        try {
            ISideModel iSideModel;
            try {
                iSideModel = this.nmd.getSideModels().getSideById(n);
            }
            catch (WrongNodeSide wrongNodeSide) {
                int n2 = DwdmSide.getSideWorkingFromLabel(n);
                iSideModel = this.nmd.getSideModels().getSideById(n2);
            }
            return iSideModel.getLineIn();
        }
        catch (WrongNodeSide wrongNodeSide) {
            throw new NoSuchEquipment("A side cannot be found for 0x" + Integer.toHexString(n));
        }
    }

    public int getSideOutputEntityIdx(int n) throws NoSuchEquipment {
        try {
            ISideModel iSideModel;
            try {
                iSideModel = this.nmd.getSideModels().getSideById(n);
            }
            catch (WrongNodeSide wrongNodeSide) {
                int n2 = DwdmSide.getSideWorkingFromLabel(n);
                iSideModel = this.nmd.getSideModels().getSideById(n2);
            }
            return iSideModel.getLineOut();
        }
        catch (WrongNodeSide wrongNodeSide) {
            throw new NoSuchEquipment("A side cannot be found for 0x" + Integer.toHexString(n));
        }
    }

    public int getSideInputProtectEntityIdx(int n) throws NoSuchEquipment {
        int n2 = this.getSideInputEntityIdx(n);
        try {
            IEntityModel iEntityModel = this.nmd.getEntityTable().getEntityModelByIndex(n2);
            IEntityModel iEntityModel2 = iEntityModel.isProtected();
            if (iEntityModel2 != null) {
                return iEntityModel2.getEntityIndex();
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        return 0;
    }

    public int getSideOutputProtectEntityIdx(int n) throws NoSuchEquipment {
        try {
            int n2 = DwdmSide.getSideProtectFromLabel(n);
            ISideModel iSideModel = this.nmd.getSideModels().getSideById(n2);
            return iSideModel.getLineOut();
        }
        catch (WrongNodeSide wrongNodeSide) {
            throw new NoSuchEquipment("A side cannot be found for 0x" + Integer.toHexString(n));
        }
    }

    public IPortModel getSplitterEntity(int n, int n2) throws NoSuchEquipment {
        block4: {
            try {
                int n3 = this.getSideForOtsPort(n);
                Set set = this.nmd.getElementModels().getSplitterElements();
                for (YCableModel yCableModel : set) {
                    IPortModel iPortModel = this.matchSideAndWavelength((IPortModel)yCableModel.getMainEntityModel(), n3, n2);
                    if (iPortModel == null) {
                        iPortModel = this.matchSideAndWavelength((IPortModel)yCableModel.getProtectEntityModel(), n3, n2);
                    }
                    if (iPortModel == null) continue;
                    return iPortModel;
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block4;
                this.db.println("Cannot get splitter for 0x" + Integer.toHexString(n) + " on WL=" + Wavelength.getWavelengthStringFromWavelength(n2));
            }
        }
        throw new NoSuchEquipment("A splitter cannot be found for 0x" + Integer.toHexString(n) + " on WL=" + Wavelength.getWavelengthStringFromWavelength(n2));
    }

    private IPortModel matchSideAndWavelength(IPortModel iPortModel, int n, int n2) {
        block4: {
            try {
                OpticsLineModel opticsLineModel;
                if (iPortModel instanceof OpticsPortModel && (opticsLineModel = (OpticsLineModel)((OpticsPortModel)iPortModel).getInterfaceModel()).getSide() == n && (!opticsLineModel.isWavelengthSupported() || opticsLineModel.getExpectedWaveLength() == n2)) {
                    return iPortModel;
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (this.db.on()) {
            this.db.println("Not match for Side " + DwdmSide.getSideFromOffset(n) + " and WL=" + Wavelength.getWavelengthStringFromWavelength(n2));
        }
        return null;
    }

    public IYCableModel getSplitterModel(int n) throws NoSuchEquipment {
        block4: {
            try {
                Set set = this.nmd.getElementModels().getSplitterElements();
                IEntityModel iEntityModel = this.nmd.getEntityTable().getEntityModelByIndex(n);
                IModuleModel iModuleModel = iEntityModel.getModuleModel();
                for (Object object : set) {
                    if (!((YCableModel)object).getMainEntityModel().getModuleModel().equals(iModuleModel)) continue;
                    return object;
                }
                int n2 = DwdmSide.getSideLabelFromId(iEntityModel.getSide());
                for (YCableModel yCableModel : set) {
                    if (DwdmSide.getSideLabelFromId(yCableModel.getMainEntityModel().getSide()) != n2) continue;
                    return yCableModel;
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        throw new NoSuchEquipment("A splitter cannot be found for 0x" + Integer.toHexString(n));
    }

    private OchncCircuits getOchncCircuitsRef() {
        return this.nmd.getIorRepository().getOchncCircuitsRef();
    }

    public boolean startPpt(int n, List<Pair<IIpAddr, Integer>> list, IPptListener iPptListener) {
        if (this.pptMgr == null) {
            this.pptMgr = new PptManager(this.nmd, this.db);
        }
        return this.pptMgr.startPpt(n, list, iPptListener);
    }

    class AllOchListFromPort
    extends NonCachedValue {
        public AllOchListFromPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchEquipment {
            if (NodeOpticsTopologyModel.this.db.on) {
                NodeOpticsTopologyModel.this.db.println(this.getClass() + "::getValue");
            }
            int n = (Integer)object;
            return NodeOpticsTopologyModel.this.getOchncCircuitsRef().getAllOchListFromPort(n);
        }
    }

    class AvailAddEntitiesForOchnc
    extends NonCachedValue {
        public AvailAddEntitiesForOchnc(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            if (NodeOpticsTopologyModel.this.db.on) {
                NodeOpticsTopologyModel.this.db.println(this.getClass() + "::getValue");
            }
            return NodeOpticsTopologyModel.this.getOchncCircuitsRef().getAddPortsForOchnc();
        }
    }

    class AvailClientsForTrunk
    extends NonCachedValue {
        public AvailClientsForTrunk(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchEquipment {
            if (NodeOpticsTopologyModel.this.db.on) {
                NodeOpticsTopologyModel.this.db.println(this.getClass() + "::getValue");
            }
            int n = (Integer)object;
            return NodeOpticsTopologyModel.this.getOchncCircuitsRef().getAvailClientsForTrunk(n);
        }
    }

    class AvailEntitiesForOchTrail
    extends NonCachedValue {
        public AvailEntitiesForOchTrail(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xAlreadyInUse {
            if (NodeOpticsTopologyModel.this.db.on) {
                NodeOpticsTopologyModel.this.db.println(this.getClass() + "::getValue");
            }
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            boolean bl = (Boolean)objectArray[2];
            return NodeOpticsTopologyModel.this.getOchncCircuitsRef().getAvailEntitiesForOchTrail(eWavelength.from_int(n), eEqType.from_int(n2), bl);
        }
    }

    class AvailEntitiesForOchcc
    extends NonCachedValue {
        public AvailEntitiesForOchcc(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xAlreadyInUse {
            if (NodeOpticsTopologyModel.this.db.on) {
                NodeOpticsTopologyModel.this.db.println(this.getClass() + "::getValue");
            }
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            boolean bl = (Boolean)objectArray[2];
            return NodeOpticsTopologyModel.this.getOchncCircuitsRef().getAvailEntitiesForOchcc(eWavelength.from_int(n), eEqType.from_int(n2), bl);
        }

        public Object outer() {
            return NodeOpticsTopologyModel.this;
        }
    }

    class AvailEntitiesForOchnc
    extends NonCachedValue {
        public AvailEntitiesForOchnc(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xAlreadyInUse, xWrongPathType {
            if (NodeOpticsTopologyModel.this.db.on) {
                NodeOpticsTopologyModel.this.db.println(this.getClass() + "::getValue");
            }
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            boolean bl = (Boolean)objectArray[2];
            boolean bl2 = (Boolean)objectArray[3];
            return NodeOpticsTopologyModel.this.getOchncCircuitsRef().getAvailEntitiesForOchnc(eWavelength.from_int(n), eOchncPathType.from_int(n2), bl, bl2);
        }
    }

    class AvailOchccPorts
    extends NonCachedValue {
        public AvailOchccPorts(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            if (NodeOpticsTopologyModel.this.db.on) {
                NodeOpticsTopologyModel.this.db.println(this.getClass() + "::getValue");
            }
            return NodeOpticsTopologyModel.this.getOchncCircuitsRef().getAddPortsForOchnc();
        }
    }

    class AvailOchncPathEntities
    extends NonCachedValue {
        public AvailOchncPathEntities(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xAlreadyInUse, xNoSuchEquipment {
            if (NodeOpticsTopologyModel.this.db.on) {
                NodeOpticsTopologyModel.this.db.println(this.getClass() + "::getValue");
            }
            Integer[] integerArray = (Integer[])object;
            int n = integerArray[0];
            int n2 = integerArray[1];
            return NodeOpticsTopologyModel.this.getOchncCircuitsRef().getAvailOchncPathEntities(eWavelength.from_int(n), n2);
        }
    }

    class OchTrailTrunkPort
    extends NonCachedValue {
        public OchTrailTrunkPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchEquipment {
            if (NodeOpticsTopologyModel.this.db.on) {
                NodeOpticsTopologyModel.this.db.println(this.getClass() + "::getValue");
            }
            int n = (Integer)object;
            return NodeOpticsTopologyModel.this.getOchncCircuitsRef().getOchTrailTrunkPort(n);
        }
    }

    class OchncLineReverseEntitiesPair
    extends NonCachedValue {
        public OchncLineReverseEntitiesPair(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xAlreadyInUse, xNoSuchEquipment, xWrongPathType {
            if (NodeOpticsTopologyModel.this.db.on) {
                NodeOpticsTopologyModel.this.db.println(this.getClass() + "::getValue");
            }
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            eWavelength eWavelength2 = (eWavelength)objectArray[2];
            return NodeOpticsTopologyModel.this.getOchncCircuitsRef().getOchncLineReverseEntitiesPair(n, n2, eWavelength2);
        }
    }
}

