/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.If.General;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.Optics.OchAllocation;
import cerent.cms.idl.Optics.eVOAForceStatus;
import cerent.cms.idl.Optics.sGeneralOpticsAttributes;
import cerent.cms.idl.Optics.sOchAllocationAttributes;
import cerent.cms.idl.Optics.xFeatureUnsupported;
import cerent.cms.idl.Optics.xProvisioningError;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.CachedValue;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OchncConnectionModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import org.omg.CORBA.UserException;

public class OpticsOchTermModel
extends AbstractOpticsLineModel {
    private OppositePort oppPort;
    private OppositeOch oppOch;
    private ActualWavelength actWavelength;
    private OchAllocation ochAlloc;
    private ForceVoa forceVoa;
    private General interfaceRef;
    private OchncConnectionModel ochncConnection;

    public OpticsOchTermModel(NodeModelDelegate nodeModelDelegate, int n) {
        this(nodeModelDelegate, n, (sInterface)null);
    }

    public OpticsOchTermModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2) {
        super(nodeModelDelegate, n, sInterface2, nodeModelDelegate.getIorRepository().getOchAllocationRef());
        this.ochAlloc = nodeModelDelegate.getIorRepository().getOchAllocationRef();
        this.interfaceRef = nodeModelDelegate.getIorRepository().getIfRef();
        this.actWavelength = new ActualWavelength(this.getNodeModelDelegate(), "ActualWaveLength", this.getIndex());
        this.oppPort = new OppositePort(this.getNodeModelDelegate(), "OppositePort", this.getIndex());
        this.oppOch = new OppositeOch(this.getNodeModelDelegate(), "OppositeOch", this.getIndex());
        this.forceVoa = new ForceVoa(this.getNodeModelDelegate(), "ForceVoa", this.getIndex());
    }

    void initConnectionModel() throws NoSuchInterface, WrongInterfaceType, FeatureUnsupported, AbstractCmsNoSuchEntityException {
        if (this.ochncConnection == null) {
            this.ochncConnection = this.getOchncConnectionModel();
            if (this.ochncConnection != null) {
                this.ochncConnection.addObserver(this);
            }
        }
    }

    public void destroy() {
        super.destroy();
    }

    protected void updateLocal(long l) {
        this.actWavelength.update();
        this.oppPort.update();
        super.updateLocal(l);
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof OchncConnectionModel) {
            if (object == ModelUpdateType.CHANGED) {
                this.setChanged();
                this.notifyObservers(ModelUpdateType.CHANGED);
            } else if (object == ModelUpdateType.DELETED) {
                if (this.ochncConnection != null) {
                    this.ochncConnection.deleteObserver(this);
                    this.ochncConnection = null;
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.DELETED);
            }
        } else {
            super.update(observable, object);
        }
    }

    public void setAttributes(sOchAllocationAttributes sOchAllocationAttributes2, long l) {
        super.setAttributes(sOchAllocationAttributes2.general, l);
    }

    public void dispose() {
        this.actWavelength.dispose();
        if (this.ochncConnection != null) {
            this.ochncConnection.deleteObserver(this);
        }
        super.dispose();
    }

    public String getCircuitName() {
        String string;
        OchncConnectionModel ochncConnectionModel;
        OchncConnectionModel ochncConnectionModel2;
        List list;
        block7: {
            list = null;
            ochncConnectionModel2 = null;
            ochncConnectionModel = null;
            Object var4_4 = null;
            string = "N/A";
            try {
                list = ((OpticsPortModel)this.getPortModel()).getConnectionsList();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block7;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && ochncConnectionModel == null) {
            ochncConnectionModel2 = (OchncConnectionModel)iterator.next();
            if (ochncConnectionModel2 == null) continue;
            try {
                if (ochncConnectionModel2.getOptChannel() != this.getExpectedWaveLength()) continue;
                ochncConnectionModel = ochncConnectionModel2;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        if (ochncConnectionModel != null) {
            string = ochncConnectionModel.getConnectionName();
        }
        return string;
    }

    private OchncConnectionModel getOchncConnectionModel() throws NoSuchInterface, WrongInterfaceType, AbstractCmsNoSuchEntityException, FeatureUnsupported {
        Object var1_1 = null;
        eWavelength eWavelength2 = this.getActualWaveLengthEnum();
        int n = this.getOppositePort()[0];
        List list = ((OpticsModuleModel)this.getModuleModel()).getOchConnectionModels(n);
        for (int i = 0; i < list.size(); ++i) {
            OchncConnectionModel ochncConnectionModel;
            int n2;
            var1_1 = list.get(i);
            if (!(var1_1 instanceof OchncConnectionModel) || (n2 = (ochncConnectionModel = (OchncConnectionModel)var1_1).getOptChannel()) != eWavelength2.value()) continue;
            return ochncConnectionModel;
        }
        return null;
    }

    public int getActualWaveLength() throws NoSuchInterface, WrongInterfaceType {
        try {
            eWavelength eWavelength2 = (eWavelength)this.actWavelength.get();
            return eWavelength2.value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getActualWaveLength", userException);
        }
    }

    public eWavelength getActualWaveLengthEnum() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eWavelength)this.actWavelength.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_GETACTUAL_WAVELENGTH), userException);
        }
    }

    public int[] getOppositePort() throws NoSuchInterface, WrongInterfaceType, FeatureUnsupported {
        try {
            return (int[])this.oppPort.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getOppositePort", userException);
        }
    }

    public int[] getOppositeOch() throws NoSuchInterface, WrongInterfaceType, FeatureUnsupported {
        try {
            return (int[])this.oppOch.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getOppositeOch", userException);
        }
    }

    public boolean isForceVOASupported() {
        try {
            return (this.getFeatures() & 0x80000) == 524288;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setForceVoaEnable(boolean bl) throws NoSuchInterface, WrongInterfaceType, FeatureUnsupported, ProvisionError {
        try {
            this.forceVoa.set(bl);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError(EMC.EID_GENERIC_PROV_ERROR, (Object[])new String[]{xProvisioningError2.errorExtraInfo.message()});
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setForceVoat", userException);
        }
    }

    public boolean getForceVoaEnable() throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        if ((this.getFeatures() & 0x80000) == 524288) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.voa.forceEnable;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getForceVoaEnable", userException);
            }
        }
        throw new FeatureUnsupported("getForceVoaEnable");
    }

    public eVOAForceStatus getForceVoaStatus() throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        if ((this.getFeatures() & 1) == 1) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.voa.forceStatus;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getVoaStatus", userException);
            }
        }
        throw new FeatureUnsupported("getVoaStatus");
    }

    public String toString() {
        return "OpticsOchTermModel" + super.toString();
    }

    public int getIngressPort() throws NoSuchInterface, WrongInterfaceType, FeatureUnsupported {
        return this.getOppositePort()[0];
    }

    public IPortModel getOchFromPortModel() {
        IPortModel iPortModel = null;
        if (this.isPortTypeRX()) {
            try {
                iPortModel = this.getPortModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        } else {
            try {
                AbstractOpticsLineModel abstractOpticsLineModel = (AbstractOpticsLineModel)this.node.getIfModels().getInterfaceModel(this.getOppositeOch()[0]);
                iPortModel = abstractOpticsLineModel.getPort();
            }
            catch (Exception exception) {
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return iPortModel;
    }

    public int getOchToPort() {
        return this.getOchToPortModel().getPositionInParent();
    }

    public int getOchFromPort() {
        return this.getOchFromPortModel().getPositionInParent();
    }

    public IPortModel getOchToPortModel() {
        IPortModel iPortModel = null;
        if (this.isPortTypeTX()) {
            try {
                iPortModel = this.getPortModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        } else {
            try {
                AbstractOpticsLineModel abstractOpticsLineModel = (AbstractOpticsLineModel)this.node.getIfModels().getInterfaceModel(this.getOppositeOch()[0]);
                iPortModel = abstractOpticsLineModel.getPort();
            }
            catch (Exception exception) {
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return iPortModel;
    }

    public int getActualToPower() throws InternalCommError, WrongInterfaceType, NoSuchInterface, FeatureUnsupported {
        OpticsOchTermModel opticsOchTermModel = this;
        if (this.isPortTypeTX()) {
            opticsOchTermModel = (OpticsOchTermModel)this.node.getIfModels().getInterfaceModel(this.getOppositeOch()[0]);
        }
        return opticsOchTermModel.getActualPower();
    }

    public int getActPower() throws InternalCommError, NoSuchInterface, WrongInterfaceType, FeatureUnsupported {
        OpticsOchTermModel opticsOchTermModel = this;
        if (this.isPortTypeRX()) {
            opticsOchTermModel = (OpticsOchTermModel)this.node.getIfModels().getInterfaceModel(this.getOppositeOch()[0]);
        }
        return opticsOchTermModel.getActualPower();
    }

    private class ActualWavelength
    extends CachedValue {
        private int index;

        private ActualWavelength(NodeModelDelegate nodeModelDelegate, String string, int n) {
            super(nodeModelDelegate, string);
            this.index = n;
        }

        protected Object getValue() throws UserException {
            return OpticsOchTermModel.this.interfaceRef.getLineWavelength(this.index);
        }
    }

    private class ForceVoa
    extends NonCachedValue {
        private int index;

        private ForceVoa(NodeModelDelegate nodeModelDelegate, String string, int n) {
            super(nodeModelDelegate, string);
            this.index = n;
        }

        protected void setValue(Object object) throws UserException {
            OpticsOchTermModel.this.ifReference.setForceVOA(OpticsOchTermModel.this.getIndex(), (Boolean)object);
        }
    }

    private class OppositeOch
    extends NonCachedValue {
        private int index;

        private OppositeOch(NodeModelDelegate nodeModelDelegate, String string, int n) {
            super(nodeModelDelegate, string);
            this.index = n;
        }

        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType, xFeatureUnsupported {
            return OpticsOchTermModel.this.ochAlloc.getOppositeOchAllocation(this.index);
        }
    }

    private class OppositePort
    extends NonCachedValue {
        private int index;

        private OppositePort(NodeModelDelegate nodeModelDelegate, String string, int n) {
            super(nodeModelDelegate, string);
            this.index = n;
        }

        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType, xFeatureUnsupported {
            return OpticsOchTermModel.this.ochAlloc.getOppositePort(this.index);
        }
    }
}

