/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.OspfTopology.OSPFTopo;
import cerent.cms.idl.OspfTopology.sOspfAdv;
import cerent.cms.idl.OspfTopology.sOspfAreas;
import cerent.cms.idl.OspfTopology.sOspfLSA;
import cerent.cms.idl.OspfTopology.sOspfLSTopology;
import cerent.cms.idl.OspfTopology.xNoSuchAdv;
import cerent.cms.model.CachedValue;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOspfAdv;
import cerent.cms.model.IOspfAreas;
import cerent.cms.model.IOspfLSA;
import cerent.cms.model.IOspfLSTopology;
import cerent.cms.model.IOspfTopologyModel;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.Model;
import cerent.cms.model.NoSuchAdv;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OspfAdvFactory;
import cerent.cms.model.OspfAreasFactory;
import cerent.cms.model.OspfLSAFactory;
import cerent.cms.model.OspfLSTopologyFactory;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public class OspfTopologyModel
extends Model
implements IOspfTopologyModel {
    private Topology topology;
    private OspfAreas ospfAreas;
    private OspfAdv ospfAdv;
    private AreaTopology areaTopology;
    private OspfLSA ospfLSA;
    private NodeModelDelegate node;
    private EventDispatcher dispatcher;
    private static NodeSingletonFactory<OspfTopologyModel> sfactory = new NodeSingletonFactory<OspfTopologyModel>(OspfTopologyModel.class);

    public static OspfTopologyModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private OspfTopologyModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(OspfTopologyModel.class));
        this.node = nodeModelDelegate;
        this.topology = new Topology(nodeModelDelegate, "OspfTopologyModel.topology");
        this.ospfAreas = new OspfAreas(nodeModelDelegate, "OspfTopologyModel.ospfAreas");
        this.ospfAdv = new OspfAdv(nodeModelDelegate, "OspfTopologyModel.ospfAdv");
        this.areaTopology = new AreaTopology(nodeModelDelegate, "OspfTopologyModel.areaTopology");
        this.ospfLSA = new OspfLSA(nodeModelDelegate, "OspfTopologyModel.ospfLSA");
        this.dispatcher = null;
    }

    public void init() {
        super.init0();
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectOspf, 1, (Observer)this);
        }
    }

    private OSPFTopo getOspfTopologyRef() {
        return this.node.getIorRepository().getOspfTopologyRef();
    }

    public void update(Observable observable, Object object) {
        if (object instanceof IObjectMessageInfo) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 1: {
                    if (this.db.on()) {
                        this.db.println("OspfTopologyModel Making local changes.");
                    }
                    this.updateLocal();
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("OspfTopologyModel update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    protected void updateLocal() {
        if (this.topology != null) {
            this.topology.update();
        }
        if (this.ospfAreas != null) {
            this.ospfAreas.update();
        }
        if (this.ospfLSA != null) {
            this.ospfLSA.update();
        }
        this.setChanged();
        super.updateLocal();
    }

    public void dispose() {
        if (this.db.on) {
            this.db.println("Enter OspfTopologyModel dispose()");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectOspf, 1, (Observer)this);
        }
        this.topology.dispose();
        this.ospfAreas.dispose();
        this.ospfLSA.dispose();
        super.dispose();
        if (this.db.on) {
            this.db.println("Exit OspfTopologyModel dispose()");
        }
    }

    public void destroy() {
        super.destroy();
    }

    public IOspfLSTopology getTopology() {
        try {
            return OspfLSTopologyFactory.getIOspfLSTopology((sOspfLSTopology)this.topology.get());
        }
        catch (UserException userException) {
            throw this.doUnknown("getTopology", userException);
        }
    }

    public IOspfAreas getOspfAreas() {
        try {
            return OspfAreasFactory.getIOspfAreas((sOspfAreas)this.ospfAreas.get());
        }
        catch (UserException userException) {
            throw this.doUnknown("getOspfAreas", userException);
        }
    }

    public IOspfLSTopology areaTopology(int n) {
        try {
            return OspfLSTopologyFactory.getIOspfLSTopology((sOspfLSTopology)this.areaTopology.get(new Integer(n)));
        }
        catch (UserException userException) {
            throw this.doUnknown("areaTopology", userException);
        }
    }

    public IOspfAdv getAdv(IIpAddr iIpAddr, int n) throws NoSuchAdv {
        try {
            Integer n2 = new Integer(n);
            Object[] objectArray = new Object[]{IpAddrFactory.getIpAddr(iIpAddr), n2};
            return OspfAdvFactory.getIOspfAdv((sOspfAdv)this.ospfAdv.get(objectArray));
        }
        catch (xNoSuchAdv xNoSuchAdv2) {
            throw new NoSuchAdv((UserException)xNoSuchAdv2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAdv", userException);
        }
    }

    public IOspfLSA getOspfVlinks() {
        try {
            return OspfLSAFactory.getIOspfLSA((sOspfLSA)this.ospfLSA.get());
        }
        catch (UserException userException) {
            throw this.doUnknown("getOspfVlinks", userException);
        }
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.node;
    }

    private UNKNOWN doUnknown(String string, UserException userException) {
        this.db.println("Caught unexpected exception in " + string);
        SDebug.printStackTrace((Throwable)userException);
        return new UNKNOWN("Caught unexpected exception in " + string + " : " + (Object)((Object)userException));
    }

    private class AreaTopology
    extends NonCachedValue {
        public AreaTopology(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return OspfTopologyModel.this.getOspfTopologyRef().areaTopology((Integer)object);
        }

        protected void setValue(Object object) {
        }

        public Object outer() {
            return OspfTopologyModel.this;
        }
    }

    private class OspfAdv
    extends NonCachedValue {
        public OspfAdv(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            sIpAddr sIpAddr2 = (sIpAddr)objectArray[0];
            Integer n = (Integer)objectArray[1];
            return OspfTopologyModel.this.getOspfTopologyRef().getAdv(sIpAddr2, n);
        }

        protected void setValue(Object object) {
        }
    }

    private class OspfAreas
    extends CachedValue {
        public OspfAreas(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            return OspfTopologyModel.this.getOspfTopologyRef().areas();
        }

        protected void setValue(Object object) {
        }
    }

    private class OspfLSA
    extends CachedValue {
        public OspfLSA(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            return OspfTopologyModel.this.getOspfTopologyRef().localVlinks();
        }

        protected void setValue(Object object) {
        }
    }

    private class Topology
    extends CachedValue {
        public Topology(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            return OspfTopologyModel.this.getOspfTopologyRef().topology();
        }

        protected void setValue(Object object) {
        }
    }
}

