/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.Container;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Equipment.xWrongEquipmentType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.CachedValue;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.ServiceState;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.util.SDebug;
import org.omg.CORBA.UserException;

public class PluggableModel
extends MfgEntityModel {
    private Unprovision unprovision;
    private PluggableTypeList pluggableTypeList;
    private int[] hierarchyNums = null;

    public PluggableModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(PluggableModel.class));
    }

    public PluggableModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, sDebug);
        this.unprovision = new Unprovision(nodeModelDelegate, "PluggableModel::unprovision");
        this.pluggableTypeList = new PluggableTypeList(nodeModelDelegate, "PluggableModel::pluggableTypeList");
    }

    public void unprovision() throws ProvisionError, ResourceInUse {
        try {
            this.unprovision.set();
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw this.doUnknown("unprovision", userException);
        }
    }

    private Container getContainerRef() {
        return this.getNodeModelDelegate().getIorRepository().getContainerRef();
    }

    public eEqType[] getPluggableTypeList(int n) {
        try {
            return (eEqType[])this.pluggableTypeList.get(new Integer(n));
        }
        catch (UserException userException) {
            throw this.doUnknown("getPluggableTypeList", userException);
        }
    }

    public void init() {
        this.pluggableTypeList.init();
        super.init();
    }

    public void dispose() {
        this.pluggableTypeList.dispose();
        super.dispose();
    }

    protected void updateLocal() {
        this.pluggableTypeList.update();
        this.setChanged();
        super.updateLocal();
    }

    public boolean isDeletable() {
        eEqType eEqType2 = this.getEqTypeEnum();
        eEqState eEqState2 = this.getState();
        return eEqType2 != eEqType.UNKNOWN_CARD && eEqState2 != eEqState.DELETED;
    }

    public boolean isResettable() {
        boolean bl = false;
        eEqType eEqType2 = this.getEqTypeEnum();
        if (eEqType2 != eEqType.ML2_EXIGE_MAPPER_CARD && (this.node.getPlatform().is454() || this.node.getPlatform().is455() || this.node.getPlatform().is327())) {
            bl = eEqType2 != eEqType.MIC_CARD && eEqType2 != eEqType.MIC_EXT_CARD && eEqType2 != eEqType.FILLER_CARD && ServiceState.isEquipmentResetAvailable(this.getServiceSt());
        }
        return bl;
    }

    public boolean isHardResettable() {
        boolean bl = false;
        eEqType eEqType2 = this.getEqTypeEnum();
        IPlatform iPlatform = this.node.getPlatform();
        if (eEqType2 == eEqType.ML2_EXIGE_MAPPER_CARD || eEqType2 == eEqType.CEMR_454_CARD || iPlatform.is600() || iPlatform.is310cl() || iPlatform.is310ma() || iPlatform.is310maSDH()) {
            boolean bl2 = bl = eEqType2 != eEqType.MIC_CARD && eEqType2 != eEqType.MIC_EXT_CARD && eEqType2 != eEqType.FILLER_CARD;
            if (bl) {
                IServiceState iServiceState = this.getServiceSt();
                bl = iServiceState.equals(3) || iServiceState.equals(25);
            }
        }
        return bl;
    }

    public boolean isSoftResettable() {
        boolean bl = false;
        eEqType eEqType2 = this.getEqTypeEnum();
        IPlatform iPlatform = this.node.getPlatform();
        if (eEqType2 == eEqType.ML2_EXIGE_MAPPER_CARD || eEqType2 == eEqType.CEMR_454_CARD || iPlatform.is600() || iPlatform.is310cl() || iPlatform.is310ma() || iPlatform.is310maSDH()) {
            bl = eEqType2 != eEqType.MIC_CARD && eEqType2 != eEqType.MIC_EXT_CARD && eEqType2 != eEqType.FILLER_CARD && ServiceState.isEquipmentResetAvailable(this.getServiceSt());
        }
        return bl;
    }

    public int[] getHierarchyNums() {
        if (this.hierarchyNums == null) {
            if (this instanceof IModuleModel || this instanceof IChassisModel) {
                this.hierarchyNums = new int[0];
            } else if (this.getParent() instanceof PluggableSlotModel) {
                this.hierarchyNums = ((PluggableSlotModel)this.getParent()).getHierarchyNums();
            } else {
                throw new IllegalStateException("The model type is incorrect.");
            }
        }
        return this.hierarchyNums;
    }

    public String getLocation() {
        String string = this.getNodeModel().isMultishelf() ? this.getShelfId() + "-" : "";
        string = string + String.valueOf(this.getSlot());
        if (this.getHierarchyNums().length > 0) {
            string = string + "-" + PluggableHelper.getHierarchyNumString(this.getHierarchyNums(), '-');
        }
        if (this.getNodeModel().isMultishelf()) {
            IChassisModel iChassisModel = this.getChassis();
            string = string + " " + iChassisModel.getRackLocation();
        }
        return string;
    }

    public boolean isDeleted() {
        return this.getState() == eEqState.DELETED;
    }

    public PortModel[] getAlarmablePorts() {
        return this.getDescendantsOfClassType(7).toArray(new PortModel[0]);
    }

    private class PluggableTypeList
    extends CachedValue {
        public PluggableTypeList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return PluggableModel.this.getContainerRef().getPluggableTypeList(n);
        }

        public Object outer() {
            return PluggableModel.this;
        }
    }

    private class Unprovision
    extends NonCachedValue {
        public Unprovision(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws xInUse, xProvisionError, xWrongEquipmentType, xNoSuchEquipment {
            PluggableModel.this.getIModuleRef().unprovision(PluggableModel.this.entityIndex);
        }

        public Object outer() {
            return PluggableModel.this;
        }
    }
}

