/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.nedefaults;

import cerent.cms.model.nedefaults.DefaultsEdit;
import cerent.cms.model.nedefaults.DefaultsElement;
import cerent.cms.model.nedefaults.IAccessor;
import cerent.util.SDebug;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class VariableRangeLimit {
    private long limit;
    private long divisor;
    private String name;
    private String sValue;
    private long value;
    private static HashMap limitExpressions = new HashMap();
    protected static SDebug db = DefaultsElement.db;

    VariableRangeLimit(long l, long l2) {
        this.limit = l;
        this.divisor = l2;
        this.name = "";
        this.sValue = "";
        this.value = 0L;
    }

    void init(IAccessor iAccessor, String string) {
        this.name = string;
        this.sValue = "";
        this.value = this.limit;
        if (!DefaultsEdit.isEmpty(string)) {
            try {
                this.value = VariableRangeLimit.findExpression(string).evaluate(iAccessor);
                this.sValue = Long.toString(this.value);
            }
            catch (EvaluationException evaluationException) {
                db.println(evaluationException.toString());
            }
        }
    }

    long getLimit() {
        return this.limit;
    }

    String getName() {
        return this.name;
    }

    String getStrValue() {
        return this.sValue;
    }

    long getValue() {
        return this.value;
    }

    String format() {
        if (DefaultsEdit.isEmpty(this.name) || VariableRangeLimit.findExpression(this.name).isComplex()) {
            if (this.divisor == 1L) {
                return Long.toString(this.value);
            }
            return Double.toString(this.value / this.divisor);
        }
        if (this.divisor == 1L) {
            return this.name + "(" + this.sValue + ")";
        }
        Double d = Double.parseDouble(this.sValue) / (double)this.divisor;
        return this.name + "(" + Double.toString(d) + ")";
    }

    public String toString() {
        return "[name='" + this.name + "' limit=" + this.limit + " value=" + this.sValue + "/" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node findExpression(String string) {
        Node node = (Node)limitExpressions.get(string);
        if (node == null && !limitExpressions.containsKey(string)) {
            Parser parser = null;
            try {
                parser = new Parser(string);
                node = parser.expression();
                if (node == null) {
                    node = new Variable(string);
                }
            }
            catch (IOException iOException) {
                node = new Variable(string);
            }
            catch (ParserException parserException) {
                db.println("error: " + parserException);
                node = new Variable(string);
            }
            catch (NumberFormatException numberFormatException) {
                node = new Variable(string);
            }
            finally {
                try {
                    parser.close();
                }
                catch (IOException iOException) {
                    db.println("Unlikely exception closing parser: " + iOException);
                }
            }
            limitExpressions.put(string, node);
        }
        return node;
    }

    private static class Constant
    extends Node {
        private long value;

        Constant(String string) {
            this.value = Long.parseLong(string);
        }

        Constant(long l) {
            this.value = l;
        }

        boolean isConstant() {
            return true;
        }

        void setValue(long l) {
            this.value = l;
        }

        long getValue() {
            return this.value;
        }

        long evaluate(IAccessor iAccessor) {
            return this.value;
        }
    }

    private static class DifferenceOf
    extends Function {
        private DifferenceOf() {
        }

        long getValue(long l, long l2) {
            return l - l2;
        }
    }

    private static class EvaluationException
    extends Exception {
        EvaluationException(String string) {
            super(string);
        }
    }

    private static abstract class Function
    extends Node {
        private ArrayList args;

        private Function() {
        }

        boolean isComplex() {
            return true;
        }

        abstract long getValue(long var1, long var3);

        long evaluate(IAccessor iAccessor) throws EvaluationException {
            long l = 0L;
            Iterator iterator = this.args.iterator();
            if (iterator.hasNext()) {
                l = ((Node)iterator.next()).evaluate(iAccessor);
                while (iterator.hasNext()) {
                    l = this.getValue(l, ((Node)iterator.next()).evaluate(iAccessor));
                }
            }
            return l;
        }

        Node setParameters(Node node, Node node2) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            arrayList.add(node);
            arrayList.add(node2);
            return this.setParameters(arrayList);
        }

        Node setParameters(ArrayList arrayList) {
            Function function;
            Node node = null;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                if (!(node2 instanceof Constant)) continue;
                if (node == null) {
                    node = (Constant)node2;
                } else {
                    ((Constant)node).setValue(this.getValue(((Constant)node).getValue(), ((Constant)node2).getValue()));
                }
                iterator.remove();
            }
            if (arrayList.size() == 0) {
                function = node;
            } else {
                if (node != null) {
                    arrayList.add(node);
                }
                this.args = arrayList;
                function = this;
            }
            return function;
        }
    }

    private static class Maximum
    extends Function {
        private Maximum() {
        }

        long getValue(long l, long l2) {
            return l > l2 ? l : l2;
        }
    }

    private static class Minimum
    extends Function {
        private Minimum() {
        }

        long getValue(long l, long l2) {
            return l < l2 ? l : l2;
        }
    }

    private static abstract class Node {
        private Node() {
        }

        boolean isComplex() {
            return false;
        }

        abstract long evaluate(IAccessor var1) throws EvaluationException;
    }

    private static class Parser {
        private static final int EOF = -1;
        private PushbackReader input;

        Parser(String string) {
            this.input = new PushbackReader(new StringReader(string));
        }

        Parser(InputStream inputStream) {
            this.input = new PushbackReader(new InputStreamReader(inputStream));
        }

        void close() throws IOException {
            this.input.close();
        }

        int skipWhiteSpace() throws IOException {
            int n;
            while ((n = this.input.read()) != -1 && Character.isWhitespace((char)n)) {
            }
            return n;
        }

        int nextch() throws IOException, ParserException {
            int n = this.input.read();
            if (n == 92 && (n = this.input.read()) == -1) {
                throw new ParserException("There is a backslash at the end of the input.");
            }
            return n;
        }

        String nextstr(int n) throws IOException, ParserException {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append((char)n);
            while ((n = this.input.read()) != -1) {
                if (n == 40 || n == 41 || n == 44 || Character.isWhitespace((char)n)) {
                    this.input.unread(n);
                    break;
                }
                if (n == 92 && (n = this.input.read()) == -1) {
                    throw new ParserException("There is a backslash at the end of the input.");
                }
                stringBuffer.append((char)n);
            }
            return stringBuffer.toString();
        }

        String next() throws IOException, ParserException {
            String string = null;
            int n = this.skipWhiteSpace();
            if (n != -1) {
                string = n == 40 ? "(" : (n == 41 ? ")" : (n == 44 ? "," : this.nextstr(n)));
            }
            return string;
        }

        void pushback(String string) throws IOException {
            if (string != null) {
                int n = string.length();
                for (int i = 0; i < n; ++i) {
                    this.input.unread(string.charAt(i));
                }
            }
        }

        boolean isNumeric(String string) {
            boolean bl;
            try {
                if (string != null) {
                    Long.parseLong(string);
                    bl = true;
                } else {
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Node expression() throws IOException, ParserException {
            void var1_11;
            Object var1_1 = null;
            String string = this.next();
            if (this.isNumeric(string)) {
                Constant constant = new Constant(string);
                return var1_11;
            } else {
                if (string == null) return var1_11;
                String string2 = string;
                string = this.next();
                if ("(".equals(string)) {
                    Node node = this.expression();
                    ArrayList<Node> arrayList = new ArrayList<Node>();
                    if (node != null) {
                        arrayList.add(node);
                        while (",".equals(string = this.next())) {
                            node = this.expression();
                            if (node == null) {
                                throw new ParserException("Please add an expression after the comma.");
                            }
                            arrayList.add(node);
                        }
                    }
                    if (!")".equals(string)) throw new ParserException("'" + string + "' was found, but {)} was expected.");
                    if ("minimum_of".equals(string2)) {
                        Node node2 = new Minimum().setParameters(arrayList);
                        return var1_11;
                    } else if ("maximum_of".equals(string2)) {
                        Node node3 = new Maximum().setParameters(arrayList);
                        return var1_11;
                    } else if ("sum_of".equals(string2)) {
                        Node node4 = new SumOf().setParameters(arrayList);
                        return var1_11;
                    } else if ("difference_of".equals(string2)) {
                        Node node5 = new DifferenceOf().setParameters(arrayList);
                        return var1_11;
                    } else if ("product_of".equals(string2)) {
                        Node node6 = new ProductOf().setParameters(arrayList);
                        return var1_11;
                    } else {
                        if (!"quotient_of".equals(string2)) throw new ParserException("unknown function " + string2);
                        Node node7 = new QuotientOf().setParameters(arrayList);
                    }
                    return var1_11;
                } else {
                    this.pushback(string);
                    Variable variable = new Variable(string2);
                }
            }
            return var1_11;
        }
    }

    private static class ParserException
    extends Exception {
        ParserException(String string) {
            super(string);
        }
    }

    private static class ProductOf
    extends Function {
        private ProductOf() {
        }

        long getValue(long l, long l2) {
            return l * l2;
        }
    }

    private static class QuotientOf
    extends Function {
        private QuotientOf() {
        }

        long getValue(long l, long l2) {
            return l / l2;
        }
    }

    private static class SumOf
    extends Function {
        private SumOf() {
        }

        long getValue(long l, long l2) {
            return l + l2;
        }
    }

    private static class Variable
    extends Node {
        private String name;

        Variable(String string) {
            this.name = string;
        }

        long evaluate(IAccessor iAccessor) throws EvaluationException {
            DefaultsElement defaultsElement = iAccessor.getCousinElement(this.name);
            if (defaultsElement == null) {
                throw new EvaluationException("The default " + this.name + " cannot be found.");
            }
            return Variable.getValue(iAccessor.getValue(defaultsElement), iAccessor.getDivisor(defaultsElement));
        }

        private static long getValue(String string, long l) {
            return DefaultsEdit.toScaledLong(Variable.getWithDefault(string), l);
        }

        private static String getWithDefault(String string) {
            return DefaultsEdit.isEmpty(string) ? "0" : string;
        }
    }
}

