/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.persistence;

import cerent.cms.model.ICORBAStreamable;
import cerent.cms.model.IModelStateFactory;
import cerent.cms.model.IStreamer;
import cerent.cms.model.persistence.AbstractStreamer;
import cerent.cms.model.persistence.MyByteArrayOutputStream;
import cerent.util.CORBAInputStream;
import cerent.util.CORBAOutputStream;
import cerent.util.SDebug;
import cerent.util.id.INetwideModelIdentity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.omg.CORBA.UserException;

public class CORBAStreamer
extends AbstractStreamer
implements IStreamer {
    protected static final CORBAStreamer inst = new CORBAStreamer();
    protected static final SDebug db = new SDebug("CORBAStreamer");

    protected CORBAStreamer() {
    }

    public static CORBAStreamer instance() {
        return inst;
    }

    public OutputStream write(OutputStream outputStream, Object object) throws IOException {
        if (object == null) {
            return new ByteArrayOutputStream();
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (outputStream == null) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            outputStream = byteArrayOutputStream;
        }
        if (!(object instanceof ICORBAStreamable)) {
            throw new IOException("o must be an instanceof ICORBAStreamable");
        }
        CORBAOutputStream cORBAOutputStream = null;
        boolean bl = true;
        try {
            cORBAOutputStream = new CORBAOutputStream(outputStream);
            ICORBAStreamable iCORBAStreamable = (ICORBAStreamable)object;
            iCORBAStreamable.write(cORBAOutputStream);
            bl = false;
        }
        catch (UserException userException) {
            throw new IOException(userException.getMessage());
        }
        finally {
            if (bl) {
                CORBAStreamer.close(byteArrayOutputStream);
                if (cORBAOutputStream != byteArrayOutputStream) {
                    CORBAStreamer.close((OutputStream)((Object)cORBAOutputStream));
                }
            }
        }
        return cORBAOutputStream;
    }

    public ByteArrayOutputStream write(Object object) throws IOException {
        MyByteArrayOutputStream myByteArrayOutputStream = new MyByteArrayOutputStream();
        myByteArrayOutputStream.setChild(this.write(myByteArrayOutputStream, object));
        return myByteArrayOutputStream;
    }

    public Object read(InputStream inputStream, Object object, INetwideModelIdentity iNetwideModelIdentity) throws IOException, ClassNotFoundException {
        int n = iNetwideModelIdentity.getModelType();
        return this.read(inputStream, object, n);
    }

    public Object read(InputStream inputStream, Object object, int n) throws IOException, ClassNotFoundException {
        ICORBAStreamable iCORBAStreamable = null;
        CORBAInputStream cORBAInputStream = null;
        try {
            cORBAInputStream = new CORBAInputStream(inputStream);
            if (object == null || !(object instanceof IModelStateFactory)) {
                throw new IOException("context must be an instanceof IModelStateFactory");
            }
            IModelStateFactory iModelStateFactory = (IModelStateFactory)object;
            iCORBAStreamable = iModelStateFactory.createInitialState(n);
            iCORBAStreamable.read(cORBAInputStream);
        }
        catch (IOException iOException) {
            try {
                throw iOException;
            }
            catch (Throwable throwable) {
                CORBAStreamer.close(cORBAInputStream);
                throw throwable;
            }
        }
        CORBAStreamer.close((InputStream)((Object)cORBAInputStream));
        return iCORBAStreamable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(byte[] byArray, Object object, INetwideModelIdentity iNetwideModelIdentity) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = null;
        Object object2 = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            object2 = this.read((InputStream)byteArrayInputStream, object, iNetwideModelIdentity);
        }
        catch (Throwable throwable) {
            CORBAStreamer.close(byteArrayInputStream);
            throw throwable;
        }
        CORBAStreamer.close(byteArrayInputStream);
        return object2;
    }

    public InputStream createInputStream(InputStream inputStream) throws IOException {
        return inputStream;
    }
}

