/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IDatabaseManagementModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.AbstractPane;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.WID;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.PersistentFileChooserDialog;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobListener;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobProgressDialog;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class BackupRestoreDialog
extends JDialog
implements ActionListener,
IJobListener {
    protected String fileName = null;
    protected int operation = 0;
    protected JButton okButton = null;
    protected JButton cancelButton = null;
    protected JButton browseButton = null;
    protected JTextField fileField = null;
    protected INodeModel nodeModel = null;
    protected JobProgressDialog progressDlg;
    private String titleMessage = null;
    private static final String FILE_DIALOG_MSG = "Select file";
    protected static final String BACKUP_RESTORE_PROP = "ctc";
    protected static final String BACKUP_RESTORE_PATH = "backup-restore.file.path";
    protected IDatabaseManagementModel dbModel;
    protected String confirmMessage;
    protected boolean swDowngradeDbRestore = false;
    private static final String BACKUP_TITLE = "Database Backup";
    private static final String RESTORE_TITLE = "Database Restore";
    private static final String BACKUP_MSG = "Select file for saving backup";
    private JCheckBox provChkbox;
    private JCheckBox alarmChkbox;
    private JCheckBox pmChkbox;
    private final String restoreMessage = "Restoring a database from an earlier backup might\nresult in a loss of traffic.\n The node will reboot after the restore has completed.\n\nIs it OK to continue?";
    private final String swRevertMessage = "Reverting to an older version will result in the loss\nof all existing provisioning, and will restore the\n provisioning made with the older software version.\n\nIs it OK to continue?";
    protected static final SDebug db = new SDebug("BackupRestoreDialog");
    protected int[] restoreTypes = null;

    public BackupRestoreDialog(AbstractPane abstractPane, INodeModel iNodeModel, int n, boolean bl) {
        super(JOptionPane.getFrameForComponent((Component)((Object)abstractPane)), n == 1 ? BACKUP_TITLE : RESTORE_TITLE, true);
        this.nodeModel = iNodeModel;
        this.operation = n;
        this.titleMessage = n == 1 ? BACKUP_TITLE : RESTORE_TITLE;
        this.getContentPane().add((Component)this.createMainPanel(), "Center");
        this.getContentPane().add((Component)this.createCommandPanel(), "South");
        this.setLocationRelativeTo(JOptionPane.getFrameForComponent((Component)((Object)abstractPane)));
        this.dbModel = iNodeModel.getDatabaseManagementModel();
        this.swDowngradeDbRestore = bl;
        this.confirmMessage = this.swDowngradeDbRestore ? "Reverting to an older version will result in the loss\nof all existing provisioning, and will restore the\n provisioning made with the older software version.\n\nIs it OK to continue?" : "Restoring a database from an earlier backup might\nresult in a loss of traffic.\n The node will reboot after the restore has completed.\n\nIs it OK to continue?";
        this.setSize(new Dimension(455, 230));
    }

    public BackupRestoreDialog(AbstractPane abstractPane, INodeModel iNodeModel, int n) {
        this(abstractPane, iNodeModel, n, false);
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(new BevelBorder(0));
        jPanel.add((Component)this.createFilePathPanel(), "North");
        jPanel.add((Component)this.createOptionPanel(), "Center");
        return jPanel;
    }

    private JPanel createFilePathPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.add((Component)new JLabel("File: "), "West");
        this.fileField = new JTextField();
        jPanel.add((Component)this.fileField, "Center");
        this.browseButton = new JButton("Browse");
        jPanel.add((Component)this.browseButton, "East");
        this.fileField.setPreferredSize(new Dimension(300, 20));
        this.fileField.setEnabled(false);
        this.browseButton.addActionListener(this);
        return jPanel;
    }

    private JPanel createOptionPanel() {
        JPanel jPanel = new JPanel(new GridLayout(3, 2));
        String string = this.operation == 1 ? "Backup Options" : "Restore Options";
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), string, 1, 2));
        this.provChkbox = new JCheckBox("Provisioning", true);
        jPanel.add(this.createOptionBox(this.provChkbox, false));
        this.alarmChkbox = new JCheckBox("Alarm History", false);
        jPanel.add(this.createOptionBox(this.alarmChkbox, true));
        this.pmChkbox = new JCheckBox("Performance", false);
        jPanel.add(this.createOptionBox(this.pmChkbox, true));
        return jPanel;
    }

    private JPanel createCommandPanel() {
        Dimension dimension = new Dimension(80, 25);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton("OK");
        this.okButton.setPreferredSize(dimension);
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setPreferredSize(dimension);
        this.cancelButton.addActionListener(this);
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    protected JPanel createOptionBox(JCheckBox jCheckBox, boolean bl) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jCheckBox.setEnabled(bl);
        jPanel.add(jCheckBox);
        if (this.operation == 2) {
            jCheckBox.setEnabled(false);
        }
        return jPanel;
    }

    protected void showSaveDialog() {
        File file = PersistentFileChooserDialog.getFile((Component)this, (String)BACKUP_TITLE, (Object)BACKUP_MSG, (byte)2, (String)BACKUP_RESTORE_PROP, (String)BACKUP_RESTORE_PATH, (int)20);
        if (file == null) {
            return;
        }
        this.fileName = file.getAbsolutePath();
        this.fileField.setText(this.fileName);
    }

    protected void showOpenDialog() {
        File file = PersistentFileChooserDialog.getFile((Component)this, (String)this.titleMessage, (Object)FILE_DIALOG_MSG, (byte)1, (String)BACKUP_RESTORE_PROP, (String)BACKUP_RESTORE_PATH, (int)20);
        if (file == null) {
            return;
        }
        this.fileName = file.getAbsolutePath();
        if (!file.exists() || !file.canRead()) {
            ErrorMsg.displayError((Component)this, (EID)CEMC.EID_FILE_NOT_EXIST_OR_READ_PARAM_1, (Object)this.fileName);
            return;
        }
        if (file.length() == 0L) {
            ErrorMsg.displayError((Component)this, (EID)CEMC.EID_FILE_SIZE_ZERO_PARAM_1, (Object)this.fileName);
            return;
        }
        this.fileField.setText(this.fileName);
        try {
            this.restoreTypes = this.dbModel.validateDbBackupFile(this.fileName);
            this.setGuiFields();
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)this, (EID)CEMC.EID_FILE_NOT_EXIST_OR_READ_PARAM_1, (Object)this.fileName);
            SDebug.printStackTrace((Throwable)exception);
            this.fileField.setText("");
            this.okButton.setEnabled(false);
        }
    }

    protected void restoreDB() {
        IJobControl iJobControl;
        if (!this.swDowngradeDbRestore && !this.nodeModel.isResetAllowed()) {
            String string = this.operation == 2 ? "Database restore" : "Configure Node";
            ErrorMsg.displayWarning((Component)this, (WID)CEMC.WID_ACTION_FAILED_SWUPGRADE_PARAM_1, (Object)string);
            return;
        }
        if (!this.isUserConfirm()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        this.setDbTypes(arrayList);
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        this.progressDlg = new JobProgressDialog(JOptionPane.getFrameForComponent(this), this.titleMessage, (this.operation == 2 ? "Restore" : "Node configuration") + " is in progress ....", false, true);
        JobController jobController = JobControllerFactory.createJC((int)1);
        try {
            iJobControl = this.nodeModel.createDataTransferJob(this.fileName, this.operation, (IJobProgressControl)this.progressDlg, nArray);
        }
        catch (Exception exception) {
            this.progressDlg.dispose();
            this.progressDlg = null;
            JobControllerFactory.disposeJC((JobController)jobController);
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this, (EID)CEMC.EID_DB_RESTORE_EXCEPTION_PARAM_1, (Object)exception.getMessage());
            return;
        }
        this.progressDlg.setJob(iJobControl);
        this.progressDlg.setProgressText(this.nodeModel.getName() + ": Restoring ...");
        jobController.submitJob(new JobGroup(iJobControl, (IJobListener)this, (Object)jobController));
    }

    protected void backupDB() {
        IJobControl iJobControl;
        this.progressDlg = new JobProgressDialog(JOptionPane.getFrameForComponent(this), BACKUP_TITLE, "Backup is in progress ....", false, true);
        JobController jobController = JobControllerFactory.createJC((int)1);
        try {
            this.dbModel.setUserSelection(this.buildBackupInfo());
            iJobControl = this.nodeModel.createDataTransferJob(this.fileName, 1, (IJobProgressControl)this.progressDlg);
        }
        catch (Exception exception) {
            this.progressDlg.dispose();
            this.progressDlg = null;
            JobControllerFactory.disposeJC((JobController)jobController);
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this, (EID)CEMC.EID_DB_BACKUP_EXCEPTION_PARAM_1, (Object)exception.getClass().getName());
            return;
        }
        this.progressDlg.setJob(iJobControl);
        this.progressDlg.setProgressText(this.nodeModel.getName() + ": Backing up ...");
        jobController.submitJob(new JobGroup(iJobControl, (IJobListener)this, (Object)jobController));
    }

    private int[] buildBackupInfo() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(5));
        if (this.pmChkbox.isSelected()) {
            arrayList.add(new Integer(7));
            arrayList.add(new Integer(6));
            arrayList.add(new Integer(3));
            arrayList.add(new Integer(4));
        }
        if (this.alarmChkbox.isSelected()) {
            arrayList.add(new Integer(1));
        }
        arrayList.add(new Integer(0));
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    private void setDbTypes(List list) {
        list.add(new Integer(5));
        if (this.pmChkbox.isSelected()) {
            int n;
            int n2;
            block5: {
                n = n2 = 7;
                try {
                    String string = this.dbModel.getDbSwVersion().substring(0, 2);
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!db.on()) break block5;
                    db.println("Exception while reading version from DB file");
                }
            }
            if (n >= n2) {
                list.add(new Integer(7));
                list.add(new Integer(6));
            }
            list.add(new Integer(3));
            list.add(new Integer(4));
        }
        if (this.alarmChkbox.isSelected()) {
            list.add(new Integer(1));
        }
        list.add(new Integer(0));
    }

    private void setGuiFields() {
        int[] nArray = this.dbModel.getDbTypesFromFile();
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) {
                this.provChkbox.setSelected(true);
                this.provChkbox.setEnabled(false);
                continue;
            }
            if (nArray[i] == 1) {
                this.alarmChkbox.setSelected(true);
                this.alarmChkbox.setEnabled(true);
                continue;
            }
            if (nArray[i] != 7 && nArray[i] != 6 && nArray[i] != 3 && nArray[i] != 4) continue;
            this.pmChkbox.setSelected(true);
            this.pmChkbox.setEnabled(true);
        }
    }

    protected boolean isUserConfirm() {
        return CerentDialog.yesNoDialog((Component)this, (String)this.confirmMessage, (String)this.titleMessage);
    }

    protected boolean isUserConfirm(String string) {
        return CerentDialog.yesNoDialog((Component)this, (String)string, (String)this.titleMessage);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == this.okButton) {
            if (this.operation == 1) {
                this.backupDB();
            } else {
                this.restoreDB();
            }
            this.dispose();
        } else if (jButton == this.browseButton) {
            if (this.operation == 1) {
                this.showSaveDialog();
            } else {
                this.showOpenDialog();
            }
            if (this.fileField.getText().length() > 0) {
                this.okButton.setEnabled(true);
            }
        } else if (jButton == this.cancelButton) {
            this.dispose();
        }
    }

    public void jobWaiting(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobRunning(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobFinished(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
        try {
            String string = this.progressDlg.getTitle();
            this.progressDlg.dispose();
            this.progressDlg = null;
            JobController jobController = (JobController)object;
            if (jobController.isIdle()) {
                JobControllerFactory.disposeJC((JobController)jobController);
            }
            if (jobStatus.value() == 3) {
                CerentDialog.infoDialog((Component)this, (String)(string + " aborted"), (String)string);
            } else if (jobStatus.value() == 2) {
                Exception exception = (Exception)jobStatus.getResult();
                if (exception != null) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)this, (EID)CEMC.EID_JOB_FAIL_EXCEPTION_PARAM_1, (Object)exception.getMessage());
                }
            } else if (jobStatus.value() == 4 && this.operation == 1) {
                db.fine("JobStatus.COMPLETE FOR BACKUP");
                CerentDialog.infoDialog((Component)this, (String)(string + " complete"), (String)string);
            }
            this.cleanup();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private void cleanup() {
        this.fileName = null;
        this.fileField = null;
        this.progressDlg = null;
        this.titleMessage = null;
        this.nodeModel = null;
        this.dbModel = null;
        this.okButton.removeActionListener(this);
        this.cancelButton.removeActionListener(this);
        this.browseButton.removeActionListener(this);
        this.okButton = null;
        this.cancelButton = null;
        this.browseButton = null;
        this.confirmMessage = null;
        this.alarmChkbox = null;
        this.pmChkbox = null;
        this.provChkbox = null;
        this.removeAll();
    }
}

